#ifndef __gtk_sciter_h__
#define __gtk_sciter_h__

#include <gtk/gtk.h>
#include <cairo.h>

#include "gtk-types.h"

#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"
#if defined(SCITER)
  #include "xdom/xview.h"
#elif defined(SCITERJS)
  #include "xdomjs/xview.h"
#endif

#include "sdk-headers.h"

namespace gtk {

  inline gool::rect cvt( cairo_rectangle_int_t rc ) {
     return gool::rect( rc.x,rc.y, rc.x + rc.width, rc.y + rc.height);
  }

  inline cairo_rectangle_int_t cvt( const gool::rect rc ) {
     cairo_rectangle_int_t r;
     r.x = rc.s.x;
     r.y = rc.s.y;
     r.width = rc.width();
     r.height = rc.height();
     return r;
  }
}

#endif


