//
//  gtk-sciter-api.cpp
//  sciter-gtk
//
//  Created by andrew on 2014-04-06.
//  Copyright (c) 2014 andrew fedoniouk. All rights reserved.
//

#include "gtk-view.h"
#include "api/api-defs.h"
#include "api/ext-ctl-api.h"
#include "gtk-sciter.h"
#include "sdk/include/sciter-x.h"

gtk::view* gtkview( HWINDOW hw );

using namespace tool;


//|
//| Sciter API
//|

struct gtk_view_callback : public html::view_callback {

    typedef html::view_callback super;

    HWINDOW               _hwnd;
    SciterHostCallback*   _callback;
    LPVOID                _callback_param;

    gtk_view_callback( HWINDOW hwnd, SciterHostCallback*   cb, LPVOID cb_param )
    : _hwnd(hwnd), _callback(cb), _callback_param(cb_param) {}

    virtual bool          load_data(html::view* pv, html::pump::request* rq) override
    {
        pv->current_rq = rq;

        SCN_LOAD_DATA nm;
        nm.hwnd = _hwnd;
        nm.code = SC_LOAD_DATA;

        ustring uri = url::unescape(rq->url);
        nm.uri = LPCWSTR(uri.c_str());
        nm.outData = rq->data.size()? rq->data.head(): 0;
        nm.outDataSize = rq->data.size();
        nm.dataType = rq->data_type;
        nm.principal = rq->dst;
        nm.initiator = rq->initiator;
        nm.requestId = rq;

        UINT lr = 0;

        if(_callback)
        {
            array<byte> data; swap(data,rq->data);
            lr = _callback((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);
            if( lr == LOAD_MYSELF ) {
              rq->external_load = TRUE;
              return false;
            }
            if( rq->data.size() )
                return true;
            swap(data,rq->data);
        }

        if(nm.outData && nm.outDataSize && nm.outData != rq->data.head())
        {
            rq->data.push(nm.outData,nm.outDataSize);
            return true;
        }

        if(lr == LOAD_DISCARD)
          return true;

        if(lr == LOAD_MYSELF)
          return false;

        if(lr == LOAD_DELAYED)
        {
            rq->add_ref();
            rq->external_load = TRUE;
            return false;
        }

        if(lr != 0)
            return nm.outDataSize > 0;

        return false;
    }
    virtual bool          data_loaded(html::view* pv, html::pump::request* rq) override
    {
        if(!_callback)
            return false;
        SCN_DATA_LOADED nm; memzero(nm);

        nm.code = SC_DATA_LOADED;
        nm.hwnd = _hwnd;
        ustring uri = url::unescape(rq->url);
        nm.uri = LPCWSTR(uri.c_str());
        nm.data = rq->data.elements();
        nm.dataSize = rq->data.size();
        nm.dataType = rq->data_type;

        (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);

        if(nm.data == 0 && nm.dataSize == 0)
            return true;
        return false;
    }
    virtual html::ctl*    create_behavior(html::view *pv, html::element* b, const tool::string& name ) override
    {

        html::helement ap = b;

        SCN_ATTACH_BEHAVIOR nmab;
        nmab.code = SC_ATTACH_BEHAVIOR;
        nmab.hwnd = _hwnd;
        nmab.behaviorName = name;
        nmab.element = ap.ptr();
        nmab.elementProc = 0;
        nmab.elementTag = 0;

        if(_callback)
        {
            (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nmab,_callback_param);
            if(nmab.elementProc)
                return new ext_ctl(name, nmab.elementProc, nmab.elementTag );
        }

        /*if( strchr(nmab.behaviorName,':') ) // attempt to load behavior from external .sbx (sciter binary extension - dll) file
        {
            tool::string bn = nmab.behaviorName;
            chars lib_name, bhv_name;
            if( !chars(bn).split(':',lib_name, bhv_name) )
                return 0;

            char buffer[2048]; buffer[0] = 0;
            GetModuleFileNameA( HINST_THISCOMPONENT ,buffer, sizeof(buffer));
            string drive, dir, name, ext;
            split_path(buffer, drive, dir, name, ext);

            string dll_name = string(lib_name) + ".dll";
            string s = drive + dir + dll_name;

            SciterBehaviorFactory* sbf = getExtFactory(s);
            if( !sbf )
                return 0;
            // second attempt, just dll name
            sbf = getExtFactory(dll_name);
            if( !sbf )
                return 0;

            //if( !( sbf = (SciterBehaviorFactory*) ::GetProcAddress( hlib, "SciterBehaviorFactory" ) ) )
            //  return 0;

            if( sbf( string(bhv_name), nmab.element, &nmab.elementProc, &nmab.elementTag))
            {
                if(nmab.elementProc)
                    return new ext_ctl(name, nmab.elementProc, nmab.elementTag );

            }
            nmab.elementTag  = 0;
            nmab.elementProc = 0;
        }*/
        return 0;

    }

    virtual void post_notify(html::view *pv, uint_ptr wp, uint_ptr lp) override {
        SCN_POSTED_NOTIFICATION nm;
        nm.hwnd = _hwnd;
        nm.code = SC_POSTED_NOTIFICATION;
        nm.wparam = wp;
        nm.lparam = lp;
        nm.lreturn = 0;
        if(_callback)
          (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);
    }

    void final_release()  override {
      if(!_callback)
        return;
      SCN_ENGINE_DESTROYED nm; memzero(nm);

      nm.code = SC_ENGINE_DESTROYED;
      nm.hwnd = _hwnd;

      (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);

      return super::final_release();
    }

};

//void gtk_deliver_posted_callback(gtk::view* pv, uint_ptr wp, uint_ptr lp) {
//  gtk_view_callback* pcb = pv->callback.ptr_of<gtk_view_callback>();
//  pcb->deliver_posted_callback(wp,lp);
//  pv->posted_callback_complete.signal();
//}

VOID SCAPI SciterSetCallback_api(HWINDOW hwnd, LPSciterHostCallback cb, LPVOID cbParam)
{
    tool::handle<gtk::view> pview = gtkview(hwnd);
    if(!pview || !cb)
        return ;

    critical_section cs(pview->guard);

    gtk_view_callback* pcb = new gtk_view_callback( hwnd, cb, cbParam );

    pview->set_callback(pcb);
}

LPVOID SCAPI SciterGetCallbackParam_api(HWINDOW hwnd)
{
    tool::handle<gtk::view> pview = gtkview(hwnd);
    if(!pview)
        return nullptr;

    critical_section cs(pview->guard);

    gtk_view_callback* pcb = (gtk_view_callback*) pview->get_callback();
    if(pcb)
      return pcb->_callback_param;
    return nullptr;
}


LPCWSTR SciterClassName_api()
{
    return WSTR("sciter-view");
}

uint module_version(bool major);

UINT SciterVersion_api(SBOOL major)
{
    return module_version(major);
}

struct view_debug_output_impl: public html::view_debug_output {
    DEBUG_OUTPUT_PROC _out;
    void*             _out_prm;
    view_debug_output_impl(DEBUG_OUTPUT_PROC out, void* out_prm):_out(out),_out_prm(out_prm) {}
    virtual void print(uint subs, uint sev, wchars msg ) override
    {
        _out(_out_prm, subs, sev, msg.start, msg.size() );
    }
};

VOID SciterSetupDebugOutput_api(
                                       HWINDOW               hwndOrNull,// HWINDOW or null if this is global output handler
                                       LPVOID                param,     // param to be passed "as is" to the pfOutput
                                       DEBUG_OUTPUT_PROC     pfOutput   // output function, output stream alike thing.
)
{
    if(hwndOrNull)
    {
        tool::handle<gtk::view> pview = gtkview(hwndOrNull);
        if(pview)
        {
            if( pfOutput )
                pview->set_native_debug_output(new view_debug_output_impl(pfOutput,param));
            else
                pview->set_native_debug_output(0);
            return;
        }
    }
    setup_debug_output(param, pfOutput);
}

#define get_pview(hwnd) tool::handle<gtk::view> pview = gtkview(hwnd);
#include "api/window-api.cpp"
#include "api/dom-api.cpp"
#include "api/ext-ctl-api.cpp"
#include "api/value-api.cpp"
#include "api/api-iface.cpp"
