#include "gtk-sciter.h"
#include "gtk-graphics.h"

extern GdkEvent* current_event;

namespace html {

  GtkWindow* get_window(const iwindow* pw) {
    if(!pw) return nullptr;
    auto hwnd = pw->get_hwnd();
    if(!hwnd) return nullptr;
    GtkWidget* gw = gtk_widget_get_toplevel(hwnd);
    if(!gw || !GTK_IS_WINDOW(gw)) return nullptr;
    return GTK_WINDOW(gw);
  }

/* void iwindow::on_animation_start() {
#ifdef _DEBUG
    dbg_printf("animation started!\n");
#endif
  }
  void iwindow::on_animation_end() {
#ifdef _DEBUG
    dbg_printf("animation ended!\n");
#endif
  } */

  bool iwindow::get_topmost() { return false; }
  bool iwindow::set_topmost(bool on) { return false; }

  point iwindow::screen_pos()
  {
    GtkWindow* pw = get_window(this);
    point pos;
    if(pw && GTK_IS_WINDOW(pw))
      gtk_window_get_position(pw,&pos.x,&pos.y);
    //return pos;
    //if(pw && GTK_IS_WINDOW(pw)) {
    //  GdkWindow* gdw = gtk_widget_get_window( GTK_WIDGET(pw) );
    //  if( GDK_IS_WINDOW(gdw) ) {
    //    //GdkRectangle wr = {0};
    //    //gdk_window_get_frame_extents (gdw, &wr);
    //    gdk_window_get_root_origin (gdw,&pos.x,&pos.y);
    //    //return point(wr.x,wr.y);
    //  }
    //}
    return pos;
  }

  size iwindow::client_dim()
  {
  #if 1
    if(!dim.x || !dim.y)
      return window_dim();
    return dim;
  #else
    return window_dim();
  #endif

    /*GtkAllocation allocation = {0};
    auto widget = get_hwnd();
    if(!widget)
      return size();
    gtk_widget_get_allocation (widget, &allocation);
    return gool::size(allocation.width,allocation.height);
    //gool::size sz( gtk_widget_get_allocated_width(get_hwnd()),
    //               gtk_widget_get_allocated_height(get_hwnd()));
    //return sz;*/
  }

  size iwindow::window_dim()
  {
    GtkWindow* pw = get_window(this);
    size sz;
    gtk_window_get_size (pw,&sz.x,&sz.y);
    /*if(pw && GTK_IS_WINDOW(pw)) {
      GdkWindow* gdw = gtk_widget_get_window( GTK_WIDGET(pw) );
      if( GDK_IS_WINDOW(gdw) ) {
        GdkRectangle wr = {0};
        gdk_window_get_frame_extents (gdw, &wr);
        sz.x = wr.width;
        sz.y = wr.height;
      }
    }
    //printf("iwindow::window_dim %d %d\n",sz.x,sz.y);*/
    return sz;
  }

  point iwindow::client_screen_pos()
  {
    //return screen_pos();
    GtkWindow* pw = get_window(this);
    if(!pw)
      return point(-1,-1);

    //point org;
    //auto r = gtk_widget_translate_coordinates(get_hwnd(), GTK_WIDGET(pw), 0, 0, &org.x, &org.y);
    //return org + screen_pos();
    auto hwnd = get_hwnd();
    if(!hwnd)
      return point(-1,-1);

    auto win = gtk_widget_get_window (hwnd);
    if(!win)
      return point(-1,-1);

    gint wx = 0, wy = 0;
    gdk_window_get_origin (win, &wx, &wy);

    return point(wx,wy);
  }

  point iwindow::cursor_pos()
  {
    point pt;
    //::GetCursorPos(PPOINT(pt));
    //::ScreenToClient(get_hwnd(), PPOINT(pt));
    gtk_widget_get_pointer (get_hwnd(), &pt.x, &pt.y);

    return pt;
  }

  gool::rect iwindow::screen_workarea(rect rc) const
  {
    GdkScreen* screen = gdk_screen_get_default();
    GtkWindow* win = get_window(this);
    if( !win || !screen )
      return gool::rect();
    int nm = -1;

    GdkWindow *window = gtk_widget_get_window(GTK_WIDGET(win));

    if( rc.empty() && window )
       nm = gdk_screen_get_monitor_at_window(screen,window);
    else {
       point center = rc.pointOf(5);
       nm = gdk_screen_get_monitor_at_point(screen,center.x,center.y);
    }

    if( nm >= 0 ) {
      GdkRectangle dest;
      gdk_screen_get_monitor_geometry (screen, nm, &dest);
      return gtk::cvt(dest);
    }
    return gool::rect(gool::size( gdk_screen_get_width(screen), gdk_screen_get_height(screen)));
  }

  int     number_of_screens()
  {
    return gdk_screen_get_n_monitors (gdk_screen_get_default());
  }
  int   screen_of(html::iwindow* hw)
  {
    GdkScreen *screen = gtk_widget_get_screen (hw->get_hwnd());
	if(!screen) screen = gdk_screen_get_default ();
		//return gdk_screen_get_number(screen);
    GtkWidget* gtw = gtk_widget_get_toplevel (hw->get_hwnd());
    GdkWindow* gdw = gtk_widget_get_window(gtw);
    return gdk_screen_get_monitor_at_window (screen, gdw);
  }

  bool    get_screen_info(int n, screen_info& si)
  {
    GdkScreen *screen = gdk_screen_get_default ();
    //GdkWindow *rw = gdk_screen_get_root_window (screen);
    //int x, y;
    //gdk_window_get_position (rw,&x,&y);
    GdkRectangle dest;
    gdk_screen_get_monitor_workarea(screen, n, &dest);
    si.workarea = gtk::cvt(dest);
    gdk_screen_get_monitor_geometry (screen, n, &dest);
    si.monitor = gtk::cvt(dest);
    si.is_primary = gdk_screen_get_primary_monitor (screen) == n;
    si.sid = n;
    return true;
  }

#ifdef SCREENSHOT_SUPPORT
  bitmap* get_screen_shot(int n) {

    GdkScreen *screen = gdk_screen_get_default ();
    GdkWindow *root_win = gdk_get_default_root_window();
    gint width = gdk_window_get_width(root_win);
    gint height = gdk_window_get_height(root_win);

    GdkRectangle dest;
    gdk_screen_get_monitor_geometry (screen, n, &dest);

    cairo_surface_t *surface = cairo_image_surface_create(CAIRO_FORMAT_ARGB32,dest.width, dest.height);

    GdkPixbuf *pb = gdk_pixbuf_get_from_window(root_win, dest.x, dest.y, dest.width, dest.height);

    cairo_t *cr = cairo_create(surface);
    gdk_cairo_set_source_pixbuf(cr, pb, 0, 0);
    cairo_paint(cr);

    //cairo_surface_write_to_png(surface, "image.png");
    gtk::bitmap* pbmp = new gtk::bitmap(gool::size(dest.width,dest.height),false,false);

    slice<argb> src;
    src.start = (argb*)cairo_image_surface_get_data( surface );
    src.length = pbmp->dim().x * pbmp->dim().y;
    pbmp->set_bits(src);

    cairo_destroy(cr);
    cairo_surface_destroy(surface);

    return pbmp;

  }
#endif

  void iwindow::invalidate(const rect& area)
  {
    GtkWidget* pwg = get_hwnd();
    if (gtk_widget_get_mapped(pwg))
    {
       if (area.empty())
         gtk_widget_queue_draw(pwg);
       else
         gtk_widget_queue_draw_area(pwg, area.s.x, area.s.y, area.width(), area.height());
    }
  }

  /*void iwindow::post_request_render_layered()
  {
    refresh( rect(client_dim()) );
  }*/


  void iwindow::update()
  {
    //::UpdateWindow(get_hwnd());

    if( client_dim().empty() )
      return;

    GtkWidget* pwg = get_hwnd();
    if (gtk_widget_get_mapped(pwg))
    {
        GdkDisplay* display = gtk_widget_get_display(pwg);
        // Flush everything out to the server, and wait for it to finish.
        // This ensures nothing will overwrite the drawing we are about to do.
        gdk_display_sync(display);

        //GdkWindow* pw = get_window(this);
        //gdk_window_process_updates(pw, true);

        // Flush again, but no need to wait for it to finish
        gdk_display_flush(display);
    }
  }

  //gdk_device_tool_get_tool_type ()
  EVENT_SOURCE get_current_event_source() {
    if(!current_event)
      return ES_UNAVAILABLE;

    GdkDevice * device = gdk_event_get_source_device (current_event);
    if(!device)
      return ES_UNAVAILABLE;

    switch(gdk_device_get_source (device))
    {
     //case GDK_DEVICE_TOOL_TYPE_UNKNOWN: return ES_UNAVAILABLE;
	 case GDK_SOURCE_PEN: return ES_PEN;
	 case GDK_SOURCE_MOUSE: return ES_MOUSE;
	 case GDK_SOURCE_KEYBOARD: return ES_KEYBOARD;
	 case GDK_SOURCE_TOUCHPAD: return ES_TOUCHPAD;
	 case GDK_SOURCE_TOUCHSCREEN : return ES_TOUCH;
	 default: break;
    }
    return ES_UNAVAILABLE;
  }

}
