#include "gtk-sciter.h"

namespace gtk {
  GdkPixbuf* to_pixbuf(gool::bitmap* bmp);
}

namespace gool {

  cursor* cursor::system(uint id)
  {
    static uint cursor_ids[] =
    {
        GDK_LEFT_PTR,     // 0
        GDK_XTERM,        // 1
        GDK_WATCH,        // 2
        GDK_TCROSS,       // 3
        GDK_CENTER_PTR,   // 4
        GDK_SIZING,       // 5
        GDK_SIZING,             // 6 --- !!!!!!!!!!!!!
        GDK_SB_H_DOUBLE_ARROW,  // 7
        GDK_SB_V_DOUBLE_ARROW,  // 8
        GDK_FLEUR,        // 9
        GDK_X_CURSOR,     // 10
        GDK_TARGET,       // 11
        GDK_QUESTION_ARROW,         // 12
        GDK_HAND1,        // 13
        GDK_HAND2,     // 14
        GDK_HAND2,     // 15
        (uint)GDK_BLANK_CURSOR,                // 16 - none

    };
    static handle<cursor> cursors[items_in(cursor_ids)];
    if( id < items_in(cursor_ids) )
    {
      if(!cursors[id]) {
        cursors[id] = new cursor();
        cursors[id]->id = id;
        cursors[id]->pcur = gdk_cursor_new ((GdkCursorType)cursor_ids[id]);
      }
      return cursors[id];
    }
    return 0;
  }

  cursor* cursor::from_bitmap(bitmap* bmp, string url, size offset)
  {
    GdkPixbuf* pixb =  gtk::to_pixbuf(bmp);
    GdkCursor* pcur =  gdk_cursor_new_from_pixbuf (gdk_display_get_default(),pixb,offset.x,offset.y);
    g_object_unref(pixb);

    if(!pcur)
      return nullptr;

    cursor* pc = new cursor();
    pc->pcur = pcur;
    pc->url = url;
    return pc;
  }

cursor* cursor::from_data(bytes data, string url)
  {
    return nullptr;
    /*char tmppath[MAX_PATH];
    char tmpname[MAX_PATH];
    GetTempPathA(MAX_PATH,tmppath);
    GetTempFileNameA(tmppath,"cur",0,tmpname);

    FILE* f = 0; fopen_s(&f,tmpname,"wb+");
    if(!f) return 0;
    fwrite(data.start, data.length,1,f);
    fclose(f);

    HCURSOR h = LoadCursorFromFileA( tmpname );

    ::remove(tmpname);

    assert(h);
    if( !h ) return 0;

    cursor *out = new cursor();
    out->hcur = h;
    out->url  = url;
    return out; */
  }

}
