#ifndef __gtk_application_h__
#define __gtk_application_h__

#include "gtk-types.h"
#include "tool/tool.h"
#include "gool/gool.h"

namespace gtk
{
  using namespace tool;
  using namespace gool;
  using namespace html;

  class view;

  class application: public gool::application
  {
  public:

    static application*    instance;

    application();
    virtual ~application();

    virtual bool is_valid() { return true; }

    virtual gool::font* create_font(const ustring& name
                    , float size
                    , uint weight = 400
                    , bool italic = false
                    , gool::FONT_RENDERING  mode = gool::FR_VECTOR) override;

    virtual void clear_font_cache() override;

    virtual tool::ustring get_supported_font_family(const tool::ustring& family_name_list) override;

    static wchars fallback_list(wchars lang_id, WRITING_SCRIPT script, bool serif );

    virtual void get_system_font(/*inout*/ ustring& name, /*out*/int& size, /*out*/ uint& weight, /*out*/bool& italic) override;

    bool get_supported_font_family(wchars family_name_list,
                                   const function<bool(wchars)>& cb,
                                   tool::wchars lang_id,
                                   WRITING_SCRIPT script );

    virtual bool          install_font(const tool::ustring& name,
                                       int        weight,
                                       bool       italic,
                                       tool::bytes data) override { return false; }

    virtual bool          get_used_font(
                                tool::handle<gool::font>& pf,
                                tool::wchars family_name_list, const gool::font* proto,
                                tool::wchars lang_id,
                                WRITING_SCRIPT script,
                                        uint char_code = 0) override;

    virtual gool::path*     create_path() override;

    virtual gool::graphics* create_bitmap_graphics( gool::graphics *proto, gool::bitmap *bmp, gool::argb initc ) override;
    virtual gool::graphics* create_bitmap_bits_graphics(gool::bitmap* bmp, gool::argb initc, bool high_quality = false) override;
    //virtual gool::text_layout* create_text_layout(tool::wchars text, const gool::text_format& tf) override;

    virtual gool::GRAPHICS_CAPS graphics_caps() const override { return gool::SOFTWARE_GRAPHICS; }

    virtual view* create_window_processor(const window_params& params);

    virtual handle<html::view> create_frame(const window_params& params) override;
    virtual handle<html::view> create_dialog(const window_params& params) override;

  protected:
    virtual bool init_font(gool::font* pfont) override;

    static PangoFontMap*  _font_map;
    static PangoContext*  _pango_ctx;

  };

  application* app_factory();
}

#endif
