#include "gtk-sciter.h"
#include "gtk-application.h"
#include "gtk-view.h"


#if defined(USE_SKIA)

#include "xgl/xgl.h"

//namespace xgl {
//  class application;
//
//  application* app_factory();
//}
#endif

namespace html {
  bool event::get_key_state(uint vk_code) {
    switch( vk_code ) {
      case KB_CAPITAL:
      case KB_NUMLOCK:
      case KB_SCROLL: break;
      default: return false;
    }
    auto km = gdk_keymap_get_default();
    switch( vk_code ) {
      case KB_CAPITAL: return gdk_keymap_get_caps_lock_state(km);
      case KB_NUMLOCK: return gdk_keymap_get_num_lock_state(km);
      case KB_SCROLL: return gdk_keymap_get_scroll_lock_state(km);
      default: return false;
    }
    return false;
  }
}

extern handle<gtk::view> gtk_create_frame(const window_params& params);

namespace gtk {

  static tool::ustring system_fontname()
    {
        ustring r; float dips;
        //osx_system_fontname(r,dips);
        return r;
    }

  static tool::pool<ustring> names;
  handle_pool<gtk::font>     fonts;



  void init_font_list()
    {
        int i;
        PangoFontFamily ** families;
        int n_families;
        PangoFontMap * fontmap;

        fontmap = pango_cairo_font_map_get_default();
        pango_font_map_list_families (fontmap, & families, & n_families);
        //printf ("There are %d families\n", n_families);
        for (i = 0; i < n_families; i++) {
            PangoFontFamily * family = families[i];
            const char * family_name = pango_font_family_get_name (family);
            names.intern( ustring(family_name) );
            //printf ("Family %d: %s\n", i, family_name);
        }
        g_free (families);
    }


  application* application::instance = 0;

  application::application()
  {
      html::init();
      html::behavior::init(true);
  }
  application::~application()
  {
      html::behavior::init(false);
      instance = 0;
  }

  gool::font* application::create_font(const ustring& name , float size , uint weight /*= 400 */, bool italic /*= false */, gool::FONT_RENDERING mode /*= gool::FR_VECTOR*/)
  {
    gtk::font key;
    key.name = name;
    key.size = size;
    //printf("font size %f %d\n",key.size, resolution_provider::desktop().pixels_per_inch().y);
    key.weight = weight;
    key.italic = italic;
    gtk::font* pf = fonts.intern(key);
    if( pf ) init_font(pf);
    return pf;
    //return nullptr;
  }

  bool application::init_font(gool::font* pfont)
  {
    gtk::font* pf = static_cast<gtk::font*>(pfont);
    if( pf && !pf->_pg_font ) {
      if(!_font_map) {
        _pango_ctx = gdk_pango_context_get(),
          _font_map = pango_cairo_font_map_get_default();
      }


      PangoFontDescription * desc = pango_font_description_new ();

      string family = pfont->name;
      const char* pname = family;

      //const float multiplier = 1.1f;
      //int pangosz = pfont->size / multiplier;
      //float device_px = pfont->size;
      //points = pfont->size * 72.0f / 96.0f; // dips to points.

      pango_font_description_set_family(desc,family);
      pango_font_description_set_style (desc,pfont->italic ? PANGO_STYLE_ITALIC : PANGO_STYLE_NORMAL);
      pango_font_description_set_weight (desc, PangoWeight( pfont->weight ));
      pango_font_description_set_absolute_size (desc, pfont->size * PANGO_SCALE);
      //pango_font_description_set_absolute_size(desc, pangosz * PANGO_SCALE);

      auto gf = pango_font_map_load_font (_font_map, _pango_ctx, desc);

      auto cgf = PANGO_CAIRO_FONT(gf);

      pf->_pg_font = cgf;

      PangoFontMetrics * metrics = pango_font_get_metrics (gf, NULL);

      pf->ascent = PANGO_PIXELS_CEIL(pango_font_metrics_get_ascent (metrics));
      pf->descent = PANGO_PIXELS_CEIL(pango_font_metrics_get_descent (metrics));

      //pf->descent = (pf->ascent + pf->descent) * multiplier - pf->ascent;

      pf->x_height = pf->ascent - pf->descent;

      pango_font_metrics_unref (metrics);
      pango_font_description_free (desc);
    }

    return true;
  }

  PangoFontMap*	application::_font_map = 0;

  tool::ustring application::get_supported_font_family(const tool::ustring& family_name_list)
  {
    ustring r;
    auto acceptor = [&r]( wchars ff ) -> bool {
      r = ff;
      return true;
    };
    get_supported_font_family(family_name_list, acceptor, wchars(), WS_UNKNOWN );
    return r;
  }

  PangoContext* application::_pango_ctx = 0;


  bool application::get_used_font(tool::handle<gool::font>& pf, tool::wchars family_name_list, const gool::font* proto, tool::wchars lang_id, WRITING_SCRIPT script, uint char_code /*= 0*/)
  {
    handle<gool::font> rf;
    auto acceptor = [&]( wchars ff ) -> bool
    {
      rf = this->create_font( ff, proto->size, proto->weight, proto->italic, proto->mode);
      if(char_code && !rf->has_glyph_for(char_code)) {
        //printf("unsupported char %x in font %s\n",char_code, string(ff).c_str());
        return false;
      }
      return true;
    };
    bool r =  get_supported_font_family(family_name_list, acceptor, lang_id, script );
    pf = rf;
    return r;
  }

  void application::clear_font_cache()
  {
    fonts.clear();
    names.clear();
  }

  gool::path* application::create_path() {
    return new gtk::path();
  }


  bool application::get_supported_font_family(wchars family_name_list, const function<bool(wchars)>& cb, tool::wchars lang_id, WRITING_SCRIPT script) // cb shall return true if it accepts the family
  {
    //return false;
    if( names.size() == 0 )
      init_font_list();

    static ustring monospace = W("Ubuntu Mono,Courier");
    static ustring serif = W("DejaVu Serif,Times New Roman");
    static ustring sansserif = W("Ubuntu,DejaVu Sans,Lucida Sans Unicode,Arial");
    static ustring system = system_fontname();
    //      static ustring system = system_fontname() + W(",sans-serif,!");
    static ustring last_resort = W("DejaVu Sans");

    //printf("get_supported_font_family %s\n",string(family_name_list).c_str());

    wtokens tz( family_name_list,WCHARS(",;") );
    wchars name;

    while(tz.next(name))
    {
      name = trim(name);
      //printf("scan font %s in list %s\n",string(name).c_str(),string(family_name_list).c_str());
      if( icmp(name,WCHARS("monospace"))  )
        return get_supported_font_family( monospace(), cb, lang_id, script);
      else if( icmp(name,WCHARS("sans-serif")) )
        return get_supported_font_family( sansserif(), cb, lang_id, script )
        || get_supported_font_family( fallback_list( lang_id, script, false ), cb,  lang_id, script );
      else if( icmp(name,WCHARS("serif")) ) {
        return get_supported_font_family( serif(),cb,  lang_id, script )
          || get_supported_font_family( fallback_list( lang_id, script, true ) , cb,  lang_id, script );
      }
      else if( icmp(name,WCHARS("cursive")) )
        return get_supported_font_family(WCHARS("zapf chancery,freestyle script,brush script,serif"),cb, lang_id, script);
      else if( icmp(name,WCHARS("fantasy")) )
        return get_supported_font_family(WCHARS("comic sans,zapfino,sans-serif"),cb, lang_id, script);
      else if( name.like(W("system*"))) {
        if(cb(system()))
          return true;
        break;
      }
      else if(name == WCHARS("!"))
        return cb(last_resort());
      else if(names.exists(name) && cb( name ))
        return true;
      else if( icmp(name,system()) && cb( name ) )
        return true;
    }
    return get_supported_font_family( fallback_list( lang_id, script, false ) , cb,  lang_id, script );
    //  return true;
    //cb(last_resort());
    //return true;
  }

  tool::wchars application::fallback_list(wchars lang_id, WRITING_SCRIPT script, bool serif)
  {
    //printf("fallback list %s script %d\n",string(lang_id).c_str(),script);
    switch(script)
    {
    default:
    case WS_UNKNOWN:
      return serif
        ? WCHARS("Georgia,DejaVu Serif,Times New Roman,FreeSerif,Century Schoolbook L,!")
        : WCHARS("Ubuntu,DejaVu Sans,FreeSans,Arial,Liberation Sans,Trebuchet MS,Arial Unicode MS,!");
    case WS_CYRILLIC: return serif
                        ? WCHARS("DejaVu Serif,Georgia,!")
                        : WCHARS("DejaVu Sans,Arial,!");
    case WS_HANZI:
      if(lang_id.starts_with(WCHARS("ja")))
        return serif
        ? WCHARS("Noto Serif CJK JP,DejaVu Serif,!")
        : WCHARS("Noto Sans CJK JP,DejaVu Sans,!");
      else if(lang_id.ends_with(WCHARS("tw")) || lang_id.ends_with(WCHARS("hant")))
        return serif  // traditional
        ? WCHARS("Noto Serif CJK TC,AR PL UKai TW,AR PL UMing TW,DejaVu Serif,!")
        : WCHARS("Noto Sans CJK TC,DejaVu Sans,AR PL UKai TW,AR PL UMing TW,!");
      else
        return serif  // simplified
        ? WCHARS("Noto Serif CJK SC,AR PL UKai CN,AR PL UMing CN,DejaVu Serif,!")
        : WCHARS("Noto Sans CJK SC,DejaVu Sans,AR PL UKai CN,AR PL UMing CN,!");
    case WS_KANA:
      return serif
        ? WCHARS("Noto Serif CJK JP,DejaVu Serif,!")
        : WCHARS("Noto Sans CJK JP,DejaVu Sans,!");
    case WS_ARABIC:
      return serif
        ? WCHARS("KacstBook,DejaVu Serif,!")
        : WCHARS("KacstNaskh,KacstFarsi,DejaVu Sans,!");
    case WS_HEBREW:
      return serif
        ? WCHARS("DejaVu Serif,!")
        : WCHARS("Ubuntu,DejaVu Sans,!");
    case WS_HANGUL:
      return serif
        ? WCHARS("Noto Serif CJK KR,Noto Serif CJK JP,DejaVu Serif,!")
        : WCHARS("Noto Sans CJK KR,Noto Sans CJK JP,DejaVu Sans,!");
    }
  }

  void application::get_system_font(/*inout*/ ustring& name, /*out*/int& size, /*out*/ uint& weight, /*out*/bool& italic)
  {
    // taken from gool::get_system_font() (gtk/gtk-gool.cpp)
    const char *param_name = "gtk-font-name";
    gchar *value = NULL;
    GtkSettings* settings = gtk_settings_get_default();
    g_object_get(settings, param_name, &value, NULL);
    chars namesize = chars_of(value);
    chars ssize = namesize.r_tail(' ');
    chars sname = namesize.r_head(' ');
    size = str_to_i(ssize,10) * 96 / 72;

    name = ustring(!sname ? CHARS("Sans"): sname);
    weight = 400;
    italic = false;
  }

  gool::graphics* application::create_bitmap_graphics( gool::graphics *proto, gool::bitmap *bmp, gool::argb initc )
  {
    return new bitmap_graphics(bmp,initc);
  }
  gool::graphics* application::create_bitmap_bits_graphics(gool::bitmap* bmp, gool::argb initc, bool high_quality)
  {
    return new bitmap_bits_graphics(bmp,initc);
  }


  /*gool::text_layout* application::create_text_layout(tool::wchars text, const gool::text_format& tf)
  {
    gtk::text_layout* pl =  new gtk::text_layout();
    pl->set( resolution_provider::desktop(),text, tf, this );
    return pl;
  }*/

  handle<html::view> application::create_frame(const window_params& params)
  {
    return  handle<html::view>(gtk_create_frame(params).ptr());
  }

  handle<html::view> application::create_dialog(const window_params& params)
  {
    return  handle<html::view>(gtk_create_frame(params).ptr());
  }

  gtk::view* application::create_window_processor(const window_params& params)
  {
    return new gtk::view(params);
  }

  application* app_factory()
  {
    if(!gtk::application::instance) {
#if defined(USE_SKIA)
      if( application::requested_gfx_layer == SKIA_OPENGL_GRAPHICS || application::requested_gfx_layer == SKIA_GRAPHICS )
        gtk::application::instance = xgl::app_factory();
      if(!gtk::application::instance)
#endif
        gtk::application::instance = new gtk::application();
    }
    return gtk::application::instance;

  }

  application* app()
  {
/*    void* app = nullptr;
    for(;;) {
  #ifdef USE_SKIA
      // try Skia first
      if(app = xgl::app_factory())
        break;
  #endif // USE_SKIA

      // then Cairo
      if(app = gtk::app_factory())
        break;
      break;
    }
    return static_cast<application*>(app);
    */
    return app_factory();
  }
}

namespace gool {

  application* app()
  {
    return gtk::app();
  }
}

/*
tool::bytes get_app_resource( const wchar* res_id, const wchar* res_type_id)
{
  wchars ext = chars_of(res_type_id);
  if( ext == WCHARS("HTML") || ext == WCHARS("html") )
      res_type_id = W("HTM");
  tool::string name = tool::string::format("%S.%S",res_id, res_type_id);
  name.to_lower();
  tool::bytes r;
  //get_sciterlib_resource( name, r.start, r.length);
  return r;
}

tool::bytes get_stock_style_resource()
{
  return get_app_resource(W("MASTER"),W("CSS"));
} */

#if defined(SCITERJS)
  #include "master-css-resources-js.cpp"
#else
  #include "master-css-resources.cpp"
#endif


tool::bytes get_resource( const wchar* path ) {
  static tool::sar ctx( tool::items_of(master_css_resources) );
  return ctx.get(path);
}

std::pair<tool::bytes,tool::ustring> get_stock_style_resource()
{
  tool::ustring u = W("ux-master.css");
  tool::bytes r = get_resource(u);
  return std::pair<tool::bytes,tool::ustring>(r,u);
}

bool load_file_thumbnail(const ustring& path, uint size, load_file_thumbnail_callback* pcb)
{
  return false;
}
