#pragma once

#ifndef __xdomjs_xwebsockets_h__
#define __xdomjs_xwebsockets_h__

#include "xcontext.h"
#include "xconv.h"
#include "tool/tl_async_io.h"
#include "tool/websockets/websockets.h"

namespace qjs
{
  using namespace html;
  extern JSClassID WebSocket_class_id;

  class websocket : public tool::async::websocket_connection, public event_target
  {
  public:
    hvalue   obj;
    hcontext ctx;

    enum WS_STATE {
      CONNECTING = 0,
      OPEN = 1,
      CLOSING = 2,
      CLOSED = 3,
    };

    websocket(xcontext& c, hvalue o): ctx(c),obj(o) { 
      add_ref();
      JS_SetOpaque(obj, this);
      JS_DupValue(c, obj);
    }

    virtual bool get_expando(html::context& hc, script_expando& seo) override {
      seo = obj;
      return true;
    }

    bool notify(event_behavior& evt)
    {
      xcontext c(ctx);
      return handle_event(c, evt);
    }
    virtual void on_connected()
    {
      event_primitive evt(WCHARS("open"));
      notify(evt);
    }
    virtual void on_text(wchars text) {
      event_primitive evt(WCHARS("message"));
      evt.data = value(text);
      notify(evt);
    }
    virtual void on_data(bytes binary) {
      event_primitive evt(WCHARS("message"));
      evt.data = value::make_bytes(binary);
      notify(evt);
    }
    virtual void on_closed() {
      event_primitive evt(WCHARS("close"));
      if(obj && ctx)
        notify(evt);
      obj.clear();
      ctx.clear();
    }
    virtual void on_error(chars errm) {
      event_primitive evt(WCHARS("error"));
      evt.data = value::make_error(errm);
      notify(evt);
      //obj.clear(); wrong - need this for on_closed
      //ctx.clear();
    }
  };

  template <> struct conv<websocket*>
  {
    static websocket* unwrap(JSContext * ctx, JSValueConst v)
    {
      websocket* pe = (websocket*)JS_GetOpaque(v, WebSocket_class_id);
      if (!pe)
        throw qjs::om::type_error("WebSocket was deleted");
      return static_cast<websocket*>(pe);
    }

    static websocket* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      websocket* pe = (websocket*)JS_GetOpaque(v, WebSocket_class_id);
      if (!pe) return nullptr;
      return static_cast<websocket*>(pe);
    }

    static JSValue wrap(JSContext * ctx, websocket* pr) noexcept
    {
      /*if (!pr->obj) {
        pr->obj.v = JS_NewObjectClass(ctx, WebSocket_class_id);
        pr->add_ref();
        JS_SetOpaque(pr->obj.v, (resource*)pr);
      }
      //return JS_DupValue(ctx, pr->obj.v); //- no! otherwise it will be a dead link. 
      */
      assert(pr->obj.v);
      return pr->obj.v;
      //return JS_DupValue(ctx, pr->obj.v); //- no! otherwise it will be a dead link. 
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, WebSocket_class_id) != NULL; }
  };

}

#endif
