#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"

#if defined(WEBSOCKETS_SUPPORT)

#include "xwebsockets.h"


namespace qjs
{
  using namespace html;

  JSClassID WebSocket_class_id = 0;

  /*string    websocket_def(xcontext& c, websocket *rq) {
    return string::format("WebSocket(%s)", rq->);
  }*/

  int websocket_ready_state(xcontext& c, websocket *ws) {
    switch (ws->get_state()) {
    case tool::async::websocket_connection::CONNECTING:
    case tool::async::websocket_connection::NAME_RESOLVING: return websocket::CONNECTING;
    case tool::async::websocket_connection::CONNECTED:      return websocket::OPEN;
    case tool::async::websocket_connection::CLOSING:        return websocket::CLOSING;
    default:
    case tool::async::websocket_connection::INITIAL:
    case tool::async::websocket_connection::CLOSED:         return websocket::CLOSED;
    }
  }

  int64 websocket_buffered_amount(xcontext& c, websocket *ws) {
    return ws->data_to_send.size();
  }

  bool websocket_send(xcontext& c, websocket *ws, hvalue data)
  {
    if (JS_IsString(data)) {
      string s = c.get<string>(data);
      ws->send_message(s.chars_as_bytes(), websocket::TEXT_FRAME);
      return true;
    }
    else {
      size_t size;
      size_t aoffset, asize;
      hvalue abuf = JS_GetTypedArrayBuffer(c, data, &aoffset, &asize, NULL);
      if (JS_IsException(abuf))
        return false;
      byte *buf = JS_GetArrayBuffer(c, &size, abuf);
      if (!buf)
        return false;
      buf += aoffset;
      size = asize;
      ws->send_message(bytes(buf,size), websocket::BINARY_FRAME);
      return true;
    }
  }

  bool websocket_close(xcontext& c, websocket *ws, int_v code, string reason)
  {
#pragma TODO("close code?")
    ws->close();
    return true;
  }

  JSOM_PASSPORT_BEGIN(WebSocket_def, qjs::websocket)
    JSOM_CONST_STR("[Symbol.toStringTag]", "WebSocket", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("readyState", websocket_ready_state),
    JSOM_RO_PROP_DEF("bufferedAmount", websocket_buffered_amount),
    JSOM_FUNC_DEF("send", websocket_send),
    JSOM_FUNC_DEF("close", websocket_close),
  JSOM_PASSPORT_END

  void init_WebSocket_class(context& ctx)
  {
    JS_NewClassID(&WebSocket_class_id);

    static JSClassDef WebSocket_class = {
      "WebSocket",
      [](JSRuntime *rt, JSValue val)
      {
        websocket* pr = (websocket*)JS_GetOpaque(val,WebSocket_class_id);
        if (pr) {
          pr->obj.tearoff();
          pr->release();
        }
      }
    };

    JS_NewClass(JS_GetRuntime(ctx), WebSocket_class_id, &WebSocket_class);
    JSValue websocket_proto = JS_NewObject(ctx);

    auto list = WebSocket_def();
    JS_SetPropertyFunctionList(ctx, websocket_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto = JS_UNDEFINED;
      tool::url u;
      xcontext c(ctx);
      websocket* pws = nullptr;

      if (argc == 0 || !JS_IsString(argv[0])) {
        JS_ThrowSyntaxError(ctx, "URL expected");
        goto fail;
      }
      if(!u.parse(c.get<string>(argv[0])))
      {
        JS_ThrowSyntaxError(ctx, "URL expected");
        goto fail;
      }
      if (u.protocol != CHARS("wss") && u.protocol != CHARS("ws")) {
        JS_ThrowSyntaxError(ctx, "ws:// or wss:// URL schema is expected");
        goto fail;
      }

      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, WebSocket_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;

      pws = new websocket(c,obj);
      pws->connect(u);
      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue websocket_class = JS_NewCFunction2(ctx, ctor, "WebSocket", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(ctx, ctx.global(), "WebSocket", JS_DupValue(ctx, websocket_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    JS_SetConstructor(ctx, websocket_class, websocket_proto);
    JS_SetClassProto(ctx, WebSocket_class_id, websocket_proto);

  }


}


#endif // WEBSOCKETS_SUPPORT
