#ifndef __xdomjs_xview_h__
#define __xdomjs_xview_h__

#include "tool/tool.h"
#include "html/html.h"
#include "xjs.h"
#include "xcontext.h"
#include "xconv.h"
#include "xgraphics.h"

namespace qjs {
  using namespace tool;
  using namespace gool;

  extern JSClassID Window_class_id;

  class xview : public html::view, public html::event_target , public html::script_expando_interface
  {
  public:
    typedef html::view super;

    bool         owns_vm = false;
    qjs::hvalue  dialog_retval;
    qjs::hvalue  obj;
    qjs::hvalue  parameters;
    array<byte>  reload_data;

    uint         dispatch_event_level = 0;

    html::timer_def* processing_timer = nullptr;

    string home_url;

    xview(const window_params& params) : super(params) {
      if (params.window_obj) {
        obj = params.window_obj;
        JS_SetOpaque(obj, this);
        add_ref();
      }
      qjs::hruntime::current().add_ref();
      parameters = params.window_parameters;
      dialog_retval.v = JS_UNDEFINED;
    }

    virtual ~xview() {}

    virtual void stop() override;
    virtual bool get_expando(html::context& hc, script_expando& seo) override {
      seo = obj;
      return true;
    }

    static void init_class(JSContext* ctx);

    //virtual bool ask_unload(html::document *, view::UNLOAD_REASON reason) override;
    virtual bool on_unload(html::document *) override;
    virtual void on_load_end(html::document *d, bool existing_doc_replaced) override;
    virtual void on_load_start(html::document *d) override;

    virtual value get_retval() override;

    #define EXEC2(A,B) if(A) return true; return B

    virtual bool on_element_event(html::element * b, html::event_mouse &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b,evt)); }
    virtual bool on_element_event(html::element * b, html::event_key &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b, evt)); }
    virtual bool on_element_event(html::element * b, html::event_focus &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b, evt)); }
    virtual bool on_element_event(html::element * b, html::event_scroll &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b, evt)); }
    virtual bool on_element_event(html::element * b, html::event_command &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b, evt)); }
    virtual bool on_element_event(html::element * b, html::event_exchange &evt) override { EXEC2(handle_element_event(b, evt), super::on_element_event(b, evt)); }
    virtual bool on_element_event(html::element * b, html::event_gesture &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b, evt)); }
    virtual bool on_element_timer(html::element *b, html::timer_def &td) override { EXEC2(handle_element_timer(b, td),super::on_element_timer(b, td)); }
    virtual bool on_element_event(html::element * b, html::event_behavior &evt) override { EXEC2(handle_element_event(b, evt),super::on_element_event(b, evt)); }
    
    #undef EXEC2

    virtual bool on_element_draw_background(gool::graphics *pg, html::element *el, gool::point pos) override;
    virtual bool on_element_draw_foreground(gool::graphics *pg, html::element *el, gool::point pos) override;
    virtual bool on_element_draw_content(gool::graphics *pg, html::element *el, gool::point pos) override;
    virtual bool on_element_draw_outline(gool::graphics *pg, html::element *el, gool::point pos) override;

    virtual void on_element_client_size_changed(html::element *b) override;
    virtual void on_element_client_size_changing(html::element *b, bool horizontal, int val) override;  // immediate
    virtual void on_element_visibility_changed(html::element *b, bool on_off) override;

    virtual void on_data_request_notify(html::element *self, pump::request *rq) override;
    virtual void on_data_arrived_notify(html::element *self, pump::request *rq) override;
    
            bool handle_element_timer(html::element *b, html::timer_def &td);
    virtual bool handle_element_event(html::helement b, html::event &evt) override;
            bool handle_view_event(html::event &evt);

    virtual bool may_have_on_size_handler(html::element *b) override;

    virtual bool get_element_value(helement b, value &v, bool ignore_text_value);
    virtual bool set_element_value(helement b, const value &v, bool ignore_text_value);

    virtual bool call_element_method(element *b, const char *name,
      slice<tool::value> args,
      tool::value &retval) override;

    virtual bool on(html::view &v, html::element *self, html::event_behavior &evt) override
    {
      if (super::on(v, self, evt))
        return true;
      return handle_view_event(evt);
    }

    virtual void on_state_changed() override {
      super::on_state_changed();
      html::event_behavior evt(WCHARS("statechange"));
      this->post_behavior_event(evt, true);
    }

    virtual bool on_activate(html::ACTIVATE_MODE am) override {
      bool r = super::on_activate(am);
      html::event_behavior evt(WCHARS("activate"));
      evt.reason = am;
      this->post_behavior_event(evt, true);
      return r;
    }

    virtual void on_dpi_changed(size dpi, rect proposed_window_rect) override
    {
      super::on_dpi_changed(dpi, proposed_window_rect);
      html::event_behavior evt(WCHARS("resolutionchange"));
      this->post_behavior_event(evt, true);
    }
    virtual bool on_media_changed() override {
      bool r = super::on_media_changed();
      html::event_behavior evt(WCHARS("mediachange"));
      this->post_behavior_event(evt, true);
      return r;
    }

    virtual void on_start_ui_replacement(tristate_v sizing = tristate_v()) override {
      super::on_start_ui_replacement(sizing);
      html::event_behavior evt(WCHARS("replacementstart"));
      this->post_behavior_event(evt, true);
    }

    virtual void on_end_ui_replacement(tristate_v sizing = tristate_v()) override {
      super::on_end_ui_replacement(sizing);
      html::event_behavior evt(WCHARS("replacementend"));
      this->post_behavior_event(evt, true);
    }

    virtual void on_size_changed() override {
      html::event_behavior evt(WCHARS("size"));
      this->send_behavior_event(evt);
    }
    virtual void on_move() override {
      super::on_move();
      html::event_behavior evt(WCHARS("move"));
      this->send_behavior_event(evt);
    }

    virtual void on_unmount_element(xcontext& c, element* pe) {

      if (pe->flags.has_global_subscriptions) {
        c.pxview()->unsubscribe(pe);
        pe->flags.has_global_subscriptions = 0;
      }
      
      if (!pe->obj)
        return;
      hvalue method = c.get_prop<hvalue>(c.known_atoms().componentWillUnmount, pe->obj);
      if (c.is_function(method)) {
        try {
          bool dummy;
          c.call(dummy, method, pe->obj);
        }
        catch (qjs::exception) {
          c.report_exception();
        }
      }
      // WRONG! pe->obj.clear(); 
    }

    virtual void on_mount_element(xcontext& c, helement pe) {
      if (!pe->obj)
        return;

      handle<document> pd = c.pdoc();

      if (hvalue method = c.get_prop<hvalue>(c.known_atoms().componentDidMount, pe->obj)) {

        try {
          bool dummy;
          c.call(dummy, method, pe->obj);
        }
        catch (qjs::exception) {
          c.report_exception();
        }

        /*c.pview()->post([pd,method,pe]()->bool {
          xcontext c(pd);
          try {
            bool dummy;
            c.call(dummy, method, pe->obj);
          }
          catch (qjs::exception) {
            c.report_exception();
          }
          return true;
        });*/
      }
    }

    virtual bool trayicon_notify(point screen_pt, uint buttons, html::mouse_events cmd) override 
    {
      if( cmd == html::MOUSE_CLICK) {
        html::event_behavior evt(WCHARS("trayiconclick"));
        
        evt.data.set_prop("screenX", value(screen_pt.x));
        evt.data.set_prop("screenY", value(screen_pt.y));
        evt.data.set_prop("buttons", value(int(buttons)));
        
        return this->send_behavior_event(evt);
      }
      return false;
    }

    html::ctl *create_behavior(html::element *b, const string &name) override;

    bool has_pending_script_jobs() const;
    bool exec_idle() override;
    bool wants_idle() const override;

    void on_element_prototype_change(xcontext& c, handle<html::element> psb);

    virtual void on_style_resolved(handle<html::element> psb, const html::style *   prev_style) override;
    void process_prototype(handle<html::element> psb, const string &name, const string &prev_name);
    void process_handlers(handle<html::element> psb, const html::handler_list_v &handler_list);
    virtual void on_element_removing(html::element *psb) override;

    void run(html::hdocument pd, chars text, chars url, bool module, int line_no = 0);

    static void set_init_script(const char* script_text);

    //virtual bool load_data(pump::request *rq, bool now = false) override;
    virtual bool on_data_loaded(pump::request *prq) override {
      bool r = super::on_data_loaded(prq);
      notify_resource_arrival(prq);
      return r;
    }
    void notify_resource_arrival(handle<pump::request> prq);

    virtual void dispatch_posted_event(handle<html::posted_event> pe) override {
      while (pe->cbf && pe->target)
      {
        html::document* pd = pe->target->doc();
        if (!pd)
          break;
        xcontext c(pd);
        try {
          hvalue rv;
          c.call(rv, pe->cbf, pe->target);
        }
        catch (qjs::exception) {
          c.report_exception();
        }
        return;
      }
      super::dispatch_posted_event(pe);
    }
    
    void post_event(html::posted_event& evt, bool only_if_not_exist = false) {
      critical_section _pg(posted_guard);

      if (only_if_not_exist) {
        if (document* pd = evt.target->doc()) {
          xcontext c(pd);
          for (auto& he : posted_events) {
            if (!he->cbf) continue;
            if ((he->target == evt.target) && JS_AreFunctionsOfSameOrigin(c, he->cbf, evt.cbf))
              return;
          }
        }
      }
      posted_events.push(new html::posted_event(evt));
      request_idle();
    }

  };

  template <> struct conv<xview*>
  {
    static xview* unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      xview* pv = (xview*)JS_GetOpaque(v, Window_class_id);
      if (!pv) 
        throw qjs::om::type_error("Window was deleted");
      return pv;
    }

    static xview* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      return (xview*)JS_GetOpaque(v, Window_class_id);
    }

    static JSValue wrap(JSContext * ctx, xview* pv) noexcept
    {
      if (!pv)
        return JS_NULL;
      if (!pv->obj) {
        pv->obj.v = JS_NewObjectClass(ctx, Window_class_id);
        pv->add_ref();
        JS_SetOpaque(pv->obj.v, pv);
      }
      return JS_DupValue(ctx, pv->obj.v);
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Window_class_id) != NULL; }
  };

  template <> struct conv<handle<xview>>
  {
    static handle<xview> unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      return conv<xview*>::unwrap(ctx,v,argc);
    }

    static xview* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      return conv<xview*>::try_unwrap(ctx, v, argc);
    }

    static JSValue wrap(JSContext * ctx, handle<xview> pv) noexcept
    {
      return conv<xview*>::wrap(ctx, pv.ptr());
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Window_class_id) != NULL; }
  };



  struct timer_callback: resource {
    qjs::hvalue fun;
  };

}

#endif
