#pragma once

#ifndef __xdomjs_xurl_h__
#define __xdomjs_xurl_h__

#include "tool.h"
#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  using namespace tool;

  struct xurl : public resource, public tool::url {
    typedef tool::url super;
    xurl() {}
    xurl(document* pd): super(pd->uri()) {}
  };
   
  extern JSClassID URL_class_id;

  template <> struct conv<handle<xurl>>
  {
    static handle<xurl> unwrap(JSContext * ctx, JSValueConst v)
    {
      handle<xurl> purl;
      if (JS_IsString(v)) {
        purl = new xurl();
        purl->parse(conv<tool::string>::unwrap(ctx, v));
      }
      else 
        purl = (xurl*)JS_GetOpaque(v, URL_class_id);
      if (!purl)
        throw qjs::om::type_error("URL was deleted");
      return purl;
    }

    static JSValue wrap(JSContext * ctx, handle<xurl> purl) noexcept
    {
      if (!purl)
        return JS_NULL;
      JSValue obj = JS_NewObjectClass(ctx, URL_class_id);
      purl->add_ref();
      JS_SetOpaque(obj, purl.ptr());
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, URL_class_id) != NULL; }
  };

}

#endif
