#include "xdom.h"
#include "xom.h"
#include "xstyle.h"
#include "xgraphics.h"

namespace html {
  //bool element::js_set_styles(context&, tool::value map) {
  //  map = map;
  //  return true;
  //}
}

namespace qjs 
{
  using namespace tool;

  JSClassID Style_class_id = 0;

  string css_to_camel_case(const char* s)
  {
    array<char> out; out.reserve(20);

    for (; *s; ++s) {
      // check for '-' in the name  
      if (*s == '-') {
        // conversion into upper case  
        out.push(toupper(*s));
        continue;
      }
      // if not '-', copy character  
      else
        out.push(*s);
    }
    return out();
  }

  uint_v cssa_from_camel_case(const char* s)
  {
    array<char> out; out.reserve(20);
    for (; *s; ++s) {
      char lo = tolower(*s);
      if (lo != *s) { // upper case, inject '-'
        out.push('-');
        out.push(lo);
      }
      else // if not upper case, copy character  
        out.push(*s);
    }
    out.push(0);
    return html::cssa::lookup(out.cbegin());
  }
 

  JSValue style_getter_magic(JSContext *ctx, JSValueConst this_val, int magic) {
    html::style_provider* sp = conv<html::style_provider*>::unwrap(ctx, this_val);
    if (sp) {
      xcontext c(ctx);
      html::element* pe = static_cast<html::element*>(sp);
      const html::style* ps = pe->get_style(*c.pview(), c.pdoc());
      tool::value v = pe->get_style()->to_value(html::cssa::symbol_t(magic));
      return conv<ustring>::wrap(ctx, v.to_string());
    }
    return JS_UNDEFINED;
  }

  JSValue style_setter_magic(JSContext *ctx, JSValueConst this_val, JSValueConst value, int magic) {
    html::style_provider* sp = conv<html::style_provider*>::unwrap(ctx, this_val);
    if (sp) {
      xcontext c(ctx);
      ustring val = conv<ustring>::unwrap(ctx, value);
      html::element* pe = static_cast<html::element*>(sp);
      html::style* ps = pe->get_style(*c.pview(), c.pdoc());
      html::style_prop_list pl;
      html::parse_css_property_as(c.pdoc(), html::cssa::symbol_t(magic), val(), &pl);
      pe->set_style_attributes(pl);
    }
    return JS_UNINITIALIZED;
  }
  
  int style_get_own_property(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop)
  {
    atom_chars ac(ctx, prop);
    uint_v sym = cssa_from_camel_case(ac.start);
    //uint_v sym = html::cssa::lookup(ac.start);
    if (sym.is_undefined())
      return FALSE;
    if (desc) {
      desc->getter = JS_NewCFunction2(ctx, (JSCFunction *)style_getter_magic, "style::getter", 0, JS_CFUNC_getter_magic, (int)sym.val(0));
      desc->setter = JS_NewCFunction2(ctx, (JSCFunction *)style_setter_magic, "style::setter", 0, JS_CFUNC_setter_magic, (int)sym.val(0));
      desc->value = JS_UNDEFINED;
      desc->flags = JS_PROP_GETSET;
    }
    return TRUE;
  }

  bool style_set_property(xcontext& c, html::style_provider* sp, string prop_name, ustring val, bool important) {
    //setProperty(propertyName, value, priority);
    html::element* pe = static_cast<html::element*>(sp);
    html::style* ps = pe->get_style(*c.pview(), c.pdoc());
    html::style_prop_list pl;
    uint_v sym = html::cssa::lookup(prop_name.cbegin());
    if (sym.is_defined()) {
      html::parse_css_property_as(c.pdoc(), sym.val(), val(), &pl);
      if (important)
        swap(pl.props, pl.important_props);
      pe->set_style_attributes(pl);
      return true;
    }
    return false;
  }
  ustring style_get_property(xcontext& c, html::style_provider* sp, string prop_name) {
    //setProperty(propertyName, value, priority);
    html::element* pe = static_cast<html::element*>(sp);
    html::style* ps = pe->get_style(*c.pview(), c.pdoc());
    html::style_prop_list pl;
    uint_v sym = html::cssa::lookup(prop_name.cbegin());
    if (sym.is_undefined())
      return ustring();
    tool::value v = pe->get_style()->to_value(sym.val(0));
    if(v.is_undefined())
      return ustring();
    return v.to_string();
  }

  hvalue style_colorOf(xcontext& c, html::style_provider* sp, string prop_name) {
    html::element* pe = static_cast<html::element*>(sp);
    html::style* ps = pe->get_style(*c.pview(), c.pdoc());
    html::style_prop_list pl;
    uint_v sym = html::cssa::lookup(prop_name.cbegin());
    if (sym.is_undefined())
      return hvalue();
    tool::value v = pe->get_style()->to_value(sym.val(0));
    if (v.is_undefined())
      return hvalue();
    if (v.is_color()) {
      color_v cv; html::color_value(cv, v);
      return c.val(cv.to_argb());
    }
    return hvalue();
  }

  hvalue style_pixelsOf(xcontext& c, html::style_provider* sp, string prop_name) 
  {
    html::element* pe = static_cast<html::element*>(sp);
    html::style* ps = pe->get_style(*c.pview(), c.pdoc());
    html::style_prop_list pl;
    uint_v sym = html::cssa::lookup(prop_name.cbegin());
    if (sym.is_undefined())
      return hvalue();
    tool::value v = pe->get_style()->to_value(sym.val(0));
    if (v.is_undefined())
      return hvalue();
    if (v.is_length()) {
      html::size_v sz = v;
      int ppx = html::pixels(*c.pview(), pe, sz, pe->dim()).width();
      return c.val(c.pview()->ppx_to_dip(size(ppx,ppx)).x);
    }
    return hvalue();
  }

  himage style_imageOf(xcontext& c, html::style_provider* sp, string prop_name)
  {
    html::element* pe = static_cast<html::element*>(sp);
    html::style* ps = pe->get_style(*c.pview(), c.pdoc());
    //html::style_prop_list pl;
    uint_v sym = html::cssa::lookup(prop_name.cbegin());
    if (sym.is_undefined())
      return himage();
    switch (sym) {
      case html::cssa_background_image:
        return pe->get_back_image(*c.pview());
      case html::cssa_foreground_image:
        return pe->get_fore_image(*c.pview());
      case html::cssa_list_style_image:
        return ps->list_style_image.img();
      default:
        return himage();
    }
  }


  hvalue style_variables(xcontext& c, html::style_provider* sp, hvalue toset)
  {
    html::element* pe = static_cast<html::element*>(sp);
    if (c.is_object(toset)) {
      tool::dictionary<tool::string, tool::value> vars;

      c.each_prop(toset, [&](chars name, hvalue val) {
        tool::value v;
        if (html::parse_css_value(c, c.get<tool::ustring>(val)(), v))
          vars[name] = v;
        else
          throw qjs::om::type_error("bad variable value");
        });

      pe->set_style_variables(*c.pview(), vars);
      return hvalue();
    }
    else {
      hvalue retval = JS_NewObjectProto(c, JS_NULL);
      for (auto& pair : pe->get_style()->vars.items)
      {
        tool::string name = html::attr::symbol_name(pair.att_sym);
        c.set_prop(name, retval, pair.att_value.to_string());
      }
      for (auto& pair : pe->vars.items) {
        tool::string name = html::attr::symbol_name(pair.att_sym);
        c.set_prop(name, retval, pair.att_value.to_string());
      }
      return retval;
    }
  }

  hvalue style_variable(xcontext& c, html::style_provider* sp, string name, hvalue toset) {

    html::element* pe = static_cast<html::element*>(sp);

    if (toset.is_defined()) {
      tool::dictionary<tool::string, tool::value> vars;
      tool::value v;
      if (html::parse_css_value(c, c.get<tool::ustring>(toset)(), v))
        vars[name] = v;
      else
        throw qjs::om::type_error("bad variable value");
      pe->set_style_variables(*c.pview(), vars);
      return hvalue();
    }
    else {
      tool::value v;
      if (!pe->get_var(html::element_context(c,pe), name, v))
        return hvalue();
      return c.val(v);
    }
  }



#if 0    

  static int style_has_property(JSContext *ctx, JSValueConst obj, JSAtom atom)
  {
    const char* str = JS_AtomToCString(ctx, atom);
    html::cssa::symbol_t prop_sym = cssa_from_camel_case(str);
    JS_FreeCString(ctx, str);
    return prop_sym > 0;
  }


  static JSValue style_get_property(JSContext *ctx, JSValueConst obj, JSAtom atom, JSValueConst receiver)
  {
    const char* str = JS_AtomToCString(ctx, atom);
    html::cssa::symbol_t prop_sym = cssa_from_camel_case(str);
    JS_FreeCString(ctx, str);
    if (prop_sym > 0) {
      html::style_provider* sp = conv<html::style_provider*>::unwrap(ctx, obj);
      if (sp) {
        xcontext c(ctx);
        html::element* pe = static_cast<html::element*>(sp);
        const html::style* ps = pe->get_style(*c.pview(), c.pdoc());
        tool::value v = pe->get_style()->to_value(prop_sym);
        if (v.is_variable_color()) {
          color_v cv; html::color_value(cv, v);
          v = pe->resolve_color(cv).to_value();
        }
        else if (v.is_variable_length())
          v = pe->resolve_length(html::size_v(v)).to_value();
        return conv<ustring>::wrap(ctx,v.to_string());
      }
    }
    return JS_UNDEFINED;
  }
  /* return < 0 if exception or TRUE/FALSE */
  static int style_set_property(JSContext *ctx, JSValueConst obj, JSAtom atom, JSValueConst value, JSValueConst receiver, int flags)
  {
    const char* str = JS_AtomToCString(ctx, atom);
    html::cssa::symbol_t prop_sym = cssa_from_camel_case(str);
    JS_FreeCString(ctx, str);
    if (prop_sym == 0)
      return -1;
    html::style_provider* sp = conv<html::style_provider*>::unwrap(ctx, obj);
    if (sp) {
      xcontext c(ctx);
      ustring val = conv<ustring>::unwrap(ctx, value);
      html::element* pe = static_cast<html::element*>(sp);
      html::style* ps = pe->get_style(*c.pview(), c.pdoc());
      html::style_prop_list pl;
      html::parse_css_property_as(c.pdoc(), prop_sym, val(), &pl);
      pe->set_style_attributes(pl);
    }
    return TRUE;
  }

  int style_delete_property(JSContext *ctx, JSValueConst obj, JSAtom prop)
  {
    return -1; // throw exception
  }
#endif

  bool style_set_cursor(xcontext& c, html::style_provider* sp, himage img, int hotspotx, int hotspoty) {
    html::element* self = static_cast<html::element*>(sp);

    if (!img) goto DROP;

    if (img->is_bitmap()) {
      if (!self->a_style) self->a_style = new html::style_prop_map();
      handle<gool::cursor> cur = gool::cursor::from_bitmap(img.ptr_of<gool::bitmap>(), img->get_url(), gool::size(hotspotx, hotspoty));
      if (cur) {
        tool::value cv = tool::value::make_resource(cur);
        self->a_style->set(html::cssa_cursor, cv);
        self->drop_style();
      }
    }
    else {
    DROP:
      if (self->a_style) {
        self->a_style->set(html::cssa_cursor, tool::value());
        self->drop_style();
      }
    }

    c.pview()->check_mouse(true);

    return true; 
  }

  static array<pair<wchars, wchars>> get_style_pairs(html::style_provider* sp) {
    html::element* self = static_cast<html::element*>(sp);
    array<pair<wchars, wchars>> list;
    ustring styletext = self->atts.get_ustring(attr::a_style);
    if (!styletext)
      return list;
    wchars text = styletext;
    do {
      wchars pv = text.chop(';');
      wchars name, val;
      if (!pv.split(':', name, val))
        continue;
      name = trim(name);
      for (int n = list.last_index(); n >= 0; --n)
        if (list[n].first == name) list.remove(n);
      list.push(pair<wchars, wchars>(name, trim(val)));
    } while (text);
    return list;
  }

  static ustring style_pairs_to_string(const array<pair<wchars, wchars>>& list) {
    ustring out;
    for (auto& nv : list) {
      if (out.length()) out += WCHARS(";");
      out += nv.first;
      out += WCHARS(":");
      out += nv.second;
    }
    return out;
  }

  ustring style_get_style_attr(xcontext& c, html::style_provider* sp) {
    html::element* self = static_cast<html::element*>(sp);
    array<pair<wchars,wchars>> list = get_style_pairs(sp);
    return style_pairs_to_string(list);
  }

  bool style_set_style_attr(xcontext& c, html::style_provider* sp, ustring val) {
    html::element* self = static_cast<html::element*>(sp);
    self->set_attr(*c.pview(), html::attr::a_style, val);
    return true;
  }

  ustring style_remove_property(xcontext& c, html::style_provider* sp, string prop_name) {
    //setProperty(propertyName, value, priority);
    html::element* pe = static_cast<html::element*>(sp);

    // remove it from @style too  :( 
    array<pair<wchars, wchars>> list = get_style_pairs(sp); 
    int nchanges = 0;
    ustring w_prop_name = prop_name;
    for (int n = list.last_index(); n >= 0; --n)
      if (list[n].first == w_prop_name) { list.remove(n); ++nchanges; }
    if(nchanges)
      pe->set_attr(*c.pview(), html::attr::a_style, style_pairs_to_string(list));

    html::style* ps = pe->get_style(*c.pview(), c.pdoc());
    html::style_prop_list pl;
    uint_v sym = html::cssa::lookup(prop_name.cbegin());
    if (sym.is_undefined())
      return ustring();
    tool::value v = pe->get_style()->to_value(sym.val(0));
    if (v.is_undefined())
      return ustring();
    pe->remove_style_attribute(sym.val(0));
    return v.to_string();
  }
  
  JSOM_PASSPORT_BEGIN(Style_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Element.Style", JS_PROP_CONFIGURABLE),
    JSOM_FUNC_DEF("getPropertyValue", style_get_property),
    JSOM_FUNC_DEF("setProperty", style_set_property),
    JSOM_FUNC_DEF("removeProperty", style_remove_property),
    JSOM_FUNC_DEF("colorOf", style_colorOf),
    JSOM_FUNC_DEF("pixelsOf", style_pixelsOf),
    JSOM_FUNC_DEF("imageOf", style_imageOf),
    JSOM_FUNC_DEF("variables", style_variables),
    JSOM_FUNC_DEF("variable", style_variable),
    JSOM_FUNC_DEF("setCursor", style_set_cursor),
    JSOM_PROP_DEF("cssText", style_get_style_attr, style_set_style_attr),
  JSOM_PASSPORT_END


  JSClassExoticMethods Style_exotic_methods = 
  {
    &style_get_own_property, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    /* return < 0 if exception, or TRUE/FALSE */
    NULL, //&style_delete_property,
    NULL, // int(*define_own_property)(JSContext *ctx, JSValueConst this_obj, JSAtom prop, JSValueConst val, JSValueConst getter, JSValueConst setter, int flags);
    NULL, // &style_has_property,
    NULL, //&style_get_property,
    NULL, //&style_set_property
  };

  void init_Style_class(context& c)
  {
    JS_NewClassID(&Style_class_id);

    static JSClassDef Style_class = {
      "Style",
      [](JSRuntime *rt, JSValue val)
      {
        html::element* pe = (html::element*)JS_GetOpaque(val,Style_class_id);  //object_of<html::element>(val);
        if (pe)
          pe->release();
      },
      NULL,
      NULL,
      &Style_exotic_methods
    };

    JS_NewClass(JS_GetRuntime(c), Style_class_id, &Style_class);
    JSValue style_proto = JS_NewObject(c);

    auto list = Style_def();
    JS_SetPropertyFunctionList(c, style_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Style_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      JS_SetOpaque(obj, 0);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue style_class = JS_NewCFunction2(c, ctor, "Style", 2, JS_CFUNC_constructor, 0);

    hvalue element_class = c.get_prop<hvalue>("Element", c.global());
    assert(element_class);

    JS_DefinePropertyValueStr(c, element_class, "Style", JS_DupValue(c, style_class), JS_PROP_CONFIGURABLE);

    //auto static_list = Style_static_def();
    //JS_SetPropertyFunctionList(c, style_class, static_list.start, static_list.length);

    JS_SetConstructor(c, style_class, style_proto);
    JS_SetClassProto(c, Style_class_id, style_proto);
  }


}
