#pragma once

#ifndef __xdomjs_xstates_h__
#define __xdomjs_xstates_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  extern JSClassID ElementState_class_id;

  void init_ElementState_class(xview* pv, html::document *pd, xcontext& c);

  template <> struct conv<html::state_provider*>
  {
    static html::state_provider* unwrap(JSContext * ctx, JSValueConst v)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, ElementState_class_id);
      if (!pe) 
        throw qjs::om::type_error("Element was deleted");
      return static_cast<html::state_provider*>(pe);
    }

    static html::state_provider* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, ElementState_class_id);
      if (!pe) return nullptr;
      return static_cast<html::state_provider*>(pe);
    }

    static JSValue wrap(JSContext * ctx, html::state_provider* psp) noexcept
    {
      if (!psp)
        return JS_NULL;
      //xcontext c(ctx);
      //JSAtom atom_states = c.known_atoms().states;
      html::element* pe = static_cast<html::element*>(psp);
      //hvalue obj = conv<html::element*>::wrap(ctx, pe);
      //JSPropertyDescriptor desc = {0};
      //if (TRUE == JS_GetOwnProperty(ctx, &desc, obj, atom_states))
      //  return desc.value;
      JSValue states_obj = JS_NewObjectClass(ctx, ElementState_class_id);
      pe->add_ref();
      JS_SetOpaque(states_obj, pe);
      //JS_DefinePropertyValue(ctx, obj, atom_states, states_obj, JS_PROP_CONFIGURABLE | JS_PROP_ENUMERABLE);
      //return JS_DupValue(ctx, states_obj);
      return states_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, ElementState_class_id) != NULL; }
  };

}

#endif
