#pragma once

#ifndef __xdomjs_xrange_h__
#define __xdomjs_xrange_h__

#include "xcontext.h"
#include "xconv.h"
//#include "xconv.h"

namespace qjs
{

  struct range : public resource {
    html::bookmark start;
    html::bookmark end;
  };
  typedef tool::handle<range> hrange;


  extern JSClassID Range_class_id;
  
  void init_Range_class(xcontext& c);
    
  template <> struct conv<hrange>
  {
    static hrange unwrap(JSContext * ctx, JSValueConst v)
    {
      hrange pr = (range*)JS_GetOpaque(v, Range_class_id);
      return pr;
    }

    static JSValue wrap(JSContext * ctx, hrange pr) noexcept
    {
      if (!pr)
        return JS_NULL;
      JSValue range_obj = JS_NewObjectClass(ctx, Range_class_id);
      pr->add_ref();
      JS_SetOpaque(range_obj, pr.ptr());
      return range_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Range_class_id) != NULL; }
  };

}

#endif