#pragma once

#ifndef __xdomjs_xom_h__
#define __xdomjs_xom_h__

#include "xcontext.h"

namespace qjs {

  namespace om {

    template <class Type> struct global_function;

    template <class Ret>
    struct global_function<Ret(*)(xcontext&)> {
      enum { n_params = 0 };
      template <Ret(*Func)(xcontext&)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0>
    struct global_function<Ret(*)(xcontext&, P0)> {
      enum { n_params = 1 };
      template <Ret(*Func)(xcontext&, P0)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get_last<P0>(argv[0], argc - 0) : P0()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0, class P1>
    struct global_function<Ret(*)(xcontext&, P0, P1)> {
      enum { n_params = 2 };
      template <Ret(*Func)(xcontext&, P0, P1)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get_last<P1>(argv[1], argc - 1) : P1()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0, class P1, class P2>
    struct global_function<Ret(*)(xcontext&, P0, P1, P2)> {
      enum { n_params = 3 };
      template <Ret(*Func)(xcontext&, P0, P1, P2)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get_last<P2>(argv[2], argc - 2) : P2()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0, class P1, class P2, class P3>
    struct global_function<Ret(*)(xcontext&, P0, P1, P2, P3)> {
      enum { n_params = 4 };
      template <Ret(*Func)(xcontext&, P0, P1, P2, P3)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get_last<P3>(argv[3], argc - 3) : P3()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0, class P1, class P2, class P3, class P4>
    struct global_function<Ret(*)(xcontext&, P0, P1, P2, P3, P4)> {
      enum { n_params = 5 };
      template <Ret(*Func)(xcontext&, P0, P1, P2, P3, P4)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get_last<P4>(argv[4], argc - 4) : P4()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0, class P1, class P2, class P3, class P4, class P5>
    struct global_function<Ret(*)(xcontext&, P0, P1, P2, P3, P4, P5)> {
      enum { n_params = 6 };
      template <Ret(*Func)(xcontext&, P0, P1, P2, P3, P4, P5)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get<P4>(argv[4]) : P4(),
            argc > 5 ? c.get_last<P5>(argv[5], argc - 5) : P5()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0, class P1, class P2, class P3, class P4, class P5, class P6>
    struct global_function<Ret(*)(xcontext&, P0, P1, P2, P3, P4, P5, P6)> {
      enum { n_params = 7 };
      template <Ret(*Func)(xcontext&, P0, P1, P2, P3, P4, P5, P6)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval((*Func)(c,
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get<P4>(argv[4]) : P4(),
            argc > 5 ? c.get<P5>(argv[5]) : P5(),
            argc > 6 ? c.get_last<P6>(argv[6], argc - 6) : P6()
          ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

#if 0
#define JSOM_FUNC(ename,fname) qjs::func_def(ename,\
    qjs::om::member_function<decltype(&TC::fname)>::n_params, \
    &qjs::om::member_function<decltype(&TC::fname)>::thunk<&TC::fname> )

#define JSOM_PROP(name,prop_getter,prop_setter) qjs::prop_def(name, \
    &qjs::om::member_getter_function<decltype(&TC::prop_getter)>::thunk<&TC::prop_getter>, \
    &qjs::om::member_setter_function<decltype(&TC::prop_setter)>::thunk<&TC::prop_setter> )

#define JSOM_RO_PROP(name,prop_getter) qjs::prop_def(name, \
    &qjs::om::member_getter_function<decltype(&TC::prop_getter)>::thunk<&TC::prop_getter>)

#endif

#define JSOM_CONST_STR(name,val,flags) qjs::cstring_def(name,val,flags)
    
#define JSOM_GLOBAL_FUNC_DEF(ename,fname) qjs::func_def(ename,\
    qjs::om::global_function<decltype(&fname)>::n_params, \
    &qjs::om::global_function<decltype(&fname)>::thunk<&fname> )


    template <class Type> struct global_getter_function;
    template <class Type> struct global_setter_function;

    template <class Ret>
    struct global_getter_function<Ret(*)(xcontext&)> {
      template <Ret(*Func)(xcontext&)> static JSValue thunk(JSContext *ctx, JSValueConst this_val)
      {
        xcontext c(ctx); try { return c.retval((*Func)(c)); }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Ret, class P0>
    struct global_setter_function<Ret(*)(xcontext&, P0)> {
      template <Ret(*Func)(xcontext&, P0)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, JSValueConst val)
      {
        xcontext c(ctx); try { return c.retval((*Func)(c, c.get<P0>(val))); }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class P0>
    struct global_setter_function<void(*)(xcontext&, P0)> {
      template <void(*Func)(xcontext&, P0)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, JSValueConst val)
      {
        xcontext c(ctx); try { (*Func)(c, c.get<P0>(val)); return JS_UNDEFINED; }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

#define JSOM_GLOBAL_PROP_DEF(name,prop_getter,prop_setter) qjs::prop_def(name,     \
    &qjs::om::global_getter_function<decltype(&prop_getter)>::thunk<&prop_getter>, \
    &qjs::om::global_setter_function<decltype(&prop_setter)>::thunk<&prop_setter> )

#define JSOM_GLOBAL_RO_PROP_DEF(name,prop_getter) qjs::prop_def(name,              \
    &qjs::om::global_getter_function<decltype(&prop_getter)>::thunk<&prop_getter>)


  template <class Type> struct free_function;
  template <class Type> struct free_iterator_function;

  template <class Type, class Ret>
    struct free_function<Ret(*)(qjs::xcontext&, Type)> {
      enum { n_params = 0 };
      template <Ret(*Func)(qjs::xcontext&,Type)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c,c.get<Type>(this_val)));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret>
    struct free_iterator_function<Ret(*)(qjs::xcontext&, Type)> {
      enum { n_params = 0 };
      template <Ret(*Func)(qjs::xcontext&, Type)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv, int magic)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val)));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0)> {
      enum { n_params = 1 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get_last<P0>(argv[0], argc - 0) : P0()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1)> {
      enum { n_params = 2 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get_last<P1>(argv[1], argc - 1) : P1()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2)> {
      enum { n_params = 3 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get_last<P2>(argv[2], argc - 2) : P2()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2, class P3>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2, P3)> {
      enum { n_params = 4 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2, P3)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get_last<P3>(argv[3], argc - 3) : P3()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2, class P3, class P4>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2, P3, P4)> {
      enum { n_params = 5 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2, P3, P4)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get_last<P4>(argv[4], argc - 4) : P4()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2, class P3, class P4, class P5>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5)> {
      enum { n_params = 6 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get<P4>(argv[4]) : P4(),
            argc > 5 ? c.get_last<P5>(argv[5], argc - 5) : P5()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2, class P3, class P4, class P5, class P6>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5, P6)> {
      enum { n_params = 7 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5, P6)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get<P4>(argv[4]) : P4(),
            argc > 5 ? c.get<P5>(argv[5]) : P5(),
            argc > 6 ? c.get_last<P6>(argv[6], argc - 6) : P6()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2, class P3, class P4, class P5, class P6, class P7>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5, P6, P7)> {
      enum { n_params = 8 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5, P6, P7)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get<P4>(argv[4]) : P4(),
            argc > 5 ? c.get<P5>(argv[5]) : P5(),
            argc > 6 ? c.get<P6>(argv[6]) : P6(),
            argc > 7 ? c.get_last<P7>(argv[7], argc - 7) : P7()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0, class P1, class P2, class P3, class P4, class P5, class P6, class P7, class P8>
    struct free_function<Ret(*)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5, P6, P7, P8)> {
      enum { n_params = 9 };
      template <Ret(*Func)(qjs::xcontext&, Type, P0, P1, P2, P3, P4, P5, P6, P7, P8)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
      {
        xcontext c(ctx); try {
          return c.retval<Ret>((*Func)(c, c.get<Type>(this_val),
            argc > 0 ? c.get<P0>(argv[0]) : P0(),
            argc > 1 ? c.get<P1>(argv[1]) : P1(),
            argc > 2 ? c.get<P2>(argv[2]) : P2(),
            argc > 3 ? c.get<P3>(argv[3]) : P3(),
            argc > 4 ? c.get<P4>(argv[4]) : P4(),
            argc > 5 ? c.get<P5>(argv[5]) : P5(),
            argc > 6 ? c.get<P6>(argv[6]) : P6(),
            argc > 7 ? c.get<P7>(argv[7]) : P7(),
            argc > 8 ? c.get_last<P8>(argv[8], argc - 8) : P8()
            ));
        }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };


    #define JSOM_FUNC_DEF(ename,fname) qjs::func_def(ename,\
        qjs::om::free_function<decltype(&fname)>::n_params, \
        &qjs::om::free_function<decltype(&fname)>::thunk<&fname> )

    #define JSOM_ITERATOR_DEF(ename,fname) qjs::func_def_magic(ename,\
        &qjs::om::free_iterator_function<decltype(&fname)>::thunk<&fname>, 1 )


    template <class Type> struct free_getter_function;
    template <class Type> struct free_setter_function;

    template <class Type, class Ret>
    struct free_getter_function<Ret(*)(qjs::xcontext&,Type)> {
      template <Ret(*Func)(qjs::xcontext&,Type)> static JSValue thunk(JSContext *ctx, JSValueConst this_val)
      {
        xcontext c(ctx); try { return c.retval<Ret>((*Func)(c, c.get<Type>(this_val))); }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class Ret, class P0>
    struct free_setter_function<Ret(*)(qjs::xcontext&, Type, P0)> {
      template <Ret(*Func)(qjs::xcontext&,Type,P0)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, JSValueConst val)
      {
        xcontext c(ctx); try { return c.retval((*Func)(c, c.get<Type>(this_val), c.get<P0>(val))); }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };

    template <class Type, class P0>
    struct free_setter_function<void(*)(qjs::xcontext&, Type, P0)> {
      template <void(*Func)(qjs::xcontext&, Type, P0)> static JSValue thunk(JSContext *ctx, JSValueConst this_val, JSValueConst val)
      {
        xcontext c(ctx); try { (*Func)(c, c.get<Type>(this_val), c.get<P0>(val)); return JS_UNDEFINED; }
        catch (om::error& err) { return err.raise_error(ctx); }
      }
    };
     
    #define JSOM_PROP_DEF(name,prop_getter,prop_setter) qjs::prop_def(name, \
        &qjs::om::free_getter_function<decltype(&prop_getter)>::thunk<&prop_getter>, \
        &qjs::om::free_setter_function<decltype(&prop_setter)>::thunk<&prop_setter> )

    #define JSOM_RO_PROP_DEF(name,prop_getter) qjs::prop_def(name, \
        &qjs::om::free_getter_function<decltype(&prop_getter)>::thunk<&prop_getter>)

    #define JSOM_RO_PROP_DEF_EX(name,prop_getter) qjs::prop_def(name, \
        &qjs::om::free_getter_function<decltype(&prop_getter)>::thunk<&prop_getter>)


#define JSOM_PASSPORT_BEGIN(funcname, classname) \
  tool::slice<JSCFunctionListEntry> funcname() { \
     typedef classname TC; \
     static JSCFunctionListEntry list[] = {

#define JSOM_PASSPORT_END \
     }; return items_of(list); \
   }
  }
}
#endif
