#pragma once

#ifndef __xdomjs_xnodelist_h__
#define __xdomjs_xnodelist_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  using namespace html;
  
  extern JSClassID Iterator_class_id;
  
  struct iterator : public resource 
  {
    virtual hvalue next(xcontext& c) = 0;
  };

  struct node_list_value_iterator : public iterator
  {
    int index;
    helement pe;

    node_list_value_iterator(node_list_provider* nl): pe(static_cast<element*>(nl)), index(-1) {}

    virtual hvalue next(xcontext& c) override 
    {
      hvalue obj = JS_NewObject(c);
      if (++index < pe->nodes.size())
        c.set_prop(c.known_atoms().value, obj, pe->nodes[index]);
      else
        c.set_prop(c.known_atoms().done, obj, true);
      return obj;
    }
  };

  hvalue make_iterator(xcontext& c, handle<iterator> it);

  extern JSClassID NodeIterator_class_id;

  struct node_iterator : public iterator
  {
    uint mask;
    hnode current;
    hvalue filter;
    hvalue acceptor;
    html::each_node it;

    node_iterator(xcontext& c, hnode r, uint m = uint(-1), hvalue f = hvalue())
      : it(r), mask(m),filter(f) 
    {
      acceptor = c.get_prop<hvalue>(c.known_atoms().acceptNode, filter);
    }

    enum ACCEPT_CODE {
      FILTER_ACCEPT = 1,
      FILTER_REJECT = 2,
      FILTER_SKIP = 3,
    };

    virtual hvalue next(xcontext& c) override
    {
      hvalue obj = JS_NewObject(c);
      hnode pn = next_node(c);
      if (pn)
        c.set_prop(c.known_atoms().value, obj, pn);
      else
        c.set_prop(c.known_atoms().done, obj, true);
      return obj;
    }

    hnode next_node(xcontext& c) {
      it.forward = true;
      for (; it(current);) {
        uint nmask = 1 << (current->node_type() - 1);
        if ((nmask & mask) == 0)
          continue;
        if (!satisfy_filter(c, current,it.dont_go_inside))
          continue;
        return current;
      }
      return nullptr;
    }

    hnode prev_node(xcontext& c) {
      it.forward = false;
      for (; it(current);) {
        uint nmask = 1 << (current->node_type() - 1);
        if ((nmask & mask) == 0)
          continue;
        if (!satisfy_filter(c, current, it.dont_go_inside))
          continue;
        return current;
      }
      return nullptr;
    }

    bool satisfy_filter(xcontext& c, hnode pn, bool& skip_it)
    {
      if(!c.is_function(acceptor))
        return true;
      else {
        try {
          int r;
          c.call(r, acceptor, filter, pn);
          if (r == FILTER_ACCEPT)
            return true;
          else if (r == FILTER_SKIP) {
            skip_it = true;
            return false;
          }
          else 
            return false;
        }
        catch (qjs::exception) {
          c.report_exception();
          return false;
        }
      }
    }
  };


  template <> struct conv<iterator*>
  {
    static iterator* unwrap(JSContext * ctx, JSValueConst v)
    {
      iterator* it = (iterator*)JS_GetOpaque(v, Iterator_class_id);
      if (!it)
        throw qjs::om::type_error("Iterator was deleted");
      return it;
    }
    static iterator* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      iterator* it = (iterator*)JS_GetOpaque(v, Iterator_class_id);
      return it;
    }
    static JSValue wrap(JSContext * ctx, iterator* it) noexcept
    {
      if (!it) return JS_NULL;
      xcontext c(ctx);
      JSValue obj = JS_NewObjectClass(ctx, Iterator_class_id);
      it->add_ref();
      JS_SetOpaque(obj, it);
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Iterator_class_id) != NULL; }
  };

  template <> struct conv<node_iterator*>
  {
    static node_iterator* unwrap(JSContext * ctx, JSValueConst v)
    {
      node_iterator* it = (node_iterator*)JS_GetOpaque(v, NodeIterator_class_id);
      if (!it)
        throw qjs::om::type_error("NodeIterator was deleted");
      return it;
    }
    static node_iterator* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      node_iterator* it = (node_iterator*)JS_GetOpaque(v, Iterator_class_id);
      return it;
    }
    static JSValue wrap(JSContext * ctx, node_iterator* it) noexcept
    {
      if (!it) return JS_NULL;
      xcontext c(ctx);
      JSValue obj = JS_NewObjectClass(ctx, NodeIterator_class_id);
      it->add_ref();
      JS_SetOpaque(obj, it);
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, NodeIterator_class_id) != NULL; }
  };
  

  extern JSClassID NodeList_class_id;

  template <> struct conv<node_list_provider*>
  {
    static node_list_provider* unwrap(JSContext * ctx, JSValueConst v)
    {
      node_list_provider* nl = element_ptr_of(ctx,v);
      if (!nl)
        throw qjs::om::type_error("NodeList was deleted");
      return nl;
    }
    static node_list_provider* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      node_list_provider* nl = element_ptr_of(ctx,v);
      if (!nl) return nullptr;
      return nl;
    }
    static JSValue wrap(JSContext * ctx, node_list_provider* nl) noexcept
    {
      if (!nl)
        return JS_NULL;
      xcontext c(ctx);
      html::node* pn = static_cast<html::element*>(nl);
      JSValue node_list_obj = JS_NewObjectClass(ctx, NodeList_class_id);
      pn->add_ref();
      JS_SetOpaque(node_list_obj, pn);
      return node_list_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, NodeList_class_id) != NULL; }
  };

}

#endif
