#include "xdom.h"
#include "xom.h"
#include "xcontext.h"
#include "xnodelist.h"

namespace qjs {

  using namespace html;
  using namespace tool;

  JSClassID NodeList_class_id = 0;
  JSClassID Iterator_class_id = 0;

  uint node_list_length(xcontext& c, node_list_provider* nl)
  {
    return uint(static_cast<element*>(nl)->nodes.length());
  }

  hnode node_list_item(xcontext& c, node_list_provider* nl, uint n)
  {
    return n < static_cast<element*>(nl)->nodes.length() ? static_cast<element*>(nl)->nodes[n] : nullptr;
  }

  hvalue node_list_iterator(xcontext& c, node_list_provider* nl)
  {
    return make_iterator(c, new node_list_value_iterator(nl));
  }
 
  int node_list_get_own_property(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop)
  {
    element* nl = (element*)(node*)JS_GetOpaque(obj, NodeList_class_id);
    if (!nl)
      return FALSE;

    uint n;
    if (!JS_AtomIsArrayIndex(ctx, &n, prop))
      return FALSE;
    if (n >= nl->nodes.length())
      return FALSE;
    if (desc) {
      desc->flags = JS_PROP_C_W_E;
      desc->getter = JS_UNDEFINED;
      desc->setter = JS_UNDEFINED;
      desc->value = conv<node*>::wrap(ctx, nl->nodes[n]);
    }
    return TRUE;
  }

  JSClassExoticMethods NodeList_exotic_methods =
  {
    &node_list_get_own_property, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    /* return < 0 if exception, or TRUE/FALSE */
    NULL, //&element_delete_property,
    NULL, //&element_define_own_property,
    NULL, //&element_has_property,
    NULL, //&element_get_property,
    NULL, //&element_set_property, //&element_set_property
  };

  JSOM_PASSPORT_BEGIN(NodeList_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "NodeList", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("length", node_list_length),
    JSOM_FUNC_DEF("item", node_list_item),
    JSOM_FUNC_DEF("[Symbol.iterator]", node_list_iterator),
  JSOM_PASSPORT_END

  void init_NodeList_class(context& c)
  {
    JS_NewClassID(&NodeList_class_id);

    static JSClassDef NodeList_class = {
      "NodeList",
      [](JSRuntime *rt, JSValue val)
      {
        node* pe = (node*)JS_GetOpaque(val, NodeList_class_id);
        if (pe) pe->release();
      },
      NULL,
      NULL,
      &NodeList_exotic_methods
    };

    JS_NewClass(JS_GetRuntime(c), NodeList_class_id, &NodeList_class);
    JSValue node_proto = JS_NewObject(c);

    auto list = NodeList_def();
    JS_SetPropertyFunctionList(c, node_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      return JS_EXCEPTION;
    };

    hvalue node_class = JS_NewCFunction2(c, ctor, "NodeList", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "NodeList", JS_DupValue(c, node_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, node_class, node_proto);
    JS_SetClassProto(c, NodeList_class_id, node_proto);

  }

  hvalue make_iterator(xcontext& c, handle<iterator> it) {
    hvalue obj = JS_NewObjectClass(c, Iterator_class_id);
    JS_SetOpaque(obj, it.ptr_of<resource>());
    it->add_ref();
    return obj;
  }

  hvalue iterator_next(xcontext& c, iterator* it)
  {
    return it->next(c);
  }

  JSOM_PASSPORT_BEGIN(Iterator_def, html::resource)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Iterator", JS_PROP_CONFIGURABLE),
    JSOM_FUNC_DEF("next", iterator_next),
    //JSOM_FUNC_DEF("[Symbol.iterator]", node_list_iterator),
  JSOM_PASSPORT_END

  void init_Iterator_class(context& c)
  {
    JS_NewClassID(&Iterator_class_id);

    static JSClassDef Iterator_class = {
      "Iterator",
      [](JSRuntime *rt, JSValue val)
      {
        iterator* pe = (iterator*)JS_GetOpaque(val, Iterator_class_id);
        if (pe) pe->release();
      }
    };

    JS_NewClass(JS_GetRuntime(c), Iterator_class_id, &Iterator_class);
    JSValue iterator_proto = JS_NewObject(c);

    auto list = Iterator_def();
    JS_SetPropertyFunctionList(c, iterator_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      return JS_EXCEPTION;
    };

    hvalue iterator_class = JS_NewCFunction2(c, ctor, "Iterator", 2, JS_CFUNC_constructor, 0);

    //JS_DefinePropertyValueStr(c, c.global(), "NodeList", JS_DupValue(c, node_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, iterator_class, iterator_proto);
    JS_SetClassProto(c, Iterator_class_id, iterator_proto);
  }
    
  JSClassID NodeIterator_class_id = 0;

  node_iterator* node_iterator_iterator(xcontext& c, node_iterator* nl) { return nl; }
  hvalue         node_iterator_next(xcontext& c, node_iterator* nl) { return nl->next(c); }
  hnode          node_iterator_next_node(xcontext& c, node_iterator* nl) { return nl->next_node(c); }
  hnode          node_iterator_prev_node(xcontext& c, node_iterator* nl) { return nl->prev_node(c);}
  hvalue         node_iterator_filter(xcontext& c, node_iterator* nl) { return nl->filter;}
  uint           node_iterator_mask(xcontext& c, node_iterator* nl) { return nl->mask; }
  hnode          node_iterator_current(xcontext& c, node_iterator* nl) { return nl->current; }
  hnode          node_iterator_root(xcontext& c, node_iterator* nl) { return nl->it.root; }

  JSOM_PASSPORT_BEGIN(NodeIterator_def, node_iterator)
    JSOM_CONST_STR("[Symbol.toStringTag]", "NodeIterator", JS_PROP_CONFIGURABLE),
    JSOM_FUNC_DEF("next", node_iterator_next),
    JSOM_FUNC_DEF("nextNode", node_iterator_next_node),
    JSOM_FUNC_DEF("previousNode", node_iterator_prev_node),
    JSOM_RO_PROP_DEF("filter", node_iterator_filter),
    JSOM_RO_PROP_DEF("mask", node_iterator_mask),
    JSOM_RO_PROP_DEF("referenceNode", node_iterator_current),
    JSOM_RO_PROP_DEF("root", node_iterator_root),
    JSOM_FUNC_DEF("[Symbol.iterator]", node_iterator_iterator),
  JSOM_PASSPORT_END


  JSCFunctionListEntry NodeFilter_constants[] = {
    int_cdef("SHOW_ALL", -1),
    int_cdef("SHOW_ATTRIBUTE", 1 << (node::ATTRIBUTE_NODE - 1)),
    int_cdef("SHOW_TEXT", 1 << (node::TEXT_NODE - 1)),
    int_cdef("SHOW_ENTITY_REFERENCE", 1 << (node::CDATA_SECTION_NODE - 1)),
    int_cdef("SHOW_ENTITY", 1 << (node::ENTITY_NODE - 1)),
    int_cdef("SHOW_PROCESSING_INSTRUCTION", 1 << (node::PROCESSING_INSTRUCTION_NODE - 1)),
    int_cdef("SHOW_COMMENT", 1 << (node::COMMENT_NODE - 1)),
    int_cdef("SHOW_DOCUMENT", 1 << (node::DOCUMENT_NODE - 1)),
    int_cdef("SHOW_DOCUMENT_TYPE", 1 << (node::DOCUMENT_TYPE_NODE - 1)),
    int_cdef("SHOW_DOCUMENT_FRAGMENT", 1 << (node::DOCUMENT_FRAGMENT_NODE - 1)),
    int_cdef("SHOW_NOTATION", 1 << (node::NOTATION_NODE - 1)),

    int_cdef("FILTER_ACCEPT", node_iterator::FILTER_ACCEPT),
    int_cdef("FILTER_REJECT", node_iterator::FILTER_REJECT),
    int_cdef("FILTER_SKIP", node_iterator::FILTER_SKIP),
  };

  void init_NodeIterator_class(context& c)
  {
    JS_NewClassID(&NodeIterator_class_id);

    static JSClassDef NodeIterator_class = {
      "NodeIterator",
      [](JSRuntime *rt, JSValue val)
      {
        node_iterator* pe = (node_iterator*)JS_GetOpaque(val, NodeIterator_class_id);
        if (pe) pe->release();
      },
      [](JSRuntime *rt, JSValueConst val, JS_MarkFunc *mark_func) {
        node_iterator* pe = (node_iterator*)JS_GetOpaque(val, NodeIterator_class_id);
        JS_MarkValue(rt, pe->filter, mark_func);
        JS_MarkValue(rt, pe->acceptor, mark_func);
      }
    };

    JS_NewClass(JS_GetRuntime(c), NodeIterator_class_id, &NodeIterator_class);
    JSValue iterator_proto = JS_NewObject(c);

    auto list = NodeIterator_def();
    JS_SetPropertyFunctionList(c, iterator_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      return JS_EXCEPTION;
    };

    hvalue iterator_class = JS_NewCFunction2(c, ctor, "NodeIterator", 2, JS_CFUNC_constructor, 0);

    JSValue node_filter = JS_NewObject(c);
    JS_SetPropertyFunctionList(c, node_filter, NodeFilter_constants, items_in(NodeFilter_constants));
    JS_DefinePropertyValueStr(c, c.global(), "NodeFilter", node_filter, JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, iterator_class, iterator_proto);
    JS_SetClassProto(c, NodeIterator_class_id, iterator_proto);
  }














}