#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xgraphics.h"

namespace qjs {

  using namespace html;
  using namespace gool;

  JSClassID Graphics_Text_class_id = 0;

  xtext* text_ptr_of(JSValueConst obj) {
    xtext* pi = (xtext*)JS_GetOpaque(obj, Graphics_Text_class_id);
    return pi;
  }

  uint    text_lines(xcontext& c, xtext* pg) { return pg->tl->get_lines_count(); }

  ustring text_chars(xcontext& c, xtext* pg) { return pg->tl->get_text(); }
  void    text_set_chars(xcontext& c, xtext* pg, ustring t) { pg->tl->set_text(t); }

  ustring text_font(xcontext& c, xtext* pg) { return pg->tl->get_font(); }
  void    text_set_font(xcontext& c, xtext* pg, ustring t) { pg->tl->set_font(t); }
  
  ustring text_style(xcontext& c, xtext* pg) { return pg->tl->get_style(); }
  void    text_set_style(xcontext& c, xtext* pg, ustring t) { pg->tl->set_style(t); }

  ustring text_class(xcontext& c, xtext* pg) { return pg->tl->get_class(); }
  void    text_set_class(xcontext& c, xtext* pg, ustring t) { return pg->tl->set_class(t); }

  hvalue  text_width(xcontext& c, xtext* ptext, float_v w) { 
    float ppx = c.pview()->pixels_per_dip(sizef(1, 1)).y;
    if (w.is_undefined()) {
      array<float> widths = { ptext->tl->width_max() / ppx, ptext->tl->width_min() / ppx, ptext->tl->get_box().x / ppx };
      return c.val(widths);
    }
    else {
      ptext->tl->set_width(w * ppx);
      return c.val(ptext);
    }
  }

  hvalue  text_height(xcontext& c, xtext* ptext, float_v h) {
    float ppx = c.pview()->pixels_per_dip(sizef(1, 1)).y;
    if (h.is_undefined()) {
      array<float> heights = { ptext->tl->height() / ppx, ptext->tl->get_box().y / ppx };
      return c.val(heights);
    }
    else {
      ptext->tl->set_height(h * ppx);
      return c.val(ptext);
    }
  }

  array<float>  text_line_metrics(xcontext& c, xtext* ptext, uint lineno) {
    if (lineno < ptext->tl->get_lines_count()) {
      float ppx = c.pview()->pixels_per_dip(sizef(1, 1)).y;
      text_layout::line ln = ptext->tl->get_line(lineno);
      return { ln.y / ppx, ln.height / ppx, ln.baseline / ppx };
    }
    return array<float>();
  }

  ustring  text_line_chars(xcontext& c, xtext* ptext, uint lineno) {
    if (lineno < ptext->tl->get_lines_count()) {
      text_layout::line ln = ptext->tl->get_line(lineno);
      return ptext->tl->get_text()(ln.start, ln.start + ln.length);
    }
    return ustring();
  }

  static handle<xtext> text_ctor(xcontext& c, int argc, JSValueConst *argv) {
    ustring text;
    ustring cls;

    if (argc == 1 && c.is_string(argv[0])) {
      text = c.get<ustring>(argv[0]);
    } else if (argc == 2 && c.is_string(argv[0]) && c.is_string(argv[1])) {
      text = c.get<ustring>(argv[0]);
      cls = c.get<ustring>(argv[1]);
    } else
      throw qjs::om::type_error("wrong text initialization parameters");

    handle<xtext> xp = new xtext(c,text,cls);
    return xp;
  }

  JSOM_PASSPORT_BEGIN(GraphicsText_def, xtext)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Graphics.Text", JS_PROP_CONFIGURABLE),

    JSOM_RO_PROP_DEF("lines", text_lines),
    JSOM_PROP_DEF("chars", text_chars, text_set_chars),
    JSOM_PROP_DEF("font", text_font, text_set_font),
    JSOM_PROP_DEF("style", text_style, text_set_style),
    JSOM_PROP_DEF("class", text_class, text_set_class),

    JSOM_FUNC_DEF("width", text_width),
    JSOM_FUNC_DEF("height", text_height),
    JSOM_FUNC_DEF("lineMetrics", text_line_metrics),
    JSOM_FUNC_DEF("lineChars", text_line_chars)

  JSOM_PASSPORT_END

    /*JSOM_PASSPORT_BEGIN(Text_static_def, qjs::xcontext)
      JSOM_GLOBAL_FUNC_DEF("fromBytes", text_from_bytes),
      JSOM_GLOBAL_FUNC_DEF("load", text_load),
    JSOM_PASSPORT_END*/


  void init_Text_class(context& c, hvalue graphics)
  {
    JS_NewClassID(&Graphics_Text_class_id);

    static JSClassDef Text_class = {
      "GraphicsText",
      [](JSRuntime *rt, JSValue val)
      {
        xtext* pi = text_ptr_of(val);
        if (pi)
          pi->release();
      }
    };

    JS_NewClass(JS_GetRuntime(c), Graphics_Text_class_id, &Text_class);
    JSValue text_proto = JS_NewObject(c);

    auto list = GraphicsText_def();
    JS_SetPropertyFunctionList(c, text_proto, list.start, list.length);
    
    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      xcontext c(ctx);
      handle<xtext> xp;
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Graphics_Text_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      xp = text_ctor(c, argc, argv);
      if (xp) {
        JS_SetOpaque(obj, xp.ptr());
        xp->add_ref();
      }
      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue text_class = JS_NewCFunction2(c, ctor, "GraphicsText", 2, JS_CFUNC_constructor, 0);

    //auto static_list = Text_static_def();
    //JS_SetPropertyFunctionList(c, text_class, static_list.start, static_list.length);

    JS_SetConstructor(c, text_class, text_proto);
    JS_SetClassProto(c, Graphics_Text_class_id, text_proto);

    c.set_prop<hvalue>("Text", graphics, text_class);

  }


}
