#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xgraphics.h"

namespace qjs {

  using namespace html;
  using namespace gool;

  JSClassID Graphics_Path_class_id = 0;

  xpath* path_ptr_of(JSValueConst obj) {
    xpath* pi = (xpath*)JS_GetOpaque(obj, Graphics_Path_class_id);
    return pi;
  }

  static xpath* path_close(xcontext& hc, xpath* pg) {
    pg->cpath->close(); return pg;
  }
  static xpath* path_move_to(xcontext& hc, xpath* pg, float x, float y) {
    pg->cpath->move_to(gool::pointf(x, y)); return pg;
  }
  static xpath* path_line_to(xcontext& hc, xpath* pg, float x, float y) {
    pg->cpath->line_to(gool::pointf(x, y)); return pg;
  }

  static xpath* path_bezier_curve_to(xcontext& hc, xpath* pg, float cp1x, float cp1y, float cp2x, float cp2y, float x, float y) {
    pg->cpath->cubic_to(pointf(x, y), pointf(cp1x, cp1y), pointf(cp2x, cp2y));
    return pg;
  }
  static xpath* path_quadratic_curve_to(xcontext& hc, xpath* pg, float cpx, float cpy, float x, float y) {
    pg->cpath->quadratic_to(pointf(x, y), pointf(cpx, cpy));
    return pg;
  }

  static xpath* path_arc(xcontext& hc, xpath* pg, float x, float y, float radius, float startAngle, float endAngle, bool anticlockwise) {
    pg->cpath->arc(pointf(x, y), sizef(radius), startAngle, (anticlockwise ? -endAngle : endAngle) - startAngle);
    return pg;
  }

  static xpath* path_arc_to(xcontext& hc, xpath* pg, float x1, float y1, float x2, float y2, float radius) {
    pg->cpath->circ_arc_to(pointf(x1, y1), pointf(x2, y2), radius);
    return pg;
  }

  static xpath* path_ellipse(xcontext& hc, xpath* pg, float x, float y, float radiusX, float radiusY, float rotation, float startAngle, float endAngle, bool anticlockwise) {
    if(!anticlockwise)
      pg->cpath->arc(pointf(x, y), sizef(radiusX, radiusY), startAngle, endAngle - startAngle);
    else
      pg->cpath->arc(pointf(x, y), sizef(radiusX, radiusY), endAngle, startAngle - endAngle);
    return pg;
  }

  static xpath* path_rect(xcontext& hc, xpath* pg, float x, float y, float w, float h) {
    pg->cpath->add_rect(pointf(x, y), sizef(w, h));
    return pg;
  }

  static bool path_is_point_inside(xcontext& hc, xpath* pg, float x, float y) {
    return pg->cpath->is_inside(pointf(x, y));
  }

  static handle<xpath> path_combine(xcontext& hc, xpath* pg, string mode, xpath* pgother) {

    gool::path::COMBINE_MODE cm;

    if (mode == CHARS("union"))
      cm = gool::path::COMBINE_MODE::COMBINE_MODE_UNION;
    else if(mode == CHARS("intersect"))
      cm = gool::path::COMBINE_MODE::COMBINE_MODE_INTERSECT;
    else if (mode == CHARS("xor"))
      cm = gool::path::COMBINE_MODE::COMBINE_MODE_XOR;
    else if (mode == CHARS("exclude"))
      cm = gool::path::COMBINE_MODE::COMBINE_MODE_EXCLUDE;
    else
      throw qjs::om::type_error("wrong path combining mode");
    
    handle<gool::path> r = pg->cpath->combine(cm, pgother->cpath);
    if (!r) return nullptr;

    handle<xpath> xp = new xpath();
    xp->cpath = r;
    return xp;
  }

  static array<float> path_bounds(xcontext& hc, xpath* pg) {
    rectf r = pg->cpath->bounds();
    return { r.left(), r.top(), r.right(), r.bottom() };
  }

  static JSValue path_fill_even_odd(xcontext& hc, xpath* pg) {
    return JS_UNDEFINED;
  }

  static void path_set_fill_even_odd(xcontext& hc, xpath* pg, bool even) {
    pg->cpath->set_even_odd(even);
  }

  static handle<xpath> path_ctor(xcontext& c, int argc, JSValueConst *argv) {
    handle<xpath> xp = new xpath();
    xp->cpath = c.pview()->app->create_path();

    if (argc == 1 && c.is_string(argv[0])) {
      if (!html::parse_d_path(xp->cpath, c.get<ustring>(argv[0])))
        throw qjs::om::type_error("wrong path initialization format");
    }

    return xp;
  }

  JSOM_PASSPORT_BEGIN(Path_def, xpath)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Graphics.Path", JS_PROP_CONFIGURABLE),

    JSOM_FUNC_DEF("moveTo", path_move_to),
    JSOM_FUNC_DEF("lineTo", path_line_to),
    JSOM_FUNC_DEF("quadraticCurveTo", path_quadratic_curve_to),
    JSOM_FUNC_DEF("bezierCurveTo", path_bezier_curve_to),
    JSOM_FUNC_DEF("arc", path_arc),
    JSOM_FUNC_DEF("arcTo", path_arc_to),
    JSOM_FUNC_DEF("ellipse", path_ellipse),
    JSOM_FUNC_DEF("rect", path_rect),
    JSOM_FUNC_DEF("close", path_close),
    JSOM_FUNC_DEF("closePath", path_close),

    JSOM_FUNC_DEF("isPointInside", path_is_point_inside),
    JSOM_FUNC_DEF("bounds", path_bounds),
    JSOM_FUNC_DEF("combine", path_combine),

    JSOM_PROP_DEF("fillEvenOdd", path_fill_even_odd, path_set_fill_even_odd),
    

  JSOM_PASSPORT_END

  /*JSOM_PASSPORT_BEGIN(Path_static_def, qjs::xcontext)
    JSOM_GLOBAL_FUNC_DEF("fromBytes", path_from_bytes),
    JSOM_GLOBAL_FUNC_DEF("load", path_load),
  JSOM_PASSPORT_END*/


  void init_Path_class(context& c, hvalue graphics)
  {
    JS_NewClassID(&Graphics_Path_class_id);

    static JSClassDef Path_class = {
      "GraphicsPath",
      [](JSRuntime *rt, JSValue val)
      {
        xpath* pi = path_ptr_of(val);
        if (pi)
          pi->release();
      }
    };

    JS_NewClass(JS_GetRuntime(c), Graphics_Path_class_id, &Path_class);
    JSValue path_proto = JS_NewObject(c);

    auto list = Path_def();
    JS_SetPropertyFunctionList(c, path_proto, list.start, list.length);


    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      xcontext c(ctx);
      handle<xpath> xp;
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Graphics_Path_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      try {
        xp = path_ctor(c, argc, argv);
        if (xp) {
          JS_SetOpaque(obj, xp.ptr());
          xp->add_ref();
        }
        return obj;
      } 
      catch (om::error& err) {
        JS_FreeValue(ctx, obj);
        return err.raise_error(ctx);
      }
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue path_class = JS_NewCFunction2(c, ctor, "GraphicsPath", 2, JS_CFUNC_constructor, 0);

    //auto static_list = Path_static_def();
    //JS_SetPropertyFunctionList(c, path_class, static_list.start, static_list.length);

    JS_SetConstructor(c, path_class, path_proto);
    JS_SetClassProto(c, Graphics_Path_class_id, path_proto);

    c.set_prop<hvalue>("Path", graphics, path_class);
    c.set_prop<hvalue>("Path2D", c.global(), path_class);

  }


}
