#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xgraphics.h"

namespace qjs {

  using namespace html;
  using namespace gool;


  JSClassID Graphics_Brush_class_id = 0;

  gool::brush* brush_ptr_of(JSValueConst obj) {
    brush* pi = (brush*)JS_GetOpaque(obj, Graphics_Brush_class_id);
    return pi;
  }

  static string brush_type(xcontext& hc, brush* br) {
    return br->type();
  }

  static hbrush brush_add_color_stop(xcontext& c, hbrush hb, float pos, gool::argb clr) {
    if (!hb->is_gradient())
      throw om::type_error("not a gradient brush");
    hb.ptr_of<gradient_brush>()->add_stop(pos, clr);
    return hb;
  }

  static hbrush brush_linear_gradient(xcontext& c, float x1, float y1, float x2, float y2)
  {
    handle<gool::linear_brush> lb = new gool::linear_brush(pointf(x1, y1), pointf(x2, y2));
    return lb;
  }

  static hbrush brush_radial_gradient(xcontext& c, float x0, float y0, float r0/*, float x1, float y1, float r1*/)
  {
    handle<gool::radial_brush> lb = new gool::radial_brush(pointf(x0, y0),sizef(r0,r0));
    return lb;
  }

  static hbrush brush_solid(xcontext& c, gool::argb clr) {
    handle<gool::solid_brush> hb = new gool::solid_brush(clr);
    return hb;
  }

  static hbrush brush_tile(xcontext& c, himage img) {
    handle<gool::tile_brush> hb = new gool::tile_brush(img);
    return hb;
  }

  JSOM_PASSPORT_BEGIN(Brush_def, brush)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Brush", JS_PROP_CONFIGURABLE),

    JSOM_FUNC_DEF("addColorStop", brush_add_color_stop),

  JSOM_PASSPORT_END

  JSOM_PASSPORT_BEGIN(Brush_static_def, qjs::xcontext)
    JSOM_GLOBAL_FUNC_DEF("createLinearGradient", brush_linear_gradient),
    JSOM_GLOBAL_FUNC_DEF("createRadialGradient", brush_radial_gradient),
    JSOM_GLOBAL_FUNC_DEF("createSolid", brush_solid),
    JSOM_GLOBAL_FUNC_DEF("createTile", brush_tile),
  JSOM_PASSPORT_END

  void init_Brush_class(context& c, hvalue graphics)
  {
    JS_NewClassID(&Graphics_Brush_class_id);

    static JSClassDef Brush_class = {
      "Brush",
      [](JSRuntime *rt, JSValue val)
      {
        brush* pi = brush_ptr_of(val);
        if (pi)
          pi->release();
      }
    };

    JS_NewClass(JS_GetRuntime(c), Graphics_Brush_class_id, &Brush_class);
    JSValue brush_proto = JS_NewObject(c);

    auto list = Brush_def();
    JS_SetPropertyFunctionList(c, brush_proto, list.start, list.length);


    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      return JS_EXCEPTION;
    };

    hvalue brush_class = JS_NewCFunction2(c, ctor, "Brush", 2, JS_CFUNC_constructor, 0);

    auto static_list = Brush_static_def();
    JS_SetPropertyFunctionList(c, brush_class, static_list.start, static_list.length);

    JS_SetConstructor(c, brush_class, brush_proto);
    JS_SetClassProto(c, Graphics_Brush_class_id, brush_proto);

    c.set_prop<hvalue>("Brush", graphics, brush_class);

  }


}
