#pragma once

#ifndef __xdomjs_xevent_h__
#define __xdomjs_xevent_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  using namespace html;
  extern JSClassID Event_class_id;

  template <> struct conv<html::event_proxy*>
  {
    static html::event_proxy* unwrap(JSContext * ctx, JSValueConst v, int argc = 0)
    {
      html::event_proxy* pe = (html::event_proxy*)JS_GetOpaque(v, Event_class_id);
      if (!pe)
        throw qjs::om::type_error("Event was deleted");
      return static_cast<html::event_proxy*>(pe);
    }

    static html::event_proxy* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      html::event_proxy* pe = (html::event_proxy*)JS_GetOpaque(v, Event_class_id);
      if (!pe) return nullptr;
      return static_cast<html::event_proxy*>(pe);
    }

    static JSValue wrap(JSContext * ctx, html::event_proxy* pr) noexcept
    {
      JSValue obj = JS_NewObjectClass(ctx, Event_class_id);
      pr->add_ref();
      JS_SetOpaque(obj, (resource*)pr);
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Event_class_id) != NULL; }
  };

  template <> struct conv<html::event*>
  {
    static JSValue wrap(JSContext * ctx, html::event* evt) noexcept
    {
      JSValue obj = JS_NewObjectClass(ctx, Event_class_id);

      handle<event_proxy> pep = evt->proxy ? evt->proxy : new event_proxy(*evt);
      JS_SetOpaque(obj, pep.detach());
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Event_class_id) != NULL; }

/*  private:
    static html::event* unwrap(JSContext * ctx, JSValueConst v)
    {
      return nullptr;
    }*/
  };


  inline html::event_proxy*  event_proxy_ptr_of(JSContext * ctx, JSValueConst obj) {
    html::event_proxy* pe = (html::event_proxy*)JS_GetOpaque(obj, Event_class_id);
    return pe;
  }

}

#endif
