#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xconsole.h"
#include "xclipboard.h"
#include "xurl.h"

extern "C" JSModuleDef *init_uv_module(JSContext *ctx, const char *name);
extern "C" JSModuleDef *js_init_module_storage(JSContext *ctx, const char *module_name);

namespace html
{
  using namespace qjs;
}

namespace qjs {

  using namespace html;

  int64 set_timeout(xcontext& c, hvalue fun, int ms) {
    html::document* pd = c.pdoc();
    qjs::xview* pv = c.pxview();
    if (!pd || !pv)
      return 0;
    if (!JS_IsFunction(c, fun))
      throw qjs::om::type_error("setTimeout: not a function");
    html::timer_id tid = c.next_timer_id();
    auto& td = pv->start_timer(pd, max(16, ms), tid, html::SCRIPT_TIMER);
    timer_callback* pcb = new timer_callback();
    pcb->fun = fun; //JS_DupValue(c, fun);
    td.pcb = pcb;
    return int64(tid);
  }

  bool clear_timeout(xcontext& c, int64 tid) {
    html::document* pd = c.pdoc();
    qjs::xview* pv = c.pxview();
    if (!pd || !pv)
      return false;
    pv->stop_timer(pd, uint64(tid), html::SCRIPT_TIMER);
    return true;
  }

  int64 post(xcontext& c, hvalue fun) {
    html::document* pd = c.pdoc();
    qjs::xview* pv = c.pxview();
    if (!pd || !pv)
      return 0;
    if (!JS_IsFunction(c, fun))
      throw qjs::om::type_error("post: not a function");
    html::timer_id tid = c.next_timer_id();
    auto& td = pv->start_timer(pd, 1, tid, html::SCRIPT_TIMER);
    timer_callback* pcb = new timer_callback();
    pcb->fun = fun;//JS_DupValue(ctx, argv[0]);
    td.pcb = pcb;
    return int64(tid);
  }


  int64 set_interval(xcontext& c, hvalue fun, int ms) {
    html::document* pd = c.pdoc();
    qjs::xview* pv = c.pxview();
    if (!pd || !pv)
      return 0;
    if (!JS_IsFunction(c, fun))
      throw qjs::om::type_error("setInterval: not a function");
    html::timer_id tid = c.next_timer_id();
    auto& td = pv->start_timer(pd, max(16, ms), tid, html::SCRIPT_INTERVAL);
    timer_callback* pcb = new timer_callback();
    pcb->fun = fun;
    td.pcb = pcb;
    return int64(tid);
  }

  bool clear_interval(xcontext& c, int64 iid) {
    html::document* pd = c.pdoc();
    qjs::xview* pv = c.pxview();
    if (!pd || !pv)
      return false;
    if (pv->processing_timer
      && pv->processing_timer->id == iid
      && pv->processing_timer->kind == html::SCRIPT_INTERVAL) {
      pv->processing_timer->kind = html::STOPPED_TIMER;
    }
    pv->stop_timer(pd, uint64(iid), html::SCRIPT_INTERVAL);
    return true;
  }

  int64 request_animation_frame(xcontext& c, hvalue fun)
  {
    if (!c.is_function(fun))
      throw qjs::om::type_error("requestAnimationFrame: not a function");
    return context::inst(c).request_animation_frame(fun);
  }
  static bool  cancel_animation_frame(xcontext& c, int64 id)
  {
    return context::inst(c).cancel_animation_frame(id);
  }

  static double device_pixel_ratio(xcontext& c) { 
    return c.pview()->pixels_per_inch().x / 96.0;
  }

  static bool scroll_to(xcontext& c, double x, double y) {
    size ppd = c.pview()->pixels_per_dip(gool::size(1,1));
    c.pdoc()->scroll_pos(*c.pview(), point(int(ppd.x * x), int(ppd.y * y)));
    return true;
  }

  style_provider* get_computed_style(xcontext&, element *el, string pseudo) {
    if (!el) return nullptr;
    if (pseudo.is_defined()) {
      if (!el->style_content) return nullptr;
      if (pseudo == CHARS("before")) return el->style_content->before;
      if (pseudo == CHARS("after")) return el->style_content->after;
      if (pseudo == CHARS("marker")) return el->style_content->marker;
    }
    return el;
  }

  hvalue get_self(xcontext& c) {
    return c.global();
  }
  
  ustring format(xcontext& c, ustring fmt, array<hvalue> args);
  array<hvalue> scan(xcontext &c, ustring fmt, ustring str);
   
  hvalue request_fetch(xcontext& c, JSValueConst resource, JSValueConst init);

  JSValue reactor_jsx(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

  ustring reactor_jsx_translate_text(xcontext& c, hvalue v, string n, bool attr);
  hvalue  reactor_jsx_translate_node(xcontext& c, hvalue node, string n, string src);

  /*array<byte> sciter_encode(xcontext& c, ustring data, string encoding);
  ustring sciter_decode(xcontext& c, array<byte> data, string encoding);

  array<byte> atob(xcontext& c, string data) {
    array<byte> out;
    tool::base64_decode(data, out);
    return out;
  }

  string btoa(xcontext& c, array<byte> data) {
    return tool::base64_encode(data());
  }*/

  JSOM_PASSPORT_BEGIN(Global_def, qjs::xcontext)
    //JSOM_GLOBAL_FUNC_DEF("println", println),
    JSOM_GLOBAL_FUNC_DEF("setTimeout", set_timeout),
    JSOM_GLOBAL_FUNC_DEF("post", post),
    JSOM_GLOBAL_FUNC_DEF("clearTimeout", clear_timeout),
    JSOM_GLOBAL_FUNC_DEF("setInterval", set_interval),
    JSOM_GLOBAL_FUNC_DEF("clearInterval", clear_interval),
    JSOM_GLOBAL_FUNC_DEF("requestAnimationFrame", request_animation_frame),
    JSOM_GLOBAL_FUNC_DEF("cancelAnimationFrame", cancel_animation_frame),
    JSOM_GLOBAL_FUNC_DEF("fetch", request_fetch),
    JSOM_GLOBAL_RO_PROP_DEF("devicePixelRatio", device_pixel_ratio),
    JSOM_GLOBAL_RO_PROP_DEF("self", get_self),
    JSOM_GLOBAL_FUNC_DEF("scrollTo", scroll_to),
    JSOM_GLOBAL_FUNC_DEF("getComputedStyle", get_computed_style),
    JSOM_GLOBAL_FUNC_DEF("printf", format),
    JSOM_GLOBAL_FUNC_DEF("scanf", scan),

    //qjs::func_def("JSX", 3, reactor_jsx),

  JSOM_PASSPORT_END

  void init_Node_class(context& ctx);
  void init_Element_class(context& c);
  void init_ElementList_class(context& c);
  void init_Document_class(context& c);
  void init_Event_class(context& c);
  void init_Style_class(context& c);
  void init_ElementState_class(context& c);
  void init_sciter_module(context& c);
  void init_env_module(context& c);
  void init_debug_module(context& c);
  void init_URL_class(context& c);
  void init_Graphics_class(context& c);
  void init_Asset_class(context& c);
  void init_Request_class(context& ctx);
  void init_Response_class(context &ctx);
  void init_WebSocket_class(context& ctx);
  void init_NodeList_class(context& c);
  void init_Iterator_class(context& c);
  void init_NodeIterator_class(context& c);
  void init_Tokenizer_class(context& c);
  void init_Range_class(context& c);
  void init_Selection_class(xcontext& c);
  void init_BJSON_class(context& c);
  void init_NativeFunctor_class(context& c);
  void init_Navigator_object(context& c);
  void init_CSS_namespace(context& c);
  void init_Audio_class(context& c);
  void init_Reactor_namespace(context& c);
 
  context::context(html::view* phv, html::document *phd): _pv(phv), _pd(phd)
  {
    xview* pxv = pxview();

    ctx = JS_NewContext(hruntime::current());
    if (!ctx)
      throw std::runtime_error{ "cannot create context" };
    JS_SetContextOpaque(ctx, this);
    init_locale_functions();
    
    init_Node_class(*this);
    init_Element_class(*this);
    init_Iterator_class(*this);
    init_NodeIterator_class(*this);
    init_NodeList_class(*this);
    init_ElementList_class(*this);
    init_Style_class(*this);
    init_ElementState_class(*this);
    init_Document_class(*this);
    init_Event_class(*this);
    init_Graphics_class(*this);
    init_Asset_class(*this);
    init_Tokenizer_class(*this);
    init_Range_class(*this);
    init_Selection_class(*this);
    xconsole::init_class(*this);
    xview::init_class(*this);
    init_Request_class(*this);
    init_Response_class(*this);
#ifdef WEBSOCKETS_SUPPORT
    init_WebSocket_class(*this);
#endif
    init_sciter_module(*this);
    init_env_module(*this);
    init_URL_class(*this);
    init_debug_module(*this);
    init_BJSON_class(*this);
    init_NativeFunctor_class(*this);
    init_Navigator_object(*this);
    init_Reactor_namespace(*this);
    init_CSS_namespace(*this);
    init_Clipboard_namespace(*this);
 #ifdef AUDIO_SUPPORT
    init_Audio_class(*this);
#endif

#ifdef CONFIG_BIGNUM
    JS_AddIntrinsicBigFloat(ctx);
    JS_AddIntrinsicBigDecimal(ctx);
    JS_AddIntrinsicOperators(ctx);
    JS_EnableBignumExt(ctx, TRUE);
#endif

    init_uv_module(*this, "@sys");
#ifdef CONFIG_STORAGE
    js_init_module_storage(ctx, "@storage");
#endif   

    hvalue g = global();

    handle<xurl> location = new xurl(pdoc());

    JS_SetPropertyStr(*this, g, "document", val(pdoc()));
    JS_SetPropertyStr(*this, g, "location", val(location));
    JS_SetPropertyStr(*this, g, "window", JS_DupValue(*this,g)); // that strange "window" thing
    hvalue console = val(xconsole::instance());
    JS_SetPropertyStr(*this, g, "console", console);

    if (pxview()->reload_data.length()) {
      array<byte> data; swap(pxview()->reload_data, data);
      JSValue pv = JS_ReadObject(ctx, data.cbegin(), data.length(), 0);
      if (is_exception(pv)) goto EMPTY_DATA_OBJECT;
      JS_SetPropertyStr(*this, g, "data", pv);
    }
    else {
EMPTY_DATA_OBJECT:
      JS_SetPropertyStr(*this, g, "data", JS_NewObject(*this));
    }
    auto list = Global_def();
    JS_SetPropertyFunctionList(*this, g, list.start, list.length);

    JS_SetJSX(ctx, &reactor_jsx);

    hruntime &hr = hruntime::get(JS_GetRuntime(ctx));
    for (int i = 0; i < hr.globals.size(); ++i)
      JS_SetProperty(*this, g, hr.globals.key(i), val(hr.globals.value(i)));

  }
  
}
