#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xnodelist.h"

namespace html
{
  //script_expando_interface
  bool document::get_expando(context& hc, script_expando& seo) {
    if (!obj)
      return false;
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    seo = c.val(this);
    return true;
  }
}

namespace qjs {

  JSClassID Document_class_id = 0;

  using namespace html;
  using namespace tool;

  html::document* document_ptr_of(JSContext * ctx, JSValueConst obj) {
    if (html::element* pe = element_ptr_of(ctx, obj)) {
      if (pe->is_document())
        return static_cast<html::document*>(pe);
    }
    hvalue cproto = JS_GetClassProto(ctx, Document_class_id);
    if (obj == cproto) {
      static handle<document> proto_doc = new document();
      return proto_doc;
    }
    return nullptr;
  }

  element*    get_body(xcontext&, document* pd) { return pd->get_body(); }
  element*    get_head(xcontext&, document* pd) { return pd->get_head(); }

  /*qjs::xview* get_window(xcontext&, document* pd) {
    if (html::view* pv = pd->pview())
      return static_cast<qjs::xview*>(pv);
    return nullptr;
  }*/

  string get_ready_state(xcontext&, document* pd) {
    if (pd->num_resources_requested == 0)
      return "complete";
    else
      return "interactive";
  }

  hvalue get_global_this(xcontext&, document* pd) {
    JSContext* doc_ctx = pd->ns;
    if (doc_ctx)
      return JS_GetGlobalObject(doc_ctx);
    else
      return JS_NULL;
  }

  element*    get_element_by_id(xcontext&, document* pd, ustring id) { return pd->get_element_by_id(id); }
  element*    get_self(xcontext&, document* pd) { return pd; }

#if 0
  JSValue create_element(xcontext& c, document* pd, string tag) {
    html::element* pel = new html::element(html::tag::symbol(tag));
    pel->parent = pd;
    pel->obj.v = JS_NewObjectClass(c, Element_class_id);
    pel->add_ref();
    JS_SetOpaque(pel->obj.v, (html::node*)pel);
    return pel->obj;
  }
#else 
  helement create_element(xcontext& c, document* pd, string tag) {
    html::element* pel = new html::element(html::tag::symbol(tag));
    //pel->parent = pd;
    c.add_airborn_node(pel);
    return pel;
  }
  helement create_element_ns(xcontext& c, document* pd, string ns, string tag) {
    html::element* pel = new html::element(html::tag::symbol(tag));
    //pel->parent = pd;
    c.add_airborn_node(pel);
    return pel;
  }
#endif
  
  hnode create_text_node(xcontext& c, document* pd, ustring text) {
    html::node* pn = new html::text(text());
    c.add_airborn_node(pn);
    //pn->parent = pd;
    return pn;
  }
  hnode create_comment_node(xcontext& c, document* pd, ustring text) {
    html::node* pn = new html::comment(text());
    //pn->parent = pd;
    c.add_airborn_node(pn);
    return pn;
  }
#if 0
  JSValue create_document_fragment(xcontext& c, document* pd) {
    html::element* pfd = new html::document_fragment();

    pfd->parent = pd; 
    // note: this gets created in the air, pfd->obj must have refcnt = 1 
    pfd->obj.v = JS_NewObjectClass(c, Element_class_id);
    pfd->add_ref();
    JS_SetOpaque(pfd->obj.v, (html::node*)pfd);
    return pfd->obj;
  }
#else 
  helement create_document_fragment(xcontext& c, document* pd) {
    html::helement pfd = new html::document_fragment();
    c.add_airborn_node(pfd);
    return pfd;
  }
#endif



    
  helement query_selector(xcontext& c, document* pd, ustring selector) {
    return html::find_first(*c.pview(), pd, selector);
  }

  array<helement> query_selector_all(xcontext& c, document* pd, ustring selector) {
    array<helement> r;
    find_all(*c.pview(), r, pd, selector);
    return r;
  }

  string doc_url(xcontext& c, document* pd, string relurl) {
    string url = pd->doc_url();
    if (relurl.is_defined())
      url = html::combine_url(url, url::escape(relurl));
    return url;
  }

  hvalue bind_image(xcontext& c, document* pd, string url, hvalue vimg) {
    himage img = c.get<himage>(vimg);
    if (img) {
      img->set_url(url);
      pd->image_arrived(*c.pview(), img);
      return c.val(true);
    }
    else if(vimg.is_undefined()) {
      image *pimg = pd->get_image(url);
      return c.val(pimg);
    }
    else if(vimg.is_null()){
      return c.val(pd->drop_image(url));
    }
    return  c.val(false);
  }
 
  node_iterator* create_node_iterator(xcontext& c, document* pd, hnode root, uint_v mask, hvalue filter ) {
    return new node_iterator(c, root, mask.val(0xFFFFFFF), filter);
  }
      
  JSOM_PASSPORT_BEGIN(Document_def, html::document)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Document", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("body", get_body),
    JSOM_RO_PROP_DEF("head", get_head),
    //JSOM_RO_PROP_DEF("window",   get_window),
    JSOM_RO_PROP_DEF("documentElement", get_self),
    JSOM_RO_PROP_DEF("globalThis", get_global_this),
    JSOM_FUNC_DEF("querySelector", query_selector),
    JSOM_FUNC_DEF("querySelectorAll", query_selector_all),
    JSOM_FUNC_DEF("getElementById", get_element_by_id),
    JSOM_RO_PROP_DEF("readyState", get_ready_state),

    JSOM_FUNC_DEF("url", doc_url),

    JSOM_FUNC_DEF("bindImage", bind_image),

    JSOM_FUNC_DEF("createElement", create_element),
    JSOM_FUNC_DEF("createElementNS", create_element_ns),
    JSOM_FUNC_DEF("createTextNode", create_text_node),
    JSOM_FUNC_DEF("createComment", create_comment_node),
    JSOM_FUNC_DEF("createDocumentFragment", create_document_fragment),
    JSOM_FUNC_DEF("createNodeIterator", create_node_iterator),
  JSOM_PASSPORT_END

#if 0
  void document_GCMark(JSRuntime *rt, JSValueConst val, JS_MarkFunc *mark_func)
  {
    //JS_MarkValue(rt, pe->filter, mark_func);
    document* pd = (document*)JS_GetOpaque(val, Document_class_id);

    function<bool(html::node *)> scan = [rt, &scan, pd, mark_func](html::node *n) -> bool 
    {
      //if (n->is_document() && static_cast<html::document *>(n)->ns)
      //  JS_MarkContext(rt,static_cast<html::document *>(n)->ns,mark_func);
      if (/*(n != pd) &&*/ n->obj) {
        n->dbg_report("mark");
        JS_MarkValue(rt, n->obj.v, mark_func);
      }
      if (n->is_document())
        return true;
      if (!n->is_element()) return false;
      html::element *el = static_cast<html::element *>(n);
#ifdef DEBUG
      if (el->flags.strayed)
        el = el;
#endif // DEBUG

      html::ctl *bhv = el->behavior;
      while (bhv) {
        bhv->scan_owned_elements(scan);
        bhv = bhv->next;
      }
      return false;
    };
    html::tree_scanner ts(pd);
    ts.each_node(scan);
  }
#endif

  extern JSClassExoticMethods Element_exotic_methods;

  void init_Document_class(context& c)
  {
    JS_NewClassID(&Document_class_id);

    static JSClassDef Document_class = {
      "Document",
      [](JSRuntime *rt, JSValue val) { // finalizer
        html::document* pd = object_of<html::document>(val);
        if (pd) {
          pd->obj.tearoff();
          pd->release();
        }
      },
      NULL,
      NULL,
      &Element_exotic_methods
    };

    JS_NewClass(JS_GetRuntime(c), Document_class_id, &Document_class);
    JSValue document_proto = JS_NewObject(c);

    // note, in Sciter: Document extends Element - essentially Document is <html> or <svg> element.
    // and so in Sciter: document.documentElement === document;

    hvalue element_proto = JS_GetClassProto(c, Element_class_id);
    JS_SetPrototype(c, document_proto, element_proto);

    auto list = Document_def();
    JS_SetPropertyFunctionList(c, document_proto, list.start, list.length);

    static auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Document_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      //!!!!!! JS_SetOpaque(obj, s);
      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    JSValue document_class = JS_NewCFunction2(c, ctor, "Document", 2, JS_CFUNC_constructor, 0);
    JS_DefinePropertyValueStr(c, c.global(), "Document", JS_DupValue(c, document_class), JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, document_class, document_proto);
    JS_SetClassProto(c, Document_class_id, document_proto);
    JS_FreeValue(c, document_class);
  }

}