#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xfetch.h"

namespace qjs {

  using namespace tool;
  using namespace html;
    
  bool css_supports(xcontext&c, hvalue obj, ustring prop, ustring val) {

    if (!val.is_empty())
      prop = ustring::format(W("(%s:%s)"), prop.c_str(), val.c_str());
    
    html::style_parser sp(string(), prop(), c.pdoc());
    try {
      bool dummy;
      return sp.parse_supports_expr(dummy);
    }
    catch (std::runtime_error) {
      return false;
    }
    
/*
    else {
      css_istream st(val(), c.pdoc()->doc_url());
      bool r = false;
      value customv;
      if (parse_custom_attribute_value(c.pdoc(), c.pdoc()->doc_url(), st, customv, nullptr)) {
        style s; r = set_attribute_value(c.pdoc(), s, string(prop), customv);
      }
      return r;
    } */
  }

  JSOM_PASSPORT_BEGIN(CSS_def, qjs::xcontext)
    JSOM_FUNC_DEF("supports", css_supports),
  JSOM_PASSPORT_END

  void init_CSS_namespace(context& c)
  {
    JSValue cssns = JS_NewObject(c);

    auto list = CSS_def();
    JS_SetPropertyFunctionList(c, cssns, list.start, list.length);

    JS_DefinePropertyValueStr(c, c.global(), "CSS", cssns, JS_PROP_CONFIGURABLE);
  }

}