#pragma once

#include "xconv.h"

namespace qjs {

  extern JSClassID Console_class_id;

  struct xconsole : public resource {

    static xconsole* instance() {
      static handle<xconsole> pc = new xconsole();
      return pc;
    }

    static bool log(xcontext& ctx, xconsole* pc, array<hvalue> argv) { return pc->print(ctx, html::OS_INFO, argv()); }
    static bool warn(xcontext& ctx, xconsole* pc, array<hvalue> argv) { return pc->print(ctx, html::OS_WARNING, argv()); }
    static bool error(xcontext& ctx, xconsole* pc, array<hvalue> argv) { return pc->print(ctx, html::OS_ERROR, argv()); }
    //static bool assert_(xcontext& ctx, xconsole* pc, bool r, slice<JSValue> argv);
    bool print(xcontext& ctx, html::OUTPUT_SEVERITY severity, slice<hvalue> argv);

    static void init_class(JSContext* ctx);

  };


  template <> struct conv<xconsole*>
  {
    static xconsole* unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      xconsole* pn = (xconsole*)JS_GetOpaque(v, Console_class_id);
      //JS_FreeValue(ctx, v); ??
      return pn;
    }

    static JSValue wrap(JSContext * ctx, xconsole* pn) noexcept
    {
      if (!pn)
        return JS_NULL;
      JSValue v = JS_NewObjectClass(ctx, Console_class_id);
      pn->add_ref();
      JS_SetOpaque(v, pn);
      return JS_DupValue(ctx, v);
      //return v;
    }
  };
}