#pragma once

#pragma once

#ifndef __xdomjs_xcolor_h__
#define __xdomjs_xcolor_h__

#include "gool/gool.h"
#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  extern JSClassID Color_class_id;

  template <> struct conv<gool::argb>
  {
    static gool::argb unwrap(JSContext * ctx, JSValueConst v, int argc = 0)
    {
      gool::argb c;
      void* popaque = 0;
      if (JS_IsString(v)) {
        gool::color_v cv = gool::parse_color(conv<string>::unwrap(ctx, v)());
        c = cv.to_argb();
      }
      else if (JS_GetClassID(v, &popaque) == Color_class_id) {
        c = (gool::color)(uint32)(uintptr_t)popaque;
      }
      else if (JS_IsNumber(v)) {
        color cv = conv<uint>::unwrap(ctx,v);
        c = cv;
      } else 
        throw qjs::om::type_error("Cannot coerce value to color");
      return c;
    }

    static gool::argb try_unwrap(JSContext * ctx, JSValueConst v, int argc = 0)
    {
      gool::argb c = gool::argb::undefined();
      void* popaque = 0;
      if (JS_IsString(v)) {
        gool::color_v cv = gool::parse_color(conv<string>::unwrap(ctx, v)());
        c = cv.to_argb();
      }
      else if (JS_GetClassID(v, &popaque) == Color_class_id) {
        c = (gool::color)(uint32)(uintptr_t)popaque;
      }
      else if (JS_IsNumber(v)) {
        color cv = conv<uint>::unwrap(ctx, v);
        c = cv;
      }
      return c;
    }

    static JSValue wrap(JSContext * ctx, gool::argb c) noexcept
    {
      JSValue obj = JS_NewObjectClass(ctx, Color_class_id);
      JS_SetOpaque(obj, (void*)(uintptr_t)c.to_color());
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetClassID(v, nullptr) == Color_class_id; }
  };

  template <> struct conv<color_v>
  {
    static color_v unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      if (JS_IsUndefined(v)) 
        return color_v();
      auto cv = conv<gool::argb>::try_unwrap(ctx, v, argc);
      if (cv == gool::argb::undefined())
        return color_v();
      else
        return cv;
    }
    static JSValue wrap(JSContext * ctx, color_v v) noexcept
    {
      return conv<gool::argb>::wrap(ctx, v.to_argb());
    }
    static bool isa(JSContext * ctx, JSValueConst v) {
      gool::argb cv = conv<gool::argb>::try_unwrap(ctx, v);
      return cv != gool::argb::undefined();
    }
  };


}

#endif

