
#include "xdom.h"
#include "xom.h"
#include "xclipboard.h"
#include "xview.h"
#include "html/html.h"

namespace qjs {

  using namespace html;
  using namespace gool;

  handle<html::clipboard::data> object2cbdata(xcontext& c, xview *pv, hvalue items) 
  {
   
    handle<html::clipboard::data> pdata = new html::clipboard::data();

    c.each_prop(items, [&](chars name, hvalue val) {
      if (name == CHARS("text"))
        pdata->add(new html::clipboard::text_item(c.get<ustring>(val)));
      else if (name == CHARS("html")) {
        if (c.is_object(val)) {
          html::element *pel = c.get<html::element*>(val);
          if (pel) {
            array<char> html;
            html::clipboard::html_cf(*pv, pel->this_pos(false),
              pel->this_pos(true), html);
            pdata->add(html::clipboard::html_item::from_cf_html(html()));
          }
        }
        else {
          string          html_fragment = c.get<string>(val);
          html::document *pd = c.pdoc();
          if (!pd) pd = pv->doc();
          array<char> html;
          html::clipboard::html_cf(html_fragment(), pd->uri().src(), html);
          pdata->add(html::clipboard::html_item::from_cf_html(html()));
        }
      }
      else if (name == CHARS("link")) {
        if (c.is_object(val)) {
          tool::ustring caption = c.get_prop<ustring>("caption", val);
          tool::ustring url = c.get_prop<ustring>("url", val);
          pdata->add(new html::clipboard::link_item(caption, url));
        }
        else if (c.is_string(val)) {
          tool::ustring caption;
          tool::ustring url = c.get<ustring>(val);
          pdata->add(new html::clipboard::link_item(caption, url));
        }
      }
      else if (name == WCHARS("image")) {
        handle<gool::image> pimg = c.get<gool::image*>(val);
        if (pimg)
          pdata->add(new html::clipboard::image_item(pimg));
      }
      else if (name == WCHARS("file")) {
        array<ustring> files;
        if (c.is_array(val))
          files = c.get<tool::array<tool::ustring>>(val);
        else if (c.is_string(val)) {
          files.push(c.get<ustring>(val));
        }
        if (files.size()) pdata->add(new html::clipboard::file_item(files));
      }
      else if (name == WCHARS("json")) {
        string s = c.toJSON(val);
        pdata->add(new html::clipboard::json_item(s.chars_as_bytes()));
      }


      });

    return pdata;
  }

  hvalue cbdata2object(xcontext& c, handle<html::clipboard::data> cbdata) {

    hvalue obj = JS_NewObjectProto(c, JS_NULL);

    for (auto pd : cbdata->items())
      switch (pd->data_type) {
      case html::clipboard::cf_undefined: continue;
      case html::clipboard::cf_text: {
        html::clipboard::text_item *ti = pd.ptr_of<html::clipboard::text_item>();
        c.set_prop("text", obj, ti->val);
      } break;
      case html::clipboard::cf_html: {
        html::clipboard::html_item *ti = pd.ptr_of<html::clipboard::html_item>();
        c.set_prop("html", obj, u8::cvt(ti->val()));
      } break;
      case html::clipboard::cf_picture: {
        html::clipboard::image_item *ti = pd.ptr_of<html::clipboard::image_item>();
        c.set_prop("image", obj, ti->image);
      } break;
      case html::clipboard::cf_hyperlink: {
        html::clipboard::link_item *ti = pd.ptr_of<html::clipboard::link_item>();
        hvalue lobj = JS_NewObjectProto(c, JS_NULL);
        c.set_prop("caption", lobj, ti->caption);
        c.set_prop("url", lobj, ti->url);
        c.set_prop("link", obj, lobj);
      } break;
      case html::clipboard::cf_json: {
        html::clipboard::json_item *ti = pd.ptr_of<html::clipboard::json_item>();
        c.set_prop("json", obj, c.parseJSON(chars_of(ti->val())));
      } break;
      case html::clipboard::cf_xml: break;
      case html::clipboard::cf_file: {
        html::clipboard::file_item *fi = pd.ptr_of<html::clipboard::file_item>();
        c.set_prop("file", obj, c.val(fi->filenames));
      } break;
    }
    return obj;
  }

  hvalue Clipboard_read(xcontext& c) {
    handle<html::clipboard::data> cbdata = html::clipboard::get();
    return cbdata2object(c,cbdata);
  }

  hvalue Clipboard_read_text(xcontext& c) {
    ustring text;
    if (html::clipboard::get(text))
      return c.val(text);
    return hvalue(JS_UNDEFINED);
  }

  bool Clipboard_write(xcontext& c, hvalue cbobj) {
    handle<html::clipboard::data> cbdata = object2cbdata(c, c.pxview(), cbobj);
    html::clipboard::set(cbdata);
    return true;
  }

  bool Clipboard_write_text(xcontext& c, ustring text) {
    html::clipboard::set_text(text());
    return true;
  }

  bool Clipboard_has(xcontext& c, string name) {
    return html::clipboard::available_format_names()().contains(name);
  }
  
  JSOM_PASSPORT_BEGIN(Clipboard_def, qjs::xcontext)
    JSOM_GLOBAL_FUNC_DEF("read", Clipboard_read),
    JSOM_GLOBAL_FUNC_DEF("readText", Clipboard_read_text),
    JSOM_GLOBAL_FUNC_DEF("write", Clipboard_write),
    JSOM_GLOBAL_FUNC_DEF("writeText", Clipboard_write_text),
    JSOM_GLOBAL_FUNC_DEF("has", Clipboard_has)
  JSOM_PASSPORT_END

  void init_Clipboard_namespace(context& c)
  {
    JSValue clipboardns = JS_NewObject(c);

    auto list = Clipboard_def();
    JS_SetPropertyFunctionList(c, clipboardns, list.start, list.length);

    JS_DefinePropertyValueStr(c, c.global(), "Clipboard", clipboardns, JS_PROP_CONFIGURABLE);
  }
  

}