#pragma once

#ifndef __xdomjs_class_list_h__
#define __xdomjs_class_list_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  extern JSClassID ClassList_class_id;

  void init_ClassList_class(context& c);

  template <> struct conv<html::class_list_provider*>
  {
    static html::class_list_provider* unwrap(JSContext * ctx, JSValueConst v)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, ClassList_class_id);
      if (!pe)
        throw qjs::om::type_error("Element was deleted");
      return static_cast<html::class_list_provider*>(pe);
    }

    static html::class_list_provider* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, ClassList_class_id);
      if (!pe) return nullptr;
      return static_cast<html::class_list_provider*>(pe);
    }

    static JSValue wrap(JSContext * ctx, html::class_list_provider* psp) noexcept
    {
      if (!psp)
        return JS_NULL;
      xcontext c(ctx);
      JSAtom atom_classList = c.known_atoms().classList;
      html::element* pe = static_cast<html::element*>(psp);
      hvalue obj = conv<html::element*>::wrap(ctx, pe);
      JSPropertyDescriptor desc;
      if (TRUE == JS_GetOwnProperty(ctx, &desc, obj, atom_classList))
        return desc.value;
      JSValue style_obj = JS_NewObjectClass(ctx, ClassList_class_id);
      pe->add_ref();
      JS_SetOpaque(style_obj, pe);
      JS_DefinePropertyValue(ctx, obj, atom_classList, style_obj, JS_PROP_CONFIGURABLE | JS_PROP_ENUMERABLE);
      return JS_DupValue(ctx, style_obj);
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, ClassList_class_id) != NULL; }
  };

}

#endif
