#pragma once

#ifndef __xdomjs_attribute_list_h__
#define __xdomjs_attribute_list_h__

#include "xcontext.h"
#include "xconv.h"
#include "xnodelist.h"

namespace qjs
{
  extern JSClassID AttributeList_class_id;

  void init_AttributeList_class(context& c);

  struct attribute_list_value_iterator : public iterator
  {
    int index;
    html::helement pe;

    attribute_list_value_iterator(html::attribute_list_provider* nl) : pe(static_cast<html::element*>(nl)), index(-1) {}

    virtual hvalue next(xcontext& c) override
    {
      hvalue obj = JS_NewObject(c);
      if (++index < pe->atts.size()) {
        hvalue attr = JS_NewObject(c);
        c.set_prop(c.known_atoms().name, attr, pe->atts.name(index));
        c.set_prop(c.known_atoms().value, attr, pe->atts.value(index));

        c.set_prop(c.known_atoms().value, obj, attr);
      }
      else
        c.set_prop(c.known_atoms().done, obj, true);
      return obj;
    }
  };
  
  template <> struct conv<html::attribute_list_provider*>
  {
    static html::attribute_list_provider* unwrap(JSContext * ctx, JSValueConst v, int argc = 0)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, AttributeList_class_id);
      if (!pe)
        throw qjs::om::type_error("Element was deleted");
      return static_cast<html::attribute_list_provider*>(pe);
    }

    static html::attribute_list_provider* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, AttributeList_class_id);
      if (!pe) return nullptr;
      return static_cast<html::attribute_list_provider*>(pe);
    }

    static JSValue wrap(JSContext * ctx, html::attribute_list_provider* psp) noexcept
    {
      if (!psp)
        return JS_NULL;
      xcontext c(ctx);
      html::element* pe = static_cast<html::element*>(psp);
      JSValue attributes_obj = JS_NewObjectClass(ctx, AttributeList_class_id);
      pe->add_ref();
      JS_SetOpaque(attributes_obj, pe);
      return attributes_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, AttributeList_class_id) != NULL; }
  };

}

#endif
