#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"

#ifndef WINDOWS
#include <dlfcn.h>
#endif // WINDOWS

namespace qjs {

  JSClassID Asset_class_id = 0;

  JSValue asset_method_magic(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv, int magic) {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx,this_val);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      const som_method_def_t& md = psp->methods[magic];
      uint nargs = min(md.params, size_t(argc));
      tool::buffer<tool::value,8> args(nargs);
      for (uint n = 0; n < nargs; ++n)
        args[n] = conv<tool::value>::unwrap(ctx, argv[n]);
      tool::value rv;
      if (!md.func(pass, nargs, args.cbegin(), &rv))
        //throw qjs::om::type_error(string::format("method %s::%s",symbol_name_a(psp->name).c_str(), symbol_name_a(md.name).c_str()));
        return JS_ThrowTypeError(ctx, string::format("method %s::%s", hruntime::current().symbol_name_a(psp->name).c_str(), hruntime::current().symbol_name_a(md.name).c_str()));
      return conv<tool::value>::wrap(ctx, rv);
    }
    return JS_UNINITIALIZED;
  }

  JSValue asset_method_next(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv) {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, this_val);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      assert(psp->item_next);
      value rv;
      dictionary<value, value> next_rv;
      if (psp->item_next(pass, nullptr, &rv)) {
        next_rv[value("done")] = value(false);
        next_rv[value("value")] = rv;
      }
      else {
        next_rv[value("done")] = value(true);
      }
      return conv<dictionary<value, value>>::wrap(ctx, next_rv);
    }
    return JS_UNDEFINED;
  }

#if 0
  JSValue asset_getter_magic(JSContext *ctx, JSValueConst this_val, int magic) {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, this_val);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      const som_property_def_t& pd = psp->properties[magic];
      tool::value rv;
      if (!pd.getter || !pd.getter(pass, &rv))
        //throw qjs::om::type_error(string::format("getter %s::%s", symbol_name_a(psp->name).c_str(), symbol_name_a(pd.name).c_str()));
        return JS_ThrowTypeError(ctx, string::format("getting %s::%s", symbol_name_a(psp->name).c_str(), symbol_name_a(pd.name).c_str()));
      return conv<tool::value>::wrap(ctx, rv);
    }
    return JS_UNINITIALIZED;
  }

  JSValue asset_setter_magic(JSContext *ctx, JSValueConst this_val, JSValueConst val, int magic) {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, this_val);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      const som_property_def_t& pd = psp->properties[magic];
      tool::value v = conv<tool::value>::unwrap(ctx,val);
      if (!pd.setter || !pd.setter(pass, &v))
        //throw qjs::om::type_error(string::format("getter %s::%s", symbol_name_a(psp->name).c_str(), symbol_name_a(pd.name).c_str()));
        return JS_ThrowTypeError(ctx, string::format("setting %s::%s", symbol_name_a(psp->name).c_str(), symbol_name_a(pd.name).c_str()));
      return val;
    }
    return JS_UNINITIALIZED;
  }

  int asset_get_own_property(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop)
  {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, obj);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      for (uint n = 0; n < psp->n_methods; ++n) {
        if (psp->methods[n].name == prop) {
          desc->flags = JS_PROP_C_W_E;
          desc->getter = JS_UNDEFINED;
          desc->setter = JS_UNDEFINED;
          desc->value = JS_NewCFunction2(ctx, (JSCFunction *)asset_method_magic,"asset::method", psp->methods[n].params, JS_CFUNC_generic_magic,int(n));
          return TRUE;
        }
      }
      for (uint n = 0; n < psp->n_properties; ++n) {
        if (psp->properties[n].name == prop) {
          desc->flags = JS_PROP_C_W_E;
          desc->getter = psp->properties[n].getter
                  ? JS_NewCFunction2(ctx, (JSCFunction *)asset_getter_magic, "asset::getter", 0, JS_CFUNC_getter_magic, int(n))
                  : JS_UNDEFINED;
          desc->setter = psp->properties[n].setter
                  ? JS_NewCFunction2(ctx, (JSCFunction *)asset_setter_magic, "asset::setter", 0, JS_CFUNC_setter_magic, int(n))
                  : JS_UNDEFINED;
          desc->value = JS_UNDEFINED;
          return TRUE;
        }
      }
    }
    return FALSE;
  }
#endif

  int asset_has_property(JSContext *ctx, JSValueConst obj, JSAtom atom)
  {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, obj);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      for (uint n = 0; n < psp->n_methods; ++n)
        if (psp->methods[n].name == atom)
          return TRUE;
      for (uint n = 0; n < psp->n_properties; ++n)
        if (psp->properties[n].name == atom)
          return TRUE;
    }
    return FALSE;
  }

  JSValue asset_get_property(JSContext *ctx, JSValueConst obj, JSAtom atom, JSValueConst receiver)
  {
    static JSAtom _Symbol_iterator = 0;
    static JSAtom _next = 0;

    auto Symbol_iterator = [&]() -> JSAtom {
      if (!_Symbol_iterator)
        _Symbol_iterator = JS_NewAtom(ctx, "[Symbol.iterator]");
      return _Symbol_iterator;
    };
    auto Symbol_next = [&]() -> JSAtom {
      if (!_next)
        _next = JS_NewAtom(ctx, "next");
      return _next;
    };

    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, obj);
    if (auto psp = sciter::om::asset_get_passport(pass))
    {
      if (psp->item_next)
      {
        if(atom == Symbol_iterator())
          return JS_DupValue(ctx, obj); // ??
        if(atom == Symbol_next())
          return JS_NewCFunction(ctx, (JSCFunction *)asset_method_next, "asset::next", 0);
      }

      for (uint n = 0; n < psp->n_methods; ++n) {
        auto& md = psp->methods[n];
        if (md.name == atom)
          return JS_NewCFunction2(ctx, (JSCFunction *)asset_method_magic, "asset::method", md.params, JS_CFUNC_generic_magic, int(n));
      }
      for (uint n = 0; n < psp->n_properties; ++n) {
        auto& pd = psp->properties[n];
        if (pd.name == atom) {
          if (pd.getter) {
            tool::value val;
            if (pd.getter(pass, &val))
              return conv<tool::value>::wrap(ctx, val);
          }
          break;
        }
      }
      if (psp->item_getter) {

        tool::value k;
        uint32 idx;
        if (JS_AtomIsArrayIndex(ctx, &idx, atom))
          k = value(int(idx));
        else {
          atom_chars ac(ctx, atom);
          k = value(ac);
        }
        tool::value val;
        if (psp->item_getter(pass, &k, &val))
          return conv<tool::value>::wrap(ctx, val);
      }
    }
    return JS_UNDEFINED;
  }

  /* return < 0 if exception or TRUE/FALSE */
  int asset_set_property(JSContext *ctx, JSValueConst obj, JSAtom atom, JSValueConst value, JSValueConst receiver, int flags)
  {
    som_asset_t* pass = conv<som_asset_t*>::unwrap(ctx, obj);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      for (uint n = 0; n < psp->n_methods; ++n) {
        auto& md = psp->methods[n];
        if (md.name == atom)
          return -1;
      }
      for (uint n = 0; n < psp->n_properties; ++n) {
        auto& pd = psp->properties[n];
        if (pd.name == atom) {
          if (pd.setter) {
            tool::value val = conv<tool::value>::unwrap(ctx, value);
            return pd.setter(pass, &val);
          }
          return -1;
        }
      }
      if (psp->item_setter) {
        hvalue key = JS_AtomToValue(ctx, atom);
        tool::value k = conv<tool::value>::unwrap(ctx, key);
        tool::value val = conv<tool::value>::unwrap(ctx, value);
        return psp->item_setter(pass, &k, &val);
      }
    }
    return -1;
  }

  JSClassExoticMethods Asset_exotic_methods =
  {
    NULL, //&asset_get_own_property, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    /* return < 0 if exception, or TRUE/FALSE */
    NULL, // &element_delete_property,
    NULL, // int(*define_own_property)(JSContext *ctx, JSValueConst this_obj, JSAtom prop, JSValueConst val, JSValueConst getter, JSValueConst setter, int flags);
    &asset_has_property,
    &asset_get_property,
    &asset_set_property
  };

  JSValue wrap_asset(JSContext* ctx, som_asset_t* pass)
  {
    JSValue obj = JS_NewObjectClass(ctx, Asset_class_id);
    sciter::om::asset_add_ref(pass);
    JS_SetOpaque(obj, pass);
#if 0
    //TODO: the class declaration shall be cached probably...
    if (auto psp = sciter::om::asset_get_passport(pass))
    {

      array<JSCFunctionListEntry> defs;
      array<string> names;
      for (uint n = 0; n < psp->n_methods; ++n) {
        tool::string name = symbol_name_a(psp->methods[n].name);
        names.push(name);
        defs.push(func_def_magic(name, asset_method_magic, int(n)));
      }
      for (uint n = 0; n < psp->n_properties; ++n) {
        tool::string name = symbol_name_a(psp->properties[n].name);
        names.push(name);
        defs.push(prop_def_magic(name, asset_getter_magic, asset_setter_magic, int(n)));
      }
      JS_SetPropertyFunctionList(ctx, obj, defs.cbegin(), defs.size());
    }
#endif
    return obj;
  }

  string    asset_def(xcontext& c, JSValue obj) { 
    som_asset_t* pass = conv<som_asset_t*>::unwrap(c, obj);
    if (auto psp = sciter::om::asset_get_passport(pass)) {
      hvalue s = JS_AtomToString(c, psp->name);
      return c.get<string>(s);
    }
    return CHARS("Asset");
  }
  
  JSOM_PASSPORT_BEGIN(Asset_def, xcontext)
    //JSOM_CONST_STR("[Symbol.toStringTag]", "Asset(native)", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("[Symbol.toStringTag]", asset_def),
  JSOM_PASSPORT_END

  void init_Asset_class(context& c)
  {
    JS_NewClassID(&Asset_class_id);

    static JSClassDef Asset_class = {
      "Asset",
      [](JSRuntime *rt, JSValue val)
      {
        som_asset_t* pass = object_of<som_asset_t>(val);
        sciter::om::asset_release(pass);
      },
      NULL,
      NULL,
      &Asset_exotic_methods
    };

    JS_NewClass(JS_GetRuntime(c), Asset_class_id, &Asset_class);
    JSValue asset_proto = JS_NewObject(c);

    auto list = Asset_def();
    JS_SetPropertyFunctionList(c, asset_proto, list.start, list.length);
    
    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
#if 1
      return JS_EXCEPTION;
#else
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Asset_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      //JS_SetOpaque(obj, s);
      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
#endif
    };

    hvalue asset_class = JS_NewCFunction2(c, ctor, "Asset", 2, JS_CFUNC_constructor, 0);

    // ???
    //JS_DefinePropertyValueStr(c, c.global(), "Asset", JS_DupValue(c, asset_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, asset_class, asset_proto);
    JS_SetClassProto(c, Asset_class_id, asset_proto);
  }


  hvalue load_native_library(xcontext& ctx, ustring dll_name) {

    tool::ustring filename = url::file_url_to_path(tool::get_home_dir(dll_name));
    tool::value val;

#ifdef WINDOWS
    if (!filename.like(W("*.dll")))
      filename = tool::ustring::format(W("%s.dll"), filename.c_str());
    HMODULE hmod = LoadLibraryEx(filename.c_str(), NULL, LOAD_WITH_ALTERED_SEARCH_PATH);
    if (!hmod) return false;
    if (SciterLibraryInitFunc *pentry = (SciterLibraryInitFunc *)GetProcAddress(hmod, "SciterLibraryInit"))
    {
      pentry(SciterAPI(), (SCITER_VALUE*)&val);
      if (val.is_defined())
        return conv<value>::wrap(ctx, val);
    }
    FreeLibrary(hmod);
#else
    if (!filename.like(W("*.so")) || !filename.like(W("*.dylib"))) {
#ifdef OSX
      filename = tool::ustring::format(W("%s.dylib"), filename.c_str());
#else
      filename = tool::ustring::format(W("%s.so"), filename.c_str());
#endif
    }
    void *hmod = dlopen(tool::string(filename.c_str()), RTLD_LAZY);
    if (!hmod) return false;
    /*if (TIScriptLibraryInitFunc *pentry =
      (TIScriptLibraryInitFunc *)dlsym(hmod, "TIScriptLibraryInit")) {
      pentry((tiscript_VM *)c, &native_interface);
      return true;
    }*/
    if (SciterLibraryInitFunc *pentry = (SciterLibraryInitFunc *)dlsym(hmod, "SciterLibraryInit"))
    {
      pentry(SciterAPI(), (SCITER_VALUE*)&val);
      if (val.is_defined())
        return conv<value>::wrap(ctx, val);
    }
    dlclose(hmod);
#endif
    return hvalue();

  }

  som_asset_t*    asset_ptr_of(JSContext * ctx, JSValueConst obj) {
    som_asset_t* pass = (som_asset_t*)JS_GetOpaque(obj, Asset_class_id);
    return pass;

  }


}
