#include "private.h"

static int tjs_init(JSContext *ctx, JSModuleDef *m) {
  tjs_mod_dns_init(ctx, m);
  tjs_mod_error_init(ctx, m);
  tjs_mod_fs_init(ctx, m);
  tjs_mod_misc_init(ctx, m);
  tjs_mod_process_init(ctx, m);
  tjs_mod_streams_init(ctx, m);
  tjs_mod_udp_init(ctx, m);
  return 0;
}

JSModuleDef *init_uv_module(JSContext *ctx, const char *name) {
  JSModuleDef *m;
  m = JS_NewCModule(ctx, name, tjs_init);
  if (!m)
    return NULL;
  tjs_mod_dns_export(ctx, m);
  tjs_mod_error_export(ctx, m);
  tjs_mod_fs_export(ctx, m);
  tjs_mod_misc_export(ctx, m);
  tjs_mod_process_export(ctx, m);
  tjs_mod_streams_export(ctx, m);
  tjs_mod_udp_export(ctx, m);
  return m;
}

int tjs__load_file(JSContext *ctx, DynBuf *dbuf, const char *filename) {
  uv_fs_t req;
  uv_file fd;
  int r;

  r = uv_fs_open(NULL, &req, filename, O_RDONLY, 0, NULL);
  uv_fs_req_cleanup(&req);
  if (r < 0)
    return r;

  fd = r;
  char buf[64 * 1024];
  uv_buf_t b = uv_buf_init(buf, sizeof(buf));
  size_t offset = 0;

  do {
    r = uv_fs_read(NULL, &req, fd, &b, 1, offset, NULL);
    uv_fs_req_cleanup(&req);
    if (r <= 0)
      break;
    offset += r;
    r = dbuf_put(dbuf, (const uint8_t *)b.base, r);
    if (r != 0)
      break;
  } while (1);

  uv_fs_close(NULL, &req, fd, NULL);

  return r;
}

