#include "xsciter.h"
#include "xgraphics.h"

namespace tis {
  // using namespace tis;
  // using namespace html;

  static html::element *this_element_ptr(xvm *c, value obj) {
    assert(CsGetDispatch(obj) == c->elementInterfaces[STYLE_IFACE]);
    if (CsGetDispatch(obj) != c->elementInterfaces[STYLE_IFACE]) return 0;

    html::node *n = static_cast<html::node *>(CsCObjectValue(obj));
    assert(n && n->is_element());
    return n->cast<html::element>();
    // html::element* b = static_cast<html::element*>(CsCObjectValue(obj));
    // assert(b);
    // return b;
  }

  value style_to_object(VM *c, const html::style *st) {
    struct propdefs : public html::style::property_callback {
      pvalue map;
      propdefs(VM *c) { map.pin(c, CsMakeObject(c, UNDEFINED_VALUE)); }
      virtual void on_prop(const tool::string &name, const tool::value &val) {
        tis::value t = tis::value_to_value(map.pvm, val);
        CsSetObjectProperty(
            map.pvm, map.val,
            CsSymbolOf(name == CHARS("prototype") ? "@prototype" : name.c_str()), t);
      }
    };
    propdefs ad(c);
    st->enum_properties(ad);
    return ad.map.val;
  }

  static value CSF_rules(xvm *c) {
    value obj;
    uint  states = 0;
    CsParseArguments(c, "V=*|i", &obj, c->elementInterfaces[STYLE_IFACE], &states);

    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    struct styledefs : public html::style_def::callback {
      pvalue res, def;
      styledefs(xvm *c) : res(c), def(c) { res = CsMakeVector(c, 0); }

      virtual void has_rule(const html::style_def *r) {
        def    = CsMakeObject(def.pvm, UNDEFINED_VALUE);
        int sz = CsVectorSize(def.pvm, res);
        res    = CsResizeVector(def.pvm, res, sz + 1);
        CsSetVectorElement(def.pvm, res, sz, def);
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("type"),
                            CsSymbolOf("style-rule"));
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("selector"),
                            CsMakeString(def.pvm, trim(r->selector_text())));
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("file"),
                            CsMakeString(def.pvm, r->src_url));
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("lineNo"),
                            CsMakeInteger(r->src_line_no));
#pragma TODO("CSS:style_to_object")
        //CsSetObjectProperty(def.pvm, def, CsSymbolOf("attributes"),
        //                    style_to_object(def.pvm, r->pstyle));
      }

      virtual void has_inline_style(const ustring &    styletext,
                                    const html::style *s) {
        def    = CsMakeObject(def.pvm, UNDEFINED_VALUE);
        int sz = CsVectorSize(def.pvm, res);
        res    = CsResizeVector(def.pvm, res, sz + 1);
        CsSetVectorElement(def.pvm, res, sz, def);
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("type"),
                            CsSymbolOf("inline-style"));
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("text"),
                            CsMakeString(def.pvm, styletext));
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("attributes"),
                            style_to_object(def.pvm, s));
      }

      virtual void has_a_style(const html::style *s) {
        def    = CsMakeObject(def.pvm, UNDEFINED_VALUE);
        int sz = CsVectorSize(def.pvm, res);
        res    = CsResizeVector(def.pvm, res, sz + 1);
        CsSetVectorElement(def.pvm, res, sz, def);
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("type"),
                            CsSymbolOf("runtime-style"));
        CsSetObjectProperty(def.pvm, def, CsSymbolOf("attributes"),
                            style_to_object(def.pvm, s));
      }
    };

    styledefs sd(c);

    self->get_applied_styles(*pv, sd);
    return sd.res;
  }

  static value CSF_all(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementInterfaces[STYLE_IFACE]);

    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return style_to_object(c, self->get_style());
  }

  // all CSS rules defined by the doc and dependent style sheets
  static value CSF_documentRules(xvm *c) {
    value obj;
    value callback = 0;
    value filter   = 0;
    CsParseArguments(c, "V=*V|V", &obj, c->elementInterfaces[STYLE_IFACE], &callback, &filter);

    if (CsObjectP(callback)) {
      filter   = callback;
      callback = 0;
    }

    handle<html::element> self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    handle<html::document> pdoc = self->doc();
    if (!pdoc) return UNDEFINED_VALUE;

    // if()
    int_t counter        = 0;
    int_t change_counter = 0;

    ustring filter_file;
    ustring filter_selector;
    int_v   filter_line_no;
    value   update_callback = 0;
    if (filter && CsObjectP(filter)) {
      CsGetProperty(c, filter, "properties", update_callback,
                    &CsMethodDispatch);
      CsGetProperty(c, filter, "file", filter_file);
      CsGetProperty(c, filter, "selector", filter_selector);
      CsGetProperty(c, filter, "lineNo", filter_line_no._v);
    }

    string filter_url = filter_file;

    value p_style = 0;

    PROTECT(callback, update_callback, p_style);

    value p_file = 0, p_selector = 0, p_lineNo = 0, p_usageCounter = 0;

    PROTECT(p_file, p_selector, p_lineNo, p_usageCounter);

    auto rules = pdoc->styles().rules();
    for (size_t n = 0; n < rules.length; ++n) {
      const html::style_def *r        = rules[n];
      wchars                 selector = trim(r->selector_text());
      if (filter_selector.is_defined()) {
        if (filter_selector != selector)
          continue;
      }
      if (filter_url.is_defined()) {
        if (filter_url != r->src_url) continue;
      }
      if (filter_line_no.is_defined()) {
        if (filter_line_no != r->src_line_no) continue;
      }

      if (callback && CsMethodP(callback)) {
        p_file         = CsMakeString(c, r->src_url);
        p_selector     = CsMakeString(c, selector);
        p_lineNo       = CsMakeInteger(r->src_line_no);
        p_usageCounter = CsMakeInteger(r->usage_counter);

        value rv = CsCallFunction(CsCurrentScope(c), callback, 4, p_selector,
                                  p_file, p_lineNo, p_usageCounter);
        if (rv == FALSE_VALUE) break;
      }

      if (update_callback && CsMethodP(update_callback)) {
        p_style = value_to_value(c,r->plist->definition_list());

        value rstyle = CsCallFunction(CsCurrentScope(c), update_callback, 1, p_style);
        if (CsObjectP(rstyle)) {
          //tool::array<tool::named_value> nv_list;
          each_property gen(c, rstyle);
          for (value tag, val; gen(tag, val);) {
            if (!CsStringP(tag) && !CsSymbolP(tag))
              CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,"string or symbol as an attribute name");
            string name  = value_to_string(tag);
            if (CsStringP(val))
              html::parse_css_property_as(pdoc, name, CsStringChars(val), r->plist);
            else {
              tool::value tval = value_to_value(c, val,true);
              r->plist->set(name, tval);
            }
            ++change_counter;
          }
        }
      }
      ++counter;
    }
    if (change_counter) {
      html::view *pv = pdoc->pview();
      if (pv) {
        pdoc->refresh(*pv);
        pdoc->drop_cache();
        pdoc->drop_styles(*pv);
      }
    }
    // return style_to_object(c, self->get_style());
    return CsIntegerValue(counter);
  }

  static value CSF_clear(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementInterfaces[STYLE_IFACE]);

    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    self->remove_style_attributes();

    return obj; // allows to chain the call
  }

  bool CsSetElementStyles(xvm *c, html::helement self, value def)
  {
    html::document *pd = self->doc();
    if (!pd) return false;

    //tool::array<tool::named_value> nv_list;
    html::style_prop_list pl;

    each_property gen(c, def);
    for (value tag, val; gen(tag, val);) {
      if (!CsStringP(tag) && !CsSymbolP(tag))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, tag, "string or symbol as an attribute name");
      string pname = value_to_string(tag);
      if (CsStringP(val))
        html::parse_css_property_as(pd, pname, CsStringChars(val), &pl);
      else {
        tool::value vv = value_to_value(c, val, true);
        pl.set(pname, vv);
      }
    }
    self->set_style_attributes(pl);
    return true; // allows to chain the call
  }

  static value CSF_set(xvm *c) {
    value obj;
    value def;
    CsParseArguments(c, "V=*V=", &obj, c->elementInterfaces[STYLE_IFACE], &def,&CsObjectDispatch);

    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    CsSetElementStyles(c, self, def);
    return obj; // allows to chain the call

  }

  static value CSF_cursor(xvm *c) {
    value       obj;
    value       img = NULL_VALUE;
    gool::point hotspot;
    CsParseArguments(c, "V=*V|ii", &obj, c->elementInterfaces[STYLE_IFACE],
                     &img, &hotspot.x, &hotspot.y);

    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    handle<gool::image> xim;

    if (img == NULL_VALUE) goto DROP;

    xim = image_ptr(c, img);

    if (xim && xim->is_bitmap()) {
      if (!self->a_style) self->a_style = new html::style_prop_map();
      handle<gool::cursor> cur = gool::cursor::from_bitmap(xim.ptr_of<gool::bitmap>(), xim->get_url(), hotspot);
      if(cur) {
        tool::value cv = tool::value::make_resource(cur);
        self->a_style->set(html::cssa_cursor, cv);
        self->drop_style();
      }
    } else {
    DROP:
      if (self->a_style) {
        self->a_style->set(html::cssa_cursor, tool::value());
        self->drop_style();
      }
    }

    html::view* pv = self->pview();
    if(pv) pv->check_mouse(true);

    return obj; // allows to chain the call
  }

  // static value CSF_morph(xvm *c)
  //{
  //  value obj;
  //  value from, to;
  //  float ratio;
  //  CsParseArguments(c,"**V=V=f",&obj,c->elementInterfaces[STYLE_IFACE],
  //  &from, &CsObjectDispatch, &to, &CsObjectDispatch,&ratio);

  //  html::element* self = this_element_ptr(c,obj);
  //  if( !self )
  //    return UNDEFINED_VALUE;

  //  tool::array< tool::named_value > nv_list_from;
  //  tool::array< tool::named_value > nv_list_to;

  //  //html

  //  html::hstyle from_style = new style();
  //  html::hstyle to_style = new style();

  //  each_property gen_from(c,from);
  //  for(value tag, val; gen_from(tag, val);)
  //  {
  //    if( !CsStringP(tag) && !CsSymbolP(tag) )
  //      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag, "string or symbol
  //      as an attribute name");

  //    tool::named_value nv;
  //    nv.name = value_to_string(tag);
  //    nv.value = value_to_value(c,val);
  //    nv_list_from.push(nv);
  //  }
  //  each_property gen_to(c,to);
  //  for(value tag, val; gen_to(tag, val);)
  //  {
  //    if( !CsStringP(tag) && !CsSymbolP(tag) )
  //      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag, "string or symbol
  //      as an attribute name");

  //    tool::named_value nv;
  //    nv.name = value_to_string(tag);
  //    nv.value = value_to_value(c,val);
  //    nv_list_to.push(nv);
  //  }
  //
  //  self->set_style_attributes(nv_list_from(), from_style);
  //  self->set_style_attributes(nv_list_from(), to_style);
  //  return obj; // allows to chain the call
  //}

  static value CSF_dimension(xvm *c) {
    value obj;
    value width = NULL_VALUE, height = NULL_VALUE;
    bool  delayed = false;
    CsParseArguments(c, "V=*VV|B", &obj, c->elementInterfaces[STYLE_IFACE],
                     &width, &height, &delayed);
    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::document *pd = self->doc();
    if (!pd) return UNDEFINED_VALUE;
    html::view *pv = pd->pview();
    if (!pv) return UNDEFINED_VALUE;
    tool::value val;
    if (!self->a_style) self->a_style = new html::style_prop_map();

    if (CsLengthP(width)) {
      val = value_to_value(c, width);
      //html::set_attribute_value(pd, *self->a_style, html::cssa_width, val);
      self->a_style->set(html::cssa_width, val);
    }
    if (CsLengthP(height)) {
      val = value_to_value(c, height);
      //html::set_attribute_value(pd, *self->a_style, html::cssa_height, val);
      self->a_style->set(html::cssa_height, val);
    }

    /*if( delayed && self->ui_parent)
    {
      self->request_delayed_measure(*pv);
      gool::size d = self->ui_parent->dim;
      self->ui_parent->drop_measured_layout();
      self->ui_parent->measure_width(*pv);
      self->ui_parent->update_height(*pv,d.y);
      self->ui_parent->refresh(*pv);
    }
    else*/
    pv->add_to_update(self, true);

    return TRUE_VALUE;
  }

  static value CSF_getStyleConst(xvm *c) {
    value obj, vconst;

    CsParseArguments(c, "V=*V", &obj, c->elementInterfaces[STYLE_IFACE],
                     &vconst);
    string sconst = value_to_string(vconst);

    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    tool::value cv = self->get_style_const(*pv, sconst);

    if (cv.is_undefined()) return UNDEFINED_VALUE;

    return value_to_value(c, cv);
  }

  value style_value_to_value(VM* c, html::element* self, tool::value tv)
  {
    if (tv.is_color())
    {
      gool::color_v c1 = gool::color_v(tv);
      gool::color_v c2 = c1.to_argb();
      tv = c2.to_value();
    }
    else if (tv.is_length())
    {
      html::size_v c1 = html::size_v(tv);
      tv = c1.to_value();
    }
    return value_to_value(c, tv);
  }

  static value CSF_styleVariables(xvm *c) {
    value obj, toset = 0;

    CsParseArguments(c, "V=*|V=", &obj, c->elementInterfaces[STYLE_IFACE],
                     &toset, &CsObjectDispatch);

    html::helement self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (toset) {
      tool::dictionary<tool::string,tool::value> vars;
      html::view *             pv = self->pview();
      if (!pv) return UNDEFINED_VALUE;

      each_property gen(c, toset);
      for (value tag, val; gen(tag, val);) {
        if (!CsStringP(tag) && !CsSymbolP(tag))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                            "string or symbol as an attribute name");
        tool::string n = value_to_string(tag);
        tool::value  v = value_to_value(c, val);
        vars[n] = v;
      }
      self->set_style_variables(*pv, vars);
      return UNDEFINED_VALUE;

    } else {
      value retval = 0;
      PROTECT(obj, retval);
      retval  = CsMakeObject(c, c->objectObject);
      for (auto& pair : self->get_style()->vars.items)
      {
        value nm = CsMakeString(c, html::attr::symbol_name(pair.att_sym));
        CsSetProperty1(c, retval, nm, style_value_to_value(c, self, pair.att_value));
      }
      for (auto& pair : self->vars.items) {
        value nm = CsMakeString(c, html::attr::symbol_name(pair.att_sym));
        CsSetProperty1(c, retval, nm , style_value_to_value(c, self, pair.att_value));
      }
      return retval;
    }
  }

  static value CSF_styleVariable(xvm *c) {
    value  obj, toset = 0;
    wchars varname;

    CsParseArguments(c, "V=*S#|V", &obj, c->elementInterfaces[STYLE_IFACE],
                     &varname.start, &varname.length, &toset);

    html::helement self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (toset) {
      html::attribute_bag_vref vars;
      html::view *             pv = self->pview();
      if (!pv) return UNDEFINED_VALUE;
      tool::value val = value_to_value(c, toset);
      self->set_style_variable(*pv, tool::string(varname), val);
      return UNDEFINED_VALUE;
    } else {
      value retval = 0;
      PROTECT(obj, retval);
      tool::value val;
      if (!self->get_var(html::element_context(self),tool::string(varname), val))
        return UNDEFINED_VALUE;
      return style_value_to_value(c, self, val);
    }
  }

  static value CSF_backgroundImage(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    gool::image *img = self->get_back_image(*pv);
    if (img)
      return image_object(c, img);
    return NULL_VALUE;
  }

  static value CSF_foregroundImage(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    gool::image *img = self->get_fore_image(*pv);
    if (img)
      return image_object(c, img);
    return NULL_VALUE;
  }

  static value CSF_backgroundImageWidth(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    gool::image *img = self->get_back_image(*pv);
    if (img) return CsMakeInteger(img->dim().x);
    return UNDEFINED_VALUE;
  }
  static value CSF_backgroundImageHeight(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    gool::image *img = self->get_back_image(*pv);
    if (img) return CsMakeInteger(img->dim().y);
    return UNDEFINED_VALUE;
  }

  static value CSF_foregroundImageWidth(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    gool::image *img = self->get_fore_image(*pv);
    if (img) return CsMakeInteger(img->dim().x);
    return UNDEFINED_VALUE;
  }
  static value CSF_foregroundImageHeight(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    gool::image *img = self->get_fore_image(*pv);
    if (img) return CsMakeInteger(img->dim().y);
    return UNDEFINED_VALUE;
  }

  static value CSF_BFC(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;
    html::element* bfc = self->floats_parent(*pv);
    return bfc ? element_object(c,bfc) : NULL_VALUE;
  }

  static value CSF_isDormant(xvm *c, value obj) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    const html::style* ps = pv ? self->get_style(*pv) : self->get_style();
    return ps->is_display_none() ? TRUE_VALUE : FALSE_VALUE;
  }

  /* element methods */
  static c_method methods[] = {
      C_METHOD_ENTRY_X("clear", CSF_clear), C_METHOD_ENTRY_X("set", CSF_set),
      // C_METHOD_ENTRY_X( "isDefined",        CSF_isDefined  ),
      C_METHOD_ENTRY_X("rules", CSF_rules), C_METHOD_ENTRY_X("all", CSF_all),
      C_METHOD_ENTRY_X("constant", CSF_getStyleConst),
      C_METHOD_ENTRY_X("variables", CSF_styleVariables),
      C_METHOD_ENTRY_X("variable", CSF_styleVariable),
      C_METHOD_ENTRY_X("dimension", CSF_dimension),
      C_METHOD_ENTRY_X("documentRules", CSF_documentRules),
      C_METHOD_ENTRY_X("cursor", CSF_cursor),

      //C_METHOD_ENTRY_X("resolve", CSF_resolve),

      // C_METHOD_ENTRY_X( "morph",              CSF_morph ),

      C_METHOD_ENTRY_X(0, 0)};

  /* String properties */
  static vp_method properties[] = {
      VP_METHOD_ENTRY_X("backgroundImage", CSF_backgroundImage, 0),
      VP_METHOD_ENTRY_X("backgroundImageWidth", CSF_backgroundImageWidth, 0),
      VP_METHOD_ENTRY_X("backgroundImageHeight", CSF_backgroundImageHeight, 0),
      VP_METHOD_ENTRY_X("foregroundImage", CSF_foregroundImage, 0),
      VP_METHOD_ENTRY_X("foregroundImageWidth", CSF_foregroundImageWidth, 0),
      VP_METHOD_ENTRY_X("foregroundImageHeight", CSF_foregroundImageHeight, 0),
      VP_METHOD_ENTRY_X("blockFormattingContext", CSF_BFC, 0),
      VP_METHOD_ENTRY_X("isDormant", CSF_isDormant, 0),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  void destroy_styles(xvm *c, value obj) { ; }

  extern long ElementSize(value obj);
  extern void ElementScan(VM *c, value obj);
  // extern value ElementCopy(VM *c,value obj);
  extern int_t ElementHash(value obj);

  /* GetElementProperty - mimics GetObjectProperty */
  static bool GetProperty(xvm *c, value &obj, value tag, value *pValue) {
    value     p;
    dispatch *d = c->elementInterfaces[STYLE_IFACE];
    if ((p = CsFindProperty(c, d->obj, tag, nullptr, nullptr)) != NIL_VALUE) {
      value propValue = CsPropertyValue(p);
      if (CsVPMethodP(propValue)) {
        vp_method *method = ptr<vp_method>(propValue);
        if (method->get(c, obj, *pValue))
          return true;
        else
          CsThrowKnownError(c, CsErrReadOnlyProperty, tag);
      } else {
        *pValue = propValue;
        return true;
      }
    }
    return false;
  }

  /* SetElementProperty - mimics SetObjectProperty  */
  static bool SetProperty(xvm *c, value obj, value tag, value val) {
    return false;
    // return CsSetCObjectProperty(c,obj,tag,val);
  }

  static value GetItem(xvm *c, value obj, value tag) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    if (CsStringP(tag) || CsSymbolP(tag)) {
      string      s = value_to_string(tag);
      tool::value v = self->get_style()->to_value(s);
      return value_to_value(c, v);
      // return string_to_value(c,self->get_style()->string_value( s ));
    }
    else {
      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
        "string or symbol as an attribute name");
      return UNDEFINED_VALUE;
    }
  }
  static void SetItem(xvm *c, value obj, value tag, value val) {
    html::element *self = this_element_ptr(c, obj);
    if (!self) return;

    html::document *pd = self->doc();
    if (!pd) return;

    if (CsStringP(tag) || CsSymbolP(tag)) {
      string pname = value_to_string(tag);
      html::style_prop_list pl;
      if (CsStringP(val))
        html::parse_css_property_as(pd, pname, CsStringChars(val), &pl);
      else {
        tool::value vv = value_to_value(c, val, true);
        pl.set(pname, vv);
      }
      self->set_style_attributes(pl);
      //--- tool::value v = value_to_value(c, value, true);
      //--- self->set_style_attribute(s, v);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                        "string or symbol as an attribute name");
  }

  void xvm::init_element_styles_class() {
    dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Styles", methods, properties);

    /* create the 'Styles' type */
    if (!pd) CsInsufficientMemory(this);

    /* setup alternate handlers */

    pd->getProperty = (get_property_t)GetProperty;
    pd->setProperty = (set_property_t)SetProperty;

    pd->scan = ElementScan;
    pd->hash = ElementHash;

    pd->getItem = (get_item_t)GetItem;
    pd->setItem = (set_item_t)SetItem;

    pd->baseType = &CsCObjectDispatch;

    pd->destroy = (destructor_t)destroy_styles;

    elementInterfaces[STYLE_IFACE] = pd;
  }

} // namespace tis
