#include "xsciter.h"
#include "xview.h"

namespace tis {

  html::bookmark value2bookmark(xvm *c, value obm) {
    if (obm) do {
        html::bookmark r;
        if (!CsTupleP(obm)) break;
        if (CsTupleName(obm) != CsSymbolOf("bookmark")) break;
        if (CsTupleSize(obm) != 3) break;
        handle<html::node> node = node_ptr(c, CsTupleElement(obm, 0));
        if (!node) break;
        if (!CsIntegerP(CsTupleElement(obm, 1))) break;
        int pos = CsIntegerValue(CsTupleElement(obm, 1));
        if (!CsBooleanP(CsTupleElement(obm, 2))) break;
        bool after = CsTrueP(CsTupleElement(obm, 2));
        return html::bookmark(node, pos, after);
      } while (0);
    return html::bookmark();
  }

  value bookmark2value(xvm *c, html::bookmark bm) {
    if (!bm.valid()) return NULL_VALUE;
    return CsMakeTuple(c, "bookmark", node_object(c, bm.node),
                       int_value(bm.pos),
                       bm.after_it ? TRUE_VALUE : FALSE_VALUE);
  }

  html::behavior::transact_ctx *transact_ctx(xvm *c, value obj) {
    dispatch *pd = CsQuickGetDispatch(obj);
    if (pd != c->transactDispatch /*&& pd != c->richtextDispatch*/)
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj,
                        "RichtextTransaction");
    html::behavior::transact_ctx *n =
        static_cast<html::behavior::transact_ctx *>(CsCObjectValue(obj));
    if (!n || !n->active())
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj,
                        "passive Richtext transaction object");
    return n;
  }

  static value CSF_tran_attr(xvm *c) {
    value  obj = 0, el = 0, val = 0;
    wchars aname;
    CsParseArguments(c, "V=*V=S#V", &obj, c->transactDispatch, &el,
                     c->elementDispatch, &aname.start, &aname.length, &val);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    if (val == UNDEFINED_VALUE)
      tctx->remove_attr(element_ptr(c, el), aname);
    else if (CsStringP(val))
      tctx->set_attr(element_ptr(c, el), aname, value_to_string(val));
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, val, "String");
    return obj;
  }
  static value CSF_tran_tag(xvm *c) {
    value  obj = 0, el = 0;
    wchars tname;
    CsParseArguments(c, "V=*V=S#", &obj, c->transactDispatch, &el,
                     c->elementDispatch, &tname.start, &tname.length);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    tctx->set_tag(element_ptr(c, el), tname);
    return obj;
  }
  static value CSF_tran_split(xvm *c) {
    value obj   = 0;
    value until = 0;
    value obm;
    CsParseArguments(c, "V=*V=V=", &obj, c->transactDispatch, &obm,
                     &CsTupleDispatch, &until, c->elementDispatch);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::helement                cont = element_ptr(c, until);
    html::bookmark                at   = value2bookmark(c, obm);
    if (tctx->split(at, cont)) return bookmark2value(c, at);
    return NULL_VALUE;
  }

  static value CSF_tran_wrap(xvm *c) {
    value obj  = 0;
    value elem = 0;
    value obmfrom = 0, obmto = 0;
    CsParseArguments(c, "V=*V=V=V=", &obj, c->transactDispatch, &obmfrom,
                     &CsTupleDispatch, &obmto, &CsTupleDispatch, &elem,
                     c->elementDispatch);
    html::behavior::transact_ctx *tctx   = transact_ctx(c, obj);
    html::bookmark                bmfrom = value2bookmark(c, obmfrom);
    html::bookmark                bmto   = value2bookmark(c, obmto);
    html::helement                cont   = element_ptr(c, elem);
    if (tctx->wrap(bmfrom, bmto, cont)) {
      obmfrom = bookmark2value(c, bmfrom);
      PROTECT(obmfrom);
      obmto = bookmark2value(c, bmto);
      CS_RETURN2(c, obmfrom, obmto);
    }
    return NULL_VALUE;
  }

  static value CSF_tran_unwrap(xvm *c) { 
    value obj = 0;
    value elem = 0;
    CsParseArguments(c, "V=*V=", &obj, c->transactDispatch, &elem,c->elementDispatch);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::helement                cont = element_ptr(c, elem);
    auto selection = tctx->unwrap(cont);
    value obmfrom = bookmark2value(c, selection.first);
    PROTECT(obmfrom);
    value obmto = bookmark2value(c, selection.second);
    CS_RETURN2(c, obmfrom, obmto);
  }

  static value CSF_tran_insert_node(xvm *c) { 
    value obj = 0;
    value vwhat = 0;
    value vwhere = 0;
    CsParseArguments(c, "V=*V=V=", &obj, c->transactDispatch, 
      &vwhere, &CsTupleDispatch, &vwhat, c->nodeDispatch);

    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);

    html::hnode    what = node_ptr(c, vwhat);
    html::bookmark where = value2bookmark(c, vwhere);

    if (where.valid() && what.is_defined()) {
      if (tctx->insert_node(where, what))
        return obj;
    }
    CsThrowKnownError(c, CsErrUnexpectedTypeError, vwhat, "failed to insert");
    return NULL_VALUE;
  }
  static value CSF_tran_remove_node(xvm *c) { 
    value  obj = 0;
    value  nod = 0;
    CsParseArguments(c, "V=*V", &obj, c->transactDispatch, &nod);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::node *pn = node_ptr(c, nod);
    if(!pn)
      CsThrowKnownError(c, CsErrUnexpectedTypeError, nod, "is not a DOM node or element");
    tctx->delete_node(pn);
    return TRUE_VALUE;
  }

  static value CSF_tran_insert_html(xvm *c) {
    value  obj = 0;
    value  obm = 0;
    wchars html;
    wchars url;
    CsParseArguments(c, "V=*V=S#", &obj, c->transactDispatch, &obm,
                     &CsTupleDispatch, &html.start, &html.length);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::bookmark at   = value2bookmark(c, obm);
    array<byte>    utf8;
    u8::from_utf16(html, utf8);
    slice<html::hnode> nodes = tctx->insert_html(at, utf8());
    return node_list(c, nodes);
  }
  static value CSF_tran_insert_text(xvm *c) {
    value  obj = 0;
    value  obm = 0;
    wchars text;
    CsParseArguments(c, "V=*V=S#", &obj, c->transactDispatch, &obm,
                     &CsTupleDispatch, &text.start, &text.length);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::bookmark                at   = value2bookmark(c, obm);
    tctx->insert_text(at, text);
    return bookmark2value(c, at);
  }
  static value CSF_tran_set_text(xvm *c) {
    value  obj  = 0;
    value  node = 0;
    wchars text;
    CsParseArguments(c, "V=*VS#", &obj, c->transactDispatch, &node, &text.start, &text.length);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::hnode                   pn = node_ptr(c, node);
    if (!pn)
      CsThrowKnownError(c, CsErrUnexpectedTypeError, node, "is not a DOM node or element");
    tctx->set_text(pn, text);
    return bookmark2value(c, pn->end_caret_pos(*tctx->pv));
  }

  static value CSF_tran_remove(xvm *c) {
    value obj   = 0;
    value vfrom = 0;
    value vto   = 0;
    CsParseArguments(c, "V=*|V=V=", &obj, c->transactDispatch, &vfrom,
                     &CsTupleDispatch, &vto, &CsTupleDispatch);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);
    html::bookmark                from; if(vfrom) from = value2bookmark(c, vfrom);
    html::bookmark                to; if (vto) to = value2bookmark(c, vto);
    html::bookmark                r;
    if (from.valid() && to.valid())
      r = tctx->delete_range(from, to);
    else
      r = tctx->delete_selection();
    return bookmark2value(c, r);
  }

  static value CSF_tran_execCommand(xvm *c) {
    value  obj   = 0;
    value  param = UNDEFINED_VALUE;
    wchars cmd;
    CsParseArguments(c, "V=*S#|V", &obj, c->transactDispatch, &cmd.start,
                     &cmd.length, &param);

    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);

    if (!cmd.length) return UNDEFINED_VALUE;

    bool r = html::exec_command(*tctx->pv.ptr(), tctx->rt, tctx->rt, cmd,
                                value_to_value(c, param));
    return r ? TRUE_VALUE : FALSE_VALUE;
  }

  value attributes_to_object(VM *c, const html::attribute_bag &ab) {

    value vab = CsMakeObject(c, UNDEFINED_VALUE);

    PROTECT(vab);
    for (int n = 0; n < ab.size(); ++n)
      CsSetObjectProperty(c, vab, CsSymbolOf(ab.name(n)()), CsMakeString(c, ab.value(n)()));

    return vab;
  }

  static value CSF_tran_merge(xvm *c) {
    value obj = 0;
    value owhat = 0, ocb = 0;
    CsParseArguments(c, "V=*V|V=", &obj, c->transactDispatch, &owhat, &ocb, &CsMethodDispatch);
    html::behavior::transact_ctx *tctx = transact_ctx(c, obj);

    array<byte> html;
    if (CsByteVectorP(owhat))
      html = CsByteVectorBytes(owhat);
    else if (CsStringP(owhat))
      html = u8::cvt(CsStringChars(owhat), true).chars_as_bytes();
    else 
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj, "string or bytes");

    bool r;
    if (ocb) {

      struct morph_callbacks : public html::behavior::richtext_ctl::morph_ctx 
      {
        typedef html::behavior::richtext_ctl::morph_ctx super;
        xvm *c = 0;
        value callback = 0;
        value obj = 0;

        morph_callbacks(html::view& v_, html::behavior::richtext_ctl* rt_, handle<html::behavior::action> op_) : super(v_, rt_, op_) {}

        virtual bool change_text(html::text* node, wchars to_text) override {
          TRY{
            static value sym = CsSymbolOf(WCHARS("change-text"));
            value vnode = 0;
            PROTECT(vnode, obj, callback);
            vnode = node_object(c, node);
            CsCallMethod(c, obj, callback, obj, 3, sym, vnode, CsMakeString(c,to_text));
          } CATCH_ERROR_NE{
            CsHandleUnhandledError(c);
          }
          return super::change_text(node, to_text);
        }
        virtual bool remove_node(html::node* old_node) override {
          TRY{
            static value sym = CsSymbolOf(WCHARS("remove-node"));
            value vnode = 0;
            PROTECT(vnode, obj, callback);
            vnode = node_object(c, old_node);
            CsCallMethod(c, obj, callback, obj, 2, sym, vnode);
          } CATCH_ERROR_NE{
            CsHandleUnhandledError(c);
          }
          return super::remove_node(old_node);
        }
        virtual bool insert_node(html::node* el, int index, html::node* node) override {
          TRY{
            static value sym = CsSymbolOf(WCHARS("insert-node"));
            value vnode = 0;
            value velement = 0;
            PROTECT(velement, vnode, obj, callback);
            vnode = node_object(c, node);
            velement = node_object(c, el);
            CsCallMethod(c, obj, callback, obj, 4, sym, velement, CsMakeInteger(index), vnode);
          } CATCH_ERROR_NE {
            CsHandleUnhandledError(c);
          }
          return super::insert_node(el, index, node);
        }
        virtual bool replace_node(html::node* old_node, html::node* by_node) override {
          TRY{
            static value sym = CsSymbolOf(WCHARS("replace-node"));
            value voldnode = 0;
            value vnewnode = 0;
            PROTECT(voldnode, vnewnode, obj, callback);
            voldnode = node_object(c, old_node);
            vnewnode = node_object(c, by_node);
            CsCallMethod(c, obj, callback, obj, 3, sym, voldnode, vnewnode);
          }
          CATCH_ERROR_NE{
            CsHandleUnhandledError(c);
          }
          return super::replace_node(old_node, by_node);
        }
        virtual bool update_atts(html::node* of, const html::attribute_bag& from) override {
          TRY{
            static value sym = CsSymbolOf(WCHARS("update-attributes"));
            value voldnode = 0;
            value vnewnode = 0;
            PROTECT(voldnode, vnewnode, obj, callback);
            voldnode = node_object(c, of);
            //vnewnode = node_object(c, from);
            //CsCallMethod(c, obj, callback, obj, 3, sym, voldnode, vnewnode);
            CsCallMethod(c, obj, callback, obj, 2, sym, voldnode);
          }
          CATCH_ERROR_NE{
            CsHandleUnhandledError(c);
          }
          return super::update_atts(of, from);
        }
      };

      morph_callbacks callbacks(*tctx->pv.ptr(),tctx->rt_ctl,tctx->act);
      callbacks.c = c;
      callbacks.obj = obj;
      callbacks.callback = ocb;

      /*PROTECT(obj, owhat, ocb);
      mut.on_attributes_changed = [&](html::element *el, const html::attribute_bag &oab, const html::attribute_bag &nab) {
        static value sym = CsSymbolOf(WCHARS("attributes"));
        TRY{
          value ooab = 0, onab = 0, vel = 0;
          PROTECT(ooab, onab, vel);
          ooab = attributes_to_object(c, oab);
          onab = attributes_to_object(c, nab);
          vel = element_object(c, el);
          CsCallMethod(c, obj, ocb, obj, 4, sym, vel, ooab, onab);
        }
        CATCH_ERROR_NE {
          CsHandleUnhandledError(c);
        }
      };

      mut.on_node_removed = [&](html::element *parent, html::node *pn, int index) {
        static value sym = CsSymbolOf(WCHARS("remove"));
        TRY{
          value vel = 0, vnode = 0;
          PROTECT(vel, vnode);
          vel = element_object(c, parent);
          vnode = node_object(c, pn);
          CsCallMethod(c, obj, ocb, obj, 4, sym, vel, vnode, CsMakeInteger(index));
        }
        CATCH_ERROR_NE{
          CsHandleUnhandledError(c);
        }
      };

      mut.on_node_added = [&](html::element *parent, html::node *pn, int index) {
        static value sym = CsSymbolOf(WCHARS("add"));
        TRY{
          value vel = 0, vnode = 0;
          PROTECT(vel, vnode);
          vel = element_object(c, parent);
          vnode = node_object(c, pn);
          CsCallMethod(c, obj, ocb, obj, 4, sym, vel, vnode, CsMakeInteger(index));
        }
        CATCH_ERROR_NE {
          CsHandleUnhandledError(c);
        }
      };

      mut.on_node_replaced = [&](html::element *parent, html::node *pon, html::node *pnn, int index) {
        static value sym = CsSymbolOf(WCHARS("replace"));
        TRY{
          value vel = 0, vnodeold = 0, vnodenew = 0;
          PROTECT(vel, vnodeold, vnodenew);
          vel = element_object(c, parent);
          vnodeold = node_object(c, pon);
          vnodenew = node_object(c, pnn);
          CsCallMethod(c, obj, ocb, obj, 5, sym, vel, vnodeold, vnodenew, CsMakeInteger(index));
        }
        CATCH_ERROR_NE {
          CsHandleUnhandledError(c);
        }
      };

      r = tctx->merge(html(), &mut);*/

      r = tctx->merge(html(), &callbacks);

    } else 
      r = tctx->merge(html());

    //if (tctx->merge(html,)) {
    //  obmfrom = bookmark2value(c, bmfrom);
    //}
    return NULL_VALUE;
  }


  // static value CSF_transact(xvm *c)

  static c_method transact_methods[] = {
      C_METHOD_ENTRY_X("attr", CSF_tran_attr),
      C_METHOD_ENTRY_X("tag", CSF_tran_tag),
      C_METHOD_ENTRY_X("split", CSF_tran_split),
      C_METHOD_ENTRY_X("wrap", CSF_tran_wrap),
      C_METHOD_ENTRY_X("unwrap", CSF_tran_unwrap),
      C_METHOD_ENTRY_X("insertNode", CSF_tran_insert_node),
      C_METHOD_ENTRY_X("removeNode", CSF_tran_remove_node),
      C_METHOD_ENTRY_X("insertHtml", CSF_tran_insert_html),
      C_METHOD_ENTRY_X("insertText", CSF_tran_insert_text),
      C_METHOD_ENTRY_X("text", CSF_tran_set_text),
      C_METHOD_ENTRY_X("removeRange", CSF_tran_remove),
      C_METHOD_ENTRY_X("execCommand", CSF_tran_execCommand),
      C_METHOD_ENTRY_X("merge", CSF_tran_merge),

      C_METHOD_ENTRY_X(0, 0)};

  /* Richtext properties */
  static vp_method transact_properties[] = {
      // VP_METHOD_ENTRY_X( "lastNode",            CSF_lastNode,         0),

      VP_METHOD_ENTRY_X(0, 0, 0)};

  static constant transact_constants[] = {CONSTANT_ENTRY_X(0, 0)};

  value CSF_richtext_transact(xvm *c) {
    value  obj    = 0;
    value  worker = 0, transaction = 0;
    wchars tname;
    CsParseArguments(c, "V=*m|S#", &obj, c->elementDispatch, &worker, &tname.start, &tname.length);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::behavior::transact_ctx tctx(self, tname);
    if (!tctx.active())
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj,
                        "object is not a richtext");

    PROTECT(obj, worker, transaction);

    value ret = TRUE_VALUE;
    // value

    transaction = CsMakeCPtrObject(c, c->transactDispatch, &tctx);
    try {
      // do changes
      if (CsCallMethod(c, self->obj, worker, self->obj, 1, transaction) !=
          FALSE_VALUE)
        tctx.commit();
      else {
        tctx.rollback();
        ret = FALSE_VALUE;
      }
    } catch (const tool::exception &) {
      tctx.rollback();
      ret = FALSE_VALUE;
    } catch (script_exception &) {
      tctx.rollback();
      CsHandleUnhandledError(c);
      ret = FALSE_VALUE;
    }

    CsSetCObjectValue(transaction, 0);

    return ret;
  }

  ///* Richtext methods */
  // static c_method methods[] = {
  //  C_METHOD_ENTRY_X( "transact",           CSF_transact  ),

  //  C_METHOD_ENTRY_X( 0,               0          )
  //};

  ///* Richtext properties */
  // static vp_method properties[] = {
  //  //VP_METHOD_ENTRY_X( "lastNode",            CSF_lastNode,         0),

  //  VP_METHOD_ENTRY_X( 0,                     0,                    0)
  //};

  // static constant constants[] =
  //{
  //  CONSTANT_ENTRY_X(0, 0)
  //};

  void xvm::init_richtext_class() {
    /* create the 'RichtextTransaction' type */

    transactDispatch =
        CsEnterCPtrObjectType(CsGlobalScope(this), "RichtextTransaction", transact_methods, transact_properties);
    if (!transactDispatch) CsInsufficientMemory(this);

    // transactDispatch->destroy  = (destructor_t)destroy_transact_ctl;
  }

} // namespace tis