#include "xsciter.h"
#include "xgraphics.h"

namespace tis {

  extern gool::argb RGBA(uint packed);

  /*bool gool::image::set_data(tool::array<byte> &data, const string &url, html::document* pd) {
    this->url = url;
    this->img = gool::image::create(data, url,pd);
    return img && img->is_valid();
  }*/

  static value CSF_open(xvm *c) {
    wchar *cmd = 0;
    CsParseArguments(c, "**S", &cmd);
    if (cmd) {}
    return UNDEFINED_VALUE;
  }

  extern gool::argb RGBA(uint packed);

  static value CSF_ctor(xvm *c) {
    handle<gool::image> xim;

    auto do_paint = [c](html::view *pv, html::graphics *bgr, value pf) {
      if (!pv)
        CsThrowKnownError(c, CsErrGenericError,
                          "'view' is not available at this point");
      PROTECT(pf);
      auto_graphics gfx(c, bgr, nullptr);
      gool::aa_mode _0(bgr);
      CsCallFunction(CsCurrentScope(c), pf, 1, gfx.graphics_obj.val);
    };

    pvalue obj(c);
    obj = CsGetArg(c, 1);
    html::helement elem;
    value          painter = 0;
    argb           initc(0, 0, 0, 0);
    size           dim;
    int            dn = 0;
    size           dstdim;

    // ustring url;

    PROTECT(painter);

    for (int n = 3; n <= CsArgCnt(c); ++n) {
      value v = CsGetArg(c, n);
      if (CsIntegerP(v) && dn == 0) {
        dstdim.x = dim.x = CsIntegerValue(v);
        ++dn;
      } else if (CsIntegerP(v) && dn == 1) {
        dstdim.y = dim.y = CsIntegerValue(v);
        ++dn;
      } else if (CsIntegerP(v) && dn == 2) {
        dstdim.x = CsIntegerValue(v);
        ++dn;
      } else if (CsIntegerP(v) && dn == 3) {
        dstdim.y = CsIntegerValue(v);
        ++dn;
      } else if (CsColorP(v))
        initc = RGBA(CsColorValue(v));
      else if (CsMethodP(v))
        painter = v;
      else if (CsIsType(v, c->elementDispatch))
        elem = element_ptr(c, v);
      // else if( CsStringP(v) )
      //  url = value_to_string(v);
    }

    html::view *pv = 0;
    if (elem) {
      pv = elem->pview();
      if (!pv)
        CsThrowKnownError(c, CsErrGenericError,
                          "element is not a member of the DOM");
    }

    if (elem && (dim.x <= 0 || dim.y <= 0)) dim = elem->border_box(*pv).size();

    if (dim.x <= 0 || dim.y <= 0) {
      CsThrowKnownError(c, CsErrGenericError,
                        "dimensions are less or equal to zero");
      // return UNDEFINED_VALUE;
    }

    if (elem) {
      // elem->commit_measure(*pv);
      // elem->drop_layout(pv);

      size eldim       = elem->border_box(*pv).size();
      size originaldim = eldim;

      elem->resolve_styles(*pv);
      elem->check_layout(*pv);

      if (eldim != dim) {
        if (elem->parent) {
          elem->measure_borders_x(*pv, elem->parent->dim());
          elem->measure_borders_y(*pv, elem->parent->dim());
        }
        elem->calc_intrinsic_widths(*pv);
        elem->set_border_width(*pv, dim.x);
        elem->set_border_height(*pv, dim.y);
        eldim = dim;
      } else
        elem->commit_measure(*pv);

      float scale = 1.0f;

      if (dstdim != dim) {
        sizef sc = sizef(dstdim) / sizef(dim);
        scale    = min(sc.x, sc.y);
        dim      = sizef(dim) * scale;
      }

      handle<gool::bitmap> bmp = new gool::bitmap(dim);
      bmp->clear(initc);

      xim = bmp; 
      
      point vpt = elem->view_pos(*pv);
      point rpt = vpt + elem->border_distance(*pv).start();

      //if (!xim->img->is_bitmap())
      //  CsThrowKnownError(c, CsErrGenericError, "image is not a bitmap");

      {
        handle<gool::graphics> bgr = pv->app->create_bitmap_bits_graphics(bmp, initc);
        if (bgr) 
        {
          bgr->set_clip_rc(eldim);

          auto_state<html::graphics *> _1(pv->drawing_surface, bgr);

          bgr->offset(-vpt);

          if (scale != 1.0f) bgr->scale(sizef(scale, scale), pointf(vpt));

          elem->do_draw(*pv, bgr, rpt); // first draw the element

          if (painter) // call painter function if any
            do_paint(pv, bgr, painter);

          if (originaldim != eldim) {
            elem->set_border_width(*pv, originaldim.x);
            elem->set_border_height(*pv, originaldim.y);
          }
          elem->drop_content_layout(pv);
        }
      }

    } else if (painter) {

      handle<gool::bitmap> bmp = new gool::bitmap(dim);
      bmp->clear(initc);

      xim = bmp;

      // new Image(painter); case
      pv = c->current_view();
      if (pv) {
        handle<gool::graphics> bgr = pv->app->create_bitmap_bits_graphics(bmp, initc);
        if (bgr) do_paint(pv, bgr, painter);
      }
    }

    if (!xim)
      CsThrowKnownError(c, CsErrGenericError,
                        "no element and no painter callback provided");

    xim->add_ref();
    CsSetCObjectValue(obj, xim);
    CsCtorRes(c) = obj;
    return obj;
  }

  static value CSF_update(xvm *c) {
    value obj = 0, painter = 0, initcolor = 0;

    CsParseArguments(c, "V=*m|V=", &obj, c->imageDispatch, &painter, &initcolor, &CsColorDispatch);
    handle<gool::image> xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;

    PROTECT(obj, painter);

    auto do_paint = [c](html::view *pv, html::graphics *bgr, value pf) {
      PROTECT(pf);
      auto_graphics gfx(c, bgr, nullptr);
      gool::aa_mode _0(bgr);
      CsCallFunction(CsCurrentScope(c), pf, 1, gfx.graphics_obj.val);
    };

    tis::xview *pv = c->current_view();
    if (!pv)
      CsThrowKnownError(c, CsErrGenericError,
                        "'view' is not available at this point");
    if (!xim->is_bitmap())
      CsThrowKnownError(c, CsErrGenericError, "image is not a bitmap");

    handle<gool::bitmap> bmp = xim.ptr_of<gool::bitmap>();

    argb initc = argb::undefined();
    if (initcolor) 
      initc = RGBA(CsColorValue(initcolor));

    handle<gool::graphics> bgr = pv->app->create_bitmap_bits_graphics(bmp, initc);
    if (bgr) do_paint(pv, bgr, painter);

    return obj;
  }

  // extern html::block* block_ptr(xvm* c, value obj);

  static value CSF_destroy(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->imageDispatch);
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;
    CsSetCObjectValue(obj, 0);
    xim->release();
    return UNDEFINED_VALUE;
  }

  static value CSF_toBytes(xvm *c) {
    value obj;
    value compression = 0;
    value packaging = 0;
    CsParseArguments(c, "V=*|V|V", &obj, c->imageDispatch, &packaging, &compression);
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;

    int compressing_level = 0;

    if (packaging && CsNumberP(packaging))
      compressing_level = CsIntegerValue(packaging);
    else if (compression && CsNumberP(compression))
      compressing_level = CsIntegerValue(compression);

    array<byte>            data;
    gool::image::PACKAGING type = gool::image::PNG;
#if defined(JPG_SUPPORT)
    if (compressing_level) type = gool::image::JPG;
#endif
    if (packaging) {
      if (packaging == CsSymbolOf("png")) type = gool::image::PNG;
#if defined(JPG_SUPPORT)
      else if (packaging == CsSymbolOf("jpeg")) type = gool::image::JPG;
#endif
      else if (packaging == CsSymbolOf("webp")) type = gool::image::WEBP;
      else if (packaging == CsSymbolOf("raw")) type = gool::image::UNKNOWN;
      else if (packaging == CsSymbolOf("bgra")) type = gool::image::UNKNOWN;
      else 
        CsBadValue(c, packaging);
    }

    if (type == gool::image::UNKNOWN) {
      handle<gool::bitmap> bitmap = xim->get_bitmap(nullptr, xim->dim());
      if (bitmap)
        data = bitmap->pixels_as_bytes();
      else
        data = xim->get_data();
    }
    else
      xim->save(data, type, compressing_level);
    if (data.size()) {
      CsPush(c, CsMakeByteVector(c, data));
      value mt = CsMakeString(c, tool::chars_of(gool::mime_type_of(type)));
      CsSetByteVectorType(CsTop(c), mt);
      value n = CsMakeString(c, xim->get_url());
      CsSetByteVectorName(CsTop(c), n);
      return CsPop(c);
    }
    return NULL_VALUE;
  }

  static value CSF_fromBytes(xvm *c) {
    value bytes;
    CsParseArguments(c, "**V=", &bytes, &CsByteVectorDispatch);

    html::document *pd = c->current_doc();

    handle<gool::image> xim = gool::image::create(CsByteVectorBytes(bytes), string(), pd);

    xim->add_ref();

    return CsMakeCPtrObject(c, c->imageDispatch, xim.ptr());
  }

  static value CSF_colorAt(xvm *c) {
    value obj;
    int   x, y;
    value clr = 0;
    CsParseArguments(c, "V=*ii|V=", &obj, c->imageDispatch, &x, &y, &clr, &CsColorDispatch);
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;

    gool::size sz = xim->dim();
    if (x < 0 || x >= sz.x || y < 0 || y >= sz.y) return UNDEFINED_VALUE;

    // if(!xim->img->is_bitmap())
    //  return UNDEFINED_VALUE;

    handle<gool::bitmap> bmp = xim->get_bitmap(nullptr, gool::size());
    if (!bmp) return UNDEFINED_VALUE;

    gool::argb &ppx = bmp->operator()(y)[x];
    if (clr) {
      gool::argb px = color_value(clr);
      ppx           = px.premultiply();
      bmp->drop_cache();
      return UNDEFINED_VALUE;
    } else {
      gool::argb px = ppx.demultiply();
      return CsMakeColor(px.red, px.green, px.blue, px.alfa);
    }
  }

  static value CSF_alphaMask(xvm *c) {
    static value sym_luma = CsSymbolOf("luminance");
    static value sym_r    = CsSymbolOf("r");
    static value sym_g    = CsSymbolOf("g");
    static value sym_b    = CsSymbolOf("b");
    static value sym_a    = CsSymbolOf("a");

    value obj;
    value maskObj;
    value sym = sym_luma;
    CsParseArguments(c, "V=*V=|V=", &obj, c->imageDispatch, &maskObj, c->imageDispatch, &sym, &CsSymbolDispatch);
    handle<gool::image> xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;

    handle<gool::image> ximm = image_ptr(c, maskObj);
    if (!ximm) return UNDEFINED_VALUE;

    if (!xim->is_bitmap()) return UNDEFINED_VALUE;
    if (!ximm->is_bitmap()) return UNDEFINED_VALUE;

    handle<gool::bitmap> bmp     = xim.ptr_of<gool::bitmap>();
    handle<gool::bitmap> bmpmask = ximm.ptr_of<gool::bitmap>();

    gool::size sz  = bmp->dim();
    gool::size szm = bmpmask->dim();

    gool::size s = size(min(sz.x, szm.x), min(sz.y, szm.y));

    if (sym == sym_luma)
      for (int y = 0; y < s.y; ++y) {
        gool::argb *msk = bmpmask->operator()(y);
        gool::argb *dst = bmp->operator()(y);
        for (int x = 0; x < s.x; ++x, ++msk, ++dst) {
          uint luma = msk->luminance_fast();
          argb t    = dst->demultiply();
          t.alfa    = gool::argb::channel_t(luma);
          *dst      = t.premultiply();
        }
      }
    else if (sym == sym_r)
      for (int y = 0; y < s.y; ++y) {
        gool::argb *msk = bmpmask->operator()(y);
        gool::argb *dst = bmp->operator()(y);
        for (int x = 0; x < s.x; ++x, ++msk, ++dst) {
          argb t = dst->demultiply();
          t.alfa = msk->red;
          *dst   = t.premultiply();
        }
      }
    else if (sym == sym_g)
      for (int y = 0; y < s.y; ++y) {
        gool::argb *msk = bmpmask->operator()(y);
        gool::argb *dst = bmp->operator()(y);
        for (int x = 0; x < s.x; ++x, ++msk, ++dst) {
          argb t = dst->demultiply();
          t.alfa = msk->green;
          *dst   = t.premultiply();
        }
      }
    else if (sym == sym_b)
      for (int y = 0; y < s.y; ++y) {
        gool::argb *msk = bmpmask->operator()(y);
        gool::argb *dst = bmp->operator()(y);
        for (int x = 0; x < s.x; ++x, ++msk, ++dst) {
          argb t = dst->demultiply();
          t.alfa = msk->blue;
          *dst   = t.premultiply();
        }
      }
    else if (sym == sym_a)
      for (int y = 0; y < s.y; ++y) {
        gool::argb *msk = bmpmask->operator()(y);
        gool::argb *dst = bmp->operator()(y);
        for (int x = 0; x < s.x; ++x, ++msk, ++dst) {
          argb t = dst->demultiply();
          t.alfa = msk->alfa;
          *dst   = t.premultiply();
        }
      }
    return UNDEFINED_VALUE;
  }

  static value CSF_compose(xvm *c) {
    static value sym_src_over = CsSymbolOf("src-over");
    static value sym_dst_over = CsSymbolOf("dst-over");
    static value sym_src_in   = CsSymbolOf("src-in");
    static value sym_dst_in   = CsSymbolOf("dst-in");
    static value sym_src_out  = CsSymbolOf("src-out");
    static value sym_dst_out  = CsSymbolOf("dst-out");
    static value sym_src_atop = CsSymbolOf("src-atop");
    static value sym_dst_atop = CsSymbolOf("dst-atop");
    static value sym_xor      = CsSymbolOf("xor");
    static value sym_copy     = CsSymbolOf("copy");

    value dst;
    value src;
    value sym;

    point dstpos(-1, -1);
    point srcpos;
    size  srcsz;

    CsParseArguments(c, "V=*V=V=|ii|iiii", &dst, c->imageDispatch, &src,
                     c->imageDispatch, &sym, &CsSymbolDispatch, &dstpos.x,
                     &dstpos.y, &srcpos.x, &srcpos.y, &srcsz.x, &srcsz.y);
    handle<gool::image> xim_dst = image_ptr(c, dst);
    if (!xim_dst) return UNDEFINED_VALUE;

    handle<gool::image> xim_src = image_ptr(c, src);
    if (!xim_src) return UNDEFINED_VALUE;

    if (!xim_dst->is_bitmap()) return UNDEFINED_VALUE;
    if (!xim_src->is_bitmap()) return UNDEFINED_VALUE;

    handle<gool::bitmap> bmp_src = xim_src.ptr_of<gool::bitmap>();
    handle<gool::bitmap> bmp_dst = xim_dst.ptr_of<gool::bitmap>();

    rect src_area(bmp_src->dim());

    if (dstpos.x < 0 || dstpos.y) dstpos = point(0, 0);
    if (!srcsz.empty()) src_area = rect(srcpos, srcsz);

    if (sym == sym_src_over)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::src_over);
    else if (sym == sym_dst_over)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::dst_over);
    else if (sym == sym_src_in)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::src_in);
    else if (sym == sym_dst_in)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::dst_in);
    else if (sym == sym_src_out)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::src_out);
    else if (sym == sym_dst_out)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::dst_out);
    else if (sym == sym_src_atop)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::src_atop);
    else if (sym == sym_dst_atop)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::dst_atop);
    else if (sym == sym_xor)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::dst_xor_src);
    else if (sym == sym_copy)
      bmp_dst->combine(dstpos, bmp_src, src_area, gool::combine::premultiplied::dst_copy_src);

    return dst;
  }

  static value CSF_size(xvm *c) {
    value obj;
    size  nsz(0, 0);
    color initc = 0xffffff;
    CsParseArguments(c, "V=*|ii|C", &obj, c->imageDispatch, &nsz.x, &nsz.y,
                     &initc);
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;
    size sz = xim->dimension();
    CS_RETURN2(c, CsMakeInteger(sz.x), CsMakeInteger(sz.y));
  }


  static value CSF_get_width(xvm *c, value obj) {
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;
    return CsMakeInteger(xim->dimension().x);
  }

  static value CSF_get_height(xvm *c, value obj) {
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;
    return CsMakeInteger(xim->dimension().y);
  }

  static value CSF_get_url(xvm *c, value obj) {
    gool::image *xim = image_ptr(c, obj);
    if (!xim) return UNDEFINED_VALUE;
    return string_to_value(c, xim->get_url());
  }

  // gfx_ctl

  /* constants */
  static constant constants[] = {CONSTANT_ENTRY_X(0, 0)};

  /* methods */
  static c_method methods[] = {C_METHOD_ENTRY_X("this", CSF_ctor),
                               C_METHOD_ENTRY_X("destroy", CSF_destroy),
                               C_METHOD_ENTRY_X("size", CSF_size),
                               C_METHOD_ENTRY_X("toBytes", CSF_toBytes),
                               C_METHOD_ENTRY_X("fromBytes", CSF_fromBytes),
                               C_METHOD_ENTRY_X("colorAt", CSF_colorAt),
                               C_METHOD_ENTRY_X("alphaMask", CSF_alphaMask),

                               C_METHOD_ENTRY_X("update", CSF_update),
                               C_METHOD_ENTRY_X("compose", CSF_compose),

                               // C_METHOD_ENTRY_X( "render",     CSF_render ),
                               // C_METHOD_ENTRY_X( "paint",      CSF_paint ),
                               C_METHOD_ENTRY_X(0, 0)};

  /* properties */
  static vp_method properties[] = {
      VP_METHOD_ENTRY_X("width", CSF_get_width, 0),
      VP_METHOD_ENTRY_X("height", CSF_get_height, 0),
      VP_METHOD_ENTRY_X("url", CSF_get_url, 0),
      // VP_METHOD_ENTRY_X( "graphics",      CSF_get_graphics,    0),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  void destroy_image(xvm *c, value obj) {
    gool::image *xim = image_ptr(c, obj);
    CsSetCObjectValue(obj, 0);
    xim->release();
  }

  void ImageScan(VM *c, value obj) {
    /*gool::image* xim = image_ptr( static_cast<xvm *>(c),obj);
    if(xim->callback)
      xim->callback = CsCopyValue(c,xim->callback);
    if(xim->gfx_object)
      xim->gfx_object = CsCopyValue(c,xim->gfx_object);*/
    CsCObjectScan(c, obj);
  }

  void xvm::init_image_class() {
    dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Image", methods, properties, constants);

    /* create the 'image' type */
    if (!pd) CsInsufficientMemory(this);

    pd->destroy   = (destructor_t)destroy_image;
    pd->scan      = ImageScan;
    imageDispatch = pd;
  }

} // namespace tis
