#include "xsciter.h"
#include "xgraphics.h"
//#include "gool.h"

namespace tis {

  // string gfx_ctl::name(" graphics");

  void xview::commit_drawing_buffers() { graphics_ctl = nullptr; }

#if 0
  gfx_ctl* element_graphics(xvm* c, value obj, bool init = false, gool::color clr = 0 )
  {
    html::block* b = block_ptr(c,obj);
    gfx_ctl* gfx = (gfx_ctl*)b->get_named_behavior( gfx_ctl::name );
    html::view* pv = 0;
    if( !gfx)
    {
//INIT:
      pv = b->pview();
      if(!pv)
        return 0;
      gfx = new gfx_ctl();
      b->attach_behavior(pv,gfx);
      gfx->init(*pv,b,clr);
    }
    else if(init)
    {
      pv = b->pview();
      if(!pv)
          return 0;
      gool::rect rc = b->client_rect(*pv);
      if( gfx->pixmap && rc.size() == gfx->pixmap->dimension() )
        gfx->reset(*pv, b, clr);
      else
        gfx->init(*pv, b, clr);
      //b->detach_behavior(pv,gfx);
      //goto INIT;
    }
    else
      gfx->prepare_to_draw(*pv, b);

    return gfx;
  }
#endif

  // helper visitor
  struct arg_visitor {
    xvm *c;
    int  first_arg;

    arg_visitor(xvm *vm, int firstArg = 3) : c(vm), first_arg(firstArg) {}

    virtual void on_arg(value v) = 0;

    void visit() {
      int nm = CsArgCnt(c);
      /*
      Yakimov:
      This day I wrote only 8 chars, this was my performance.
      Compiler for Windows Mobile that generates incorrect code and
      trashes 'n' variable so the loop is continued until data abort, that is
      why volatile is required.
      */
      for (volatile int n = first_arg; n <= nm; ++n) {
        value v = CsGetArg(c, n);
        if (CsVectorP(v))
          visit_vector(v);
        else
          on_arg(v);
      }
    }
    void visit_vector(value a) {
      int nm = CsVectorSize(c, a);
      for (int n = 0; n < nm; ++n) {
        value v = CsVectorElement(c, a, n);
        if (CsVectorP(v))
          visit_vector(v);
        else
          on_arg(v);
      }
    }
  };

  struct arg_doubles : arg_visitor {
    tool::array<real> vector;
    arg_doubles(xvm *c) : arg_visitor(c) { visit(); }
    virtual void on_arg(value v) {
      if (CsIntegerP(v))
        vector.push(CsIntegerValue(v));
      else if (CsFloatP(v))
        vector.push(CsFloatValue(v));
    }
  };

  struct arg_polygon : arg_visitor {
    gool::polygonr polygon;
    int            n;
    arg_polygon(xvm *c, int first_arg) : arg_visitor(c, first_arg), n(0) {
      visit();
    }
    virtual void on_arg(value v) {
      if (++n & 1) {
        gool::pointr pt(0, 0);
        if (CsIntegerP(v))
          pt.x = CsIntegerValue(v);
        else if (CsFloatP(v))
          pt.x = CsFloatValue(v);
        polygon.push(pt);
      } else {
        if (CsIntegerP(v))
          polygon.last().y = CsIntegerValue(v);
        else if (CsFloatP(v))
          polygon.last().y = CsFloatValue(v);
      }
    }
  };

  //#ifdef PLATFORM_WINCE
  //#pragma optimize( "g", off )
  //#endif

  value CSF_commit(xvm *c) {
    /*value obj;
    int x = 0,y = 0,w = 0, h = 0;
    CsParseArguments(c,"V=|",&obj,c->graphicsDispatch,&x,&y,&w,&h);

    gfx_ctl* gfx = graphics_ptr(obj);
    if( !gfx || !gfx->self) return UNDEFINED_VALUE;

    gool::rect rc = gool::rect::normalized( point(x,y), size(w,h) );

          // we need non transparent background color to avoid triple buffering
    if( gfx->background_color.alfa != 0xff)
      CsThrowKnownError(c, CsErrGenericError, "the block that does gfx should
    have non transparent background color, do Element.graphics(color(r, g,
    b))");

    arg_doubles av(c);
    if( av.vector.size() % 4 )
      CsThrowKnownError(c,CsErrGenericError,"Coordinates should be in [x, y, w,
    h] array.");

    for(int i = 0; i < av.vector.size(); i += 4)
    {
      gool::rect r(av.vector[i], av.vector[i + 1], av.vector[i] + av.vector[i +
    2], av.vector[i + 1] + av.vector[i + 3]);
      //gfx->dirty.push(r & self->client_rect());
      html::render_dib_on_element( gfx->self,r.origin, gfx->pixmap, r);
    }
    */
    return TRUE_VALUE;
  }

  //#ifdef PLATFORM_WINCE
  //#pragma optimize( "g", on )
  //#endif

  value CSF_element_graphics(xvm *c) {
    /*value     obj;
    //symbol_t  cmd;
    value     cmd = UNDEFINED_VALUE;
    bool      init = true;

    CsParseArguments(c,"V=*|V|B",&obj,c->elementDispatch,&cmd,&init);

    html::block* self = block_ptr(c,obj);
    if( !self )
      return UNDEFINED_VALUE;

    if( CsSymbolP(cmd) && get_sym_id(cmd) == id_destroy )
    {
      html::block* b = block_ptr(c,obj);
      gfx_ctl* gfx = (gfx_ctl*)b->get_named_behavior( gfx_ctl::name );

      gfx->gfx_object.unpin();

      html::view *pv = self->pview();
      if(!pv)
        return UNDEFINED_VALUE;
      if(gfx)
      {
        self->detach_behavior(pv,gfx);
        pv->refresh(self);
      }
      return NULL_VALUE;
    }

    gool::color initc = 0xFFFFFF;
    


    if( CsIntegerP(cmd) )
    {
      initc = CsIntegerValue(cmd);
      initc = (initc & 0xFFFFFF) | ((255 - a(initc)) << 24);
    }
    else if( CsColorP(cmd) )
    {
      initc = CsColorValue(cmd);
      initc = (initc & 0xFFFFFF) | ((255 - a(initc)) << 24);
    }
    else
    {
      init = false;
      if( CsArgCnt(c) > 2 ) // allow no parameters
        CsThrowKnownError(c, CsErrUnexpectedTypeError, cmd, "integer or color or
    #destroy");
    }

    gfx_ctl* gfx = element_graphics(c,obj,init, initc);
    if(gfx->gfx_object.is_set())
      CsSetCObjectValue(gfx->gfx_object,gfx);
    else
      gfx->gfx_object.pin(c,CsMakeCPtrObject(c,c->graphicsDispatch,gfx));

    if(init)
    {
      html::view *pv = self->pview();
      if(pv)
        pv->refresh(self);
    }
    return gfx->gfx_object;//CsMakeCPtrObject(c,c->graphicsDispatch,gfx);
    */
    return NULL_VALUE;
  }

  static value CSF_get_lineJoin(xvm *c, value obj) {
    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;
    return CsMakeInteger(gfx->gfx->line_join());
  }

  static void CSF_set_lineJoin(xvm *c, value obj, value val) {
    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return;

    int_t i = 0;
    if (is_int(val))
      i = to_int(val);
    else if (is_symbol(val)) {
      if (val == CsSymbolOf("mitter"))
        i = gool::JOIN_MITER;
      else if (val == CsSymbolOf("round"))
        i = gool::JOIN_ROUND;
      else if (val == CsSymbolOf("bevel"))
        i = gool::JOIN_BEVEL;
      else
        CsThrowKnownError(c, CsErrValueError, val);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, val, "integer");

    switch (i) {
    case gool::JOIN_MITER:
    case gool::JOIN_ROUND:
    case gool::JOIN_BEVEL: gfx->gfx->line_join((gool::LINE_JOIN)i); break;
    default: CsThrowKnownError(c, CsErrValueError, val);
    }
  }

  value int2sym(int e, value p0 = UNDEFINED_VALUE, value p1 = UNDEFINED_VALUE,
                value p2 = UNDEFINED_VALUE, value p3 = UNDEFINED_VALUE) {
    switch (e) {
    default:
    case 0: return p0;
    case 1: return p1;
    case 2: return p2;
    case 3: return p3;
    }
  }

  template <typename E>
  E sym2int(VM *c, value e, value p0 = UNDEFINED_VALUE,
            value p1 = UNDEFINED_VALUE, value p2 = UNDEFINED_VALUE,
            value p3 = UNDEFINED_VALUE) {

    if (e == p0)
      return E(0);
    else if (e == p1)
      return E(1);
    else if (e == p2)
      return E(2);
    else if (e == p3)
      return E(3);
    else {
      CsThrowKnownError(c, CsErrValueError, e);
      return E(0);
    }
  }

  static value CSF_strokeJoin(xvm *c) {
    value obj;
    value join = 0;

    CsParseArguments(c, "V=*|V", &obj, c->graphicsDispatch, &join);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    if (!join) return CsMakeInteger(gfx->gfx->line_join());

    int_t i = 0;
    if (is_int(join))
      i = to_int(join);
    else if (is_symbol(join)) {
      if (join == CsSymbolOf("mitter"))
        i = gool::JOIN_MITER;
      else if (join == CsSymbolOf("round"))
        i = gool::JOIN_ROUND;
      else if (join == CsSymbolOf("bevel"))
        i = gool::JOIN_BEVEL;
      else
        CsThrowKnownError(c, CsErrValueError, join);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, join, "integer or symbol");

    switch (i) {
    case gool::JOIN_MITER:
    case gool::JOIN_ROUND:
    case gool::JOIN_BEVEL: gfx->gfx->line_join((gool::LINE_JOIN)i); break;
    default: CsThrowKnownError(c, CsErrValueError, join);
    }

    return obj;
  }

  static value CSF_get_lineCap(xvm *c, value obj) {
    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;
    return CsMakeInteger(gfx->gfx->cap_style());
  }

  static void CSF_set_lineCap(xvm *c, value obj, value val) {
    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return;

    int_t i = 0;
    if (is_int(val))
      i = to_int(val);
    else if (is_symbol(val)) {
      if (val == CsSymbolOf("butt"))
        i = gool::CAP_BUTT;
      else if (val == CsSymbolOf("square"))
        i = gool::CAP_SQUARE;
      else if (val == CsSymbolOf("round"))
        i = gool::CAP_ROUND;
      else
        CsThrowKnownError(c, CsErrValueError, val);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, val, "integer or symbol");

    switch (i) {
    case gool::CAP_BUTT:
    case gool::CAP_SQUARE:
    case gool::CAP_ROUND: gfx->gfx->cap_style((gool::CAP_STYLE)i); break;
    default: CsThrowKnownError(c, CsErrValueError, val);
    }
  }

  static value CSF_strokeCap(xvm *c) {
    value obj;
    value cap = 0;

    CsParseArguments(c, "V=*|V", &obj, c->graphicsDispatch, &cap);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    if (!cap) return CsMakeInteger(gfx->gfx->cap_style());

    int_t i = 0;
    if (is_int(cap))
      i = to_int(cap);
    else if (is_symbol(cap)) {
      if (cap == CsSymbolOf("butt"))
        i = gool::CAP_BUTT;
      else if (cap == CsSymbolOf("square"))
        i = gool::CAP_SQUARE;
      else if (cap == CsSymbolOf("round"))
        i = gool::CAP_ROUND;
      else
        CsThrowKnownError(c, CsErrValueError, cap);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, cap, "integer or symbol");

    switch (i) {
    case gool::CAP_BUTT:
    case gool::CAP_SQUARE:
    case gool::CAP_ROUND: gfx->gfx->cap_style((gool::CAP_STYLE)i); break;
    default: CsThrowKnownError(c, CsErrValueError, cap);
    }
    return obj;
  }

  static value CSF_strokeDash(xvm *c) {
    value obj;
    value cap = 0;
    value off = 0;

    static const value S_STROKE_SOLID  = CsSymbolOf("solid");
    static const value S_STROKE_DOTTED = CsSymbolOf("dotted");
    static const value S_STROKE_DASHED = CsSymbolOf("dashed");

    CsParseArguments(c, "V=*|V|V", &obj, c->graphicsDispatch, &cap, &off);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    if (!cap)
      return int2sym(gfx->gfx->dash_style(), S_STROKE_SOLID, S_STROKE_DASHED,
                     S_STROKE_DOTTED);

    gool::DASH_STYLE i = DASH_STYLE_SOLID;
    if (is_symbol(cap)) {
      i = sym2int<gool::DASH_STYLE>(c, cap, S_STROKE_SOLID, S_STROKE_DASHED,
                                    S_STROKE_DOTTED);
      gfx->gfx->dash_style(i);
    } else if (CsVectorP(cap)) {
      array<float> pattern(CsVectorSize(c, cap));
      for (int n = 0; n < pattern.size(); ++n)
        pattern[n] =
            (float)CsFloatValue(CsToFloat(c, CsVectorElement(c, cap, n)));
      float offset = (float)(off ? CsFloatValue(CsToFloat(c, off)) : 0.0);
      gfx->gfx->custom_dash_style(pattern(), offset);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, cap, "symbol");

    return obj;
  }

  static value CSF_clearAll(xvm *c) {
    value obj;
    uint  clr = 0xFFFFFFFF;

    CsParseArguments(c, "V=*|C", &obj, c->graphicsDispatch, &clr);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    // gfx->self
    // gfx->gfx.clear_all(CLR(clr).premultiply());
    return obj;

    // return NULL_VALUE;
  }

  static value CSF_RGBA(xvm *c) { return CSF_color(c); }

  static value CSF_rectangle(xvm *c) {
    value obj;
    float x, y, w, h, r1 = 0, r2 = 0, r3 = 0, r4 = 0;
    CsParseArguments(c, "V=*ffff|f|f|f|f", &obj, c->graphicsDispatch, &x, &y,
                     &w, &h, &r1, &r2, &r3, &r4);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    gool::pointf org(x, y);
    gool::sizef  dim(w, h);

    switch (c->argc) {
    case 6: gfx->gfx->draw_rectangle(org, dim); break;
    case 7:
      gfx->gfx->draw_rectangle(org, dim, gool::sizef(r1), gool::sizef(r1),
                               gool::sizef(r1), gool::sizef(r1));
      break;
    case 8:
    case 9: gfx->gfx->draw_rectangle(org, dim, r1, r2, r1, r2); break;
    case 10:
      gfx->gfx->draw_rectangle(org, dim, r3, r4, r1, r2);
      break; // swap!
    }
    return obj;
    // return NULL_VALUE;
  }

  static value CSF_line(xvm *c) {
    value obj;
    float x1, y1, x2, y2;
    CsParseArguments(c, "V=*ffff", &obj, c->graphicsDispatch, &x1, &y1, &x2,
                     &y2);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) gfx->gfx->draw_line(pointf(x1, y1), pointf(x2, y2));
    return obj;
  }

  static value CSF_connector(xvm *c) {
    value obj;
    value params = 0;

    auto crackParams = [c](wchars suffix, value params,
                           gool::graphics::line_end_style &st, uint &pt) {
      each_property each2(c, params);
      for (value key, val; each2(key, val);) {
        ustring name  = value_to_string(key);
        wchars  chars = name();
        if (!chars.starts_with(suffix)) continue;
        chars.prune(suffix.length);
        if (chars == WCHARS("Cap")) {
          ustring cap = value_to_string(val);
          if (cap == "arrow")
            st.type = gool::graphics::LET_ARROW;
          else if (cap == "circle")
            st.type = gool::graphics::LET_CIRCLE;
          else if (cap == "none")
            st.type = gool::graphics::LET_NONE;
        } else if (chars == WCHARS("Size")) {
          if (CsVectorP(val) && CsVectorSize(c, val) == 2) {
            st.dim.x =
                float(CsFloatOrPixelsValue(c, CsVectorElement(c, val, 0)));
            st.dim.y =
                float(CsFloatOrPixelsValue(c, CsVectorElement(c, val, 1)));
          } else
            st.dim.x = st.dim.y = float(CsFloatOrPixelsValue(c, val));
        } else if (chars == WCHARS("Point")) {
          if (CsIntegerP(val)) pt = limit(CsIntegerValue(val), 1, 9);
        }
      }
    };

    int argcnt = CsArgCnt(c);

    pointf from, to;

    gool::graphics::line_end_style st_from =
        gool::graphics::line_end_style::none();
    gool::graphics::line_end_style st_to =
        gool::graphics::line_end_style::arrow(8, 5);

    switch (argcnt) {
    case 6:
    case 7: // two points
      CsParseArguments(c, "V=*ffff|V=", &obj, c->graphicsDispatch, &from.x,
                       &from.y, &to.x, &to.y, &params, &CsObjectDispatch);
      break;
    case 10:
    case 11: // two rects
    {
      sizef sfrom, sto;
      CsParseArguments(c, "V=*ffffffff|V=", &obj, c->graphicsDispatch, &from.x,
                       &from.y, &sfrom.x, &sfrom.y, &to.x, &to.y, &sto.x,
                       &sto.y, &params, &CsObjectDispatch);
      rectf rfrom(from, sfrom), rto(to, sto);
      uint  pt_from = 5, pt_to = 5;

      crackParams(WCHARS("from"), params, st_from, pt_from);
      crackParams(WCHARS("to"), params, st_to, pt_to);

      from = rfrom.pointOf(pt_from);
      to   = rto.pointOf(pt_to);

      do {
        if (gool::geom::intersects_at(from, to, rto.pointOf(7), rto.pointOf(9),
                                      to) == gool::geom::DO_INTERSECT)
          break;
        if (gool::geom::intersects_at(from, to, rto.pointOf(9), rto.pointOf(3),
                                      to) == gool::geom::DO_INTERSECT)
          break;
        if (gool::geom::intersects_at(from, to, rto.pointOf(3), rto.pointOf(1),
                                      to) == gool::geom::DO_INTERSECT)
          break;
        gool::geom::intersects_at(from, to, rto.pointOf(1), rto.pointOf(7), to);
      } while (false);
      do {
        if (gool::geom::intersects_at(from, to, rfrom.pointOf(7),
                                      rfrom.pointOf(9),
                                      from) == gool::geom::DO_INTERSECT)
          break;
        if (gool::geom::intersects_at(from, to, rfrom.pointOf(9),
                                      rfrom.pointOf(3),
                                      from) == gool::geom::DO_INTERSECT)
          break;
        if (gool::geom::intersects_at(from, to, rfrom.pointOf(3),
                                      rfrom.pointOf(1),
                                      from) == gool::geom::DO_INTERSECT)
          break;
        gool::geom::intersects_at(from, to, rfrom.pointOf(1), rfrom.pointOf(7),
                                  from);
      } while (false);
    } break;

    default:
      CsThrowKnownError(c, CsErrGenericError, "invalid arguments.");
      return UNDEFINED_VALUE;;
    }

    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) gfx->gfx->draw_line(from, to, st_from, st_to);
    return obj;
  }

  static value CSF_triangle(xvm *c) {
    value obj;
    float x1, y1, x2, y2, x3, y3;
    CsParseArguments(c, "V=*ffffff", &obj, c->graphicsDispatch, &x1, &y1, &x2,
                     &y2, &x3, &y3);
    gfx_ctl *gfx = graphics_ptr(obj);

    gool::polygonf vertices;
    vertices.add(pointf(x1, y1));
    vertices.add(pointf(x2, y2));
    vertices.add(pointf(x3, y3));

    if (gfx) gfx->gfx->draw_path(vertices);
    return obj;
  }

  gool::argb RGBA(uint packed) {
    return gool::argb(gool::r(packed), gool::g(packed), gool::b(packed),
                      255 - gool::a(packed));
  }

  static value CSF_lineColor(xvm *c) {
    value obj;
    uint  clr = 0xFF000000;
    CsParseArguments(c, "V=*C", &obj, c->graphicsDispatch, &clr);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    if (clr == 0xFF000000)
      gfx->gfx->set_stroke();
    else
      gfx->gfx->set_stroke(RGBA(clr));
    return obj;
  }

  static value CSF_noStroke(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->graphicsDispatch);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;
    gfx->gfx->set_stroke();
    return obj;
  }

  static value CSF_lineWidth(xvm *c) {
    value obj;
    float w = 0;
    CsParseArguments(c, "V=*f", &obj, c->graphicsDispatch, &w);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return obj;

    gfx->gfx->set_stroke_width(w);

    return obj;
  }

  static value CSF_fillColor(xvm *c) {
    value obj;
    // agg2d::Color noclr = CLR(0);
    // agg2d::Color clr = noclr;
    uint clr = 0xFF000000;

    CsParseArguments(c, "V=*|C", &obj, c->graphicsDispatch, &clr);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    if (clr == 0xFF000000)
      gfx->gfx->set_fill();
    else
      gfx->gfx->set_fill(RGBA(clr));
    return obj;
  }

  static value CSF_noFill(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->graphicsDispatch);

    gfx_ctl *gfx = graphics_ptr(obj);
    if (!gfx) return UNDEFINED_VALUE;

    gfx->gfx->set_fill();
    return obj;
  }

  static value CSF_fillImage(xvm *c) {
    value obj, img;
    CsParseArguments(c, "V=*V=", &obj, c->graphicsDispatch, &img, c->imageDispatch);
    gfx_ctl *gfx  = graphics_ptr(obj);
    if(gool::image * ximg = image_ptr(c, img))
      gfx->gfx->set_fill(ximg);
    return obj;
  }

  static value CSF_setLinearGradient(xvm *c, bool toFill) {
    value obj;
    float x1, y1, x2, y2, p = 1.0;
    value v1 = 0, v2 = UNDEFINED_VALUE;
    // uint c1,c2;
    CsParseArguments(c, "V=*ffffV|V|f", &obj, c->graphicsDispatch, &x1, &y1,
                     &x2, &y2, &v1, &v2, &p);
    gfx_ctl *          gfx = graphics_ptr(obj);
    gool::linear_brush lb(pointf(x1, y1), pointf(x2, y2));

    if (CsColorP(v1) && CsColorP(v2)) {
      argb c1 = CsColorValue(v1);
      argb c2 = CsColorValue(v2);
      lb.generate_stops(c1, c2, float(p));
      // lb.add_stop(0, c1);
      // lb.add_stop(1, c2);
    } else if (CsVectorP(v1) && v2 == UNDEFINED_VALUE) {
      int n = CsVectorSize(c, v1);
      for (int i = 0; i < n; ++i) {
        value vc = CsVectorElement(c, v1, i);
        if (!CsColorP(vc))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, vc, "color");
        lb.add_stop(float_v(), CsColorValue(vc));
      }
      lb.normalize_stops();
    } else if (CsVectorP(v1) && CsVectorP(v2) &&
               CsVectorSize(c, v1) == CsVectorSize(c, v2)) {
      int n = CsVectorSize(c, v1);
      for (int i = 0; i < n; ++i) {
        value vc = CsVectorElement(c, v1, i);
        value vs = CsVectorElement(c, v2, i);
        if (!CsColorP(vc))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, vc, "color");
        if (!CsFloatP(vs) || !is_between(CsFloatValue(vs), 0.0, 1.0))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, vs,
                            "float 0.0 .. 1.0 ");
        lb.add_stop((float)CsFloatValue(vs), CsColorValue(vc));
      }
    } else
      CsThrowKnownError(c, CsErrGenericError, "invalid arguments.");

    if (toFill)
      gfx->gfx->set_fill(lb);
    else
      gfx->gfx->set_stroke(lb);
    return obj;
  }

  // void
  static value CSF_fillLinearGradient(xvm *c) {
    return CSF_setLinearGradient(c, true);
    /*value obj;
    double x1,y1,x2,y2, p = 1.0;
    uint c1,c2;
    CsParseArguments(c,"V=*ddddCC|d",&obj,c->graphicsDispatch,&x1,&y1,&x2,&y2,&c1,&c2,&p);
    gfx_ctl* gfx = graphics_ptr(obj);
    gool::linear_brush lb(pointf(x1,y1),pointf(x2,y2));
    lb.generate_stops(RGBA(c1),RGBA(c2),float(p));
    gfx->gfx->set_fill(lb);
    return obj;*/
  }

  static value CSF_strokeLinearGradient(xvm *c) {
    /*value obj;
    double x1,y1,x2,y2, p = 1.0;
    uint c1,c2;
    CsParseArguments(c,"V=*ddddCC|d",&obj,c->graphicsDispatch,&x1,&y1,&x2,&y2,&c1,&c2,&p);
    gfx_ctl* gfx = graphics_ptr(obj);
    gool::linear_brush lb(pointf(x1,y1),pointf(x2,y2));
    lb.generate_stops(RGBA(c1),RGBA(c2),float(p));
    gfx->gfx->set_stroke(lb);
    return obj;*/
    return CSF_setLinearGradient(c, false);
  }

  static value CSF_setRadialGradient(xvm *c, bool toFill) {
    value obj;
    float x1, y1, r, p = 1.0;
    value v1 = 0, v2 = UNDEFINED_VALUE;
    // CsParseArguments(c,"V=*ddddVV|d",&obj,c->graphicsDispatch,&x1,&y1,&x2,&y2,&v1,&v2,&p);
    CsParseArguments(c, "V=*fffV|V|f", &obj, c->graphicsDispatch, &x1, &y1, &r,
                     &v1, &v2, &p);

    gfx_ctl *          gfx = graphics_ptr(obj);
    gool::radial_brush rb(pointf(x1, y1), pointf(r, r));

    if (CsColorP(v1) && CsColorP(v2)) {
      argb c1 = CsColorValue(v1);
      argb c2 = CsColorValue(v2);
      // rb.generate_stops(c1,c2,float(p));
      rb.add_stop(0.0f, c1);
      rb.add_stop(1.0f, c2);
    } else if (CsVectorP(v1) && v2 == UNDEFINED_VALUE) {
      int n = CsVectorSize(c, v1);
      for (int i = 0; i < n; ++i) {
        value vc = CsVectorElement(c, v1, i);
        if (!CsColorP(vc))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, vc, "color");
        rb.add_stop(float_v(), CsColorValue(vc));
      }
      rb.normalize_stops();
    } else if (CsVectorP(v1) && CsVectorP(v2) &&
               CsVectorSize(c, v1) == CsVectorSize(c, v2)) {
      int n = CsVectorSize(c, v1);
      for (int i = 0; i < n; ++i) {
        value vc = CsVectorElement(c, v1, i);
        value vs = CsVectorElement(c, v2, i);
        if (!CsColorP(vc))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, vc, "color");
        if (!CsFloatP(vs) || !is_between(CsFloatValue(vs), 0.0, 1.0))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, vs,
                            "float 0.0 .. 1.0 ");
        rb.add_stop((float)CsFloatValue(vs), CsColorValue(vc));
      }
    } else
      CsThrowKnownError(c, CsErrGenericError, "invalid arguments.");

    if (toFill)
      gfx->gfx->set_fill(rb);
    else
      gfx->gfx->set_stroke(rb);
    return obj;
  }

  static value CSF_fillRadialGradient(xvm *c) {
    return CSF_setRadialGradient(c, true);
    /*value obj;
    float x1,y1,r, p = 1.0;
    uint c1,c2;
    CsParseArguments(c,"V=*fffCC|f",&obj,c->graphicsDispatch,&x1,&y1,&r,&c1,&c2,&p);
    gfx_ctl* gfx = graphics_ptr(obj);

    gool::radial_brush rb(pointf(x1,y1),pointf(r,r));
    rb.generate_stops(RGBA(c1),RGBA(c2),float(p));
    gfx->gfx->set_fill(rb);
    return obj;*/
  }

  static value CSF_strokeRadialGradient(xvm *c) {
    return CSF_setRadialGradient(c, false);
    /*value obj;
    float x1,y1,r, p = 1.0;
    uint c1,c2;
    CsParseArguments(c,"V=*fffCC|f",&obj,c->graphicsDispatch,&x1,&y1,&r,&c1,&c2,&p);
    gfx_ctl* gfx = graphics_ptr(obj);
    gool::radial_brush rb(pointf(x1,y1),pointf(r,r));
    rb.generate_stops(RGBA(c1),RGBA(c2),float(p));
    gfx->gfx->set_stroke(rb);
    return obj;*/
  }

  static value CSF_fillEvenOdd(xvm *c) {
    value obj;
    bool  evenodd = false;
    CsParseArguments(c, "V=*B", &obj, c->graphicsDispatch, &evenodd);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) gfx->gfx->set_fill_even_odd(evenodd);
    return obj;
  }

#ifndef M_PI
  #define M_PI 3.14159265358979323846264338327950288
#endif

  static value CSF_rotate(xvm *c) {
    value obj;
    float a  = 0;
    float cx = 0;
    float cy = 0;
    CsParseArguments(c, "V=*f|ff", &obj, c->graphicsDispatch, &a, &cx, &cy);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) {
      gfx->gfx->rotate(a, pointf(cx, cy)); //
    }
    return obj;
  }

  static value CSF_scale(xvm *c) {
    value obj;
    float sx, sy;
    float cx = 0;
    float cy = 0;
    CsParseArguments(c, "V=*ff|ff", &obj, c->graphicsDispatch, &sx, &sy, &cx,
                     &cy);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) gfx->gfx->scale(sizef(sx, sy), pointf(cx, cy));
    return obj;
  }

  static value CSF_transform(xvm *c) {
    value obj;
    gool::affine_mtx_f m; //REAL sx, shy, shx, sy, tx, ty;
    CsParseArguments(c, "V=*ffffff", &obj, c->graphicsDispatch, &m.sx,&m.shy, &m.shx, &m.sy, &m.tx, &m.ty);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) gfx->gfx->transform(m);
    return obj;
  }
  
  static value CSF_skew(xvm *c) {
    value obj;
    float x, y;
    float cx = 0;
    float cy = 0;
    CsParseArguments(c, "V=*ff|ff", &obj, c->graphicsDispatch, &x, &y, &cx,
                     &cy);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) gfx->gfx->skew(sizef(x, y), pointf(cx, cy));
    return obj;
  }

  static value CSF_translate(xvm *c) {
    value obj;
    float dx, dy;
    CsParseArguments(c, "V=*ff", &obj, c->graphicsDispatch, &dx, &dy);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) { gfx->gfx->translate(pointf(dx, dy)); }
    return obj;
  }

  static value CSF_worldToScreen(xvm *c) {
    value  obj;
    pointf pt;
    CsParseArguments(c, "V=*f|f", &obj, c->graphicsDispatch, &pt.x, &pt.y);
    bool     only_x = CsArgCnt(c) == 3;
    gfx_ctl *gfx    = graphics_ptr(obj);
    if (gfx) {
      if (only_x)
        return CsMakeFloat(gfx->gfx->world_to_screen(pt.x));
      else {
        pt = gfx->gfx->world_to_screen(pt);
        CS_RETURN2(c, CsMakeFloat(pt.x), CsMakeFloat(pt.y));
      }
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_screenToWorld(xvm *c) {
    value  obj;
    pointf pt;
    CsParseArguments(c, "V=*f|f", &obj, c->graphicsDispatch, &pt.x, &pt.y);
    bool     only_x = CsArgCnt(c) == 3;
    gfx_ctl *gfx    = graphics_ptr(obj);
    if (gfx) {
      if (only_x)
        return CsMakeFloat(gfx->gfx->screen_to_world(pt.x));
      else {
        pt = gfx->gfx->screen_to_world(pt);
        CS_RETURN2(c, CsMakeFloat(pt.x), CsMakeFloat(pt.y));
      }
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_ellipse(xvm *c) {
    value        obj;
    gool::pointf center;
    gool::sizef  radius;
    CsParseArguments(c, "V=*fff|f", &obj, c->graphicsDispatch, &center.x,
                     &center.y, &radius.x, &radius.y);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) {
      if (c->argc == 5) radius.y = radius.x;
      gfx->gfx->draw_ellipse(center, radius);
    }
    return obj;
  }

  static value CSF_arc(xvm *c) {
    value  obj;
    float  start_radian, sweep_radian;
    pointf center;
    sizef  radius;
    CsParseArguments(c, "V=*ffffff", &obj, c->graphicsDispatch, &center.x,
                     &center.y, &radius.x, &radius.y, &start_radian, &sweep_radian);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) { gfx->gfx->draw_arc(center, radius, start_radian, sweep_radian); }
    return obj;
  }

  static value CSF_star(xvm *c) {
    value obj;
    float x, y, r1, r2, start;
    int   numRays;
    CsParseArguments(c, "V=*fffffi", &obj, c->graphicsDispatch, &x, &y, &r1,
                     &r2, &start, &numRays);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx && numRays) {
      gfx->gfx->draw_star(pointf(x, y), sizef(r1), sizef(r2), start, numRays);
    }
    return obj;
  }

  static value CSF_polygon(xvm *c) {
    value obj;
    CsParseArguments(c, "V=|", &obj, c->graphicsDispatch);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) {
      arg_doubles av(c);
      if (av.vector.size() & 1)
        CsThrowKnownError(c, CsErrGenericError, "Odd number of coordinates.");
      handle<gool::path> pa = gfx->gfx->create_path();
      pa->reset();
      pa->move_to(pointf((float)av.vector[0], (float)av.vector[1]));
      for (int n = 2; n < av.vector.size(); n += 2)
        pa->line_to(pointf((float)av.vector[n], (float)av.vector[n + 1]));
      pa->close();
      pa->seal();
      gfx->gfx->draw_path(pa);
    }
    return obj;
  }

  static value CSF_polyline(xvm *c) {
    value obj;
    CsParseArguments(c, "V=|", &obj, c->graphicsDispatch);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) {
      arg_doubles av(c);
      if (av.vector.size() & 1)
        CsThrowKnownError(c, CsErrGenericError, "Odd number of coordinates.");

      bool closed = false;
      if (av.vector.size() >= 8) {
        // determine if it is closed
        real xdelta = av.vector[av.vector.size() - 2] - av.vector[0];
        real ydelta = av.vector.last() - av.vector[1];
        if (abs(xdelta) < 0.001 && abs(ydelta) < 0.001) {
          closed = true;
          av.vector.size(av.vector.size() - 2);
        }
      }
      // gfx->gfx.polyline(av.vector.head(),av.vector.size() / 2, closed);
      handle<gool::path> pa = gfx->gfx->create_path();
      pa->reset();
      pa->move_to(pointf((float)av.vector[0], (float)av.vector[1]));
      for (int n = 2; n < av.vector.size(); n += 2)
        pa->line_to(pointf((float)av.vector[n], (float)av.vector[n + 1]));
      if (closed) pa->close();
      pa->seal();
      gfx->gfx->draw_path(pa, true, false);
    }
    return obj;
  }

  // Graphics.getFonts([mask:String])
  static value CSF_fonts(xvm *c) {
    /*
      wchar* mask = 0;
      CsParseArguments(c,"**|S",&mask);

      tool::pool<tool::ustring> names;
      gool::font::all(names);
      pvalue arr(c);
      if( mask )
      {
        tool::ustring umask(mask);
        int i, n = 0, k = 0;
        for( i = 0; i < int(names.size()); ++i )
          if(is_like(names(i), umask)) ++n;
        arr = CsMakeVector(c, n);
        for( i = 0; i < n; ++i )
          if(is_like(names(i), umask))
            CsSetVectorElement(c,arr,k++,CsMakeString(c,names(i)));
      }
      else
      {
        arr = CsMakeVector(c, names.size());
        for( int i = 0; i < int(names.size()); ++i )
          CsSetVectorElement(c,arr,i,CsMakeString(c,names(i)));
      }
      return arr;
      */
    return NULL_VALUE;
  }

  static value CSF_antialiasing(xvm *c) {
    value obj, aa;
    CsParseArguments(c, "V=*V", &obj, c->graphicsDispatch, &aa);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) { gfx->gfx->set_antialiasing(CsToBoolean(c, aa) == TRUE_VALUE); }
    return obj;
  }

  static value CSF_save(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->graphicsDispatch);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) { gfx->gfx->push_state(); }
    return obj;
  }
  static value CSF_restore(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->graphicsDispatch);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) { gfx->gfx->pop_state(); }
    return obj;
  }

  gool::COMPOSITION_OP sym_to_composition(value sym) {
    static value sym_src_over = CsSymbolOf("src-over");
    static value sym_dst_over = CsSymbolOf("dst-over");
    static value sym_src_in   = CsSymbolOf("src-in");
    static value sym_dst_in   = CsSymbolOf("dst-in");
    static value sym_src_out  = CsSymbolOf("src-out");
    static value sym_dst_out  = CsSymbolOf("dst-out");
    static value sym_src_atop = CsSymbolOf("src-atop");
    static value sym_dst_atop = CsSymbolOf("dst-atop");
    static value sym_xor      = CsSymbolOf("xor");
    static value sym_copy     = CsSymbolOf("copy");

    COMPOSITION_OP op = gool::no_composition;

    if (sym == sym_src_over)
      op = gool::src_over;
    else if (sym == sym_dst_over)
      op = gool::dst_over;
    else if (sym == sym_src_in)
      op = gool::src_in;
    else if (sym == sym_dst_in)
      op = gool::dst_in;
    else if (sym == sym_src_out)
      op = gool::src_out;
    else if (sym == sym_dst_out)
      op = gool::dst_out;
    else if (sym == sym_src_atop)
      op = gool::src_atop;
    else if (sym == sym_dst_atop)
      op = gool::dst_atop;
    else if (sym == sym_xor)
      op = gool::dst_src_xor;
    else if (sym == sym_copy)
      op = gool::dst_copy_src;

    return op;
  }

  /*function<bool(gool::filter_graph_builder *)> filter_producer;

  if (cs->filters.has_items() && v.app->supports_filters()) {
    filter_producer = [&](gool::filter_graph_builder *target) -> bool {
      return produce_filter_graph(v, this, cs->filters.elements(), target);
    };
  }*/

  static value CSF_pushLayer(xvm *c) {
    value obj;
    value p1 = UNDEFINED_VALUE, p2 = UNDEFINED_VALUE, p3 = UNDEFINED_VALUE, p4 = UNDEFINED_VALUE, p5 = NULL_VALUE, p6 = NULL_VALUE;
    CsParseArguments(c, "V=*V|V|V|V|V", &obj, c->graphicsDispatch, &p1, &p2,
                     &p3, &p4, &p5, &p6);
    gfx_ctl *ctl = graphics_ptr(obj);
    if (!ctl) return obj;

    byte opacity = 255;
    function<bool(gool::filter_graph_builder *)> filter_producer;

    auto make_filter = [&](value v) -> function<bool(gool::filter_graph_builder *)> {
      xview *pv = c->current_view();
      if (!pv) return function<bool(gool::filter_graph_builder *)>();
      html::element *pel = ctl->self ? ctl->self : pv->doc();
      
      tool::value filters = value_to_value(c,v); 
      if (filters.is_function())
        filters = tool::value::make_array(slice<tool::value>(filters));

      return [pv,pel,filters](gool::filter_graph_builder *target) -> bool 
      {
        return html::produce_filter_graph(*pv, pel, filters.values(), target);
      };
    };

    int nargs = CsArgCnt(c) - 2;
    if (nargs == 6 || nargs == 5 || nargs == 4) // x,y,w,h[,opacity|filter]
    {
      if (!CsNumberOrLengthP(p1))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p1,
                          "x shall be a number");
      if (!CsNumberOrLengthP(p2))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p2,
                          "y shall be a number");
      if (!CsNumberOrLengthP(p3))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p3,
                          "width shall be a number");
      if (!CsNumberOrLengthP(p4))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p4,
                          "height shall be a number");
      gool::rectf rc(
          pointd(CsFloatOrPixelsValue(c, p1), CsFloatOrPixelsValue(c, p2)),
          sized(CsFloatOrPixelsValue(c, p3), CsFloatOrPixelsValue(c, p4)));

      if (CsFloatP(p5))
        opacity = byte(255 * CsFloatValue(p5));
      else if (CsFloatP(p6))
        opacity = byte(255 * CsFloatValue(p6));

      if (CsTupleP(p5) || CsVectorP(p5))
        filter_producer = make_filter(p5);
      else if (CsTupleP(p6) || CsVectorP(p6))
        filter_producer = make_filter(p6);

      if (filter_producer) {
        //CsThrowKnownError(c, CsErrGenericError, "unrecognized parameter");
        ctl->gfx->push_layer(rc, opacity, filter_producer);
      } else {
        ctl->gfx->push_layer(rc, opacity);
      }
      // CsThrowKnownError(c, CsErrUnexpectedTypeError, p5, "opacity(float) or
      // composition(symbol)");
    }
    // path [,opacity]
    else if ((nargs == 2 || nargs == 1) && CsIsType(p1, c->pathDispatch)) {
      gool::path *pth = path_ptr(p1);
      if (!pth) return obj;
      if (nargs == 2) {
        if (!CsFloatP(p2))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, p2,
                            "opacity shall be a float");
        ctl->gfx->push_layer(pth, byte(255 * CsFloatValue(p2)));
      } else
        ctl->gfx->push_layer(pth);
    }

    // imageMask, draw1a [,opacity|filter]
    else if ((nargs == 3 || nargs == 2) && CsIsType(p1, c->imageDispatch)) {
      handle<gool::image> xim = image_ptr(c, p1);
      // if( !xim )
      //  return UNDEFINED_VALUE;

      if (!xim) return obj;

      bool draw1a = CsToBoolean(c, p2) == TRUE_VALUE;

      if (nargs == 3) {
        if (!CsFloatP(p3))
          CsThrowKnownError(c, CsErrUnexpectedTypeError, p3, "opacity shall be a float");
        ctl->gfx->push_layer(xim->get_bitmap(ctl->gfx, xim->dim()),draw1a, byte(255 * CsFloatValue(p2)));
      } else
        ctl->gfx->push_layer(xim->get_bitmap(ctl->gfx, xim->dim()), draw1a);
    } else if (nargs == 1 && CsSymbolP(p1)) {
ELEMENT_SHAPE:
      static value background_area = CsSymbolOf("background-area");
      static value client_box      = CsSymbolOf("client-box");
      static value margin_box      = CsSymbolOf("margin-box");
      static value border_box      = CsSymbolOf("border-box");
      static value padding_box     = CsSymbolOf("padding-box");
      static value inner_box       = CsSymbolOf("inner-box");

      if (!ctl->self)
        CsThrowKnownError(
            c, CsErrUnexpectedTypeError, p1,
            "layer shape is applicable only to element's graphics");
      html::view *pv = ctl->self->pview();
      if (!pv)
        CsThrowKnownError(c, CsErrUnexpectedTypeError, obj,
                          "is not in the DOM");
      if (background_area == p1) {
        html::hstyle       cs = ctl->self->get_style(*pv);
        gool::rect         rect = ctl->self->border_box(*pv);
        handle<gool::path> path;
        cs->background_outline(*pv, ctl->gfx, rect, rect, path,ctl->gfx->current_element);

        if (filter_producer)
          ctl->gfx->push_layer(rect, opacity, filter_producer);
        else if (path)
          ctl->gfx->push_layer(path);
        else
          ctl->gfx->push_layer(rect);
        return obj;
      }
      gool::rect rect;
      if (p1 == border_box)
        rect = ctl->self->border_box(*pv);
      else if (p1 == padding_box)
        rect = ctl->self->padding_box(*pv);
      else if (p1 == margin_box)
        rect = ctl->self->margin_box(*pv);
      else if (p1 == client_box)
        rect = ctl->self->client_rect(*pv);
      else if (p1 == inner_box)
        rect = ctl->self->dim();
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p1,
                          "unknown box specifier");
      if (filter_producer)
        ctl->gfx->push_layer(rect, opacity, filter_producer);
      else 
        ctl->gfx->push_layer(rect);

      return obj;
    }
    else if ((nargs == 2 || nargs == 3) && CsSymbolP(p1)) 
    {
      if (CsFloatP(p2))
        opacity = byte(255 * CsFloatValue(p2));
      else if (CsFloatP(p3))
        opacity = byte(255 * CsFloatValue(p3));
      if (CsTupleP(p2) || CsVectorP(p2))
        filter_producer = make_filter(p2);
      else if (CsTupleP(p3) || CsVectorP(p3))
        filter_producer = make_filter(p3);
      goto ELEMENT_SHAPE;
    }
    else 
      CsThrowKnownError(c, CsErrGenericError, "unrecognized parameters");
    return obj;
  }

  static value CSF_popLayer(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->graphicsDispatch);
    gfx_ctl *gfx = graphics_ptr(obj);
    if (gfx) { gfx->gfx->pop_layer(); }
    return obj;
  }

  static value CSF_copyImage(xvm *c) {
    /*  value obj, img;
      float_t x,y;
      int srcx1 = 0, srcy1=0, srcx2 = 0, srcy2=0;
      gfx_ctl* gfx = 0;
      handle<gool::image> xim;
      size sz;

      switch( c->argc )
      {
        case 5:
          CsParseArguments(c,"V=*V=dd",&obj,c->graphicsDispatch,&img,c->imageDispatch,&x,&y);
          gfx = graphics_ptr(obj);
          xim = image_ptr(c,img);
          if( !gfx || !xim->hd)
            return UNDEFINED_VALUE;
          sz = xim->hd->dimension();
          srcx2 = sz.x;
          srcy2 = sz.y;
          break;
        case 9:
          CsParseArguments(c,"V=*V=ddiiii",&obj,c->graphicsDispatch,&img,c->imageDispatch,&x,&y,
      &srcx1, &srcy1, &srcx2, &srcy2); gfx = graphics_ptr(obj); xim =
      image_ptr(c,img); if( !gfx || !xim->hd) return UNDEFINED_VALUE; sz
      = xim->hd->dimension(); srcx1 = limit( srcx1, 0, sz.x ); srcx2 = limit(
      srcx1 + srcx2 , 0, sz.x ); srcy1 = limit( srcy1, 0, sz.y ); srcy2 = limit(
      srcy1 + srcy2, 0, sz.y ); if( srcy1 >= srcy2 || srcx1 >= srcx2 ) return
      UNDEFINED_VALUE; break; default: CsWrongNumberOfArguments(c); return
      UNDEFINED_VALUE;
      }
      //y += (srcy2 - srcy1);
      //srcy1 = sz.y - srcy1 - 1;
      //srcy2 = sz.y - srcy2 - 1;
      //swap(srcy1,srcy2);
      gfx->gfx.copy_image( *xim, srcx1, srcy1, srcx2, srcy2, x,y );
      return obj;
      */
    return NULL_VALUE;
  }

  static value CSF_blendImage(xvm *c) {
    value          obj, img;
    float          x = 0, y = 0;
    float          w = 0, h = 0;
    int            srcx1 = 0, srcy1 = 0, srcx2 = 0, srcy2 = 0;
    gfx_ctl *      gfx = 0;
    handle<gool::image> xim;
    size           sz;

    value va     = 0;
    bool  got_wh = false;

    switch (c->argc) {
    case 5:
    case 6:
      CsParseArguments(c, "V=*V=ff|V", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y, &va);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim ) return UNDEFINED_VALUE;
      sz    = xim->dimension();
      srcx2 = sz.x - 1;
      srcy2 = sz.y - 1;
      break;
    case 7:
    case 8:
      CsParseArguments(c, "V=*V=ffff|V", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y, &w, &h, &va);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim) return UNDEFINED_VALUE;
      sz     = xim->dimension();
      got_wh = true;
      srcx2  = sz.x - 1;
      srcy2  = sz.y - 1;
      break;
    case 9:
    case 10:
      CsParseArguments(c, "V=*V=ffiiii|V", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y, &srcx1, &srcy1, &srcx2, &srcy2,
                       &va);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim) return UNDEFINED_VALUE;
      sz     = xim->dimension();
      srcx1  = limit(srcx1, 0, sz.x);
      srcx2  = limit(srcx1 + srcx2 - 1, 0, sz.x - 1);
      srcy1  = limit(srcy1, 0, sz.y);
      srcy2  = limit(srcy1 + srcy2 - 1, 0, sz.y - 1);
      w      = float(srcx2 - srcx1 + 1);
      h      = float(srcy2 - srcy1 + 1);
      got_wh = true;
      if (srcy1 > srcy2 || srcx1 > srcx2) return obj;

      break;
    default:
      CsWrongNumberOfArguments(c);
      return UNDEFINED_VALUE;
    }

    int ialpha = 255;
    if (va && CsIntegerP(va))
      ialpha = CsIntegerValue(va);
    else if (va && CsFloatP(va))
      ialpha = int(CsFloatValue(va) * 255);

    if (!got_wh) {
      sz        = xim->dimension();
      float one = gfx->gfx->screen_to_world(1.0f);
      w         = sz.x * one;
      h         = sz.y * one;
    }

    ialpha = limit(ialpha, 0, 255);
    if (ialpha != 0) {
      gfx->gfx->draw_image(xim, rectf(pointf(x, y), sizef(w, h)),
                           rect(srcx1, srcy1, srcx2, srcy2), byte(ialpha));
    }
    return obj;
  }

  static value CSF_drawImage(xvm *c) {
    value obj, img;
    rect  src_rc;
    // rectf  dst_rc;
    float          x, y;
    float          w, h;
    gfx_ctl *      gfx = 0;
    handle<gool::image> xim;
    size           sz;

    switch (c->argc) {
    case 5: {
      CsParseArguments(c, "V=*V=ff", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim) return UNDEFINED_VALUE;
      sz        = xim->dimension();
      src_rc    = sz;
      float one = gfx->gfx->screen_to_world(1.0f);
      w         = sz.x * one;
      h         = sz.y * one;
      gfx->gfx->draw_image(xim, rectf(pointf(x, y), sizef(w, h)), src_rc);
    } break;
    case 7: {
      CsParseArguments(c, "V=*V=ffff", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y, &w, &h);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim) return UNDEFINED_VALUE;
      sz     = xim->dimension();
      src_rc = sz;
      gfx->gfx->draw_image(xim, rectf(pointf(x, y), sizef(w, h)), src_rc);
    } break;
    case 9: {
      int srcx = 0, srcy = 0, srcw = 0, srch = 0;
      CsParseArguments(c, "V=*V=ffiiii", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y, &srcx, &srcy, &srcw, &srch);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim) return UNDEFINED_VALUE;
      sz          = xim->dimension();
      srcx        = limit(srcx, 0, sz.x);
      srcy        = limit(srcy, 0, sz.y);
      int   srcx1 = limit(srcx + srcw, 0, sz.x);
      int   srcy1 = limit(srcy + srch, 0, sz.y);
      float one   = gfx->gfx->screen_to_world(1.0f);
      w           = (srcx1 - srcx) * one;
      h           = (srcy1 - srcy) * one;
      if (srcy > srcy1 || srcx > srcx1) return obj;
      gfx->gfx->draw_image(xim, rectf(pointf(x, y), sizef(w, h)),
                           rect(point(srcx, srcy), size(srcw, srch)));
    } break;
    case 11: {
      int srcx = 0, srcy = 0, srcw = 0, srch = 0;
      CsParseArguments(c, "V=*V=ffffiiii", &obj, c->graphicsDispatch, &img,
                       c->imageDispatch, &x, &y, &w, &h, &srcx, &srcy, &srcw,
                       &srch);
      gfx = graphics_ptr(obj);
      xim = image_ptr(c, img);
      if (!gfx || !xim) return UNDEFINED_VALUE;
      sz        = xim->dimension();
      srcx      = limit(srcx, 0, sz.x);
      srcy      = limit(srcy, 0, sz.y);
      int srcx1 = limit(srcx + srcw, 0, sz.x);
      int srcy1 = limit(srcy + srch, 0, sz.y);
      if (srcy > srcy1 || srcx > srcx1) return obj;
      gfx->gfx->draw_image(xim, rectf(pointf(x, y), sizef(w, h)),
                           rect(point(srcx, srcy), size(srcw, srch)));
    } break;
    default: CsWrongNumberOfArguments(c);
    }
    return obj;
  }

  static value CSF_drawPath(xvm *c) {
    value obj;
    value path_obj;
    // agg2d::draw_path_flag_e flag = agg2d::FILL_AND_STROKE;
    CsParseArguments(c, "V=*V=", &obj, c->graphicsDispatch, &path_obj,
                     c->pathDispatch);
    gfx_ctl * gfx = graphics_ptr(obj);
    gool::path *pth = path_ptr(path_obj);
    if (gfx && pth) { gfx->gfx->draw_path(pth); }
    return obj;
  }

  static value CSF_drawText(xvm *c) {
    value       obj;
    value       text_obj;
    gool::color clr = gool::color(-1);
    // value       p1 = 0, p2 = 0;
    value  p1 = 0, p2 = 0;
    int    point_of = 0;
    pointf dst;

    CsParseArguments(c, "V=*V=ff|V|V", &obj, c->graphicsDispatch, &text_obj,
                     c->textDispatch, &dst.x, &dst.y, &p1, &p2);

    if (p1 && CsColorP(p1)) clr = CsColorValue(p1);
    if (p2 && CsIntegerP(p2)) point_of = CsIntegerValue(p2);

    if (p1 && CsIntegerP(p1))
      point_of = CsIntegerValue(p1);
    else if (p2 && CsColorP(p2))
      clr = CsColorValue(p2);

    gfx_ctl * gfx = graphics_ptr(obj);
    text_ctl *ptt = text_ptr(text_obj);
    if (gfx && ptt) {
      rectf rc(dst, ptt->tl->get_box());
      if (point_of) rc.pointOf(point_of, dst);
      if (clr != gool::color(-1))
        gfx->gfx->draw(ptt->tl, rc.start(), gool::argb(clr));
      else
        gfx->gfx->draw(ptt->tl, rc.start());
    }
    return obj;
  }

  /* constants */
  static constant constants[] = {
      CONSTANT_ENTRY_X("JOIN_MITER", int_value(gool::JOIN_MITER)),
      CONSTANT_ENTRY_X("JOIN_ROUND", int_value(gool::JOIN_ROUND)),
      CONSTANT_ENTRY_X("JOIN_BEVEL", int_value(gool::JOIN_BEVEL)),

      CONSTANT_ENTRY_X("CAP_BUTT", int_value(gool::CAP_BUTT)),
      CONSTANT_ENTRY_X("CAP_SQUARE", int_value(gool::CAP_SQUARE)),
      CONSTANT_ENTRY_X("CAP_ROUND", int_value(gool::CAP_ROUND)),

      CONSTANT_ENTRY_X("ALIGN_START", int_value(gool::ALIGN_START)),
      CONSTANT_ENTRY_X("ALIGN_END", int_value(gool::ALIGN_END)),
      CONSTANT_ENTRY_X("ALIGN_CENTER", int_value(gool::ALIGN_CENTER)),

      CONSTANT_ENTRY_X("FILL_ONLY", int_value(gool::FILL_ONLY)),
      CONSTANT_ENTRY_X("STROKE_ONLY", int_value(gool::STROKE_ONLY)),
      CONSTANT_ENTRY_X("STROKE_AND_FILL", int_value(gool::FILL_AND_STROKE)),
      CONSTANT_ENTRY_X("FILL_BY_LINE_COLOR",
                       int_value(gool::FILL_BY_LINE_COLOR)),

      CONSTANT_ENTRY_X("BLEND_ALPHA", int_value(0)),
      /*CONSTANT_ENTRY_X("BLEND_CLEAR"    , int_value( agg2d::BlendClear )),
      CONSTANT_ENTRY_X("BLEND_SRC"      , int_value( agg2d::BlendSrc        )),
      CONSTANT_ENTRY_X("BLEND_DST"      , int_value( agg2d::BlendDst        )),
      CONSTANT_ENTRY_X("BLEND_SRCOVER"  , int_value( agg2d::BlendSrcOver    )),
      CONSTANT_ENTRY_X("BLEND_DSTOVER"  , int_value( agg2d::BlendDstOver    )),
      CONSTANT_ENTRY_X("BLEND_SRCIN"    , int_value( agg2d::BlendSrcIn      )),
      CONSTANT_ENTRY_X("BLEND_DSTIN"    , int_value( agg2d::BlendDstIn      )),
      CONSTANT_ENTRY_X("BLEND_SRCOUT"   , int_value( agg2d::BlendSrcOut     )),
      CONSTANT_ENTRY_X("BLEND_DSTOUT"   , int_value( agg2d::BlendDstOut     )),
      CONSTANT_ENTRY_X("BLEND_SRCATOP"  , int_value( agg2d::BlendSrcAtop    )),
      CONSTANT_ENTRY_X("BLEND_DSTATOP"  , int_value( agg2d::BlendDstAtop    )),
      CONSTANT_ENTRY_X("BLEND_XOR"      , int_value( agg2d::BlendXor        )),
      CONSTANT_ENTRY_X("BLEND_ADD"      , int_value( agg2d::BlendAdd        )),
      CONSTANT_ENTRY_X("BLEND_SUB"      , int_value( agg2d::BlendSub        )),
      CONSTANT_ENTRY_X("BLEND_MULTIPLY" , int_value( agg2d::BlendMultiply   )),
      CONSTANT_ENTRY_X("BLEND_SCREEN"   , int_value( agg2d::BlendScreen     )),
      CONSTANT_ENTRY_X("BLEND_OVERLAY"  , int_value( agg2d::BlendOverlay    )),
      CONSTANT_ENTRY_X("BLEND_DARKEN"   , int_value( agg2d::BlendDarken     )),
      CONSTANT_ENTRY_X("BLEND_LIGHTEN"  , int_value( agg2d::BlendLighten    )),
      CONSTANT_ENTRY_X("BLEND_COLORDODGE" , int_value( agg2d::BlendColorDodge
      )), CONSTANT_ENTRY_X("BLEND_COLORBURN", int_value( agg2d::BlendColorBurn
      )), CONSTANT_ENTRY_X("BLEND_HARDLIGHT", int_value( agg2d::BlendHardLight
      )), CONSTANT_ENTRY_X("BLEND_SOFTLIGHT", int_value( agg2d::BlendSoftLight
      )), CONSTANT_ENTRY_X("BLEND_DIFFERENCE" , int_value(
      agg2d::BlendDifference )), CONSTANT_ENTRY_X("BLEND_EXCLUSION"  ,
      int_value( agg2d::BlendExclusion  )), CONSTANT_ENTRY_X("BLEND_CONTRAST"
      , int_value( agg2d::BlendContrast   )),*/

      CONSTANT_ENTRY_X(0, 0)};

  /* methods */
  static c_method methods[] = {
      C_METHOD_ENTRY_X("RGBA", CSF_RGBA),

      C_METHOD_ENTRY_X("clearAll", CSF_clearAll),
      C_METHOD_ENTRY_X("line", CSF_line),
      C_METHOD_ENTRY_X("connector", CSF_connector),
      C_METHOD_ENTRY_X("triangle", CSF_triangle),
      C_METHOD_ENTRY_X("rectangle", CSF_rectangle),
      C_METHOD_ENTRY_X("ellipse", CSF_ellipse),
      C_METHOD_ENTRY_X("arc", CSF_arc), C_METHOD_ENTRY_X("star", CSF_star),
      C_METHOD_ENTRY_X("polygon", CSF_polygon),
      C_METHOD_ENTRY_X("polyline", CSF_polyline),
      C_METHOD_ENTRY_X("copyImage", CSF_copyImage),
      C_METHOD_ENTRY_X("blendImage", CSF_blendImage),
      C_METHOD_ENTRY_X("drawImage", CSF_drawImage),

      C_METHOD_ENTRY_X("lineWidth", CSF_lineWidth),

      C_METHOD_ENTRY_X("lineColor", CSF_lineColor),
      C_METHOD_ENTRY_X("lineLinearGradient", CSF_strokeLinearGradient),
      C_METHOD_ENTRY_X("lineRadialGradient", CSF_strokeRadialGradient),
      C_METHOD_ENTRY_X("noLine", CSF_noStroke),

      // synonyms
      C_METHOD_ENTRY_X("strokeWidth", CSF_lineWidth),
      C_METHOD_ENTRY_X("strokeColor", CSF_lineColor),
      C_METHOD_ENTRY_X("strokeLinearGradient", CSF_strokeLinearGradient),
      C_METHOD_ENTRY_X("strokeRadialGradient", CSF_strokeRadialGradient),
      C_METHOD_ENTRY_X("noStroke", CSF_noStroke),
      C_METHOD_ENTRY_X("strokeJoin", CSF_strokeJoin),
      C_METHOD_ENTRY_X("strokeCap", CSF_strokeCap),
      C_METHOD_ENTRY_X("strokeDash", CSF_strokeDash),

      C_METHOD_ENTRY_X("fillColor", CSF_fillColor),
      C_METHOD_ENTRY_X("fillLinearGradient", CSF_fillLinearGradient),
      C_METHOD_ENTRY_X("fillRadialGradient", CSF_fillRadialGradient),
      C_METHOD_ENTRY_X("fillImage", CSF_fillImage),
      C_METHOD_ENTRY_X("fillEvenOdd", CSF_fillEvenOdd),
      C_METHOD_ENTRY_X("noFill", CSF_noFill),

      C_METHOD_ENTRY_X("rotate", CSF_rotate),
      C_METHOD_ENTRY_X("scale", CSF_scale),
      C_METHOD_ENTRY_X("translate", CSF_translate),
      C_METHOD_ENTRY_X("skew", CSF_skew),
      C_METHOD_ENTRY_X("transform", CSF_transform),

      C_METHOD_ENTRY_X("screenToWorld", CSF_screenToWorld),
      C_METHOD_ENTRY_X("worldToScreen", CSF_worldToScreen),

      /*C_METHOD_ENTRY_X( "beginPath"                ,CSF_beginPath  ),
      C_METHOD_ENTRY_X( "moveTo"                   ,CSF_moveTo  ),
      C_METHOD_ENTRY_X( "lineTo"                   ,CSF_lineTo  ),
      C_METHOD_ENTRY_X( "hlineTo"                  ,CSF_hlineTo  ),
      C_METHOD_ENTRY_X( "vlineTo"                  ,CSF_vlineTo  ),
      C_METHOD_ENTRY_X( "arcTo"                    ,CSF_arcTo  ),
      C_METHOD_ENTRY_X( "ellipseTo"                ,CSF_ellipseTo  ),
      C_METHOD_ENTRY_X( "quadraticCurveTo"         ,CSF_quadricCurveTo  ),
      C_METHOD_ENTRY_X( "bezierCurveTo"            ,CSF_cubicCurveTo  ),
      C_METHOD_ENTRY_X( "closePath"                ,CSF_closePath  ),
      */
      C_METHOD_ENTRY_X("drawPath", CSF_drawPath),
      C_METHOD_ENTRY_X("drawText", CSF_drawText),

      // C_METHOD_ENTRY_X( "font",                   CSF_font  ),
      // C_METHOD_ENTRY_X( "text",                   CSF_text  ),
      // C_METHOD_ENTRY_X( "textAlignment",          CSF_textAlignment  ),
      // C_METHOD_ENTRY_X( "textWidth",              CSF_textWidth  ),

      C_METHOD_ENTRY_X("save", CSF_save),
      C_METHOD_ENTRY_X("restore", CSF_restore),

      C_METHOD_ENTRY_X("antialiasing", CSF_antialiasing),

      C_METHOD_ENTRY_X("fonts", CSF_fonts),
      C_METHOD_ENTRY_X("commit", CSF_commit),

      C_METHOD_ENTRY_X("pushLayer", CSF_pushLayer),
      C_METHOD_ENTRY_X("popLayer", CSF_popLayer),

      // C_METHOD_ENTRY_X( "pointInPolygon",         CSF_pointInPolygon  ),

      C_METHOD_ENTRY_X(0, 0)};

  /* properties */
  static vp_method properties[] = {
      VP_METHOD_ENTRY_X("lineJoin", CSF_get_lineJoin, CSF_set_lineJoin),
      VP_METHOD_ENTRY_X("lineCap", CSF_get_lineCap, CSF_set_lineCap),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  // ===================================================
  // Path object
  // ===================================================

  static value CSF_path_ctor(xvm *c) {
    value   val;
    wchars  svg_d;

    CsParseArguments(c, "V=*|S#", &val, c->pathDispatch,&svg_d.start, &svg_d.length);

    handle<gool::path> b = app()->create_path();
    b->reset();
    b->add_ref();
    CsSetCObjectValue(val, b);
    CsCtorRes(c) = val;

    if (!!svg_d) {
      if (!html::parse_d_path(b, svg_d))
        CsThrowKnownError(c, CsErrGenericError, "wrong path initialization format");
    }

    return val;
  }

  static value CSF_path_moveTo(xvm *c) {
    value  obj;
    bool   rel = false;
    pointf p;
    CsParseArguments(c, "V=*ff|B", &obj, c->pathDispatch, &p.x, &p.y, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->move_to(p, rel); }
    return obj;
  }

  static value CSF_path_lineTo(xvm *c) {
    value  obj;
    bool   rel = false;
    pointf p;
    CsParseArguments(c, "V=*ff|B", &obj, c->pathDispatch, &p.x, &p.y, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->line_to(p, rel); }
    return obj;
  }

  static value CSF_path_hlineTo(xvm *c) {
    value obj;
    bool  rel = false;
    float x;
    CsParseArguments(c, "V=*f|B", &obj, c->pathDispatch, &x, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->hline_to(x, rel); }
    return obj;
  }

  static value CSF_path_vlineTo(xvm *c) {
    value obj;
    bool  rel = false;
    float y;
    CsParseArguments(c, "V=*f|B", &obj, c->pathDispatch, &y, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->vline_to(y, rel); }
    return obj;
  }

  static value CSF_path_arcTo(xvm *c) {
    value  obj;
    bool   rel = false;
    pointf p1, p2;
    float  radius;
    CsParseArguments(c, "V=*fffff|B", &obj, c->pathDispatch, &p1.x, &p1.y,
                     &p2.x, &p2.y, &radius, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->circ_arc_to(p1, p2, radius, rel); }
    return obj;
  }

  static value CSF_path_arc(xvm *c) {
    value  obj;
    pointf center;
    sizef  radius;
    float  start;
    float  swipe;
    if (CsArgCnt(c) == 7) {
      float  r;
      CsParseArguments(c, "V=*fffff", &obj, c->pathDispatch, &center.x, &center.y, &r, &start, &swipe);
      radius = r;
    }
    else
      CsParseArguments(c, "V=*ffffff", &obj, c->pathDispatch, &center.x, &center.y, &radius.x, &radius.y, &start, &swipe);
    gool::path *pt = path_ptr(obj);
    if (pt) pt->arc(center, radius, start, swipe, false);
    return obj;
  }


  static value CSF_path_quadricCurveTo(xvm *c) {
    value  obj;
    bool   rel = false;
    pointf p, c0;
    CsParseArguments(c, "V=*ffff|B", &obj, c->pathDispatch, &c0.x, &c0.y, &p.x,
                     &p.y, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->quadratic_to(p, c0, rel); }
    return obj;
  }

  static value CSF_path_cubicCurveTo(xvm *c) {
    value  obj;
    bool   rel = false;
    pointf p, c1, c2;
    CsParseArguments(c, "V=*ffffff|B", &obj, c->pathDispatch, &c1.x, &c1.y,
                     &c2.x, &c2.y, &p.x, &p.y, &rel);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->cubic_to(p, c1, c2, rel); }
    return obj;
  }


  static value CSF_path_combine(xvm *c) {
    value obj;
    value sym, other;

    CsParseArguments(c, "V=*V=V=", &obj, c->pathDispatch, &sym,
                     &CsSymbolDispatch, &other, c->pathDispatch);
    gool::path *pt      = path_ptr(obj);
    gool::path *ptother = path_ptr(other);
    if (pt && ptother) {
      static value symbols[4] = {
          CsSymbolOf(WCHARS("union")),
          CsSymbolOf(WCHARS("intersect")),
          CsSymbolOf(WCHARS("xor")),
          CsSymbolOf(WCHARS("exclude")),
      };

      int n = items_of(symbols).index_of(sym);
      if (n < 0) CsThrowKnownError(c, CsErrValueError, sym);

      handle<gool::path> r =  pt->combine(gool::path::COMBINE_MODE(n), ptother);
      if (!r) return NULL_VALUE;

      r->add_ref();
      return CsMakeCPtrObject(c, c->pathDispatch, (void *)r.ptr());
    }
    return NULL_VALUE;
  }

  static value CSF_path_reset(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->pathDispatch);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->reset(); }
    return obj;
  }

  static value CSF_path_bounds(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->pathDispatch);
    gool::path *pt = path_ptr(obj);
    if (pt) { 
      auto rc = pt->bounds();
      CS_RETURN4(c, CsMakeFloat(rc.left()), CsMakeFloat(rc.top()), CsMakeFloat(rc.right()), CsMakeFloat(rc.bottom()));
    }
    return UNDEFINED_VALUE;
  }


  static value CSF_path_close(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->pathDispatch);
    gool::path *pt = path_ptr(obj);
    if (pt) {
      pt->close();
      // path_cmd_stop
    }
    return obj;
  }

  static value CSF_path_isPointInside(xvm *c) {
    value  obj;
    pointf p;
    CsParseArguments(c, "V=*ff", &obj, c->pathDispatch, &p.x, &p.y);
    gool::path *pt = path_ptr(obj);
    if (pt) { return pt->is_inside(p) ? TRUE_VALUE : FALSE_VALUE; }
    return UNDEFINED_VALUE;
  }

  static value CSF_path_fillEvenOdd(xvm *c) {
    value obj;
    bool  even_odd = false;
    CsParseArguments(c, "V=*B", &obj, c->pathDispatch, &even_odd);
    gool::path *pt = path_ptr(obj);
    if (pt) { pt->set_even_odd(even_odd); }
    return UNDEFINED_VALUE;
  }

  static value CSF_path_last(xvm *c, value obj) {
    gool::path *pt = path_ptr(obj);
    if (!pt) return UNDEFINED_VALUE;
    gool::pointf pos = pt->lastp();
    if (!pt->is_empty()) 
      CS_RETURN2(c, CsMakeFloat(pos.x), CsMakeFloat(pos.y));
    return UNDEFINED_VALUE;
  }

  void destroy_path_ctl(xvm *c, value obj);

  static value CSF_path_destroy(xvm *c) {
    value obj;
    CsParseArguments(c, "V=", &obj, c->pathDispatch);
    destroy_path_ctl(c, obj);
    return UNDEFINED_VALUE;
  }

  /* Path methods */
  static c_method path_methods[] = {
      C_METHOD_ENTRY_X("this", CSF_path_ctor),
      C_METHOD_ENTRY_X("reset", CSF_path_reset),
      C_METHOD_ENTRY_X("moveTo", CSF_path_moveTo),
      C_METHOD_ENTRY_X("lineTo", CSF_path_lineTo),
      C_METHOD_ENTRY_X("hlineTo", CSF_path_hlineTo),
      C_METHOD_ENTRY_X("vlineTo", CSF_path_vlineTo),
      C_METHOD_ENTRY_X("arcTo", CSF_path_arcTo),
      C_METHOD_ENTRY_X("arc", CSF_path_arc),
      C_METHOD_ENTRY_X("quadraticCurveTo", CSF_path_quadricCurveTo),
      C_METHOD_ENTRY_X("bezierCurveTo", CSF_path_cubicCurveTo),
      C_METHOD_ENTRY_X("fillEvenOdd", CSF_path_fillEvenOdd),
      C_METHOD_ENTRY_X("close", CSF_path_close),
      C_METHOD_ENTRY_X("isPointInside", CSF_path_isPointInside),
      C_METHOD_ENTRY_X("combine", CSF_path_combine),
      C_METHOD_ENTRY_X("bounds", CSF_path_bounds),

      C_METHOD_ENTRY_X("destroy", CSF_path_destroy),

      C_METHOD_ENTRY_X(0, 0)};

  /* Path properties */
  static vp_method path_properties[] = {
      VP_METHOD_ENTRY_X( "last",     CSF_path_last, 0 ),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  void destroy_path_ctl(xvm *c, value obj) {
    gool::path *b = path_ptr(obj);
    CsSetCObjectValue(obj, 0);
    b->release();
  }

  // Graphics.Text object

  static value CSF_text_ctor(xvm *c) {
    value          val;
    wchars         text(W(""), 0);
    value          styleSource = 0;
    wchars         cls;
    html::helement el;

    CsParseArguments(c, "V=*|S#|V|S#", &val, c->textDispatch, &text.start, &text.length, &styleSource, &cls.start, &cls.length);
    if (styleSource) el = element_ptr(c, styleSource);
    else el = c->current_doc();

    if (el) {
      handle<text_ctl> b = new text_ctl(el, text, cls);
      b->add_ref();
      CsSetCObjectValue(val, b);
      CsCtorRes(c) = val;
      return val;
    }
    else {
      CsThrowKnownError(c, CsErrGenericError, "wrong context, document not found");
      return UNDEFINED_VALUE;
    }
  }

  static value CSF_text_font(xvm *c, value obj) {
    text_ctl *ptext = text_ptr(obj);

    if (!ptext)
      return UNDEFINED_VALUE;

    return CsMakeString(c,ptext->tl->get_font());
  }

  static void CSF_text_set_font(xvm *c, value obj, value val) {

    if (!CsStringP(val)) val = CsToString(c, val);

    wchars font = CsStringChars(val);

    text_ctl *ptext = text_ptr(obj);

    if (ptext)
      ptext->tl->set_font(font);
  }

  static value CSF_text_style(xvm *c, value obj) {

    text_ctl *ptext = text_ptr(obj);

    if (!ptext)
      return UNDEFINED_VALUE;

    return CsMakeString(c, ptext->tl->get_style());
  }

  static void CSF_text_set_style(xvm *c, value obj, value val) {

    if (!CsStringP(val)) val = CsToString(c, val);

    wchars style = CsStringChars(val);

    text_ctl *ptext = text_ptr(obj);

    if (ptext)
      ptext->tl->set_style(style);
  }

  static value CSF_text_class(xvm *c, value obj) {

    text_ctl *ptext = text_ptr(obj);

    if (!ptext)
      return UNDEFINED_VALUE;

    return CsMakeString(c, ptext->tl->get_class());
  }

  static void CSF_text_set_class(xvm *c, value obj, value val) {

    if (!CsStringP(val)) val = CsToString(c, val);

    wchars cls = CsStringChars(val);

    text_ctl *ptext = text_ptr(obj);

    if (ptext)
      ptext->tl->set_class(cls);
  }

  static value CSF_text_alignment(xvm *c) {

    value obj;
    if (CsArgCnt(c) == 2) // alignment():(halign,valign)
    {
      CsParseArguments(c, "V=*", &obj, c->textDispatch);
      text_ctl *ptext = text_ptr(obj);
      CS_RETURN2(c, int_value(ptext->tl->get_text_alignment()),
                    int_value(ptext->tl->get_lines_alignment()));
    } else // alignment(halign,valign)
    {
      TEXT_ALIGNMENT ha = ALIGN_DEFAULT, va = ALIGN_DEFAULT;
      CsParseArguments(c, "V=*ii", &obj, c->textDispatch, &ha, &va);
      text_ctl *ptext          = text_ptr(obj);
      ptext->tl->set_alignment(ha,va);
      return obj;
    }
  }

  static value CSF_text_width(xvm *c) {
    value obj;
    if (CsArgCnt(c) == 2) {
      CsParseArguments(c, "V=*", &obj, c->textDispatch);
      text_ctl *ptext = text_ptr(obj);
      CS_RETURN3(c, float_value(ptext->tl->width_max()),
                 float_value(ptext->tl->width_min()),
                 float_value(ptext->tl->get_box().x));
    } else {
      float w;
      CsParseArguments(c, "V=*f", &obj, c->textDispatch, &w);
      text_ctl *ptext = text_ptr(obj);
      ptext->tl->set_width(w);
      return obj;
    }
  }

  static value CSF_text_height(xvm *c) {
    value obj;
    if (CsArgCnt(c) == 2) {
      CsParseArguments(c, "V=*", &obj, c->textDispatch);
      text_ctl *ptext = text_ptr(obj);
      CS_RETURN2(c, float_value(ptext->tl->height()),
                 float_value(ptext->tl->get_box().y));
    } else {
      float h;
      CsParseArguments(c, "V=*f", &obj, c->textDispatch, &h);
      text_ctl *ptext = text_ptr(obj);
      ptext->tl->set_height(h);
      return obj;
    }
  }

  static value CSF_text_get_numLines(xvm *c, value obj) {
    text_ctl *ptext = text_ptr(obj);
    if (ptext) {
      return int_value(ptext->tl->get_lines_count());
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_text_line(xvm *c) {
    value obj;
    int_t lineNo;
    CsParseArguments(c, "V=*i", &obj, c->textDispatch, &lineNo);
    text_ctl *ptext = text_ptr(obj);
    if (uint(lineNo) < ptext->tl->get_lines_count()) {
      text_layout::line ln = ptext->tl->get_line(lineNo);
      CS_RETURN4(c, float_value(ln.y), float_value(ln.height), float_value(ln.baseline), int_value(ln.length));
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_text_get_text(xvm *c, value obj) {
    text_ctl *ptext = text_ptr(obj);
    if (ptext) { return CsMakeString(c, ptext->tl->get_text()); }
    return UNDEFINED_VALUE;
  }

  static void CSF_text_set_text(xvm *c, value obj, value val) {
    text_ctl *ptext = text_ptr(obj);
    if (!ptext) return;

    if (!CsStringP(val)) val = CsToString(c, val);

    wchars t = CsStringChars(val);

    //xview *pv = c->current_view();
    //if (pv) 
    ptext->tl->set_text(t);
  }

  void destroy_text_ctl(xvm *c, value obj) {
    text_ctl *b = text_ptr(obj);
    CsSetCObjectValue(obj, 0);
    b->release();
  }

  static value CSF_text_destroy(xvm *c) {
    value obj;
    CsParseArguments(c, "V=", &obj, c->textDispatch);
    destroy_text_ctl(c, obj);
    return UNDEFINED_VALUE;
  }

  /* Text methods */
  static c_method text_methods[] = {
      C_METHOD_ENTRY_X("this", CSF_text_ctor),
      C_METHOD_ENTRY_X("alignment", CSF_text_alignment),
      C_METHOD_ENTRY_X("width", CSF_text_width),
      C_METHOD_ENTRY_X("height", CSF_text_height),
      C_METHOD_ENTRY_X("line", CSF_text_line),
      C_METHOD_ENTRY_X("destroy", CSF_text_destroy),
      C_METHOD_ENTRY_X(0, 0)};

  /* Text properties */
  static vp_method text_properties[] = {
      VP_METHOD_ENTRY_X("lines", CSF_text_get_numLines, 0),
      VP_METHOD_ENTRY_X("chars", CSF_text_get_text, CSF_text_set_text),
      VP_METHOD_ENTRY_X("font", CSF_text_font, CSF_text_set_font),
      VP_METHOD_ENTRY_X("style", CSF_text_style, CSF_text_set_style),
      VP_METHOD_ENTRY_X("class", CSF_text_class, CSF_text_set_class),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  void destroy_gfx_ctl(xvm *c, value obj) {
    gfx_ctl *b = graphics_ptr(obj);
    CsSetCObjectValue(obj, 0);
    b->release();
  }

  void xvm::init_graphics_class() {
    graphicsDispatch = CsEnterCPtrObjectType(CsGlobalScope(this), "Graphics", methods, properties, constants);
    /* create the 'Graphics' type */
    if (!graphicsDispatch) CsInsufficientMemory(this);
    graphicsDispatch->baseType = &CsCObjectDispatch;
    graphicsDispatch->destroy  = (destructor_t)destroy_gfx_ctl;
    /* create the 'Path' type */
    value ons = this->currentNS;
    PROTECT_P(this, ons);

    this->currentNS = graphicsDispatch->obj;

    pathDispatch = CsEnterCPtrObjectType(CsGlobalScope(this), "Path",path_methods, path_properties);
    if (!pathDispatch) CsInsufficientMemory(this);
    pathDispatch->baseType = &CsCObjectDispatch;
    pathDispatch->destroy  = (destructor_t)destroy_path_ctl;

    textDispatch = CsEnterCPtrObjectType(CsGlobalScope(this), "Text",text_methods, text_properties);
    if (!textDispatch) CsInsufficientMemory(this);
    textDispatch->baseType = &CsCObjectDispatch;
    textDispatch->destroy  = (destructor_t)destroy_text_ctl;

    this->currentNS = ons;
  }

} // namespace tis
