#include "xsciter.h"
#include "xview.h"
#include "tiscript/include/cs_json.h"
#include "tiscript/include/cs_int.h"
#include "xgraphics.h"
#include "xdom.h"
#include "xmorpher.h"
#include "html/html-dom-merge.h"
//#include "cs_json.h"

/* CallSciterMethod - send a message to an obj by name */
bool CallSciterMethod(tis::VM *c, tis::value obj, const char *sname, int argc,
                      const tool::value *argv, tool::value &retval) {
  return tis::CsSendMessageByNameJSON(c, obj, sname, argc, argv, retval);
}

namespace html 
{
  uint64 node_factory(context& pv, node* pn) {
    assert(pv);
    assert(pn);
    if (!pn->is_element()) return 0;
    tis::value elobj = tis::element_object_nc(((tis::xview*)pv.pview())->vm, pn->cast<element>());
    return elobj ? CsObjectClass(elobj) : 0;
  }
}

namespace tis {
  // using namespace tis;
  // using namespace html;

  //extern value CSF_propertyAt(VM *c);

  struct vnode_protector: protector {
    vnode_protector(html::view* pv, value &val) : protector(((xview*)pv)->vm, val) {}
  };

  typedef html::morph_t<value, vnode_protector> vnode_morph;

  value       node_object(xvm *pvm, html::node *n);
  html::node *node_ptr(xvm *c, value obj);

#ifdef _DEBUG
//  static int g_counter = 0;
#endif //  _DEBUG

  value element_object(xvm *pvm, html::element *b) {
    if (!b) return NULL_VALUE;

    if (!has_object(b)) {
      b->obj = CsMakeCPtrObject(pvm, pvm->elementDispatch,
                                static_cast<html::node *>(b));
      b->add_ref();
#ifdef _DEBUG
//      ++g_counter;
//      int l_counter = g_counter;
//      if (l_counter > 2000)
//        l_counter = l_counter;
#endif //  _DEBUG
    }
#ifdef _DEBUG
    else {
      dispatch *pd = CsGetDispatch(b->obj);
      assert(pd == pvm->elementDispatch /* || pd == pvm->richtextDispatch*/);
    }
#endif
    return b->obj;
  }

  value element_object_nc(xvm *pvm, html::element *b) {
    if (!b || !has_object(b)) return 0;
    if (!is_valid_ptr_value(pvm, b->obj)) 
      b->obj = 0;
    return b->obj;
  }

  html::element *element_ptr(xvm *c, value obj) {
    dispatch *pd = CsGetDispatch(obj);
    if (pd != c->elementDispatch /*&& pd != c->richtextDispatch*/)
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj, "Element");
    html::node *n = static_cast<html::node *>(CsCObjectValue(obj));
    // b could be null if called from GCing constructor.
    // assert(b);
    if (!n) return 0;
    if (!n->is_element())
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj, "Element");
    return n->cast<html::element>();
  }

  bool CsElementP(xvm* c, value obj) {
    dispatch *pd = CsGetDispatch(obj);
    return pd == c->elementDispatch;

  }

  html::element *element_ptr_no_throw(xvm *c, value obj) {
    dispatch *pd = CsQuickGetDispatch(obj);
    if (pd != c->elementDispatch /*&& pd != c->richtextDispatch*/) return 0;
    html::node *b = static_cast<html::node *>(CsCObjectValue(obj));
    return b && b->is_element() ? b->cast<html::element>() : 0;
  }

  void destroy_element(xvm *c, value obj) {
    html::element *b = element_ptr(c, obj);
    if (b) {
      b->obj = 0;
      b->release();
    }
    CsSetCObjectValue(obj, 0);
#ifdef _DEBUG
    //--g_counter;
#endif //  _DEBUG
  }

  void object_to_attribute_bag(VM *c, value o, html::attribute_bag &atts) {

    each_property gen(c, o);
    for (value key, val; gen(key, val);) {
      string  aname;
      ustring aval;
      if (CsStringP(key))
        aname = string(CsStringChars(key));
      else if (CsSymbolP(key))
        aname = CsSymbolName(key);
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, key,
                          "attribute name must be either string or symbol");
      val = CsToString(c, val);
      if (!CsStringP(val))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, val,
                          "cannot convert attribute value to string");
      aval = CsStringAddress(val);
      atts.set(aname, aval);
    }
  }

  void object_to_attribute_bag_v(VM *c, value o, html::attribute_bag_v &atts) {

    each_property gen(c, o);
    for (value key, val; gen(key, val);) {
      string  aname;
      if (CsStringP(key))
        aname = string(CsStringChars(key));
      else if (CsSymbolP(key))
        aname = CsSymbolName(key);
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, key,
          "attribute name must be either string or symbol");
      tool::value tv = value_to_value(c, val);
      atts.set(aname, tv);
    }
  }

  //void setup_element_by_vnode(xvm* c, html::helement pe, value vnode);

  void update_element_atts_states(xview* pv, html::helement pel, tis::value vnode) {
    ElementCreatorCtx ctx(pv, vnode, pel->parent.ptr());
    ctx.b = pel;

    value vatts = CsVNodeAtts(ctx.tuple);
    //if (CsObjectP(vatts))
    ctx.set_attributes(vatts);

    value vstates = CsVNodeStates(ctx.tuple);
    if (CsObjectP(vstates))
      ctx.set_states(vstates);

    //setup_element_by_vnode(pv->vm, ctx.b, ctx.tuple);
  }


  ElementCreatorCtx::ElementCreatorCtx(xview *pxv, value velement, html::hnode parent_node) 
    : pv(pxv), gc_callback(pxv->vm) {
    tuple = velement; 
    parent = parent_node.ptr_of<html::element>();
  }

  void ElementCreatorCtx::exec_ref(value ref) {
    PROTECT(ref);
    value eobj = 0;
    if(!CsEntityMeta(c, tuple, sym_instance, eobj))
      eobj = element_object(static_cast<xvm*>(c), b);
    if(eobj)
      CsCallFunction(c->currentScope(), ref, 1, eobj);
  }

  bool CsSetElementStyles(xvm *c, html::helement self, value def);

  void ElementCreatorCtx::set_states(value vstates) {
    html::attribute_bag_v states;
    html::ui_state st;
    each_property gen(c, vstates);
    for (value key, val; gen(key, val);) {
      string  aname;
      if (CsStringP(key))
        aname = string(CsStringChars(key));
      else if (CsSymbolP(key))
        aname = CsSymbolName(key);
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, key, "attribute name must be either string or symbol");

      if (aname == CHARS("@") && CsMethodP(val)) {
        exec_ref(val);
      }
      else if (aname == CHARS("style")) {
        if( !CsObjectP(val) )
          CsThrowKnownError(c, CsErrUnexpectedTypeError, val, "style object");
        CsSetElementStyles(static_cast<xvm*>(c), b, val);
      }
      else if (aname != CHARS("value") && !html::parse_state_flag(aname, st)) // if that is not a state flag
      {
        value bobj = element_object(static_cast<xvm*>(c), b);
        CsSetProperty(c, bobj, key, val);
      }
      else {
        tool::value tv = value_to_value(c, val);
        states.set(aname, tv);
      }
    }
    b->set_states(states, pv,true);
  }

  void ElementCreatorCtx::set_attributes(value vatts) {
    
    html::attribute_bag   atts;
        
    if (CsObjectP(vatts)) {
      each_property gen_atts(c, vatts);
      for (value key, val; gen_atts(key, val);) {
        /*ustring attr_name = value_to_string(key);
        if (CsMethodP(val) && attr_name().starts_with(WCHARS("on-"))) { - not clear who will unsubscribe it
          ustring ename = attr_name;
          //assert(ename().starts_with(WCHARS("on-")));
          value obj = element_object(c, b);
          CsEventObjectAdd(c, obj, val, ename()(3));
        }
        else*/
        if (!CsPrimitiveValueP(c, val)) {
          continue; // skip non-primitive values - functions, objects
        }
        else {
          string  aname = value_to_string(key);
          ustring aval;

          if (val != NULL_VALUE && val != UNDEFINED_VALUE) {
            /*val = CsToString(c, val);
            if (!CsStringP(val))
              CsThrowKnownError(c, CsErrUnexpectedTypeError, val,
                "cannot convert attribute value to string");
            aval = CsStringChars(val);*/
            string_stream s;
            CsToString(c, val, s);
            aval = s.to_ustring();
          }
          //if(pv)
          //  b->set_attr(*pv,aname, aval);
          //else
          //  b->atts.set(aname, aval);
          atts.set(aname, aval);
        }
      }
    }

    b->set_attributes(atts, pv);

  }

  void ElementCreatorCtx::crack_item(value item, array<html::hnode>& list, int at) {
    //dispatch* pdi = CsGetDispatch(item);
    if (item == NULL_VALUE || item == UNDEFINED_VALUE)
      return;
    else if (CsVectorP(item)) {
PROCESS_CHILDREN:
      value children = item;
      PROTECT(children); //??
      for (int i = 0; i < CsVectorSize(c, children); ++i) {
        value vchild = CsVectorElement(c, children, i);
        crack_item(vchild, list, i);
      }
    }
    else if (CsObjectP(item) && at == 0) {
      set_attributes(item);
    }
    else if (CsObjectP(item) && at != 0) {
      set_states(item);
    }
    else if (CsStringP(item)) {
      list.push(new html::text(CsStringChars(item)));
    }
    else if (CsTupleP(item)) {
      ElementCreatorCtx ctx(pv, item, b);
      html::helement child = ctx.make();
      if (child)
        list.push(child);
      else if (CsVectorP(ctx.tuple)) {
        //crack_item(ctx.tuple, list, at);
        item = ctx.tuple;
        goto PROCESS_CHILDREN;
      }
    }
    else if (CsElementP(static_cast<xvm*>(c), item)) {
      list.push(element_ptr(static_cast<xvm*>(c), item));
    }
    else if (CsMethodP(item)) {
    }
    else if (item == FALSE_VALUE || item == UNDEFINED_VALUE || item == NOTHING_VALUE) {
    }
    else {
      value str = CsToString(c, item);
      if (CsStringP(str))
        list.push(new html::text(CsStringChars(str)));
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, item, "object, tuple or string");
    }
  }

  html::document* ElementCreatorCtx::pdoc() const  { 
    return nullptr; 
  }
  html::view* ElementCreatorCtx::pview() const {
    return pv; 
  }

  void ElementCreatorCtx::on_GC(VM *c) {
    if (tuple)
      tuple = CsCopyValue(c, tuple);
    if(b && b->obj)
      b->obj = CsCopyValue(c, b->obj);
    for (auto& n : nodes) {
      if(n->obj)
        n->obj = CsCopyValue(c, n->obj);
    }
  }

  html::helement ElementCreatorCtx::make()
  {
    html::hnode hn;

    //TRY{

    tuple = node_element_expand(*this, tuple, hn, parent);
   
    if (!CsVNodeP(tuple))
      return nullptr;

    if (!hn) {
      string tagname = value_to_string(CsTupleName(tuple));

      if (tagname.length() == 0)
        CsThrowKnownError(c, CsErrGenericError, "undefined tag name");

      b = new html::element(html::tag::symbol(tagname));
    }
    else {
      b = hn.ptr_of<html::element>();
    }
    //setup_element_by_vnode(pv->vm, b, tuple);

    //array<html::hnode> nodes;

    for (int n = 0; n < CsTupleSize(tuple); ++n) {
      value item = CsTupleElement(tuple, n);
      crack_item(item, nodes, n);
    }

    b->insert_nodes(0, nodes());

    return b;
  }

  value CSF_extend(xvm *c) {
    value obj, other = 0, deep = 0;
    //CsParseArguments(c, "V=*V", &obj, &CsObjectDispatch, &deep);
    CsParseArguments(c, "V=*V", &obj, c->elementDispatch, &deep);

    PROTECT(obj, other);
    int i = 3;
    if (deep == TRUE_VALUE) i = 4;

    for (; i <= c->argc; ++i) {
      other = CsGetArg(c, i);
      if (!CsDerivedFromObjectP(other))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, other, "object");
      obj = CsExtendObject(c, obj, other, deep == TRUE_VALUE);
    }
    return obj;
  }


  static value CSF_create(xvm *c) {
    value obj = 0; // template object
    CsParseArguments(c, "**V=", &obj, &CsTupleDispatch);

    ElementCreatorCtx ctx(c->current_view(), obj, c->current_doc());

    tool::handle<html::element> b = ctx.make();
    if (b) {
      b->add_ref();
      return b->obj = CsMakeCPtrObject(c, c->elementDispatch,
                                       static_cast<html::node *>(b));
    }
    return NULL_VALUE;
  }

  /* method handlers */
  static value CSF_ctor(xvm *c) {
    string tagname;
    wchars text;
    value  tag, val;
    value  p1 = 0, p2 = 0;

    // CsParseArguments(c,"V=*V|S",&val,c->elementDispatch,&tag,&text);
    CsParseArguments(c, "V=*V|V|V", &val, c->elementDispatch, &tag, &p1, &p2);

    if (CsStringP(tag))
      tagname = string(CsStringChars(tag));
    else if (CsSymbolP(tag))
      tagname = CsSymbolName(tag);
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                        "tagname must be either string or symbol or object");

    html::attribute_bag         ab;
    tool::handle<html::element> b =
        new html::element(html::tag::symbol(tagname));

    if (p1) {
      if (CsStringP(p1))
        text = CsStringChars(p1);
      else if (CsObjectP(p1))
        object_to_attribute_bag(c, p1, ab);
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p1,
                          "either text or attributes expected");
      if (p2) {
        if (CsStringP(p2))
          text = CsStringChars(p2);
        else
          CsThrowKnownError(c, CsErrUnexpectedTypeError, p2,
                            "text must be of type string");
      }
    }

    if (*text) {
      handle<html::text> tel = new html::text(text);
      b->append(tel);
    }
    b->parent = c->current_doc();
    b->add_ref();
    b->obj  = val;
    b->atts = ab;
    CsSetCObjectValue(val, static_cast<html::node *>(b));
    CsCtorRes(c) = val;
    return val;
  }

  value CSF_createElement(xvm *c) {
    string tagname;
    wchars text;
    value  tag;
    value  p1 = 0, p2 = 0;

    CsParseArguments(c, "**V|V|V", &tag, &p1, &p2);

    if (CsStringP(tag))
      tagname = string(CsStringChars(tag));
    else if (CsSymbolP(tag))
      tagname = CsSymbolName(tag);
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                        "tagname must be either string or symbol or object");

    html::attribute_bag         ab;
    tool::handle<html::element> b =
        new html::element(html::tag::symbol(tagname));

    if (p1) {
      if (CsStringP(p1))
        text = CsStringChars(p1);
      else if (CsObjectP(p1))
        object_to_attribute_bag(c, p1, ab);
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, p1,
                          "either text or attributes expected");
      if (p2) {
        if (CsStringP(p2))
          text = CsStringChars(p2);
        else
          CsThrowKnownError(c, CsErrUnexpectedTypeError, p2,
                            "text must be of type string");
      }
    }

    if (*text) {
      handle<html::text> tel = new html::text(text);
      b->append(tel);
    }
    b->parent = c->current_doc();
    return element_object(c, b);
  }

  /*static value CSF_close(xvm *c)
  {
    hsmile_view *v;
    CsParseArguments(c,"P=*",&v,c->element_type);
    return UNDEFINED_VALUE;
  }*/

  static value CSF_root(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::element *d = self->doc();
    return element_object(c, d);
  }

  static value CSF_view(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    xview *pv = static_cast<xview *>(self->pview());
    if (pv) return pv->view_obj.val;
    return NULL_VALUE;
  }

  // root [global] namespace object
  static value CSF_root_ns(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::document *pd = self->doc();
    if (pd) return pd->ns;
    return NULL_VALUE;
    // return element_object_nc(c, self);
  }

  // get options container, defined for <select> & <select|dropdown>
  static value CSF_options(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    self->get_style();

    html::element *optc = 0;

    self->each_behavior([&](html::ctl *pc) -> bool {
      optc = pc->get_options_container(self);
      return optc != nullptr;
    });
    return optc ? element_object(c, optc) : UNDEFINED_VALUE;
  }

  static value CSF_tag_name(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    ustring name = html::tag::symbol_name(self->tag);
    return string_to_value(c, name);
  }

  static void CSF_set_tag_name(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) return;

    if (!CsStringP(val)) val = CsToString(c, val);

    string tag = CsStringChars(val);

    pv->add_to_update(self, html::CHANGES_MODEL);

    self->tag = html::tag::symbol(tag);

    pv->add_to_update(self, html::CHANGES_MODEL);
    // self->set_text(*pv, t );
  }

  static value CSF_id(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return string_to_value(c, self->attr_id());
  }

  static value CSF_uid(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return CsMakeInteger(self->uid);
  }

  static value CSF_parent(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    if (!self->is_connected())
      return NULL_VALUE;
    html::element *b = self->parent;
    return element_object(c, b);
  }

  static value CSF_layoutParent(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    html::view *pv = self->pview();
    if (!pv) return NULL_VALUE;

    html::element *b = self->layout_parent(*pv);

    return element_object(c, b);
  }

  static value CSF_owner(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    //html::view *pv = self->pview();
    //if (!pv) return NULL_VALUE;

    /*html::element *b = nullptr;
    if (self->state.popup()) // popup elements inherit some of styles from their
                             // anchors
      b = pv->popup_anchor(self);
    else 
      b = self->get_owner();

    */
    html::element *b = self->get_event_owner();
    return b ? element_object(c, b) : NULL_VALUE;
  }

  static void CSF_set_owner(xvm *c, value obj, value objowner) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;

    html::element *owner = nullptr;
    if (objowner != NULL_VALUE)
    {
      owner = element_ptr(c, objowner);
      if (!owner)
        CsThrowKnownError(c, CsErrUnexpectedTypeError, objowner, "connected DOM element");

      if (owner->belongs_to(self, true) || self->belongs_to(owner))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, objowner, "DOM element outside of these element");
    }
    if(!self->set_event_owner(owner))
      CsThrowKnownError(c, CsErrUnexpectedTypeError, objowner, "connected DOM element");

  }


  static value CSF_next(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::element *n = self->next_element();
    if (!n) return NULL_VALUE;
    return element_object(c, n);
  }

  static value CSF_first(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::element *n = self->first_element();
    if (!n) return NULL_VALUE;
    // assert(n->index() == 0);
    return element_object(c, n);
  }

  static value CSF_last(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::element *n = self->last_element();
    if (!n) return NULL_VALUE;
    return element_object(c, n);
  }

  static value CSF_prior(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::element *n = self->prev_element();
    if (!n) return NULL_VALUE;
    return element_object(c, n);
  }

  static value CSF_index(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return CsMakeInteger(self->index());
  }

  static value CSF_html(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::ostream_w os;
    self->emit_content(os);
    return CsMakeString(c, os.data());
  }

  
  static void CSF_set_html(xvm *c, value obj, value value) {
    html::helement self = element_ptr(c, obj);
    if (!self) return;

    string  utf;
    ustring us;

    // bool    CsFileP(VM *c, value o);
    // inline  stream* CsFileStream(value o)           { return (stream
    // *)CsCObjectValue(o); }

    if (CsFileP(c, value)) {
      stream *           s = CsFileStream(value);
      tool::array<wchar> buf;
      s->get_content(buf);
      tool::array<byte> buf8;
      u8::from_utf16(buf.head(), buf.size(), buf8);
      utf = tool::string((const char *)buf8.head(), buf.size());
    } else if (CsStringP(value)) {
      ustring us = value_to_string(value);
      utf        = u8::cvt(us);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, value, "html string");

    html::hdocument pd     = self->doc();
    if (!pd) pd = c->current_doc();
    html::view *    pv     = nullptr;
    bool            result = false;

    if (!pd) goto NOT_IN_DOM;

    pv = pd->pview();
    if (!pv) goto NOT_IN_DOM;

    self->allow_reconciliation(false);
    result = pv->set_element_html(self, utf.chars_as_bytes(), html::SE_REPLACE);
    assert(result);
    result = result;
    return;
  NOT_IN_DOM:
    CsThrowKnownError(c, CsErrGenericError,
                      "The element is not attached to the DOM");
  }

  static value CSF_outer_html(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    // array<wchar> data;
    html::ostream_w os;
    self->emit(os);
    return CsMakeString(c, os.data());
  }

  static void CSF_set_outer_html(xvm *c, value obj, value value) {
    handle<html::element> self = element_ptr(c, obj);
    if (!self) return;

    ustring us;

    if (CsFileP(c, value)) {
      stream *           s = CsFileStream(value);
      tool::array<wchar> buf;
      s->get_content(buf);
      us = buf();
    } else if (CsStringP(value)) {
      us = value_to_string(value);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, value, "html string");

    html::document *pd = self->doc();
    if (!pd) return;

    html::view *pv = self->pview();
    if (!pv) return;

    html::helement el = self;
    bool result       = pv->set_element_html(el, us(), html::SE_OUTER_REPLACE);
    assert(result);
    result = result;
  }

  static value CSF_parseHtml(xvm *c) {
    value obj;
    value what;
    CsParseArguments(c, "V=*V", &obj, c->elementDispatch, &what);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    string utf;

    if (CsFileP(c, what)) {
      stream *           s = CsFileStream(what);
      tool::array<wchar> buf;
      s->get_content(buf);
      tool::array<byte> buf8;
      u8::from_utf16(buf(), buf8);
      utf = tool::string((const char *)buf8.head(), buf.size());
    } else if (CsStringP(what)) {
      ustring us = value_to_string(what);
      if (us.like(W("file://*"))) {
        tool::mm_file f;
        if (f.open(us))
          utf = f.bytes();
        else
          utf = u8::cvt(us);
      } else
        utf = u8::cvt(us);
    }
    else if (CsByteVectorP(what)) {
      utf = CsByteVectorBytes(what);
    }
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, what, "html string");

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    html::document *       thisdoc = self->doc();
    handle<html::document> nd = new html::document(thisdoc->uri().src);
    nd->flags.is_synthetic    = true;
    nd->pview(pv);
    html::istream m(utf, thisdoc->uri().src, pv->debug_mode());
    m.set_utf8_encoding();

    auto r = parse_html(*pv, m, nd);

    if (r.full_document)
      return element_object(c, r.content[0].ptr_of<html::element>());

    slice<html::hnode> new_nodes = r.content();

    nd->clear();

    value arr = 0, nel = 0;
    PROTECT(arr, nel);

    array<html::helement> new_elements;
    for (int i = 0; i < new_nodes.size(); ++i) {
      html::node *pn = new_nodes[i];
      if (!pn->is_element())
        goto MAKE_NODES;
      else {
        // assert(pn->cast<html::element>()->c_style ==
        // html::element::null_style);
        new_elements.push(pn->cast<html::element>());
      }
    }
    // MAKE_ELEMENTS:
    arr = CsMakeVector(c, new_elements.size(), c->elementListObject);
    for (int i = 0; i < new_elements.size(); ++i) {
      html::element *n   = new_elements[i];
      nel = element_object(c, n);
      CsSetVectorElement(c, arr, i, nel);
    }
    return arr;
  MAKE_NODES:
    arr = CsMakeVector(c, new_nodes.size(), c->nodeListObject);
    for (int i = 0; i < new_nodes.size(); ++i) {
      html::node *n = new_nodes[i];
      nel           = node_object(c, n);
      CsSetVectorElement(c, arr, i, nel);
    }
    return arr;
  }

  static value CSF_patch(xvm *c, html::helement el, value vnode, bool only_children) {
    html::morph_options opts;
    opts.children_only = only_children;
    html::document_context dc(el);
    html::helement res = vnode_morph::exec(dc, el, vnode, &opts);
    if (res) 
      return element_object(c, res);
    return NULL_VALUE;
  }
  
  static value CSF_merge(xvm *c) {
    value obj = 0;
    value what = 0;
    value callback = 0;
    value how = 0;
    CsParseArguments(c, "V=*V|V|V", &obj, c->elementDispatch, &what, &callback, &how);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    static value only_children = CsSymbolOf(WCHARS("only-children"));

    if (callback == only_children) {
      how = callback;
      callback = 0;
    }

    //dispatch *pd = CsGetDispatch(what);
    //if (pd != c->elementDispatch)
    if (CsTupleP(what))
      return CSF_patch(c, self, what, how == only_children);
    else if(!CsElementP(c,what))
      CsThrowKnownError(c, CsErrUnexpectedTypeError, what, "Element");
    
    html::element *other = element_ptr(c, what);

    if (!callback) {
      html::morph_options opts;
      opts.children_only = how == only_children;
      html::document_context dc(self);
      html::helement res = html::morph::exec(dc, self, other, &opts);
      if (res)
        return element_object(c, res);
    }
    else if(CsMethodP(callback)) {

      struct options : public html::morph_options {
        xvm *c;
        value obj = 0;
        value callback = 0;

        virtual bool change_text(html::text* node, wchars to_text) override { 
          static value sym = CsSymbolOf(WCHARS("change-text"));
          value vnode = 0;
          PROTECT(vnode, obj, callback);
          vnode = node_object(c, node);
          value r = CsCallMethod(c, obj, callback, obj, 3, sym, vnode, CsMakeString(c,to_text));
          return r != FALSE_VALUE; 
        }
        virtual bool remove_node(html::node* old_node) override {
          static value sym = CsSymbolOf(WCHARS("remove-node"));
          value vnode = 0;
          PROTECT(vnode, obj, callback);
          vnode = node_object(c, old_node);
          value r = CsCallMethod(c, obj, callback, obj, 2, sym, vnode);
          return r != FALSE_VALUE;
        }
        virtual bool insert_node(html::node* el, int index, html::node* node) override {
          static value sym = CsSymbolOf(WCHARS("insert-node"));
          value vnode = 0;
          value velement = 0;
          PROTECT(velement, vnode, obj, callback);
          vnode = node_object(c, node);
          velement = node_object(c, el);
          value r = CsCallMethod(c, obj, callback, obj, 4, sym, velement, CsMakeInteger(index), vnode);
          return r != FALSE_VALUE;
        }
        virtual bool reposition_node(html::node* el, int index, html::node* node) override {
          static value sym = CsSymbolOf(WCHARS("reposition-node"));
          value vnode = 0;
          value velement = 0;
          PROTECT(velement, vnode, obj, callback);
          vnode = node_object(c, node);
          velement = node_object(c, el);
          value r = CsCallMethod(c, obj, callback, obj, 4, sym, velement, CsMakeInteger(index), vnode);
          return r != FALSE_VALUE;
        }
        virtual bool replace_node(html::node* old_node, html::node* by_node) override {
          static value sym = CsSymbolOf(WCHARS("replace-node"));
          value voldnode = 0;
          value vnewnode = 0;
          PROTECT(voldnode, vnewnode, obj, callback);
          voldnode = node_object(c, old_node);
          vnewnode = node_object(c, by_node);
          value r = CsCallMethod(c, obj, callback, obj, 3, sym, voldnode, vnewnode);
          return r != FALSE_VALUE;
        }
        virtual bool update_atts(html::node* of, const html::attribute_bag& from)  override {
          static value sym = CsSymbolOf(WCHARS("update-attributes"));
          value voldnode = 0;
          value vnewnode = 0;
          PROTECT(voldnode, vnewnode, obj, callback);
          voldnode = node_object(c, of);
          //vnewnode = node_object(c, from);
          //value r = CsCallMethod(c, obj, callback, obj, 3, sym, voldnode, vnewnode);
          value r = CsCallMethod(c, obj, callback, obj, 2, sym, voldnode);
          return r != FALSE_VALUE;
        }
      };

      options cb;
      cb.children_only = how == only_children;
      cb.c = c;
      cb.callback = callback;
      cb.obj = obj;

      html::document_context dc(self);

      html::helement res = html::morph::exec(dc, self, other, &cb);
      if (res)
        return element_object(c, res);
    }
    
    return NULL_VALUE;
  }

  /*
  static value CSF_first_child(xvm *c,value obj)
  {
    html::element* self = element_ptr(c,obj);
    if( !self )
      return undefinedValue;
    if(self->subs.size() == 0)
      return undefinedValue;
    return element_object(c,self->subs[0]);
  }

  static value CSF_last_child(xvm *c,value obj)
  {
    html::element* self = element_ptr(c,obj);
    if( !self )
      return undefinedValue;
    if(self->subs.size() == 0)
      return undefinedValue;
    return element_object(c,self->subs.last());
  }
  */

  static value CSF_child_count(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return int_value(self->n_children());
  }

  /*
  static value CSF_child(xvm *c)
  {
    value obj;
    int_t idx;
    CsParseArguments(c,"V=*i",&obj,c->elementDispatch,&idx);
    html::element* self = element_ptr(c,obj);
    if( !self )
      return undefinedValue;
    if(idx < 0 || idx >= self->subs.size())
      return undefinedValue;
    return element_object(c,self->subs[idx]);
  }
  */

  extern value get_ns(html::element *b);

  static value CSF_update(xvm *c) {
    value obj;
    value how = 0;
    value params = 0;
    CsParseArguments(c, "V=*|V|V", &obj, c->elementDispatch, &how, &params);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    handle<html::view> pv = self->pview();
    if (!pv) return FALSE_VALUE;

    value ret = TRUE_VALUE;

    if (!how || how == TRUE_VALUE || how == FALSE_VALUE) {
      self->reset_styles(*pv);
      pv->to_update.update(pv);
      self->check_layout(*pv);
      self->commit_measure(*pv);
      pv->refresh(self);
      if (how == TRUE_VALUE) {
        html::iwindow *pw = self->get_window(*pv, true);
        if (pw) pw->update();
      }

    } else if (CsMethodP(how)) {

      handle<html::animated_effect> panidef;
      html::effect_animator::STATE state = html::effect_animator::FORWARD;
      if (params && CsObjectP(params)) 
      {
        double seconds = 0.2; CsGetProperty(c, params, "duration", seconds);
        ustring easef = W("linear"); CsGetProperty(c, params, "ease", easef);
        ustring effect = W("blend"); CsGetProperty(c, params, "effect", effect);
        ustring direction = W("forward"); CsGetProperty(c, params, "direction", direction);
        
        static html::enum_item_def dirs[] = {
          { html::effect_animator::FORWARD, W("forward") },
          { html::effect_animator::ROLLBACK_FORWARD, W("rollback-forward") },
          { html::effect_animator::BACKWARD, W("backward") },
          { html::effect_animator::ROLLBACK_BACKWARD, W("rollback-backward") },
        };
        enum_v dir = html::effect_animator::FORWARD;
        parse_enum(dir, direction(), dirs);

        panidef = new html::animated_effect();
        panidef->easef = html::ease::get_ease_func(tool::value(easef));
        parse_effect_type(effect, panidef->etype);
        panidef->duration = uint(seconds * 1000);

        state = (html::effect_animator::STATE)dir.val(html::effect_animator::FORWARD);
        
        if (!panidef->easef || !panidef->duration || !panidef->etype)
          panidef = nullptr;
      }

      auto worker = [&c, how, &ret](html::view &v, html::element *el) -> bool {
        TRY {
          ret = CsCallMethod(c, el->obj, how, el->obj, 0);
          return true;
        }
        CATCH_ERROR(e) {
          if (e.number != 0) // close() called
            CsHandleUnhandledError(c);
          return false;
        }
      };
      self->animated_update(*pv, worker, panidef,state);
    }

    return ret;
  }

  static value CSF_refresh(xvm *c) {
    value obj;
    int   x = 0, y = 0, w = 0, h = 0;
    CsParseArguments(c, "V=*|IIII", &obj, c->elementDispatch, &x, &y, &w, &h);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return FALSE_VALUE;

    if (CsArgCnt(c) == 6) {
      gool::rect rc = gool::rect::normalized(point(x, y), size(w, h));
      pv->refresh(self, rc);
    } else
      pv->refresh(self);

    return TRUE_VALUE;
  }

  static value CSF_capture(xvm *c) {
    value obj;
    value mode;
    CsParseArguments(c, "V=*V", &obj, c->elementDispatch, &mode);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return FALSE_VALUE;
    if (mode == TRUE_VALUE)
      pv->set_capture(self);
    else if (mode == FALSE_VALUE)
      pv->set_capture(0);
    else if (mode == CsSymbolOf("strict"))
      pv->set_capture_strict(self);
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, mode, "boolean");

    return TRUE_VALUE;
  }

  /*uint translate_event_type( value sym, html::event_behavior& evt )
  {
    uint t = get_sym_id(sym);
    switch( t )
    {
      case id_BUTTON_CLICK            : return html::BUTTON_CLICK            ;
      case id_BUTTON_PRESS            : return html::BUTTON_PRESS            ;
      case id_BUTTON_STATE_CHANGED    : return html::BUTTON_STATE_CHANGED    ;
      case id_EDIT_VALUE_CHANGING     : return html::EDIT_VALUE_CHANGING     ;
      case id_EDIT_VALUE_CHANGED      : return html::EDIT_VALUE_CHANGED      ;
      case id_SELECT_SELECTION_CHANGED: return html::SELECT_SELECTION_CHANGED;
      case id_SELECT_STATE_CHANGED    : return html::SELECT_STATE_CHANGED    ;
    }
    evt.symbol = to_symbol(sym);
    return 0;
  }*/

  static value CSF_post(xvm *c) {
    value obj;
    value m;
    // int_t    reason = 0;
    // html::element* src_blk = 0;
    // value src = 0;

    bool only_if_not_there = false;

    CsParseArguments(c, "V=*m|B", &obj, c->elementDispatch, &m, &only_if_not_there);

    html::element *self = element_ptr(c, obj);
    if (!self) return FALSE_VALUE;
    xview *pv = (xview *)self->pview();
    if (!pv) return FALSE_VALUE;

    html::posted_event be;
    be.target = self;
    be.cbf    = m;

    pv->post_event(be, only_if_not_there);
    return UNDEFINED_VALUE;
  }

  // static value CSF_postEvent(xvm *c)
  //{
  //  value    obj;
  //  int_t    cmd = 0;
  //  int_t    reason = 0;
  //  value    src = 0;
  //  value    data = UNDEFINED_VALUE;
  //  html::element* src_blk = 0;
  //  CsParseArguments(c,"V=*i|i|V|V",&obj,c->elementDispatch,&cmd,
  //  &reason,&src,&data);
  //
  //  html::element* self = element_ptr(c,obj);
  //  if( !self )
  //    return FALSE_VALUE;
  //  html::view* pv = self->pview();
  //  if(!pv)
  //    return FALSE_VALUE;
  //
  //  if(src && src != UNDEFINED_VALUE && src != NULL_VALUE)
  //  {
  //     src_blk = element_ptr(c, src);
  //     if(!src_blk)
  //        CsThrowKnownError(c, CsErrUnexpectedTypeError, src, "Element");
  //  }
  //  else
  //     src_blk = self;
  //
  //  html::event_behavior be;
  //  be.cmd = cmd;//translate_event_type(sym, be);
  //  be.target = self;
  //  be.reason = reason;
  //  be.source = src_blk;
  //  be.data = value_to_value(c,data);
  //  pv->post_behavior_event( be );
  //  return TRUE_VALUE;
  //
  //}

  static value fire_event(xvm *c, bool immediately) {
    value          obj;
    value          src     = 0;
    value          data    = UNDEFINED_VALUE;
    html::element *src_blk = 0;

    html::subscription   sub;
    html::event_behavior be;

    if (CsIntegerP(CsGetArg(c, 3))) {
      sub.event_group = html::HANDLE_BEHAVIOR_EVENT;
      CsParseArguments(c, "V=*i|i|V|V", &obj, c->elementDispatch, &sub.event_type._v, &sub.event_reason._v, &src, &data);
    }
    else {
      wchars name;
      CsParseArguments(c, "V=*S#|V", &obj, c->elementDispatch, &name.start, &name.length, &data);
      sub.parse(name);
      be.name = name;
    }

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (src && src != UNDEFINED_VALUE && src != NULL_VALUE) {
      src_blk = element_ptr(c, src);
      if (!src_blk)
        CsThrowKnownError(c, CsErrUnexpectedTypeError, src, "Element");
    } else
      src_blk = self;

    if (sub.event_group == html::HANDLE_BEHAVIOR_EVENT) {
      be.cmd    = sub.event_type;
      be.target = self;
      be.reason = sub.event_reason;
      be.source = src_blk;
      be.data = value_to_value(c, data);
      //be.name = sub.event_name;
      if (immediately) {
        if (pv->send_behavior_event(be)) {
          if (be.data.is_defined()) return value_to_value(c, be.data);
          return TRUE_VALUE;
        }
      } else {
        pv->post_behavior_event(be);
        return TRUE_VALUE;
      }
    } else
      CsThrowKnownError(c, CsErrGenericError, "Unsupported event type");
    return FALSE_VALUE;
  }

  static value CSF_sendEvent(xvm *c) { return fire_event(c, true); }
  static value CSF_postEvent(xvm *c) { return fire_event(c, false); }

  static value CSF_sendKeyEvent(xvm *c) {
    value obj;
    value def;
    CsParseArguments(c, "V=*V=", &obj, c->elementDispatch, &def,
                     &CsObjectDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    html::event_key evt;
    evt.cmd      = CsGetProp(c, def, "type", html::KEY_DOWN);
    evt.key_code = CsGetProp(c, def, "keyCode", 0);
    bool ak      = CsGetProp(c, def, "altKey", false);
    bool ck      = CsGetProp(c, def, "ctrlKey", false);
    bool sk      = CsGetProp(c, def, "shiftKey", false);
    bool cmdk    = CsGetProp(c, def, "commandKey", false);
    bool shk     = CsGetProp(c, def, "shortcutKey", false);

    evt.alt_state = 0;
    if (ak) evt.alt_state |= html::ALT_ALT;
    if (ck) evt.alt_state |= html::ALT_CONTROL;
    if (sk) evt.alt_state |= html::ALT_SHIFT;
    if (cmdk) evt.alt_state |= html::ALT_COMMAND;
    if (shk) evt.alt_state |= html::ALT_SHORTCUT;

    evt.target = self;
    html::traverser<html::event_key> trv(*pv);
    return trv.traverse(self, evt) ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_sendMouseEvent(xvm *c) {
    value obj;
    value def;
    CsParseArguments(c, "V=*V=", &obj, c->elementDispatch, &def,
                     &CsObjectDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    html::event_mouse evt;
    evt.cmd = CsGetProp(c, def, "type", html::MOUSE_MOVE);
    bool mb = CsGetProp(c, def, "mainButton", false);
    bool pb = CsGetProp(c, def, "propButton", false);

    size delta;
    delta.x = CsGetProp(c, def, "deltaX", 0);
    delta.y = CsGetProp(c, def, "deltaY", 0);

    evt.button_state = 0;
    if (mb) evt.button_state |= html::MAIN_BUTTON;
    if (pb) evt.button_state |= html::PROP_BUTTON;
    if (!mb && !pb)
      evt.button_state = make_dword(short(delta.x), short(delta.y));

    bool ak   = CsGetProp(c, def, "altKey", false);
    bool ck   = CsGetProp(c, def, "ctrlKey", false);
    bool sk   = CsGetProp(c, def, "shiftKey", false);
    bool cmdk = CsGetProp(c, def, "commandKey", false);
    bool shk  = CsGetProp(c, def, "shortcutKey", false);

    evt.alt_state = 0;
    if (ak) evt.alt_state |= html::ALT_ALT;
    if (ck) evt.alt_state |= html::ALT_CONTROL;
    if (sk) evt.alt_state |= html::ALT_SHIFT;
    if (cmdk) evt.alt_state |= html::ALT_COMMAND;
    if (shk) evt.alt_state |= html::ALT_SHORTCUT;

    evt.pos.x    = CsGetProp(c, def, "x", 0);
    evt.pos.y    = CsGetProp(c, def, "y", 0);
    evt.pos_view = evt.pos;
    evt.target   = self;
    return pv->_traverse_mouse(self, evt) ? TRUE_VALUE : FALSE_VALUE;
  }



  static value CSF_getState(xvm *c) {
    value obj;
    uint  stateMask = 0; // only lower bits are allowed to be modified here.
    CsParseArguments(c, "V=*|i", &obj, c->elementDispatch, &stateMask);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    uint r = uint((self->get_state(true).data & stateMask) &
                  html::STATE_ONOFF_BITMASK);
    return CsMakeInteger(int(r));
  }

  static value CSF_setState(xvm *c) {
    value obj;
    uint  stateMask = 0;
    bool  update    = true;
    CsParseArguments(c, "V=*i|B", &obj, c->elementDispatch, &stateMask,
                     &update);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    // if(!pv)
    //  return UNDEFINED_VALUE;

    html::ui_state st;
    st.data = (stateMask & html::STATE_ONOFF_BITMASK);
    if (self->state.is_clear(st)) {
      if (update && pv)
        self->set_state(st, pv);
      else
        self->set_state(st, 0);
    }

    return UNDEFINED_VALUE;
  }

  static value CSF_clearState(xvm *c) {
    value obj;
    uint  stateMask = 0;
    bool  update    = true;
    CsParseArguments(c, "V=*i|B", &obj, c->elementDispatch, &stateMask,
                     &update);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();

    html::ui_state st;
    st.data = (stateMask & html::STATE_ONOFF_BITMASK);
    if (self->state.is_set(st)) {
      if (update && pv)
        self->reset_state(st, pv);
      else
        self->reset_state(st, 0);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_move(xvm *c) {
    value obj;
    point pt(INT_MIN, INT_MIN);
    size *psz = nullptr;
    size  sz;

    value p[3] = {0, 0, 0};

    bool stop_move = false;

    if (CsArgCnt(c) == 2) {
      CsParseArguments(c, "V=*", &obj, c->elementDispatch);
      stop_move = true;
    }
    else if (CsParseArguments(c, "|V=*iiii|V|V|V", &obj, c->elementDispatch, &pt.x, &pt.y, &sz.x, &sz.y, &p[0], &p[1], &p[2]))
      psz = &sz;
    else
      CsParseArguments(c, "V=*ii|V|V|V", &obj, c->elementDispatch, &pt.x, &pt.y, &p[0], &p[1], &p[2]);

#if 0
    /*else if( CsArgCnt(c) <= 5 )
    {
      value v = 0;
      CsParseArguments(c,"V=*ii|V",&obj,c->elementDispatch,&pt.x,&pt.y,&v);
      if( CsSymbolP(v) )
        relto = to_symbol(v);
      else if(CsIntegerP(v))
        ref_point = Cs
    }*/
    else if (CsArgCnt(c) <= 7 &&
             (!CsIntegerP(CsGetArg(c, 5)) || !CsIntegerP(CsGetArg(c, 6)))) {
      CsParseArguments(c, "V=*ii|V|V|V", &obj, c->elementDispatch, &pt.x, &pt.y,
                       &p[0], &p[1], &p[2]);
    } else {
      CsParseArguments(c, "V=*iiii|V|V|V", &obj, c->elementDispatch, &pt.x,
                       &pt.y, &sz.x, &sz.y, &p[0], &p[1], &p[2]);
      psz = &sz;
    }
#endif

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (stop_move) {
      // pv->refresh(self);
      // self->a_style = 0;
      // pv->add_to_update(self,true);
      pv->stop_move_element(self);
      return obj;
    }

    handle<html::element> vroot = pv->doc();
    if (!vroot) return UNDEFINED_VALUE;

    static value sym_screen = CsSymbolOf(WCHARS("screen"));
    static value sym_root   = CsSymbolOf(WCHARS("root"));
    static value sym_view   = CsSymbolOf(WCHARS("view"));
    static value sym_parent = CsSymbolOf(WCHARS("parent"));
    static value sym_self   = CsSymbolOf(WCHARS("self"));

    static value sym_attached_window = CsSymbolOf(WCHARS("attached-window"));
    static value sym_detached_window = CsSymbolOf(WCHARS("detached-window"));
    static value sym_detached_popup_window = CsSymbolOf(WCHARS("detached-topmost-window"));

    bool                      relto_seen = false;
    html::ELEMENT_WINDOW_MODE wmode      = html::ELEMENT_WINDOW_AUTO;
    int                       ref_point  = 0;

    for (int n = 0; n < 3; ++n) {
      value f = p[n];
      if (f == sym_screen && !relto_seen) {
        pt -= pv->client_screen_pos();
        relto_seen = true;
      } else if (f == sym_root && !relto_seen) {
        pt += self->doc()->view_pos(*pv);
        relto_seen = true;
      } else if (f == sym_view && !relto_seen) {
        pt         = pt;
        relto_seen = true;
      } else if (f == sym_parent && !relto_seen) {
        if (self->parent) pt += self->parent->view_pos(*pv);
        relto_seen = true;
      } else if (f == sym_self && !relto_seen) {
        pt += self->view_pos(*pv);
        relto_seen = true;
      } else if (f == sym_attached_window || f == TRUE_VALUE)
        wmode = html::ELEMENT_WINDOW_ATTACHED;
      else if (f == sym_detached_window)
        wmode = html::ELEMENT_WINDOW_DETACHED;
      else if (f == sym_detached_popup_window)
        wmode = html::ELEMENT_WINDOW_DETACHED_TOPMOST;
      else if (CsIntegerP(f))
        ref_point = CsIntegerValue(f);
    }

    pv->move_element(self, pt, psz, wmode, ref_point);
    return obj;
  }

  static value CSF_rows(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    return CsMakeInteger(self->n_rows());
  }

  static value CSF_columns(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return NULL_VALUE;
    return CsMakeInteger(self->n_cols());
  }

  static value CSF_rowy(xvm *c) {
    value obj;
    int_t row_no = 0;

    CsParseArguments(c, "V=*i", &obj, c->elementDispatch, &row_no);

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    int n_rows = self->n_rows();
    if (row_no < 0 || row_no >= n_rows) return UNDEFINED_VALUE;

    gool::range y;
    if (!self->get_row_y(row_no, y)) return UNDEFINED_VALUE;

    // CsSetRVal(c,1, CsMakeInteger( y.length() ));
    // return CsMakeInteger( y.l );
    CS_RETURN2(c, CsMakeInteger(y.s), CsMakeInteger(y.length()));
  }

  static value CSF_columnx(xvm *c) {
    value obj;
    int_t col_no = 0;

    CsParseArguments(c, "V=*i", &obj, c->elementDispatch, &col_no);

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    int n_cols = self->n_cols();
    if (col_no < 0 || col_no >= n_cols) return UNDEFINED_VALUE;

    gool::range x;
    if (!self->get_col_x(col_no, x)) return UNDEFINED_VALUE;

    // CsSetRVal(c,1, CsMakeInteger( x.length() ));
    // return CsMakeInteger( x.l );
    CS_RETURN2(c, CsMakeInteger(x.s), CsMakeInteger(x.length()));
  }

  static value CSF_row(xvm *c) {
    value obj;
    int_t row_no = 0;

    CsParseArguments(c, "V=*i", &obj, c->elementDispatch, &row_no);

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    int n_rows = self->n_rows();
    if (row_no < 0 || row_no >= n_rows) return NULL_VALUE;

    array<html::helement> elements;
    self->get_row(row_no, elements);

    value arr = CsMakeVector(c, elements.size(), c->elementListObject);
    for (int i = 0; i < elements.size(); ++i) {
      html::element *b = elements[i];
      if (b) {
        PROTECT(arr);
        value vel = element_object(c, b);
        CsSetVectorElement(c, arr, i, vel);
      }
      else
        CsSetVectorElement(c, arr, i, NULL_VALUE);
    }
    return arr;
  }

  static value CSF_column(xvm *c) {
    value obj;
    int_t col_no = 0;

    CsParseArguments(c, "V=*i", &obj, c->elementDispatch, &col_no);

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    int n_cols = self->n_cols();
    if (col_no < 0 || col_no >= n_cols) return NULL_VALUE;

    array<html::helement> elements;
    self->get_col(col_no, elements);

    value arr = CsMakeVector(c, elements.size(), c->elementListObject);
    for (int i = 0; i < elements.size(); ++i) {
      html::element *b = elements[i];
      if (b) {
        PROTECT(arr);
        value vel = element_object(c, b);
        CsSetVectorElement(c, arr, i, vel);
      }
      else
        CsSetVectorElement(c, arr, i, NULL_VALUE);
    }
    return arr;
  }

  static value CSF_removeColumns(xvm *c) {
    value obj;
    int_t col_no     = 0;
    int_t num_colums = 1;

    CsParseArguments(c, "V=*i|i", &obj, c->elementDispatch, &col_no,
                     &num_colums);

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    assert(NOT_YET);
#if NOT_YET
    if (self->element_type() == html::BLOCK_TABLE) {
      html::table *tbl = (html::table *)self.ptr();
      int          n   = 0;
      for (; n < num_colums; ++n) {
        if (col_no >= tbl->n_cols()) break;
        tbl->_remove_column_at(col_no);
      }
      if (n) {
        tbl->fixup();
        if (pv) pv->add_to_update(tbl, true);
      }
    }
#endif
    return UNDEFINED_VALUE;
  }

  static value CSF_removeRows(xvm *c) {
    value obj;
    int_t row_no   = 0;
    int_t num_rows = 1;

    CsParseArguments(c, "V=*i|i", &obj, c->elementDispatch, &row_no, &num_rows);

    handle<html::element> self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    assert(NOT_YET);
#if NOT_YET
    if (self->element_type() == html::BLOCK_TABLE) {
      html::table *tbl = (html::table *)self.ptr();
      int          n   = 0;
      for (; n < num_rows; ++n) {
        if (row_no >= tbl->n_rows()) break;
        tbl->_remove_row_at(row_no);
      }
      if (n) {
        tbl->fixup();
        if (pv) pv->add_to_update(tbl, true);
      }
    }
#endif
    return UNDEFINED_VALUE;
  }

  static value CSF_scrollToView(xvm *c) {
    value obj;
    bool  toTop   = false;
    bool  animate = true;
    CsParseArguments(c, "V=*|B|B", &obj, c->elementDispatch, &toTop, &animate);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    // pv->ensure_visible will take care about it: pv->commit_update();

    pv->ensure_visible(self, toTop,
                       animate ? html::SCROLL_SMOOTH : html::SCROLL);

    // uint r = (self->set_state(true).data & stateMask);
    // return CsMakeInteger(int(r));
    return UNDEFINED_VALUE;
  }

  static value CSF_insert_at(xvm *c, int_t index) {
    value obj   = 0;
    value src   = 0;
    bool  after = false;
    PROTECT(obj, src);

    CsParseArguments(c, "V=*V|I|B", &obj, c->elementDispatch, &src, &index,
                     &after);

    html::element *self = element_ptr(c, obj);
    if (!self) return FALSE_VALUE;
#ifdef _DEBUG
    if (index == 6) self = self;
#endif
    tis::xview *pv = (tis::xview*)self->pview();
    if (!pv) { pv = c->current_view(); if (!pv) return FALSE_VALUE; }
    
    int node_index = index;

    // deliberately prevent reconciliation
    self->allow_reconciliation(false);

    if (index < 0)
      node_index = 0;
    else if (index >= self->n_children())
      node_index = self->nodes.size();
    else {
      html::element *child_at = self->child(index);
      if (child_at) node_index = child_at->node_index + int(after);
    }

    if (CsStringP(src)) {
      if (!pv) return FALSE_VALUE;

      html::SE_TYPE  where;
      html::helement anchor;

      ustring us = value_to_string(src);
      if (us.length() == 0) { return FALSE_VALUE; }

      if (index < 0) {
        where  = html::SE_INSERT;
        anchor = self;
      } else if (index >= self->n_children()) {
        where  = html::SE_APPEND;
        anchor = self;
      } else {
        anchor = self->child(index);
        if (!anchor) return FALSE_VALUE;
        where =
            after ? html::SE_OUTER_INSERT_AFTER : html::SE_OUTER_INSERT_BEFORE;
      }
      bool r = pv->set_element_html(anchor, us, where);
      if (r) {
        //(void)self->current_style(*pv);
        return TRUE_VALUE;
      }
      return FALSE_VALUE;
    } else if (CsInstanceOf(c, src, c->elementDispatch->obj)) {
      html::helement srcb = element_ptr(c, src);
      if (!srcb) return FALSE_VALUE;

      if (self->belongs_to(srcb, true))
        CsThrowKnownError(c, CsErrGenericError, "Recursive DOM inclusion");

      self->insert(node_index, srcb, pv);

      if (pv) srcb->get_style(*pv);

      return src;
    } else if (CsInstanceOf(c, src, c->nodeDispatch->obj)) {
       html::hnode srcn = node_ptr(c, src);
       if (!srcn) return FALSE_VALUE;
       self->insert(node_index, srcn, pv);
       return src;
    }  else if (CsVectorP(src)) {
      slice<value>       elements = CsVectorElements(c, src);
#if 0 // a) causes problems in Notes and b) slower?
      for (; !!elements; ++elements) {
        CSF_crack_element_item(c, self, *elements);
      }
#else 
      array<html::hnode> nodes(elements.length);
      nodes.size(0);

      for (; !!elements; ++elements) {

//#ifdef _DEBUG
//        dispatch *pd = CsGetDispatch(*elements);
//#endif 

        if (CsVNodeP(*elements)) {
          ElementCreatorCtx ctx(pv, *elements,self);
          html::helement b = ctx.make();
          nodes.push(b.ptr());
        }
        else {
          html::hnode srcb = node_ptr(c, *elements);
          if (!srcb) continue;
          if (srcb->is_element() && self->belongs_to(srcb.ptr_of<html::element>(), true))
            CsThrowKnownError(c, CsErrGenericError, "Recursive DOM inclusion");
          nodes.push(srcb.ptr());
        }

      }
      self->insert_nodes(node_index, nodes(), pv);
#endif

      return src;
    } else if (CsVNodeP(src)) {
      ElementCreatorCtx ctx(pv, src, self);
      html::helement b = ctx.make();
      if (b) {
        self->insert(node_index, b, pv);
        return element_object(c, b);
      } else 
        CsThrowKnownError(c, CsErrUnexpectedTypeError, src, "VNode tuple");

    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, src,
                        "either Element, Tuple(template) or string(html)");
    return UNDEFINED_VALUE;
  }

  static value CSF_insert(xvm *c) { return CSF_insert_at(c, 0x7FFFFFFF); }
  static value CSF_append(xvm *c) { return CSF_insert_at(c, 0x7FFFFFFF); }
  static value CSF_prepend(xvm *c) { return CSF_insert_at(c, -1); }

  static value CSF_$set_html(xvm *c, html::SE_TYPE where) {
    goto START;

  NOT_IN_DOM:
    CsThrowKnownError(c, CsErrGenericError,
                      "The element is not attached to the DOM");
    // return FALSE_VALUE;

  START:
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);
    value obj = CsGetArg(c, 1);

    html::helement self = element_ptr(c, obj);
    if (!self) goto NOT_IN_DOM;
    html::view *pv = self->pview();
    if (!pv) goto NOT_IN_DOM;

    string_stream s;
    int           i, argc = CsArgCnt(c);
    for (i = 3; i <= argc; ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s);
      else
        CsToHtmlString(c, CsGetArg(c, i), s);

    /*html::helement parent = self->parent;
    int          index = self->index();
    int          self_subs = self->nodes.size();
    int          owner_subs = parent? parent->nodes.size():0;*/

    bool r = pv->set_element_html(self, s.buf(), where);
    if (!r) return NULL_VALUE;
    return element_object(c, self);
  }

  static value CSF_$append(xvm *c) { return CSF_$set_html(c, html::SE_APPEND); }

  static value CSF_$prepend(xvm *c) {
    return CSF_$set_html(c, html::SE_INSERT);
  }

  static value CSF_$content(xvm *c) {
    return CSF_$set_html(c, html::SE_REPLACE);
  }

  static value CSF_$after(xvm *c) {
    return CSF_$set_html(c, html::SE_OUTER_INSERT_AFTER);
  }
  static value CSF_$before(xvm *c) {
    return CSF_$set_html(c, html::SE_OUTER_INSERT_BEFORE);
  }
  static value CSF_$replace(xvm *c) {
    return CSF_$set_html(c, html::SE_OUTER_REPLACE);
  }

  static value CSF_content(xvm *c) {
    CsCheckArgType(c, 1, c->elementDispatch);
    value          obj  = CsGetArg(c, 1);
    html::helement self = element_ptr(c, obj);
    tis::xview *   pv   = nullptr;
     
    if (!self) goto NOT_IN_DOM;
    pv = (tis::xview*)self->pview();
    if (!pv) goto NOT_IN_DOM;

    // tool::array<html::element_or_text> reactors;
#if 1
    {
      ElementCreatorCtx ctx(pv, obj, self.ptr());
      array<html::hnode> nodes;
      for (int n = 3; n <= CsArgCnt(c); ++n) {
        value item = CsGetArg(c, n);
        ctx.crack_item(item, nodes,n - 3);
      }
      self->clear(pv);
      self->insert_nodes(0, nodes(), pv);
    }
#else
    for (int n = 3; n <= CsArgCnt(c); ++n) {

      value src = CsGetArg(c, n);
      if (CsStringP(src)) {
        self->append(new html::text(CsStringChars(src)));
      }
      else if (CsTupleP(src)) {
        html::helement b;
        CSF_make_element(c, src, b);
        self->append(b);
      }
      else if (CsVectorP(src)) {
        slice<value>       elements = CsVectorElements(c, src);
        array<html::hnode> nodes(elements.length);
        nodes.size(0);
        for (; !!elements; ++elements) {
          if (CsTupleP(*elements)) {
            html::helement b;
            CSF_make_element(c, *elements, b);
            nodes.push(b.ptr());
          }
          else {
            html::hnode srcb = node_ptr(c, *elements);
            if (!srcb) continue;

            if (srcb->is_element() &&
              self->belongs_to(srcb.ptr_of<html::element>(), true))
              CsThrowKnownError(c, CsErrGenericError, "Recursive DOM inclusion");

            nodes.push(srcb.ptr());
          }
        }
        self->insert_nodes(0, nodes(), pv);
        return src;
      }
      else {
        html::helement b = element_ptr(c, src);
        if (b)
          self->append(b);
        else
          CsThrowKnownError(c, CsErrUnexpectedTypeError, src,
            "string, object or element");
      }
    }
    pv->add_to_update(self, true);
#endif
    return obj;
  NOT_IN_DOM:
    CsThrowKnownError(c, CsErrGenericError,
                      "The element is not attached to the DOM");

    return UNDEFINED_VALUE;
  }


  static value CSF_remove(xvm *c) {
    value obj;
    value mode = 0;
    value num = 0;
    CsParseArguments(c, "V=*|V|V", &obj, c->elementDispatch, &mode, &num);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view * pv         = self->pview();

    if (mode && num && CsIntegerP(mode) && CsIntegerP(num))
    {
      PROTECT(obj);
      // remove children
      int start = CsIntegerValue(mode);
      int end = start + CsIntegerValue(num);
      self->remove_nodes(start,end, pv);
      return obj;
    }
    
    static value sym_unwrap = CsSymbolOf("unwrap");

    if (mode == sym_unwrap) {
      html::helement selfparent = self->parent;
      if (!selfparent) return obj;

      html::view *pv = self->pview();

      int                pos   = self->node_index;
      array<html::hnode> nodes = self->nodes;
      self->clear();
      self->remove(true);
      selfparent->insert_nodes(pos, nodes());
      if (pv) {
        selfparent->drop_layout_tree(pv);
        pv->add_to_update(selfparent, html::CHANGES_MODEL);
      }

    } else {

      if (self->parent && pv) pv->add_to_update(self->parent, true);
      self->remove(true,pv);
    }
    return obj;
  }

  static value CSF_detach(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) {
        CsThrowKnownError(c, CsErrGenericError,
                          "The element is not attached to the DOM");
    }
    if (self->is_connected())
        pv->add_to_update(self, html::CHANGES_MODEL);

    //auto doc = self->doc();
    self->remove(false);
    //self->parent = doc; moved to element::remove

    return obj;
  }

  static value CSF_toString(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::ostream_w os;
    self->emit(os);
    return CsMakeString(c, os.data());
  }

  static value CSF_valueOf(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    tool::value val;
    if (self->get_value(*pv, val)) return value_to_value(c, val);

    return UNDEFINED_VALUE;

    // return CsMakeCharString(c, data.head(),data.size() );
  }

  static value CSF_clone(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::helement b = self->clone_element();
    b->parent = self->doc();
    return element_object(c, b); // it will do b->add_ref();
    // return UNDEFINED_VALUE;
  }

  static value CSF_find(xvm *c) {
    value obj;
    point pos;
    CsParseArguments(c, "V=*ii", &obj, c->elementDispatch, &pos.x, &pos.y);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    html::element *found = self->find_element(*pv, pos);
    if (!found) return UNDEFINED_VALUE;
    return element_object(c, found);
  }

  static value CSF_box(xvm *c) {
    value obj;

    symbol_t side;
    symbol_t box   = uint(-1);
    symbol_t relTo = uint(-1);

    CsParseArguments(c, "V=*L|L|L", &obj, c->elementDispatch, &side, &box,
                     &relTo);

    side  = get_sym_id(side, id_left);
    box   = get_sym_id(box, id_inner);
    relTo = get_sym_id(relTo, id_self);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    // DOM element has to have valid positions for that
    if (!self->is_layout_valid())
      self->commit_measure(*pv); //too heavy pv->commit_update();

#ifdef _DEBUG
    //if (self->is_id_test()) 
    //  self = self;
    //clip_rect(v, this)
#endif

    rect rc(self->dim());
    switch (box) {
    case id_client: rc = self->client_rect(*pv); break;
    case id_clip: rc = self->clip_box(*pv); break;
    case id_margin: rc = self->margin_box(*pv); break;
    case id_border: rc = self->border_box(*pv); break;
    case id_padding: rc = self->padding_box(*pv); break;
    case id_caret:
      rc = rect();
      self->get_caret_location(*pv, rc);
      break;
    case id_inner:
    default: break;
    case id_content: {
      // if( self->min_content_width.undefined() ||
      // self->min_content_height.undefined() )
      //  self->calc_intrinsic_widths(*pv);
      html::scroll_data sd;
      self->get_scroll_data(*pv, sd);
      rc = sd.content_outline + sd.pos;
    } break;
    case id_icon: {
      // html::hstyle cs = self->get_style(*pv);
      // rc = self->image_z_box(*pv,cs->fore_image);
      if (self->ldata) rc = self->ldata->foreground_box;
    } break;
    }

    rect inner(self->dim());

    switch (relTo) {
    case id_client: inner = self->client_rect(*pv); goto WIDTHS;
    case id_margin: inner = self->margin_box(*pv); goto WIDTHS;
    case id_border: inner = self->border_box(*pv); goto WIDTHS;
    case id_padding: inner = self->padding_box(*pv); goto WIDTHS;
    case id_inner: goto WIDTHS;
    case id_screen: rc += self->view_pos(*pv) + pv->client_screen_pos(); break;
    case id_root: rc += self->doc_pos(*pv); break;
    case id_parent: if (self->parent) rc += self->doc_pos(*pv) - self->parent->doc_pos(*pv); break;
    case id_content: rc += self->doc_pos(*pv) - self->parent->doc_pos(*pv) + self->parent->scroll_pos(); break;
    case id_container: { html::element *bp = self->layout_parent(*pv); if (bp) rc += self->doc_pos(*pv) - bp->doc_pos(*pv); } break;
    case id_view: rc += self->view_pos(*pv); break;

    default: break;
    }

    switch (side) {
    case id_rect:
      CS_RETURN4(c, CsMakeInteger(rc.left()), CsMakeInteger(rc.top()), CsMakeInteger(rc.right()), CsMakeInteger(rc.bottom()));
    case id_rectw:
      CS_RETURN4(c, CsMakeInteger(rc.left()), CsMakeInteger(rc.top()), CsMakeInteger(rc.width()), CsMakeInteger(rc.height()));
    case id_position:
      CS_RETURN2(c, CsMakeInteger(rc.left()), CsMakeInteger(rc.top()));
    case id_dimension:
      CS_RETURN2(c, CsMakeInteger(rc.width()), CsMakeInteger(rc.height()));
    case id_left: return CsMakeInteger(rc.left());
    case id_right: return CsMakeInteger(rc.right());
    case id_top: return CsMakeInteger(rc.top());
    case id_bottom: return CsMakeInteger(rc.bottom());
    case id_width: return CsMakeInteger(rc.width());
    case id_height: return CsMakeInteger(rc.height());
    case id_intrinsics:
      CS_RETURN4(c,
        CsMakeInteger(self->ldata->dim_min.x),
        CsMakeInteger(self->ldata->dim_min.y),
        CsMakeInteger(self->ldata->dim_max.x),
        CsMakeInteger(self->ldata->dim_max.y));
    }
    return UNDEFINED_VALUE;
  WIDTHS:
    switch (side) {
    case id_rect:
      CS_RETURN4(c, CsMakeInteger(inner.left() - rc.left()), CsMakeInteger(inner.top() - rc.top()), 
                    CsMakeInteger(rc.right() - inner.right()), CsMakeInteger(rc.bottom() - inner.bottom()));
    case id_left: return CsMakeInteger(inner.left() - rc.left());
    case id_right: return CsMakeInteger(rc.right() - inner.right());
    case id_top: return CsMakeInteger(inner.top() - rc.top());
    case id_bottom: return CsMakeInteger(rc.bottom() - inner.bottom());
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_scroll(xvm *c) {
    value obj;

    symbol_t side;

    CsParseArguments(c, "V=*L", &obj, c->elementDispatch, &side);

    side = get_sym_id(side, id_left);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    // DOM elements has to have valid positions for that
    pv->to_update.update(pv);

    rect rc(self->client_rect(*pv).size());
    rc += self->scroll_pos();

    html::scroll_data sd;
    self->get_scroll_data(*pv, sd);

    size corner_off = sd.content_outline.size();
    corner_off.x -= rc.e.x;
    corner_off.y -= rc.e.y;

    switch (side) {
    case id_left: return CsMakeInteger(rc.left());
    case id_right: return CsMakeInteger(corner_off.x);
    case id_top: return CsMakeInteger(rc.top());
    case id_bottom: return CsMakeInteger(corner_off.y);
    case id_width: return CsMakeInteger(rc.width());
    case id_height: return CsMakeInteger(rc.height());
    case id_position: CS_RETURN2(c, CsMakeInteger(rc.left()), CsMakeInteger(rc.top()));
    case id_rect:
      CS_RETURN4(c, CsMakeInteger(rc.left()), CsMakeInteger(rc.top()),
                 CsMakeInteger(corner_off.x), CsMakeInteger(corner_off.y));
    case id_rectw:
      CS_RETURN4(c, CsMakeInteger(rc.left()), CsMakeInteger(rc.top()),
                    CsMakeInteger(rc.width()), CsMakeInteger(rc.height()));
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_translate(xvm *c) {
    value obj;
    point pos;
    bool  use_scroll = true;
    CsParseArguments(c, "V=*ii|B", &obj, c->elementDispatch, &pos.x, &pos.y,
                     &use_scroll);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    pos = self->scroll_translate(*pv, pos);

    CS_RETURN2(c, CsMakeInteger(pos.x), CsMakeInteger(pos.y));
  }

  static value CSF_inverseTranslate(xvm *c) {
    value obj;
    point pos;
    bool  use_scroll = true;
    CsParseArguments(c, "V=*ii|B", &obj, c->elementDispatch, &pos.x, &pos.y,
                     &use_scroll);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    pos = self->inverse_translate(*pv, pos);

    CS_RETURN2(c, CsMakeInteger(pos.x), CsMakeInteger(pos.y));
  }

  static value CSF_scrollTo(xvm *c) {
    value obj;
    point pos;
    bool  smooth              = false;
    bool  allow_out_of_bounds = false;
    CsParseArguments(c, "V=*ii|B|B", &obj, c->elementDispatch, &pos.x, &pos.y,
                     &smooth, &allow_out_of_bounds);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    critical_section cs(pv->guard);

    self->set_scroll_pos(*pv, pos, smooth, allow_out_of_bounds);

    return UNDEFINED_VALUE;
  }

  static value CSF_mapLocalToView(xvm *c) {
    value obj;
    point pos;

    CsParseArguments(c, "V=*ii", &obj, c->elementDispatch, &pos.x, &pos.y);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    pos = self->transform_local_to_view(*pv, pos);

    CS_RETURN2(c, CsMakeInteger(pos.x), CsMakeInteger(pos.y));
  }

  static value CSF_mapViewToLocal(xvm *c) {
    value obj;
    point pos;

    CsParseArguments(c, "V=*ii", &obj, c->elementDispatch, &pos.x, &pos.y);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    pos = self->transform_view_to_local(*pv, pos);

    CS_RETURN2(c, CsMakeInteger(pos.x), CsMakeInteger(pos.y));
  }

  static value CSF_attributes(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return iface_value(ptr<header>(obj), ATTRIBUTE_IFACE);
  }

  /*static value CSF_extenders(xvm *c,value obj)
  {
    html::element* self = element_ptr(c,obj);
    if( !self )
      return UNDEFINED_VALUE;
    return iface_value(ptr<header>(obj), EXTENDERS_IFACE);
  }*/

  static value CSF_style(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return iface_value(ptr<header>(obj), STYLE_IFACE);
  }

  static value CSF_state(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return iface_value(ptr<header>(obj), STATE_IFACE);
  }

  value CSF_select(xvm *c) {
    value obj = 0;
    value fun = 0;
    PROTECT(obj, fun);

    // CsParseArguments(c,"V=*|V",&vector,&CsVectorDispatch,&cmpf);
    // vector = CsMovedVectorP(vector)? CsVectorForwardingAddr(vector): vector;

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);
    fun = CsGetArg(c, 3);

    int firstArg = 4;

    if (!CsMethodP(fun)) {
      firstArg = 3;
      fun      = 0;
    }

    tool::ustring selector;
    value         selector_param = CsGetArg(c, firstArg);

    if (CsSymbolP(selector_param)) {
      selector =
          tool::ustring::format(W("#%S"), CsSymbolName(selector_param).c_str());
    } else if (CsStringP(selector_param)) {
      string_stream ss;
      ss.printf_args(c,
                     firstArg); // enum(fn/*argn=4*/, "format"/*argn=5*/, ...)
      selector = ss.to_ustring();
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, selector_param,
                        "string or symbol");

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (!fun) {
      html::element *b = html::find_first(*pv, self, selector);
      if (b) return element_object(c, b);
    } else {
      html::selector_context     selctx(self, selector, false);
      int                        cnt = 0;
      html::element_iterator_ctx it(*pv, self, selctx);
      for (html::element *bf; it(bf);) {
        PROTECT(fun);
        value bobj = element_object(c, bf); // may allocate memory and so GC.
        value r    = tis::CsCallFunction(CsCurrentScope(c), fun, 1, bobj);
        ++cnt;
        if (r == TRUE_VALUE) break;
      }
      return CsMakeInteger(cnt);
    }
    return UNDEFINED_VALUE;
  }

  value CSF_$(xvm *c) {
    value obj = 0;
    PROTECT(obj);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i, argc = CsArgCnt(c);
    for (i = 3; i <= argc; ++i)
      if( i & 1 )
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    html::element *b = html::find_first(*pv, self, selector);
    if (b) return element_object(c, b);

    return UNDEFINED_VALUE;
  }

  /*#ifdef _DEBUG
    tool::hash_table<tool::ustring,uint> _selector_lookups;
    uint _selector_lookups_counter = 0;
  #endif*/

  value CSF_$_global(xvm *c) {
    
    CsCheckArgMin(c, 3);
        
    static value self_sym = CsSymbolOf("self");

    value self_obj = NULL_VALUE;

    //if (!CsGetProperty(c, gns, self_sym, &self_obj)) return UNDEFINED_VALUE;
    if( !CsGetGlobalOrNamespaceValue(c,self_sym,&self_obj))
      return UNDEFINED_VALUE;

    html::element *self = element_ptr_no_throw(c, self_obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i, argc = CsArgCnt(c);
    for (i = 3; i <= argc; ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    html::element *b = html::find_first(*pv, self, selector);

    /*#ifdef _DEBUG
      {
        bool created = false;
        uint& c = _selector_lookups.get_ref(selector,created);
        if( created ) c = 1;
        else ++c;
      }
      if(++_selector_lookups_counter == 100) {
        tool::array<tool::ustring> keys;
        _selector_lookups.keys(keys);
        for(int n = 0; n < _selector_lookups.size(); ++n) {
          dbg_printf("%S : %d\n", keys[n].c_str(), _selector_lookups[keys[n]]);
        }
        _selector_lookups_counter = _selector_lookups_counter;
      }
    #endif*/

    if (b) return element_object(c, b);

    return UNDEFINED_VALUE;
  }

  value CSF_selectAll(xvm *c) {
    pvalue obj(c);
    pvalue arr(c);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    int firstArg = 3;

    tool::ustring selector;
    value         selector_param = CsGetArg(c, firstArg);

    if (CsSymbolP(selector_param)) {
      selector = tool::ustring::format(W("#%S"), CsSymbolName(selector_param).c_str());
    } else if (CsStringP(selector_param)) {
      string_stream ss;
      ss.printf_args(c,
                     firstArg); // enum(fn/*argn=4*/, "format"/*argn=5*/, ...)
      selector = ss.to_ustring();
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, selector_param,
                        "string or symbol");

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    array<html::helement> all;
    html::find_all(*pv, all, self, selector, false);

    arr = CsMakeVector(c, all.size(), c->elementListObject);

    for (int i = 0; i < all.size(); ++i) {
      value vel = element_object(c, all[i]);
      CsSetVectorElement(c, arr, i, vel);
    }

    return arr;
  }

  value CSF_selectParents(xvm *c) {
    pvalue obj(c);
    pvalue arr(c);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    int firstArg = 3;

    tool::ustring selector;
    value         selector_param = CsGetArg(c, firstArg);

    if (CsSymbolP(selector_param)) {
      selector =
          tool::ustring::format(W("#%S"), CsSymbolName(selector_param).c_str());
    } else if (CsStringP(selector_param)) {
      string_stream ss;
      ss.printf_args(c,
                     firstArg); // enum(fn/*argn=4*/, "format"/*argn=5*/, ...)
      selector = ss.to_ustring();
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, selector_param,
                        "string or symbol");

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    array<html::helement> all;
    html::find_all_parents(*pv, all, self, selector);

    arr = CsMakeVector(c, all.size(), c->elementListObject);

    for (int i = 0; i < all.size(); ++i) {
      value vel = element_object(c, all[i]);
      CsSetVectorElement(c, arr, i, vel);
    }

    return arr;
  }

  value CSF_$$(xvm *c) {
    pvalue obj(c);
    pvalue arr(c);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i;
    for (i = 3; i <= CsArgCnt(c); ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    if (selector.length() == 0) return NULL_VALUE;

    array<html::helement> all;
    html::find_all(*pv, all, self, selector, false);

    arr = CsMakeVector(c, all.size(), c->elementListObject);
    for (i = 0; i < all.size(); ++i) {
      value elem = element_object(c, all[i]);
      CsSetVectorElement(c, arr, i, elem);
    }
    return arr;
  }

  value CSF_$$_global(xvm *c) {
    //pvalue gns(c);
    //pvalue arr(c);
    value arr = UNDEFINED_VALUE;

    PROTECT(arr);

    CsCheckArgMin(c, 3);

    //gns = c->currentScope()->globals;
    
    static value self_sym = CsSymbolOf("self");

    value self_obj = NULL_VALUE;

    //if (!CsGetProperty(c, gns, self_sym, &self_obj)) return UNDEFINED_VALUE;
    if (!CsGetGlobalOrNamespaceValue(c, self_sym, &self_obj))
      return UNDEFINED_VALUE;

    html::element *self = element_ptr_no_throw(c, self_obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i;
    for (i = 3; i <= CsArgCnt(c); ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    if (selector.length() == 0) return NULL_VALUE;

    array<html::helement> all;
    html::find_all(*pv, all, self, selector, false);

    arr = CsMakeVector(c, all.size(), c->elementListObject);
    for (i = 0; i < all.size(); ++i) {
      value elem = element_object(c, all[i]);
      CsSetVectorElement(c, arr, i, elem);
    }
    return arr;
  }

  value CSF_selectParent(xvm *c) {
    value obj = 0, fun = 0;
    PROTECT(obj, fun);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);
    fun = CsGetArg(c, 3);

    int firstArg = 4;

    if (!CsMethodP(fun)) {
      firstArg = 3;
      fun      = 0;
    }

    string_stream ss;
    ss.printf_args(c, firstArg); // enum(fn/*argn=4*/, "format"/*argn=5*/, ...)

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    tool::ustring selector = ss.to_ustring();

    if (!fun) {
      html::element *b = html::find_first_parent(*pv, self, selector, 0);
      if (b) return element_object(c, b);
    } else {
      array<html::helement> all;
      find_all_parents(*pv, all, self, selector);
      int cnt = 0;
      for (int n = all.last_index(); n >= 0; --n) {
        value r = tis::CsCallFunction(CsCurrentScope(c), fun, 1,
                                      element_object(c, all[n]));
        if (r == TRUE_VALUE) break;
        ++cnt;
      }
      return CsMakeInteger(cnt);
    }
    return UNDEFINED_VALUE;
  }

  value CSF_$p(xvm *c) {
    pvalue obj(c);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i;
    for (i = 3; i <= CsArgCnt(c); ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    html::element *b =
        html::find_first_parent(*pv, self->doc(), self, selector, 0);
    if (b) return element_object(c, b);

    return UNDEFINED_VALUE;
  }

  value CSF_$o(xvm *c) {
    pvalue obj(c);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i;
    for (i = 3; i <= CsArgCnt(c); ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    html::element *b =
        html::find_first_ui_parent(*pv, self->doc(), self, selector, 0);
    if (b) return element_object(c, b);

    return UNDEFINED_VALUE;
  }

  value CSF_$$p(xvm *c) {
    value obj = 0;
    value arr = 0;
    PROTECT(obj, arr);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i;
    for (i = 3; i <= CsArgCnt(c); ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();

    array<html::helement> all;
    html::find_all_parents(*pv, all, self, selector);

    arr = CsMakeVector(c, all.size(), c->elementListObject);
    for (int i = 0; i < all.size(); ++i) {
      value vel = element_object(c, all[i]);
      CsSetVectorElement(c, arr, i, vel);
    }

    return arr;
  }

  static value CSF_match(xvm *c) {
    value obj;

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    int firstArg = 3;

    string_stream ss;
    ss.printf_args(c, firstArg); // enum(fn/*argn=4*/, "format"/*argn=5*/, ...)

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    tool::ustring selector = ss.to_ustring();

    html::element *b = html::find_first_parent(*pv, self, selector, 1);
    return b ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_$is(xvm *c) {
    pvalue obj(c);

    CsCheckArgMin(c, 3);
    CsCheckArgType(c, 1, c->elementDispatch /*,c->richtextDispatch*/);

    obj = CsGetArg(c, 1);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    string_stream s(20);
    int           i;
    for (i = 3; i <= CsArgCnt(c); ++i)
      if (i & 1)
        CsToString(c, CsGetArg(c, i), s); // as is
      else
        CsToCssString(c, CsGetArg(c, i), s); // escape

    tool::ustring selector = s.to_ustring();
    s.close();
    html::element *b = html::find_first_parent(*pv, self, selector, 1);
    return b ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_text(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;
    return CsMakeString(c, self->get_text(*pv));
  }

  static void CSF_set_text(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) return;

    if (!CsStringP(val)) val = CsToString(c, val);

    wchars t = CsStringChars(val);
    self->set_text_value(*pv, t);
  }

/*  static value CSF_prototype(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return ptr<c_object>(self->obj)->proto;
  }

  static void CSF_set_prototype(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    // if(CsInstanceOf(c, val, c->behaviorObject))
    { CsSetObjectClass(obj, val); }
    // else
    //   CsThrowKnownError(c, CsErrUnexpectedTypeError, val, "instance of
    //   Behavior class");
  } */

  static value CSF_clear(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);
    html::element *self = element_ptr(c, obj);
    if (!self) return obj;
    html::view *pv = self->pview();
    // if(pv)
    //  self->clear_value(*pv);
    // else
    self->clear(pv);
    return obj;
  }

  void CSF_handle_headers(xvm *c, html::request *xrq, value headers);

  static value CSF_load(xvm *c) {
    value obj;
    // wchar *path = 0;
    // int_t  pathlen = 0;
    bool now = false;

    value p1, p2 = 0;
    CsParseArguments(c, "V=*V|V", &obj, c->elementDispatch, &p1, &p2);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    self->check_layout(*pv);

    if (CsStringP(p1) && p2 && CsStringP(p2)) {
      wchars      html(CsStringAddress(p1), CsStringSize(p1));
      array<byte> html_utf;
      u8::from_utf16(html, html_utf, true);
      tool::ustring wuri(CsStringAddress(p2), CsStringSize(p2));
      tool::string  uri = tool::url::escape(wuri);
      uri               = html::combine_url(self->doc()->uri().src, uri);
      handle<html::pump::request> rq =
          new html::pump::request(uri, html::DATA_HTML);
      rq->dst       = self;
      rq->initiator = self;
      rq->data.swap(html_utf);
      rq->rq_type = html::RQ_PUSH;
      //??? notify pv->on_data_loaded(rq);
      self->on_data_request(*pv, rq);
      self->on_data_arrived(*pv, rq);
      // pv->data_arrived(rq);
      return TRUE_VALUE;
    } else if (CsStringP(p1)) {
      now = p2 ? (CsToBoolean(c, p2) == TRUE_VALUE) : false;
      tool::ustring wuri(CsStringAddress(p1), CsStringSize(p1));
      tool::string  uri = tool::url::escape(wuri);
      uri               = html::combine_url(self->doc()->uri().src, uri);

      handle<html::pump::request> rq =
          new html::pump::request(uri, html::DATA_HTML);
      rq->dst       = self;
      rq->initiator = self;
      if (p2 && CsObjectP(p2)) CSF_handle_headers(c, rq, p2);

      if (now) {
        return pv->load_data(rq, true) ? TRUE_VALUE : FALSE_VALUE;
      } else {
        pv->request_data(rq);
        return rq->success_flag ? TRUE_VALUE : FALSE_VALUE;
      }
    } else if (CsFileP(c, p1) && CsFileStream(p1)->is_string_stream()) {
      string_stream *ss  = (string_stream *)CsFileStream(p1);
      tool::string   uri = html::combine_url(self->doc()->uri().src,
                                           tool::string(ss->stream_name()));
      // bool r = pv->set_element_html(self, ss->buf.head(), ss->buf.size(), uri
      // );
      handle<html::pump::request> rq =
          new html::pump::request(uri, html::DATA_HTML);
      rq->dst       = self;
      rq->initiator = self;
      rq->data.swap(ss->buf);
      self->on_data_request(*pv, rq);
      self->on_data_arrived(*pv, rq);
      // pv->data_arrived(rq);
      return TRUE_VALUE;
    } else if (CsByteVectorP(p1)) {
      tool::string uri =
          self->doc()->uri().src; // html::combine_url(self->doc()->uri().src,
                                  // tool::string(ss->stream_name()));
      // bool r = pv->set_element_html(self, ss->buf.head(), ss->buf.size(), uri
      // );
      handle<html::pump::request> rq =
          new html::pump::request(uri, html::DATA_HTML);
      rq->dst       = self;
      rq->initiator = self;
      rq->data      = CsByteVectorBytes(p1);
      self->on_data_request(*pv, rq);
      self->on_data_arrived(*pv, rq);
      // pv->data_arrived(rq);
      return TRUE_VALUE;
    } else if (image_ptr(c, p1)) {
      if (self->layout_type() != html::flow_image) {
        //self->dbg_report("expecting image");
        CsThrowKnownError(c, CsErrGenericError,
                          "loading image to non-image element");
      }
      gool::image *pximg = image_ptr(c, p1);
      if (!pximg)
        CsThrowKnownError(c, CsErrGenericError, "loading invalid image");
      self.ptr_of<html::block_image>()->set_image(*pv, pximg);
      return TRUE_VALUE;
    } else {
      CsThrowKnownError(c, CsErrUnexpectedTypeError, p1,
                        "source is neither string (url) nor in-memory stream");
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_save(xvm *c) {
    value obj;
    value dest = 0, mode = 0;

    if (!c->can_use_feature(FEATURE_FILE_IO))
    {
      CsThrowKnownError(c, CsErrNotAllowed, "FILE IO");
      // return UNDEFINED_VALUE;
    }

    CsParseArguments(c, "V=*|V|V", &obj, c->elementDispatch, &dest, &mode);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (!dest) {
      html::ostream_w os;
      self->emit_content(os);
      return CsMakeString(c, os.data());
    } else if (CsStringP(dest)) {
      tool::ustring wuri(CsStringAddress(dest), CsStringSize(dest));
      // tool::string uri = tool::url::escape(wuri);
      // uri = html::combine_url(self->doc()->uri().src, uri);

      tool::wchars fname = wuri;
      if (fname.like(W("file://*"))) fname.prune(7);

      html::ostream_8 os;
      self->emit_content(os);

      FILE *fp = 0;
#ifdef WINDOWS
      _wfopen_s(&fp, fname.start, L"wb");
#else
        fp = fopen(u8::cvt(fname), "wb");
#endif
      if (!fp)
        CsThrowKnownError(c, CsErrWrite);
      else {
        size_t written = fwrite(os.data.head(), os.data.length(), 1, fp);
        fclose(fp);
        if (!written) CsThrowKnownError(c, CsErrWrite);
      }
      return TRUE_VALUE;
    }
    /*else if( CsFileP(c,dest) && CsFileStream(dest)->is_output_stream() )
    {
      stream *ss = CsFileStream(dest);
      tool::string uri = html::combine_url(self->doc()->uri().src,
    tool::string(ss->stream_name())); return TRUE_VALUE;
    }
    else
    {
       CsThrowKnownError(c, CsErrUnexpectedTypeError, dest, "destination is
    neither \"file://path\" nor writeable stream");
    }*/
    else {
      CsThrowKnownError(c, CsErrUnexpectedTypeError, dest,
                        "destination is not \"file://path\"");
    }
    return UNDEFINED_VALUE;
  }


  static value CSF_swap(xvm *c) {
    value obj;
    value dst;

    CsParseArguments(c, "V=*V=", &obj, c->elementDispatch, &dst,
                     c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();

    html::element *other = element_ptr(c, dst);
    if (!other) return UNDEFINED_VALUE;

    if (!pv) pv = other->pview();
    if (!html::element::swap_locations(self, other, pv))
      CsThrowKnownError(c, CsErrGenericError, "Incompatible types of elements");
    return obj;
  }

  static value CSF_loadImage(xvm *c) {
    value obj;
    value callback = 0;
    value src;
    value use_cache = FALSE_VALUE;

    CsParseArguments(c, "V=*V|V|V", &obj, c->elementDispatch, &src, &callback,
                     &use_cache);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    handle<html::document> pd = self->doc();
    if (!pd) return UNDEFINED_VALUE;

    html::view *pv = pd->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (callback && !CsMethodP(callback))
      CsThrowKnownError(c, CsErrUnexpectedTypeError, callback,
                        "callback must be function");

    struct image_ref : resource {
      handle<gool::image> img;
      //virtual ~image_ref() {
      //  img = nullptr;
      //}
    };

    handle<image_ref> ximg = new image_ref();

    if (CsStringP(src)) {
      tool::string uri(CsStringChars(src));
      uri = html::combine_url(self->doc()->uri().src, uri);

      pvalue ximg_callback(c, callback);

      auto notify_ready = [ximg, ximg_callback, pd](uint status) 
      {
        if (ximg_callback.is_set() && CsMethodP(ximg_callback)) {
          auto_scope as(ximg_callback.pvm, pd->ns);
          try {
            if (ximg->img.ptr())
              CsCallFunction(&as, ximg_callback, 2,image_object(static_cast<xvm *>(ximg_callback.pvm), ximg->img), CsMakeInteger(status));
            else
              CsCallFunction(&as, ximg_callback, 2, NULL_VALUE,
                             CsMakeInteger(status));
          } catch (script_exception &) {
            CsDisplay(ximg_callback.pvm, ximg_callback.pvm->val,
                      ximg_callback.pvm->standardError);
          }
        }
      };

      auto on_image_data_arrived = [c,ximg, ximg_callback, pv, pd, notify_ready,use_cache](html::pump::request *rq) -> bool 
      {
        ximg->img = gool::image::create(rq->data, rq->url,c->current_doc());

        if (use_cache != FALSE_VALUE && ximg->img)
          pd->image_arrived(*pv, ximg->img);

        notify_ready(rq->status);
        return true;
      };

      if (use_cache != FALSE_VALUE) {
        handle<image> img = pd->get_image(uri);
        if (img) {
          ximg->img = img;
          if (!ximg_callback.is_set())
            return image_object(c, ximg->img);
          else {
            notify_ready(200);
            return NULL_VALUE;
          }
        }
      }

      html::RESOURCE_DATA_TYPE dt = use_cache == FALSE_VALUE ? html::DATA_RAW_DATA : html::DATA_IMAGE;
      handle<html::pump::request> rq = (new html::pump::request(uri, dt))->add(on_image_data_arrived);
      if (pv->load_data(rq, !ximg_callback.is_set()) && ximg->img)
        return image_object(c, ximg->img);

      return NULL_VALUE;

    }
    /*
    else if( CsFileP(c,p1) && CsFileStream(p1)->is_string_stream() )
    {
      string_stream *ss = (string_stream *)CsFileStream(p1);
      tool::string uri = html::combine_url(self->doc()->url().src,
    tool::string(ss->stream_name()));

      html::pump::request rq( uri, html::DATA_HTML );
      rq.dst = self;
      rq.initiator = self;
      rq.data.swap( ss->buf );
      bool r = self->on_data_arrived(*pv, &rq);
      return r? TRUE_VALUE: FALSE_VALUE;
    }*/
    else {
      CsThrowKnownError(c, CsErrUnexpectedTypeError, src,
                        "source is neither string (url) nor byte array");
      return UNDEFINED_VALUE;
    }
  }

  static value CSF_bindImage(xvm *c) {
    value obj;
    // value  callback = 0;
    wchars uri;
    value  img = 0;

    CsParseArguments(c, "V=*S#|V=", &obj, c->elementDispatch, &uri.start,
                     &uri.length, &img, c->imageDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::document *pd = self->doc();
    if (!pd) return UNDEFINED_VALUE;

    html::view *pv = pd->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (img) {
      gool::image *xim = image_ptr(c, img);
      if (!xim) return UNDEFINED_VALUE;

      if (xim) {
        xim->set_url(url::escape(uri));
        pd->image_arrived(*pv, xim);
        return TRUE_VALUE;
      }
      CsThrowKnownError(c, CsErrGenericError, "invalid image");
    } else {
      image *pimg = pd->get_image(uri);
      if (!pimg) return NULL_VALUE;
      if (!pimg->is_bitmap())
        CsThrowKnownError(c, CsErrGenericError, "image is not a bitmap");
      return image_object(c, pimg);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_isVisible(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    return self->is_visible(*pv) ? TRUE_VALUE : FALSE_VALUE;
  }
  static value CSF_isEnabled(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return self->get_state(true).disabled() ? FALSE_VALUE : TRUE_VALUE;
  }

  static value CSF_value(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    tool::value v;
    //-------------  if(self->get_value(*pv,v))
    if (pv->get_element_native_value(self, v, false)) return value_to_value(c, v);

    return UNDEFINED_VALUE;
  }

  /*static void CSF_set_value(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) return;

    tool::value v = value_to_value(c, val);

    c->native_value_set_result = pv->set_element_native_value(self, v, c->native_value_set_ignore_text);
  }*/

  static value CSF_rawValue(xvm *c) {
    value obj;
    value val = 0;

    CsParseArguments(c, "V=*|V", &obj, c->elementDispatch, &val);
    html::element *self = element_ptr(c, obj);

    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    if (val != 0) {
      tool::value v = value_to_value(c, val);
      pv->set_element_native_value(self, v,false);
      // self->set_value(*pv,v);
    }
    tool::value v;
    if (self->get_value(*pv, v)) return value_to_value(c, v);
    return UNDEFINED_VALUE;
  }

  static value CSF_enabled(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return self->get_state(false).disabled() ? FALSE_VALUE : TRUE_VALUE;
  }

  static void CSF_set_enabled(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) {
      self->flags.state_initialized = 1;
      if (val == TRUE_VALUE)
        self->state.disabled(false);
      else
        self->state.disabled(true);
      return;
    }

    if (CsToBoolean(c, val) == FALSE_VALUE)
      self->state_on(*pv, html::S_DISABLED);
    else
      self->state_off(*pv, html::S_DISABLED);
  }

  static value CSF_checked(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return self->get_state(false).checked() ? TRUE_VALUE : FALSE_VALUE;
  }

  static void CSF_set_checked(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) {
      self->flags.state_initialized = 1;
      if (val == TRUE_VALUE)
        self->state.checked(true);
      else
        self->state.checked(false);
      return;
    }
    if (CsToBoolean(c, val) == TRUE_VALUE)
      self->state_on(*pv, html::S_CHECKED);
    else
      self->state_off(*pv, html::S_CHECKED);
  }

  static value CSF_focus(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return self->get_state(false).focus() ? TRUE_VALUE : FALSE_VALUE;
  }

  static void CSF_set_focus(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) return;

    if (CsToBoolean(c, val) == TRUE_VALUE)
      pv->set_focus(self, html::BY_CODE);
    else if (self->parent)
      pv->set_focus(self->parent, html::BY_CODE);
  }

  static value CSF_current(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return self->get_state(false).current() ? TRUE_VALUE : FALSE_VALUE;
  }

  static void CSF_set_current(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) {
      self->flags.state_initialized = 1;
      if (val == TRUE_VALUE)
        self->state.current(true);
      else
        self->state.current(false);
      return;
    }

    if (CsToBoolean(c, val) == TRUE_VALUE)
      self->state_on(*pv, html::S_CURRENT);
    else
      self->state_off(*pv, html::S_CURRENT);
  }

  static value CSF_expanded(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::ui_state st = self->get_state(false);

    if (st.expanded())
      return TRUE_VALUE;
    else if (st.collapsed())
      return FALSE_VALUE;
    return UNDEFINED_VALUE;
  }

  static void CSF_set_expanded(xvm *c, value obj, value val) {
    html::element *self = element_ptr(c, obj);
    if (!self) return;
    html::view *pv = self->pview();
    if (!pv) {
      self->flags.state_initialized = 1;
      if (val == TRUE_VALUE)
        self->state.expanded(true);
      else if (val == FALSE_VALUE)
        self->state.collapsed(true);
      else
        self->state -= html::S_COLLAPSED | html::S_EXPANDED;
      return;
    }
    if (val == TRUE_VALUE)
      self->state_on(*pv, html::S_EXPANDED);
    else if (val == FALSE_VALUE)
      self->state_on(*pv, html::S_COLLAPSED);
    else
      self->state_off(*pv, html::S_COLLAPSED | html::S_EXPANDED);
  }

  static value CSF_contentModel(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    static value $block_inside  = CsSymbolOf("block-inside");
    static value $inline_inside = CsSymbolOf("inline-inside");
    static value $transparent   = CsSymbolOf("transparent");
    static value $text_only     = CsSymbolOf("text-only");
    static value $table         = CsSymbolOf("table");

    auto cm = html::tag::content_model(self->tag);

    switch (cm) {
    case html::tag::CMODEL_BLOCKS: return $block_inside;
    case html::tag::CMODEL_INLINES: return $inline_inside;
    case html::tag::CMODEL_TRANSPARENT: return $transparent;
    case html::tag::CMODEL_TEXT: return $text_only;
    case html::tag::CMODEL_TABLE: return $table;
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_isBlockElement(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return FALSE_VALUE;
    return self->is_block_element(*pv) ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_isBoxElement(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return FALSE_VALUE;
    return self->is_box_element(*pv) ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_firstCaretPos(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;
    self->check_layout(*pv);
    return bookmark2value(c, self->start_caret_pos(*pv));
  }
  static value CSF_lastCaretPos(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;
    self->check_layout(*pv);
    return bookmark2value(c, self->end_caret_pos(*pv));
  }

  static value CSF_startPos(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;
    self->check_layout(*pv);
    return bookmark2value(c, self->start_pos());
  }
  static value CSF_endPos(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;
    self->check_layout(*pv);
    return bookmark2value(c, self->end_pos());
  }

  extern value selection_object(xvm *pvm, html::element *pel);

  static value CSF_selection(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return selection_object(c, self);
  }

  static value CSF_behavior_call(xvm *c) {
    value obj;
    value sym;

    CsParseArguments(c, "V=*V=|", &obj, c->elementDispatch, &sym,
                     &CsSymbolDispatch);
    html::element *self = element_ptr(c, obj);

    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    array<tool::value> argv;
    int                argc = CsArgCnt(c) - 3;
    argv.size(argc);

    for (int i = 0; i < argc; ++i)
      argv[i] = value_to_value(c, CsGetArg(c, i + 4));

    tool::value retval;

    if (pv->call_behavior_method(self, string(CsSymbolName(sym)), argv.head(),
                                 argv.size(), retval))
      return value_to_value(c, retval);
    return UNDEFINED_VALUE;
  }

  // void CsScanObject( VM *c, value obj, object_scanner& osc )

  /*struct rq_form_params: object_scanner
  {
    string_stream name;
    string_stream data;
    xrequest*     prq;

    rq_form_params(xrequest* xrq): prq(xrq) {}

    bool item( VM *c, value key, value val )
    {
      name.buf.clear();
      data.buf.clear();

      //if (!CsPrintData(c,key,&name,false)) return false;
      CsDisplay(c,key,&name);
      CsDisplay(c,val,&data);

      html::pump::param param;
      param.name = name.to_ustring();
      param.value = data.to_ustring();
      prq->rq_params.push( param );

      return true;
    }
  };*/

  value CSF_request(xvm *c);

  /* call_element_method - send a message to an obj by name */
  bool call_element_method(xvm *c, html::element *self, const char *sname,
                           int argc, const tool::value *argv,
                           tool::value &retval) {
    value obj = element_object(c, self);

    if (obj == UNDEFINED_VALUE) return false;

    html::document *pd = self->doc();
    if (pd) {
      auto_scope ascope(c, pd->ns);
      if (CallSciterMethod(c, obj, sname, argc, argv, retval)) return true;
      html::view *pv = pd->pview();
      if (pv) return pv->call_behavior_method(self, sname, argv, argc, retval);
    }
    return false;
  }

  /* call_element_function - call global function in elements namespace */
  bool call_element_function(xvm *c, html::element *self, const char *sname,
                             int argc, const tool::value *argv,
                             tool::value &retval) {
    value obj = element_object(c, self);

    if (obj == UNDEFINED_VALUE) return false;

    html::document *pd = self->doc();
    if (pd) {
      auto_scope ascope(c, pd->ns);
      return CallSciterMethod(c, pd->ns, sname, argc, argv, retval);
    }
    return false;
  }

  static value CSF_popup(xvm *c) {
    value obj, popupObj;
    int_t placement1 = 2;
    int_t placement2 = 0;
    int_t placement3 = 0;
    CsParseArguments(c, "V=*V=|i|i|i", &obj, c->elementDispatch, &popupObj,
                     c->elementDispatch, &placement1, &placement2, &placement3);

    html::element *self = element_ptr(c, obj);
    if (!self) return FALSE_VALUE;

    html::element *popup = element_ptr(c, popupObj);
    if (!popup) return FALSE_VALUE;

    html::view *pv = self->pview();
    if (!pv) return FALSE_VALUE;

    // value vp = element_object(c, popup);

    // if( c->argc == 5 )
    //  pv->show_popup( popup, self, self->doc_pos() +
    //  point(placement,placement_y), 7, html::view::POPUP_ANIMATE |
    //  html::view::POPUP_MODAL );
    // else
    //  pv->show_popup( popup, self, placement, html::view::POPUP_ANIMATE |
    //  html::view::POPUP_MODAL );
    if (c->argc == 5)
      pv->show_popup(popup, self, html::POPUP_WINDOW, 0x20,
                     point(placement1, placement2));
    else if (c->argc == 6)
      pv->show_popup(popup, self, html::POPUP_WINDOW, placement1 | 0xFFFF0000,
                     point(placement2, placement3));
    else
      pv->show_popup(popup, self, html::POPUP_WINDOW, placement1);

    return TRUE_VALUE;
  }

  static value CSF_closePopup(xvm *c) {
    value obj = 0;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    while (self) {
      if (self->state.popup()) {
        pv->close_popup(self, false);
        return TRUE_VALUE;
      }
      self = self->get_owner();
    }
    return FALSE_VALUE;
  }

  static value CSF_intrinsicWidthMin(xvm *c) {
    value obj = 0;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    return CsMakeInteger(self->min_content_width(*pv));
  }

  static value CSF_intrinsicWidthMax(xvm *c) {
    value obj = 0;
    CsParseArguments(c, "V=*", &obj, c->elementDispatch);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    return CsMakeInteger(self->max_content_width(*pv));
  }

  static value CSF_intrinsicHeight(xvm *c) {
    value obj      = 0;
    int   forWidth = 0;
    CsParseArguments(c, "V=*|i", &obj, c->elementDispatch, &forWidth);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    int height;

    if (forWidth) {
      size dim = self->dim();
      self->set_width(*pv, forWidth);
      height = self->min_content_height(*pv);
      self->set_width(*pv, dim.x);
    } else {
      height = self->min_content_height(*pv);
    }
    return CsMakeInteger(height);
  }

  static value CSF_timer(xvm *c) {
    value obj;
    value fun;
    int_t milliseconds            = 0;
    bool  avoid_same_origin_check = false;

    CsParseArguments(c, "V=*Tm|B", &obj, c->elementDispatch, &milliseconds,
                     &fun, &avoid_same_origin_check);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    auto same_origin = [fun](html::timer_id id, html::TIMER_KIND kind) -> bool {
      if (id == fun) return true;
      if (kind != html::SCRIPT_TIMER) return false;
      return CsMethodCode(id) == CsMethodCode(fun);
    };

    if (milliseconds) {
      if (!avoid_same_origin_check) pv->stop_timer_if(self, same_origin);
      pv->start_timer(self, milliseconds, fun, html::SCRIPT_TIMER);
    } else {
      if (!avoid_same_origin_check)
        pv->stop_timer_if(self, same_origin);
      else
        pv->stop_timer(self, fun, html::SCRIPT_TIMER);
    }
    return UNDEFINED_VALUE;
  }

  void crack_duration(VM *c, value v, int &period_ms) {
    if (!v) return;
    if (CsIntegerP(v))
      period_ms = CsIntegerValue(v);
    else if (CsDurationP(v))
      period_ms = int(1000 * CsDurationSeconds(v));
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, v, "integer or duration");
  }

  static value CSF_animate(xvm *c) 
  {
    value obj = 0, params = 0;
    value fun = 0;
    value finfun = 0;
    int   duration = 0; // milliseconds

    PROTECT(obj);

    CsParseArguments(c, "V=*|V=", &obj, c->elementDispatch, &params);
    if (params) {
      if(!CsGetProperty(c, params, "step", fun, &CsMethodDispatch))
        CsThrowKnownError(c, CsErrGenericError, "no step function");
      CsGetProperty(c, params, "completion", finfun, &CsMethodDispatch);
      CsGetPropertyMilliseconds(c, params, "duration", duration);
    }
    else {
      value p1 = 0;
      value p2 = 0;
      CsParseArguments(c, "V=*m|V|V", &obj, c->elementDispatch, &fun, &p1, &p2);

      if (p1) {
        if (CsMethodP(p1)) {
          finfun = p1;
          crack_duration(c, p2, duration);
        }
        else
          crack_duration(c, p1, duration);
      }
    }

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    handle<html::script_animator> pan = new html::script_animator();
    if (duration > 0) pan->duration = uint(duration);
    pan->cbf.pin(c, fun);

    if (finfun != 0) pan->fin_cbf.pin(c, finfun);

    pv->add_animation(self, pan, self->get_style(*pv), self->p_style);
    return obj;
  }

  static value CSF_url(xvm *c) {
    value        obj;
    const wchars path_default = WCHARS("");
    const wchars path = path_default;
    CsParseArguments(c, "V=*|S#", &obj, c->elementDispatch, &path.start,&path.length);
    html::element *self = element_ptr(c, obj);
    if (self) {
      string url = self->doc_url();
      if (path != path_default) 
        url = html::combine_url(url, url::escape(path));
      // WRONG!: return CsMakeCString(c,url::unescape(url));
      return CsMakeCString(c, url);
    }
    return UNDEFINED_VALUE;
  }

  /*struct cmpElementsSorterProxy
    {
      pvalue  fun;
      cmpElementsSorterProxy( xvm *pvm, value f ): fun(pvm,f) {}
    };
  */

  static value CSF_sort(xvm *c) {
    value obj  = 0;
    value cmpf = 0;

    int start  = 0;
    int length = -1;

    CsParseArguments(c, "V=*m|i|i", &obj, c->elementDispatch, &cmpf, &start, &length);

    html::element *self = element_ptr(c, obj);

    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    array<html::helement> elements;
    html::child_iterator  ci(*pv, self);
    uint                  need_restyle = 0;
    for (html::element *el; ci(el);) {
      elements.push(el);
      need_restyle += el->flags.disable_fast_css_match;
    }

    if (start >= elements.size()) return UNDEFINED_VALUE;
    if (length < 0) length = elements.size() - start;
    if (length < 0) return UNDEFINED_VALUE;

    // cmpElementsSorterProxy _1(c,cmpf);

    PROTECT(cmpf);

    auto comparator = [&](const html::helement &v1,
                          const html::helement &v2) -> bool {
      value bo1 = element_object(c, v1);
      CsPush(c, bo1);
      value bo2 = element_object(c, v2);
      bo1       = CsPop(c);
      value r   = CsCallFunction(CsCurrentScope(c), cmpf, 2, bo1, bo2);
      if (CsIntegerP(r)) return CsIntegerValue(r) < 0;
      return false;
    };

    tool::sort(elements.head() + start, length, comparator);

    self->nodes.clear();
    self->nodes.size(elements.size());
    FOREACH(i, elements) {
      html::element *pel = elements[i];
      pel->node_index    = i;
      self->nodes[i]     = pel;
    }

    self->flags.indexes_are_valid = 0;
    if (need_restyle) self->reset_styles(*pv);
    self->drop_layout(pv);
    self->commit_measure(*pv);
    pv->refresh(self);

    return UNDEFINED_VALUE;
  }

  static value sym_width  = 0;
  static value sym_height = 0;

  //uint      lu2tool(UNIT_TYPE ut);
  //UNIT_TYPE tool2lu(uint ut);

  static value CSF_toPixels(xvm *c) {
    if (!sym_width) {
      sym_width  = CsSymbolOf("width");
      sym_height = CsSymbolOf("height");
    }
    value obj;
    value length;
    value dirSymbol = sym_width;
    value logicalUnits = 0;
    CsParseArguments(c, "V=*V|V|V", &obj, c->elementDispatch, &length,&dirSymbol,&logicalUnits);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::view *pv = self->pview();
    if (!pv) return UNDEFINED_VALUE;

    html::size_v lv;

    if (CsLengthP(length)) {
      tool::value tv = value_to_value(c, length);
      lv             = html::size_v(tv);
    } else if (CsStringP(length) || CsSymbolP(length)) {
      html::from_string(lv, value_to_string(length));
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, length,
                        "length, symbol or string");

    if (lv.is_undefined()) return UNDEFINED_VALUE;

    int px;
    static value sym_logical = CsSymbolOf(CHARS("logical"));

    if (dirSymbol == sym_height) {
      px = html::pixels(*pv, self, lv).height();
      if (logicalUnits == sym_logical)
        px = (int)roundf(pv->ppx_to_px(sizef(float(px))).x);
  }
    else {
      px = html::pixels(*pv, self, lv).width();
      if (logicalUnits == sym_logical)
        px = (int)roundf(pv->ppx_to_px(sizef(float(px))).y);
    }
    return int_value(px);
  }


  static value CSF_subscribe_raw(xvm *c) {
    value  obj;
    uint_v subscription_event_group;
    uint_v subscription_event_type;
    value  subscription_fcn;
    CsParseArguments(c, "V=*mi|i", &obj, c->elementDispatch, &subscription_fcn,
                     &subscription_event_group._v,
                     &subscription_event_type._v);
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    value v_name = subscription_event_type.is_defined()
                       ? CsMakeInteger(subscription_event_type)
                       : UNDEFINED_VALUE;
    return CsEventObjectAdd(c, obj, subscription_fcn, v_name,
                     CsMakeInteger(subscription_event_group));
  }

  static value CSF_subscribe_by_name(xvm *c) {
    value obj;
    value v_name      = UNDEFINED_VALUE;
    value v_namespace = UNDEFINED_VALUE;
    value v_selector  = UNDEFINED_VALUE;
    value v_cb        = UNDEFINED_VALUE;

    CsParseArguments(c, "V=*VV|V", &obj, c->elementDispatch, &v_name,
                     &v_selector, &v_cb);

    if (v_cb == UNDEFINED_VALUE) swap(v_selector, v_cb);

    PROTECT(obj, v_name, v_namespace, v_selector, v_cb);

    // ustring e_name;
    // ustring e_selector;
    tool::ustring ls = value_to_string(v_name);
    tool::wchars  list = ls();
    if (list.length == 0)
      CsThrowKnownError(c, CsErrUnexpectedTypeError, v_name,
                        "event name, symbol or string");

    tool::ustring vlist = list;
    list                = vlist();

    // html::element* self = element_ptr(c,obj);
    // if( !self )
    //  return UNDEFINED_VALUE;

    for (; list.length;) {
      wchars nn = list.chop(' ');
      if (!nn) continue;
      wchars name = nn.chop('.');
      wchars ns   = nn;

      v_name      = CsSymbolOf(name);
      v_namespace = ns.length ? CsSymbolOf(ns) : UNDEFINED_VALUE;

      if (!CsMethodP(v_cb) && !CsCMethodP(v_cb))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, v_cb,
                          "callback, function");

      if (v_selector == UNDEFINED_VALUE)
        v_selector = v_selector;
      else if (CsStringP(v_selector))
        v_selector = v_selector;
      else if (CsSymbolP(v_selector)) {
        PROTECT(obj, v_name, v_namespace, v_cb);
        v_selector = CsMakeString(c, WCHARS("#") + value_to_string(v_selector));
      } else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, v_selector,
                          "selector, symbol or string");

      CsEventObjectAdd(c, obj, v_cb, v_name, v_namespace, v_selector);
    }
    return obj;
  }

  static value CSF_subscribe_function(xvm *c, value obj, value fun) {
    if (!CsMethodP(fun))
      CsThrowKnownError(c, CsErrUnexpectedTypeError, fun, "function");

    return CsEventObjectAddEF(c, obj, fun);
  }

  static value CSF_subscribe(xvm *c) {
    if (CsMethodP(CsGetArg(c, 3)))
      return CSF_subscribe_raw(c);
    else
      return CSF_subscribe_by_name(c);
  }

  static value CSF_unsubscribe(xvm *c) {
    value obj;
    value p1 = UNDEFINED_VALUE;
    value p2 = UNDEFINED_VALUE;
    CsParseArguments(c, "V=*V|V", &obj, c->elementDispatch, &p1, &p2);

    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    PROTECT(obj);

    if (CsMethodP(p1)) {
      // self->unsubscribe(p1);
      CsEventObjectRemove(c, obj, p1);
    } else if (CsIntegerP(p1)) {
      value subscription_event_group = CsIntegerValue(p1);
      value subscription_event_type  = UNDEFINED_VALUE;
      if (CsIntegerP(p2)) subscription_event_type = CsIntegerValue(p2);
      // self->unsubscribe(subscription_event_group,subscription_event_type);
      CsEventObjectRemove(c, obj, UNDEFINED_VALUE, subscription_event_type,
                          subscription_event_group);
    } else if (CsStringP(p1) || CsSymbolP(p1)) {
      wchars e_names = value_to_wchars(p1);
      for (; e_names.length;) {
        wchars e_name = e_names.chop(' ');
        if (!e_name) continue;
        tool::wchars nm          = e_name.chop('.');
        tool::wchars ns          = e_name;
        value        v_name      = nm.length ? CsSymbolOf(nm) : UNDEFINED_VALUE;
        value        v_namespace = ns.length ? CsSymbolOf(ns) : UNDEFINED_VALUE;
        if (p2 == UNDEFINED_VALUE) {
          CsEventObjectRemove(c, obj, UNDEFINED_VALUE, v_name, v_namespace);
        } else if (CsMethodP(p2)) {
          CsEventObjectRemove(c, obj, p2, v_name, v_namespace);
        } else if (CsStringP(p2)) {
          CsEventObjectRemove(c, obj, UNDEFINED_VALUE, v_name, v_namespace, p2);
        } else
          CsThrowKnownError(c, CsErrUnexpectedTypeError, p2,
                            "selector or function");
      }
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, p2,
                        "event name or function");

    return obj;
  }

  static value CSF_unsubscribe_by_unshift(xvm *c, value obj, value operand) {
    html::element *self = element_ptr(c, obj);
    if (!self) return obj;

    if (CsMethodP(operand)) {
      return CsEventObjectRemove(c, obj, operand);
    } else if (CsStringP(operand)) {
      wchars       e_name      = value_to_wchars(operand);
      tool::wchars nm          = e_name.chop('.');
      tool::wchars ns          = e_name;
      value        v_name      = nm.length ? CsSymbolOf(nm) : UNDEFINED_VALUE;
      value        v_namespace = ns.length ? CsSymbolOf(ns) : UNDEFINED_VALUE;
      return CsEventObjectRemove(c, obj, UNDEFINED_VALUE, v_name, v_namespace);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, operand,
                        "event name or function");
    return obj;
  }

  /*static value CSF_subscriptions(xvm *c)
  {
    value obj = 0;
    value cb = 0;
    PROTECT(cb,obj);
    CsParseArguments(c,"V=*V=",&obj, c->elementDispatch, &cb,
  &CsMethodDispatch);

    html::element* self = element_ptr(c,obj);
    if( !self )
      return UNDEFINED_VALUE;

    static value sym_delete = CsSymbolOf("delete");
    static value sym_delete_stop = CsSymbolOf("delete-stop");
    static value sym_stop = CsSymbolOf("stop");

    auto oneach = [&](html::subscription* sub, bool& delete_it) -> bool {
      delete_it = false;
      value rv = CsCallMethod(c,obj, cb, obj,  3, sub->fcn,
  int_value(sub->event_group), int_value(sub->event_type)); if( rv == sym_delete
  ) { delete_it = true; return false; } if( rv == sym_delete_stop ) { delete_it
  = true; return false; } if( rv == sym_stop ) { return true; } return false; //
  continue
    };
    self->each_subscription(oneach);
    return int_value(self->subscriptions.size());
  } */

  static value CSF_belongsTo(xvm *c) {
    value obj;
    value par;
    bool  ui             = false;
    bool  including_this = false;
    CsParseArguments(c, "V=*V=|B|B", &obj, c->elementDispatch, &par,
                     c->elementDispatch, &ui, &including_this);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::helement parent = element_ptr(c, par);
    if (!parent) return UNDEFINED_VALUE;
    if (ui) {
      html::view *pv = self->pview();
      if (pv)
        return self->belongs_to(*pv, parent, including_this) ? TRUE_VALUE
                                                             : FALSE_VALUE;
    }
    return self->belongs_to(parent, including_this) ? TRUE_VALUE : FALSE_VALUE;
  }

  // +++ Nodes

  value CSF_node_insertNodeBefore(xvm *c);
  value CSF_node_insertNodeAfter(xvm *c);
  value CSF_node_nextNode(xvm *c, value obj);
  value CSF_node_prevNode(xvm *c, value obj);
  value CSF_node_nodeIndex(xvm *c, value obj);

  static value CSF_firstNode(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::node *n = self->first_node();
    if (!n) return NULL_VALUE;
    return node_object(c, n);
  }

  static value CSF_lastNode(xvm *c, value obj) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::node *n = self->last_node();
    if (!n) return NULL_VALUE;
    return node_object(c, n);
  }

  value CSF_node_isText(xvm *c, value obj);
  value CSF_node_isComment(xvm *c, value obj);
  value CSF_node_isElement(xvm *c, value obj);

  static value CSF_nodes(xvm *c) {
    value obj;
    int_t index = -424242;
    CsParseArguments(c, "V=*|i", &obj, c->elementDispatch, &index);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (index == -424242) {
      value arr = 0, nel = 0;
      PROTECT(arr, nel);

      arr = CsMakeVector(c, self->nodes.size(), c->nodeListObject);
      for (int i = 0; i < self->nodes.size(); ++i) {
        html::node *n = self->nodes[i];
        nel = node_object(c, n);
        CsSetVectorElement(c, arr, i, nel);
      }
      return arr;
    }
    else if (index >= 0 && index < self->nodes.size()) {
      return node_object(c, self->nodes[index]);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_execCommand(xvm *c) {
    value  obj;
    value  param = UNDEFINED_VALUE;
    wchars cmd;
    CsParseArguments(c, "V=*S#|V", &obj, c->elementDispatch, &cmd.start,
                     &cmd.length, &param);

    if (!cmd.length) return UNDEFINED_VALUE;

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (pv) {
      bool r =
          html::exec_command(*pv, self, self, cmd, value_to_value(c, param));
      return r ? TRUE_VALUE : FALSE_VALUE;
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_queryCommand(xvm *c) {
    value  obj;
    value  param = UNDEFINED_VALUE;
    wchars cmd;
    CsParseArguments(c, "V=*S#|V", &obj, c->elementDispatch, &cmd.start,
                     &cmd.length, &param);

    if (!cmd.length) return UNDEFINED_VALUE;

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    if (pv) {
      tool::pair<bool, tool::value> r =
          html::query_command(*pv, self, self, cmd, value_to_value(c, param));
      if (r.first) return value_to_value(c, r.second);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_commonParent(xvm *c) {
    value obj = 0, objOther = 0;
    CsParseArguments(c, "V=*V=", &obj, c->elementDispatch, &objOther,
                     c->elementDispatch);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::helement other = element_ptr(c, objOther);
    if (!other) return UNDEFINED_VALUE;

    html::helement root = html::element::find_common_parent(self, other);
    if (!root) return NULL_VALUE;

    return element_object(c, root);
  }

  static value CSF_appendNode(xvm *c) {
    value obj;
    value obj_what;
    // bool  ui = false;
    CsParseArguments(c, "V=*V=", &obj, c->elementDispatch, &obj_what,
                     c->nodeDispatch);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::hnode what = node_ptr(c, obj_what);
    if (!what) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    self->append(what, pv);

    return UNDEFINED_VALUE;
  }

  static value CSF_prependNode(xvm *c) {
    value obj;
    value obj_what;
    // bool  ui = false;
    CsParseArguments(c, "V=*V=", &obj, c->elementDispatch, &obj_what,
                     c->nodeDispatch);

    html::helement self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::hnode what = node_ptr(c, obj_what);
    if (!what) return UNDEFINED_VALUE;

    html::view *pv = self->pview();
    self->insert(0, what, pv);

    return UNDEFINED_VALUE;
  }

  // --- Nodes

  /* GetElementProperty - mimics GetObjectProperty */
  static bool GetElementProperty(xvm *c, value &obj, value tag, value *pValue) {
    PROTECT(obj,tag);
    handle<html::element> pb = element_ptr(c, obj);
    if (pb && pb->is_connected()) {
      PROTECT(obj, tag);
      pb->get_style(); // to force behaviors to be resolved
      assert(pb->obj == obj);
    }

    if (pb && pb->behavior) {
      handle<html::ctl> pc = pb->behavior;
      while (pc) {
        if (som_passport_t* psp = pc->asset_get_passport()) {
          if (psp->name == tag) {
            *pValue = CsMakeAssetObject(c, pc->as_asset());
            return true;
          }
        }
        pc = pc->next;
      }
    }
    
    return CsGetObjectProperty(c, obj, tag, pValue);
  }

  static bool SetElementProperty(xvm *c, value obj, value tag, value val) {
    handle<html::element> pb = element_ptr(c, obj);

    //if (tag == VALUE_SYM)
    //  pb = pb;

    if (pb) {

      html::view* pv = pb->pview(); 
      if (pv) {

        PROTECT(obj, tag, val);

        if(pb->is_connected())
          pb->get_style(*pv); // to force behaviors to be resolved, GC may happen here
                              // due to prototype/attached/etc.

        bool r = CsSetObjectProperty(c, obj, tag, val);

        switch (get_sym_id(tag)) {
          case id_onSize: pb->flags.has_on_size_script = CsMethodP(val) ? 1 : 0; break;
          case id_onVisibilityChanged: pb->flags.has_on_visibility_changed_script = CsMethodP(val) ? 1 : 0; break;
          case id_paintBackground: pb->flags.script_draws_background = CsMethodP(val) ? 1 : 0; break;
          case id_paintForeground: pb->flags.script_draws_foreground = CsMethodP(val) ? 1 : 0; break;
          case id_paintContent: pb->flags.script_draws_content = CsMethodP(val) ? 1 : 0; break;
          case id_paintOutline: pb->flags.script_draws_outline = CsMethodP(val) ? 1 : 0; break;
          case id_isPointInside: pb->flags.script_has_is_point_inside = CsMethodP(val) ? 1 : 0; break;
          case id_value: if(!r) r = pv->set_element_native_value(pb, value_to_value(c, val), false); break;
          default: break;
        }
        
        //html::check_prop_used_by_style_content(*pv, pb, CsSymbolName(tag));
        return r;
      }
    }
//#ifdef _DEBUG
//    ustring name = value_to_string(tag);
//#endif
    //if (pb->behavior) {
    //  tristate_v r = CsSetNativeBehaviorProperty(c, pb->behavior, tag, val);
    //  if (r.is_defined()) return !!r.val();
    //}

    return CsSetObjectProperty(c, obj, tag, val);
  }

  static bool HandleElementCall(xvm *c, value obj, value tag, int argc, value *pretval) {
    //value obj = 0;
    //CsParseArguments(c, "V=*|", &obj, c->elementDispatch);
    html::element *self = element_ptr(c, obj);

    if (!self || !self->behavior) return false;

    PROTECT(obj, tag);

    html::view *pv = self->pview();
    if (!pv) return false;

    //OBSOLETE: if (pv->call_behavior_method(self, c, tag, *pretval)) { return true; }
#if 0
    if (self->behavior) {
      tool::tristate_v r = CsNativeBehaviorCall(c, self->behavior, tag, pretval);
      if (r.is_defined()) return !!r.val();
    }
#endif

    argc -= 2;

    array<tool::value> argv;
    argv.size(argc);

    for (int i = 0; i < argc; ++i)
      argv[i] = value_to_value(c, c->sp[argc - i - 1]);

    tool::value retval;
    if (pv->call_behavior_method(self, string(CsSymbolName(tag)), argv.head(),
                                 argv.size(), retval)) {
      *pretval = value_to_value(c, retval, true);
      return true;
    }
    return false;
  }

  /* ObjectScan - Object scan handler */
  void ElementScan(VM *c, value obj) {
    CsCObjectScan(c, obj);

    handle<html::element> p = element_ptr(static_cast<xvm *>(c), obj);
    if (!p) return;

    if (p->is_document() && p.ptr_of<html::document>()->ns)
      p.ptr_of<html::document>()->ns =
          CsCopyValue(c, p.ptr_of<html::document>()->ns);

    if (p->obj) p->obj = CsCopyValue(c, p->obj);

    /*FOREACH(i, p->subscriptions )
    {
      html::subscription* ps = p->subscriptions[i];
      ps->fcn = CsCopyValue(c,ps->fcn);
    }*/
    html::ctl *bhv = p->behavior;
    if (bhv) {
      function<bool(html::element *)> scan = [c](html::element *el) -> bool {
        if (el->obj && !CsIsNewObjectP(c, el->obj))
          el->obj = CsCopyValue(c, el->obj);
        return false;
      };
      while (bhv) {
        bhv->scan_owned_elements(scan);
        bhv = bhv->next;
      }
    }

    if (!p->doc() || !p->is_connected()) {
      // if it has no parent it may have expando created on its children, walk
      // through them
      function<bool(html::node *)> scan = [c, &scan, p](html::node *n) -> bool {
        if (n->is_document() && static_cast<html::document *>(n)->ns)
          static_cast<html::document *>(n)->ns = CsCopyValue(c, static_cast<html::document *>(n)->ns);
        if ((n != p) && n->obj) 
          n->obj = CsCopyValue(c, n->obj);
        if (!n->is_element()) return false;
        html::element *el = static_cast<html::element *>(n);
        html::ctl *bhv = el->behavior;
        while (bhv) {
          bhv->scan_owned_elements(scan);
          bhv = bhv->next;
        }
        return false;
      };

      html::tree_scanner ts(p);
      ts.each_node(scan);
    } 

  }

  /*void ElementScan(VM *c,value obj)
  {
      CsCObjectScan(c,obj);

      handle<html::element> p = element_ptr( static_cast<xvm *>(c),obj);
      if(!p)
        return;

      function<bool(html::element*)> scan = [c,&scan,p](html::element* el)->bool
      {
        if( el->is_document() && static_cast<html::document*>(el)->ns)
          static_cast<html::document*>(el)->ns =
  CsCopyValue(c,static_cast<html::document*>(el)->ns); if((el != p) && el->obj)
        {
          if( CsIsNewObjectP(c,el->obj))
            return false; // already copied
          el->obj = CsCopyValue(c,el->obj);
        }
        FOREACH(i, el->subscriptions )
        {
          html::subscription* ps = el->subscriptions[i];
          ps->fcn = CsCopyValue(c,ps->fcn);
        }
        html::ctl* bhv = el->behavior;
        while(bhv) {
          bhv->scan_owned_elements(scan);
          bhv = bhv->next;
        }
        el->each_child(scan);
        el->each_ui_child(scan);
        return false;
      };
      scan(p);
  }*/

  value ElementCopy(VM *c, value obj) {
#if 0 && defined(_DEBUG)
  if (!CsIsNewObjectP(c, obj))
  {
    html::element* p = element_ptr(static_cast<xvm *>(c), obj);
    if (p)
    {
      if (!p->pview()) {
        p->dbg_stack("GC, disconnected element");
        if (p->attr_class() == WCHARS("settings") && p->tag == html::tag::T_DIV)
          p = p;
      }
    }
  }
#endif
    return CsDefaultCopy(c, obj);
  }

  int_t ElementHash(value obj) {
    // its address is a perfect hash
    html::node *b = static_cast<html::node *>(CsCObjectValue(obj));
    return (int_t)(uint_ptr)b;
  }

  bool ElementPrint(xvm *c, value val, stream *s) {
    html::element *b = element_ptr_no_throw(c, val);
    if (b) {
      s->put_str("<");
      s->put_str(html::tag::symbol_name(b->tag));
      ustring a = b->attr_id();
      if (a.length()) {
        s->put_str("#");
        s->put_str(a);
      }
      a = b->attr_class();
      if (a.length()) {
        s->put_str(".");
        s->put_str(a);
      }
      value cls = CsObjectClass(val);
      if (cls != UNDEFINED_VALUE && CsClassP(cls)) {
        value vclsn = CsClassName(cls);
        /*if( CsStringP(vclsn) )
        {
          wchars clsn = CsStringChars(vclsn);
          s->put_str(" of ");
          s->put_str(clsn.start,clsn.end());
        }
        else*/
        if (CsSymbolP(vclsn)) {
          string clsn = CsSymbolName(vclsn);
          s->put_str("/");
          s->put_str(clsn);
        }
      }
      /*else
      {
        string pr = b->_style->prototype;
        pr = b->current_style()->prototype;
        b = b;
      }*/
      s->put('>');
    } else
      s->put_str("{deleted}");
    return true;
  }

  bool ElementPrintType(xvm *c, value val, stream *s) {
    html::element *b = element_ptr_no_throw(c, val);
    if (b) {
      s->put_str("Element(");
      s->put_str(html::tag::symbol_name(b->tag));
      ustring a = b->attr_id();
      if (a.length()) {
        s->put_str("#");
        s->put_str(a);
      }
      a = b->attr_class();
      if (a.length()) {
        s->put_str(".");
        s->put_str(a);
      }
      value cls = CsObjectClass(val);
      if (cls != UNDEFINED_VALUE && CsClassP(cls)) {
        value vclsn = CsClassName(cls);
        /*if( CsStringP(vclsn) )
        {
        wchars clsn = CsStringChars(vclsn);
        s->put_str(" of ");
        s->put_str(clsn.start,clsn.end());
        }
        else*/
        if (CsSymbolP(vclsn)) {
          string clsn = CsSymbolName(vclsn);
          s->put_str("/");
          s->put_str(clsn);
        }
      }
      /*else
      {
      string pr = b->_style->prototype;
      pr = b->current_style()->prototype;
      b = b;
      }*/
      s->put(')');
    }
    else
      s->put_str("Element(deleted)");
    return true;
  }


  value MakeElement(xvm *c, value proto) { return UNDEFINED_VALUE; }

  value ElementNextElement(xvm *c, value *index, value obj) {
    int_t          idx  = 0;
    html::element *self = element_ptr(c, obj);
    assert(self);
    if (!self) 
      //CS_RETURN2(c, NOTHING_VALUE, NOTHING_VALUE);
      return NOTHING_VALUE;

    if (*index != NOTHING_VALUE) idx = CsIntegerValue(*index) + 1; // not first

    *index = CsMakeInteger(idx);

    if (idx >= self->n_children())
      //CS_RETURN2(c, NOTHING_VALUE, NOTHING_VALUE);
      return NOTHING_VALUE;

    //CsSetRVal(c, 1, *index);
    html::element *pe = self->child(idx);
    //return element_object(c, pe);
    CS_RETURN2(c, *index, element_object(c, pe));
  }

  value ElementGetItem(xvm *c, value obj, value tag) {
    html::element *self = element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    if (CsIntegerP(tag)) {
      int i = CsIntegerValue(tag);

      html::element *cb = self->child(i);
      if (!cb) return NULL_VALUE;
      return element_object(c, cb);
    }

    value vi = CsObjectGetItem(c, obj, tag);

    // this will allow to use
    //    self#element-id
    // to refer elements by id
    if (vi == UNDEFINED_VALUE && CsSymbolP(tag)) {
      tool::ustring  id  = CsSymbolName(tag);
      html::element *tid = self->get_element_by_id(id);
      if (tid) return element_object(c, tid);
    }
    return vi;
  }

  void ElementSetItem(xvm *c, value obj, value tag, value value) {
    //html::element *self = element_ptr(c, obj);
    //if (!self) return;
#if NOT_YET
    html::element *src = 0;
    if (CsGetDispatch(value) == c->elementDispatch) src = element_ptr(c, value);
    if (CsIntegerP(tag) && src) {
      int index = CsIntegerValue(tag);
      if (index < 0 || index >= self->subs.size())
        CsThrowKnownError(c, CsErrIndexOutOfBounds, tag);
      html::remove(self->subs[index], true);
      if (!html::insert(self, index, src))
        CsThrowKnownError(c, CsErrGenericError,
                          "Cannot insert this html element type here");
    } else if (CsIntegerP(tag)) {
      CsThrowKnownError(
          c, CsErrGenericError,
          "Integer as index is only supported for Element rvalue, not for %V",
          value);
    } else
#endif
      CsObjectSetItem(c, obj, tag, value);
  }

  value ElementBinOp(xvm *c, int op, value obj, value operand) {
    switch (op) {
    case BC_ADD:
    case BC_SHL: return CSF_subscribe_function(c, obj, operand); 
    case BC_SUB:
    case BC_SHR: return CSF_unsubscribe_by_unshift(c, obj, operand); return obj;
    }
    return obj;
  }

  extern value CSF_element_graphics(xvm *c);
  // extern value CSF_element_commit_graphics(xvm *c);

  // richtext addons
  extern value CSF_richtext_transact(xvm *c);
  //extern value CSF_propertyAt(VM* c);

  
  /* element methods */
  static c_method methods[] = {
      C_METHOD_ENTRY_X("this", CSF_ctor),

      C_METHOD_ENTRY_X("$", CSF_$),     // find first -> element
      C_METHOD_ENTRY_X("$$", CSF_$$),   // find all -> vector
      C_METHOD_ENTRY_X("$p", CSF_$p),   // find first parent -> element
      C_METHOD_ENTRY_X("$o", CSF_$o),   // find first ui_parent -> element
      C_METHOD_ENTRY_X("$$p", CSF_$$p), // find all parents -> vector
      C_METHOD_ENTRY_X("$is",
                       CSF_$is), // check if it matches the selector -> bool

      C_METHOD_ENTRY_X("select", CSF_select),
      C_METHOD_ENTRY_X("selectAll", CSF_selectAll),
      C_METHOD_ENTRY_X("selectParent", CSF_selectParent),
      C_METHOD_ENTRY_X("selectParents", CSF_selectParents),
      C_METHOD_ENTRY_X("match", CSF_match),
      C_METHOD_ENTRY_X("update", CSF_update),
      C_METHOD_ENTRY_X("refresh", CSF_refresh),
      C_METHOD_ENTRY_X("find", CSF_find),
      C_METHOD_ENTRY_X("toString", CSF_toString),
      C_METHOD_ENTRY_X("valueOf", CSF_valueOf),
      C_METHOD_ENTRY_X("clone", CSF_clone),
      C_METHOD_ENTRY_X("create", CSF_create),

      C_METHOD_ENTRY_X("box", CSF_box), C_METHOD_ENTRY_X("scroll", CSF_scroll),
      C_METHOD_ENTRY_X("scrollTo", CSF_scrollTo),
      C_METHOD_ENTRY_X("scrollToView", CSF_scrollToView),
      C_METHOD_ENTRY_X("translate", CSF_translate),
      C_METHOD_ENTRY_X("inverseTranslate", CSF_inverseTranslate),

      C_METHOD_ENTRY_X("post", CSF_post),

      C_METHOD_ENTRY_X("postEvent", CSF_postEvent),
      C_METHOD_ENTRY_X("sendEvent", CSF_sendEvent),

      C_METHOD_ENTRY_X("sendMouseEvent", CSF_sendMouseEvent),
      C_METHOD_ENTRY_X("sendKeyEvent", CSF_sendKeyEvent),

      C_METHOD_ENTRY_X("getState", CSF_getState),
      C_METHOD_ENTRY_X("setState", CSF_setState),
      C_METHOD_ENTRY_X("clearState", CSF_clearState),
      C_METHOD_ENTRY_X("extend", CSF_extend),

      C_METHOD_ENTRY_X("insert", CSF_insert),
      C_METHOD_ENTRY_X("append", CSF_append),
      C_METHOD_ENTRY_X("prepend", CSF_prepend),
      C_METHOD_ENTRY_X("remove", CSF_remove),
      C_METHOD_ENTRY_X("detach", CSF_detach),
      C_METHOD_ENTRY_X("swap", CSF_swap),
      C_METHOD_ENTRY_X("parseHtml", CSF_parseHtml),

      C_METHOD_ENTRY_X("merge", CSF_merge),

      C_METHOD_ENTRY_X("move", CSF_move),

      C_METHOD_ENTRY_X("load", CSF_load),
      C_METHOD_ENTRY_X("loadImage", CSF_loadImage),
      C_METHOD_ENTRY_X("bindImage", CSF_bindImage),
      C_METHOD_ENTRY_X("save", CSF_save),

      // C_METHOD_ENTRY_X( "graphics",           CSF_element_graphics ),

      C_METHOD_ENTRY_X("xcall", CSF_behavior_call),

      C_METHOD_ENTRY_X("popup", CSF_popup),
      C_METHOD_ENTRY_X("closePopup", CSF_closePopup),
      C_METHOD_ENTRY_X("request", CSF_request),

      C_METHOD_ENTRY_X("clear", CSF_clear),

      C_METHOD_ENTRY_X("url", CSF_url),

      C_METHOD_ENTRY_X("timer", CSF_timer),

      C_METHOD_ENTRY_X("capture", CSF_capture),
      C_METHOD_ENTRY_X("sort", CSF_sort),

      C_METHOD_ENTRY("eval", CSF_eval),

      C_METHOD_ENTRY_X("animate", CSF_animate),

      // C_METHOD_ENTRY_X( "textWidth",          CSF_textWidth ),
      // C_METHOD_ENTRY_X( "textHeight",         CSF_textHeight ),

      C_METHOD_ENTRY_X("intrinsicWidthMin", CSF_intrinsicWidthMin),
      C_METHOD_ENTRY_X("intrinsicWidthMax", CSF_intrinsicWidthMax),
      C_METHOD_ENTRY_X("intrinsicHeight", CSF_intrinsicHeight),

      //C_METHOD_ENTRY("propertyAt", CSF_propertyAt),
      C_METHOD_ENTRY_X("toPixels", CSF_toPixels),

      C_METHOD_ENTRY_X("row", CSF_row), C_METHOD_ENTRY_X("column", CSF_column),
      C_METHOD_ENTRY_X("rowY", CSF_rowy),
      C_METHOD_ENTRY_X("columnX", CSF_columnx),

      C_METHOD_ENTRY_X("removeColumns", CSF_removeColumns),
      C_METHOD_ENTRY_X("removeRows", CSF_removeRows),

      C_METHOD_ENTRY_X("subscribe", CSF_subscribe),
      C_METHOD_ENTRY_X("unsubscribe", CSF_unsubscribe),
      // C_METHOD_ENTRY_X( "eachSubscription",   CSF_subscriptions  ),

      // jQuery alike
      C_METHOD_ENTRY_X("on", CSF_subscribe_by_name),
      C_METHOD_ENTRY_X("off", CSF_unsubscribe),

      C_METHOD_ENTRY_X("rawValue", CSF_rawValue),

      C_METHOD_ENTRY_X("$append", CSF_$append),
      C_METHOD_ENTRY_X("$prepend", CSF_$prepend),
      C_METHOD_ENTRY_X("$content", CSF_$content),
      C_METHOD_ENTRY_X("$before", CSF_$before),
      C_METHOD_ENTRY_X("$after", CSF_$after),
      C_METHOD_ENTRY_X("$replace", CSF_$replace),

      C_METHOD_ENTRY_X("content", CSF_content),
      C_METHOD_ENTRY_X("belongsTo", CSF_belongsTo),

      C_METHOD_ENTRY_X("execCommand", CSF_execCommand),
      C_METHOD_ENTRY_X("queryCommand", CSF_queryCommand),

      C_METHOD_ENTRY_X("commonParent", CSF_commonParent),

      // Node interface:
      C_METHOD_ENTRY_X("insertNodeBefore", CSF_node_insertNodeBefore),
      C_METHOD_ENTRY_X("insertNodeAfter", CSF_node_insertNodeAfter),
      C_METHOD_ENTRY_X("appendNode", CSF_appendNode),
      C_METHOD_ENTRY_X("prependNode", CSF_prependNode),
      C_METHOD_ENTRY_X("nodes", CSF_nodes),

      C_METHOD_ENTRY_X("transact", CSF_richtext_transact),
      C_METHOD_ENTRY_X("mapLocalToView", CSF_mapLocalToView),
      C_METHOD_ENTRY_X("mapViewToLocal", CSF_mapViewToLocal),

      C_METHOD_ENTRY_X(0, 0)};

      static c_method static_methods[] = {
        C_METHOD_ENTRY_X("create", CSF_create),

        C_METHOD_ENTRY_X(0, 0) };

  /* Element properties */
  static vp_method properties[] = {
      VP_METHOD_ENTRY_X("root", CSF_root, 0),
      VP_METHOD_ENTRY_X("view", CSF_view, 0),
      VP_METHOD_ENTRY_X("parent", CSF_parent, 0),
      VP_METHOD_ENTRY_X("layoutParent", CSF_layoutParent, 0),
      VP_METHOD_ENTRY_X("owner", CSF_owner, CSF_set_owner),
      VP_METHOD_ENTRY_X("index", CSF_index, 0),
      VP_METHOD_ENTRY_X("id", CSF_id, 0), VP_METHOD_ENTRY_X("uid", CSF_uid, 0),
      VP_METHOD_ENTRY_X("tag", CSF_tag_name, CSF_set_tag_name),
      VP_METHOD_ENTRY_X("next", CSF_next, 0),
      VP_METHOD_ENTRY_X("prior", CSF_prior, 0),
      VP_METHOD_ENTRY_X("first", CSF_first, 0),
      VP_METHOD_ENTRY_X("last", CSF_last, 0),

      VP_METHOD_ENTRY_X("length", CSF_child_count, 0),
      VP_METHOD_ENTRY_X("attributes", CSF_attributes, 0),
      VP_METHOD_ENTRY_X("@", CSF_attributes, 0),
      // VP_METHOD_ENTRY_X( "x",                   CSF_extenders,        0),
      VP_METHOD_ENTRY_X("style", CSF_style, 0),
      VP_METHOD_ENTRY_X("state", CSF_state, 0),
      VP_METHOD_ENTRY_X("text", CSF_text, CSF_set_text),
      VP_METHOD_ENTRY_X("html", CSF_html, CSF_set_html),
      VP_METHOD_ENTRY_X("value", CSF_value, CsSilentPropertySetter),
      VP_METHOD_ENTRY_X("isVisible", CSF_isVisible, 0),
      VP_METHOD_ENTRY_X("isEnabled", CSF_isEnabled, 0),

      VP_METHOD_ENTRY_X("outerHtml", CSF_outer_html, CSF_set_outer_html),

      //VP_METHOD_ENTRY_X("prototype", CSF_prototype, CSF_set_prototype),
      VP_METHOD_ENTRY_X("enabled", CSF_enabled, CSF_set_enabled),
      VP_METHOD_ENTRY_X("checked", CSF_checked, CSF_set_checked),
      VP_METHOD_ENTRY_X("focus", CSF_focus, CSF_set_focus),
      VP_METHOD_ENTRY_X("current", CSF_current, CSF_set_current),
      VP_METHOD_ENTRY_X("expanded", CSF_expanded, CSF_set_expanded),

      VP_METHOD_ENTRY_X("rows", CSF_rows, 0),
      VP_METHOD_ENTRY_X("columns", CSF_columns, 0),

      VP_METHOD_ENTRY_X("ns", CSF_root_ns, 0),
      VP_METHOD_ENTRY_X("options", CSF_options, 0),

      // Node interface:
      VP_METHOD_ENTRY_X("isElement", CSF_node_isElement, 0),
      VP_METHOD_ENTRY_X("isText", CSF_node_isText, 0),
      VP_METHOD_ENTRY_X("isComment", CSF_node_isComment, 0),
      VP_METHOD_ENTRY_X("nodeIndex", CSF_node_nodeIndex, 0),
      VP_METHOD_ENTRY_X("nextNode", CSF_node_nextNode, 0),
      VP_METHOD_ENTRY_X("priorNode", CSF_node_prevNode, 0),

      VP_METHOD_ENTRY_X("firstNode", CSF_firstNode, 0),
      VP_METHOD_ENTRY_X("lastNode", CSF_lastNode, 0),

      VP_METHOD_ENTRY_X("contentModel", CSF_contentModel, 0),
      VP_METHOD_ENTRY_X("selection", CSF_selection, 0),

      VP_METHOD_ENTRY_X("isBlockElement", CSF_isBlockElement, 0),
      VP_METHOD_ENTRY_X("isBoxElement", CSF_isBoxElement, 0),

      VP_METHOD_ENTRY_X("firstCaretPos", CSF_firstCaretPos, 0),
      VP_METHOD_ENTRY_X("lastCaretPos", CSF_lastCaretPos, 0),

      VP_METHOD_ENTRY_X("startPos", CSF_startPos, 0),
      VP_METHOD_ENTRY_X("endPos", CSF_endPos, 0),

      // VP_METHOD_ENTRY_X( "content",             CSF_inner_html,
      // CSF_set_inner_html),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  static constant constants[] = {
      CONSTANT_ENTRY_X("STATE_LINK", int_value(html::S_LINK)),
      CONSTANT_ENTRY_X("STATE_HOVER", int_value(html::S_HOVER)),
      CONSTANT_ENTRY_X("STATE_ACTIVE", int_value(html::S_ACTIVE)),
      CONSTANT_ENTRY_X("STATE_FOCUS", int_value(html::S_FOCUS)),
      // CONSTANT_ENTRY_X("STATE_OWNS_FOCUS", int_value(html::S_OWNS_FOCUS)),
      CONSTANT_ENTRY_X("STATE_TAB_FOCUS", int_value(html::S_TABFOCUS)),
      CONSTANT_ENTRY_X("STATE_VISITED", int_value(html::S_VISITED)),
      CONSTANT_ENTRY_X("STATE_CURRENT", int_value(html::S_CURRENT)),
      CONSTANT_ENTRY_X("STATE_CHECKED", int_value(html::S_CHECKED)),
      CONSTANT_ENTRY_X("STATE_UNCHECKED", int_value(html::S_UNCHECKED)),
      CONSTANT_ENTRY_X("STATE_DISABLED", int_value(html::S_DISABLED)),
      CONSTANT_ENTRY_X("STATE_READONLY", int_value(html::S_READONLY)),
      CONSTANT_ENTRY_X("STATE_EXPANDED", int_value(html::S_EXPANDED)),
      CONSTANT_ENTRY_X("STATE_COLLAPSED", int_value(html::S_COLLAPSED)),
      CONSTANT_ENTRY_X("STATE_INCOMPLETE", int_value(html::S_INCOMPLETE)),
      CONSTANT_ENTRY_X("STATE_ANIMATING", int_value(html::S_ANIMATING)),
      CONSTANT_ENTRY_X("STATE_FOCUSABLE", int_value(html::S_FOCUSABLE)),
      CONSTANT_ENTRY_X("STATE_ANCHOR", int_value(html::S_ANCHOR)),
      CONSTANT_ENTRY_X("STATE_POPUP", int_value(html::S_POPUP)),
      CONSTANT_ENTRY_X("STATE_OWNS_POPUP", int_value(html::S_OWNS_POPUP)),
      CONSTANT_ENTRY_X("STATE_EMPTY", int_value(html::S_EMPTY)),
      CONSTANT_ENTRY_X("STATE_BUSY", int_value(html::S_BUSY)),
      CONSTANT_ENTRY_X("STATE_MOVING", int_value(html::S_MOVING)),
      CONSTANT_ENTRY_X("STATE_COPYING", int_value(html::S_COPYING)),
      CONSTANT_ENTRY_X("STATE_DROP_TARGET", int_value(html::S_DROP_TARGET)),
      CONSTANT_ENTRY_X("STATE_DRAG_OVER", int_value(html::S_DRAG_OVER)),
      CONSTANT_ENTRY_X("STATE_IS_RTL", int_value(html::S_IS_RTL)),
      CONSTANT_ENTRY_X("STATE_IS_LTR", int_value(html::S_IS_LTR)),
      CONSTANT_ENTRY_X("STATE_READY", int_value(html::S_READY)),

      CONSTANT_ENTRY_X(0, 0)};

  void xvm::init_element_class() {
    dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Element", methods, properties);

    /* create the 'Element' type */
    if (!pd) CsInsufficientMemory(this);

    /* setup alternate handlers */
    // pd->newInstance = (new_instance_t) MakeElement;

    pd->baseType = nodeDispatch;

    pd->getProperty = (get_property_t)GetElementProperty;
    pd->setProperty = (set_property_t)SetElementProperty;
    pd->scan        = ElementScan;
    // pd->size = ElementSize;
    pd->copy    = ElementCopy;
    pd->hash    = ElementHash;
    pd->getItem = (get_item_t)ElementGetItem;
    pd->setItem = (set_item_t)ElementSetItem;
    pd->print   = (print_t)ElementPrint;
    pd->printType = (print_t)ElementPrintType;

    pd->getNextElement = (get_next_element_t)ElementNextElement;

    pd->destroy    = (destructor_t)destroy_element;
    pd->interfaces = elementInterfaces;

    pd->handleCall = (call_method_t)HandleElementCall;
    pd->delItem    = (del_item_t)CsRemoveObjectProperty;

    pd->binOp = (binary_operator_t)ElementBinOp;

    CsEnterConstants(this, pd->obj, constants);

    elementDispatch = pd;

    static value sElementList = CsSymbolOf("ElementList");
    static value sNodeList    = CsSymbolOf("NodeList");

    elementListObject = CsNewClassInstance(
        this, /*WRONG: d->ns, creates cyclic ref*/ UNDEFINED_VALUE,
        sElementList);
    nodeListObject = CsNewClassInstance(
        this, /*WRONG: d->ns, creates cyclic ref*/ UNDEFINED_VALUE, sNodeList);

    CsAddConstant(this, CsGlobalScope(this)->globals, sElementList,
                  elementListObject);

// Note: "Behavior" is an alias of "Element"
//CsAddConstant(vm, d->ns, sBehavior, vm->elementDispatch->obj);
    CsSetNamespaceValue(this, CsSymbolOf("Behavior") , pd->obj, true);

  }

  value xvm::process_vnode(value factory, value atts, value kids, value states, html::hnode& he, html::hnode parent) {

    value vnode = NULL_VALUE;

    PROTECT_THIS(vnode, factory, atts, kids, states);

    value vparent = parent ? element_object(this, parent.ptr_of<html::element>()): NULL_VALUE;
    
    PROTECT_THIS(vparent);

    if (CsMethodP(factory)) {
      // <Dialog /> - Dialog is a function
      vnode = CsCallFunction(this->currentScope(), factory, 4, atts, kids, states, vparent);
#ifdef DEBUG
      //if (CsMethodP(vnode))
      //  vnode = vnode;
#endif
      if (CsTupleP(vnode)) {
        value vname = CsTupleName(vnode);
        if (CsClassP(vname) || CsMethodP(vname))
        {
          vnode = process_vnode(vname,
            CsVNodeAtts(vnode),
            CsVNodeKids(vnode),
            CsVNodeStates(vnode),
            he,
            parent);
        }
      }
    }
    else if (CsClassP(factory)) 
    {
      // <Dialog /> - Dialog is a class
      value inst = NULL_VALUE;
      PROTECT_THIS(inst);
      // 1. Create DOM element if needed for the vdom
      if (he) {
        // 1.a. handling exisitng element already present in the DOM
        inst = element_object(this, he.ptr_of<html::element>());
        assert(inst);
        //assert();
        if (CsObjectClass(inst) != factory) {
          CsSetObjectClass(inst, factory);
          CsMergeThisVarsFromClass(this, inst, factory);
          he.ptr_of<html::element>()->flags.script_need_attached_call = 1; // we want attached(), a.k.a. didMount
          he.ptr_of<html::element>()->flags.script_reactors_prototype = 1;
        }
        else
          goto STEP2;
      }
      else {
        // 1.b. creating brand new DOM element
        he = new html::element(html::tag::T_OBJECT); // tag will be set later
        he.ptr_of<html::element>()->flags.script_need_attached_call = 1; // we want attached(), a.k.a. didMount
        he.ptr_of<html::element>()->flags.script_reactors_prototype = 1;
        inst = element_object(this, he.ptr_of<html::element>());
        CsSetObjectClass(inst, factory);
        // do "preconstruct": assigining this var' defined in class
        CsMergeThisVarsFromClass(this, inst, factory);
      }

      {
        // 1.c styleset handling
        value ss;
        static value sym_styleset = CsSymbolOf(WCHARS("styleset"));
        if (CsGetProperty(this, inst, sym_styleset, &ss))
        {
          value name = 0, url = 0, important = 0;
          static value sym_important = CsSymbolOf(WCHARS("important"));
          if (CsVectorP(ss)) { // const styleset = ["name", url];
            auto elements = CsVectorElements(this, ss);
            if (elements.length < 2 || !CsStringP(elements[0]) || !CsStringP(elements[1]))
              CsThrowKnownError(this, CsErrUnexpectedTypeError, ss, "styleset must be [\"set name\",\"css url\"]");
            name = elements[0];
            url = elements[1];
            if (elements.length >= 3)
              important = elements[2];
          }
          else if (CsTupleP(ss)) { // const styleset = [name: url];
            auto elements = CsTupleElements(ss);
            if (elements.length < 1 || !CsStringP(elements[0]))
              CsThrowKnownError(this, CsErrUnexpectedTypeError, ss, "styleset must be [name:\"css url\"]");
            name = CsTupleName(ss);
            url = elements[0];
            if (elements.length > 1)
              important = elements[1];
          }
          he.ptr_of<html::element>()->forced_style_set(value_to_string(name), value_to_string(url), sym_important == important);
        }
      }
STEP2:
      // 2. invoke constructor. Note: in case of exisitng DOM element the constructor function
      //                              can be called multiple times on the same DOM element - each
      //                              time when we call render      
      value ctor;
      if (CsGetProperty(this, factory, THIS_SYM, &ctor) && CsMethodP(ctor)) {
        //CsThrowKnownError(c, CsErrNoMethod, "", c->val, sym_render);
        CsCallMethod(this, inst, ctor, factory, 4, atts, kids, states, vparent);
      }
      // 3. invoke {factory}.render() with `this` set to `inst` 
      static value sym_render = CsSymbolOf(WCHARS("render"));
      value render = 0;
      if (!CsGetProperty(this, factory, sym_render, &render) || !CsMethodP(render))
        CsThrowKnownError(this, CsErrNoMethod, "", render, sym_render); // it is mandatory
      vnode = CsCallMethod(this, inst, render, factory, 0);
      if (!CsTupleP(vnode))
        CsThrowKnownError(this, CsErrUnexpectedTypeError, vnode, "Tuple (vnode)");

      value vname = CsTupleName(vnode);

      if (CsClassP(vname) || CsMethodP(vname)) {
        tis::value r = process_vnode(vname,
          CsTupleElement(vnode, 0, NULL_VALUE),
          CsTupleElement(vnode, 1, NULL_VALUE),
          CsTupleElement(vnode, 2, NULL_VALUE),
          he,
          parent);
        vnode = r;
        if(CsVNodeP(vnode))
          vname = CsTupleName(vnode);
      }

      if (CsSymbolP(vname)) {
        string name = CsSymbolName(vname);
        he.ptr_of<html::element>()->tag = html::tag::symbol(name);
      }
    }
    else 
      assert(false); // neither function nor class

    if (CsVectorP(vnode))
        return vnode;

    if(!CsVNodeP(vnode) && !CsStringP(vnode))
      CsThrowKnownError(this, CsErrUnexpectedTypeError, vnode, "VNODE or string");
        
    if (CsObjectP(atts)) {
      PROTECT_THIS(atts);
      // "tunelling" id,class,name,type attributes
      static value sym_id = CsSymbolOf(WCHARS("id"));
      static value sym_class = CsSymbolOf(WCHARS("class"));
      static value sym_name = CsSymbolOf(WCHARS("name"));
      static value sym_type = CsSymbolOf(WCHARS("type"));
      value va_id = 0;    CsGetProperty(this, atts, sym_id, &va_id);
      value va_class = 0; CsGetProperty(this, atts, sym_class, &va_class);
      value va_name = 0;  CsGetProperty(this, atts, sym_name, &va_name);
      value va_type = 0;  CsGetProperty(this, atts, sym_type, &va_type);
      if (va_id || va_class || va_name || va_type) {
        value vatts = CsTupleElement(vnode, 0);
        PROTECT_THIS(vatts, va_id, va_class, va_name, va_type);
        if (!CsObjectP(vatts)) {
          vatts = CsMakeObject(this, this->objectObject);
          CsSetTupleElement(vnode, 0, vatts);
        }
        if (va_id) CsSetProperty(this, vatts, sym_id, va_id);
        if (va_name) CsSetProperty(this, vatts, sym_name, va_name);
        if (va_type) CsSetProperty(this, vatts, sym_type, va_type);
        if (va_class) {
          value previousClass = 0;
          if (CsGetProperty(this, vatts, sym_class, &previousClass)) // inherit class
          {
            ustring p_class = value_to_string(previousClass);
            ustring n_class = value_to_string(va_class);
            value new_class = CsMakeString(this, ustring::format(W("%s %s"), p_class.c_str(), n_class.c_str()));
            CsSetProperty(this, vatts, sym_class, new_class);
          }
          else
            CsSetProperty(this, vatts, sym_class, va_class);
        }
      }
    }

    if (CsObjectP(states)) {
      // "tunelling" states
      if (CsTupleSize(vnode) < 3) {
        value cvnode = CsMakeTuple(this, 3);
        PROTECT_THIS(cvnode);
        CsSetTupleName(cvnode, CsTupleName(vnode));
        CsSetTupleElement(cvnode, 0, CsTupleElement(vnode, 0));
        CsSetTupleElement(cvnode, 1, CsTupleElement(vnode, 1));
        value meta; 
        if(CsEntityMeta(vnode,meta)) 
          CsSetEntityMeta(cvnode, meta);
        vnode = cvnode;
        CsSetTupleElement(vnode, 2, states);
      }
      else {
        value estates = CsTupleElement(vnode, 2);
        if (CsObjectP(estates)) {
          value new_states = CsExtendObject(this, estates, states, false);
          CsSetTupleElement(vnode, 2, new_states);
        }
        else
          CsSetTupleElement(vnode, 2, states);
      } 
    }

    // for future DOM/VDOM reconciliations 
    if (he) {
      value factorydef = CsMakeVNode(this, factory, atts); // making reduced VNode as factory defintion
      PROTECT_THIS(factorydef);
      value inst = element_object(this, he.ptr_of<html::element>());
      CsSetEntityMeta(this,inst,sym_factory, factorydef);
    }

    return vnode;

  }


} // namespace tis

namespace html {

  /*bool element::is_x_focusable(view &v) {
    tis::xview *xv = (tis::xview *)pview();
    if (!xv) return false;
    tis::value obj = tis::element_object_nc(xv->vm, const_cast<element *>(this));
    if (obj) {
      dispatch* pd = CsGetDispatch(obj);
      tis::value selector = tis::get_sym_by_id(tis::id_onFocus);
      tis::value m = NULL_VALUE;
      tis::CsGetProperty(xv->vm, obj, selector, &m);
      return tis::CsMethodP(m);
    }
    return false;
  }*/

  bool element::send(const char *method_name, int argc, tool::value *argv,
                     tool::value *retval, bool optional) {
    tis::xview *xv = (tis::xview *)pview();
    if (xv) {
      return tis::call_element_method(xv->vm, this, method_name, argc, argv,
                                      *retval);
    }
    return false;
  }

  uint script_animator::start(view &v, element *b, const style *nst,
                              const style *ost) {
    return step(v, b, v.get_animation_ticks());
  }

  uint script_animator::step(view &v, element *b, uint current_clock) {
    if (cbf.is_set() && tis::CsMethodP(cbf)) {
      tis::xvm *      vm = (tis::xvm *)cbf.pvm;
      html::document *pd = b->doc();
      if (!pd) return 0;
      tis::auto_scope as(vm, pd->ns);
      TRY {
        bool done = false;
        if (duration.is_defined()) {
          if (current_clock > start_clock + duration) {
            current_clock = start_clock + duration;
            done          = true;
          }
        }
        if (done) return 0;

        tis::value obj       = tis::element_object(vm, b);
        tis::value vprogress = tis::float_value(progress(current_clock));
        tis::value r         = tis::CsSendMessage(vm, obj, cbf, &vprogress, 1);
        if (tis::CsIntegerP(r)) {
          uint t = (uint)tis::CsIntegerValue(r);
          // if( t == 0 )
          //  stopped = true;
          return t;
        } else if (tis::CsDurationP(r)) {
          uint t = (uint)(tis::CsDurationSeconds(r) * 1000.0);
          // if( t == 0 )
          //  stopped = true;
          return t;
        }

        else if (r == TRUE_VALUE)
          return html::ANIMATION_TIMER_SPAN;
        if (duration.is_defined() && r == NOTHING_VALUE)
          return html::ANIMATION_TIMER_SPAN;

        // stopped = true;
        return 0;
      }
      CATCH_ERROR(e) {
        if (e.number == 0) // close() called
          return 0;
        else
          tis::CsHandleUnhandledError(vm);
      }
    }
    // tis::dispatch* pd = tis::CsGetDispatch(cbf);
    return 0;
  }

  void script_animator::stop(view &v, element *b) {
    html::document *pd = b->doc();
    if (!pd) return;

    if (cbf.is_set() && tis::CsMethodP(cbf)) {
      tis::xvm *      vm = (tis::xvm *)cbf.pvm;
      tis::auto_scope as(vm, pd->ns);
      TRY {
        tis::value obj       = tis::element_object(vm, b);
        tis::value vprogress = tis::float_value(1.0);
        tis::CsSendMessage(vm, obj, cbf, &vprogress, 1);
      }
      CATCH_ERROR(e) {
        if (e.number != 0) // close() called
          tis::CsHandleUnhandledError(vm);
      }
    }

    if (fin_cbf.is_set() && tis::CsMethodP(fin_cbf)) {
      tis::xvm *      vm = (tis::xvm *)fin_cbf.pvm;
      tis::auto_scope as(vm, pd->ns);
      try {
        tis::value obj = tis::element_object(vm, b);
        tis::CsSendMessage(vm, obj, fin_cbf);
      } catch (tis::script_exception &e) {
        if (e.number != 0) // close() called
          tis::CsDisplay(vm, vm->val, vm->standardError);
      }
    }
    cbf.unpin();
    fin_cbf.unpin();
    v.check_mouse(true);
  }


  // SSX stuff:
  namespace behavior {

    struct reactor_ctl_factory : public ctl_factory {
      reactor_ctl_factory() : ctl_factory("reactor") {}
      virtual ctl *create(element *el);
    };

    static reactor_ctl_factory *_reactor_ctl = 0;

    struct reactor_ctl : ctl {

      reactor_ctl() {}

      virtual CTL_TYPE get_type() override { return CTL_UNKNOWN; }
      virtual bool     is_atomic() const override { return true; }

      virtual const string &behavior_name() const {
        return _reactor_ctl->name;
      }

      virtual bool attach(view &v, element *self) override {
        html::hdocument d = self->doc();
        if (!d) return false;
        xview* xv = static_cast<xview*>(&v);
        bool is_loading = !d->state.ready();
        if (is_loading) {
          event_behavior evt(self, self, MOUNT_COMPONENT, 0);
          xv->post_behavior_event(evt,true);
          return true;
        }
        else {
          xv->mount_component(self);
          return true;
        }
      }

      virtual bool on(view &v, element *self, event_behavior &evt) override { 
        if (evt.cmd == MOUNT_COMPONENT) {
          xview* xv = static_cast<xview*>(&v);
          xv->mount_component(self);
          return true;
        }
        return false; 
      }

    };

    ctl *reactor_ctl_factory::create(element *el) {
      return new reactor_ctl();
    }

    void init_reactor() {
      ctl_factory::add(_reactor_ctl = new reactor_ctl_factory());
    }

  } // namespace behavior

} // namespace html

bool sciter_get_expando(html::element *b, tool::value &pval,
                        bool force_creation) {
  tis::xview *pv = static_cast<tis::xview *>(b->pview());
  if (!pv) return false;

  if (!tis::has_object(b)) {
    if (!force_creation) {
      pval = tool::value::null_val();
      return true;
    }
    b->obj = tis::CsMakeCPtrObject(pv->vm, pv->vm->elementDispatch, b);
    b->add_ref();
  } else {
    tis::dispatch *pd = tis::CsGetDispatch(b->obj);
    assert(pd == pv->vm->elementDispatch);
    pd = pd;
  }

  pval = tis::value_to_value(pv->vm, b->obj);
  return true;
}

bool sciter_get_object(html::element *b, tis::value &pval,
                       bool force_creation) {
  if (!tis::has_object(b)) {
    if (!force_creation) {
      pval = 0;
      return true;
    }
    tis::xview *pv = (tis::xview *)b->pview();
    if (!pv) return false;
    b->obj = tis::CsMakeCPtrObject(pv->vm, pv->vm->elementDispatch, b);
    b->add_ref();
  }

  pval = b->obj;

  return true;
}

bool sciter_call_scripting_function(html::element *b, const char *name,
                                    const tool::value *argv, uint argc,
                                    tool::value &retval, bool this_method) {
  html::view *pv = b->pview();
  if (!pv) return false;

  critical_section _(pv->guard);

  tis::xview *xv = (tis::xview *)pv;
  try {
    if (this_method)
      return tis::call_element_method(xv->vm, b, name, argc, argv, retval);
    else
      return tis::call_element_function(xv->vm, b, name, argc, argv, retval);
  } catch (tis::script_exception &e) {
    retval = tis::value_to_value(xv->vm, xv->vm->val);
    e;
    tis::CsDisplay(xv->vm, xv->vm->val, xv->vm->standardError);
    return false;
  }
}



/*bool sciter_call_scripting_method( html::element* b, const char* name, const
tool::value* argv, uint argc, tool::value& retval, bool this_method )
{
  html::view* pv = b->pview();
  if(!pv)
    return false;

  tis::xview* xv = (tis::xview*)pv;
  try
  {
    if( this_method )
      return tis::call_element_method(xv->vm,b,name,argc,argv, retval);
    else
      return tis::call_element_function(xv->vm,b,name,argc,argv, retval);
  }
  catch(tis::script_exception& e)
  {
    e;
    tis::CsDisplay(xv->vm,xv->vm->val,xv->vm->standardError);
    return false;
  }
  return true;
}*/
