#pragma once

#ifndef __xdom_h__
#define __xdom_h__

#include "html/html.h"
#include "tiscript/include/cs.h"

namespace tis {
  using namespace tool;
  using namespace gool;

  class xvm;
  class xview;

  value element_object(xvm *pvm, html::element *b);
  value element_object_nc(xvm *pvm, html::element *b);
  html::element *element_ptr(xvm *c, value obj);
  html::element *element_ptr_no_throw(xvm *c, value obj);

  bool CsElementP(xvm* c, value obj);
  
  struct ElementCreatorCtx : public gc_callback, public html::context // note, this must be created on stack only
  {
    xview* pv;    
    value tuple; // velement
    html::helement b;
    html::helement parent;
    array<html::hnode> nodes;
    //int map_counter = 0;
    ElementCreatorCtx(const ElementCreatorCtx&) = delete;
    ElementCreatorCtx(xview *pv, value velement, html::hnode parent);

    html::document* pdoc() const override;
    html::view* pview() const override;

    html::helement make();

    virtual void on_GC(VM *c) override;

    void crack_item(value item, array<html::hnode>& list, int n);
    void set_states(value vstates);
    void set_attributes(value vatts);
    void exec_ref(value ref);

  };

}

#endif