#include "config.h"
#include "xsciter.h"
#include "xview.h"

#if defined(WINDOWLESS)
  
#elif defined(NATIVE_WINDOWS_BACKEND)
  #include "win/win-frame.h"
#elif defined(NATIVE_OSX_BACKEND)
  #include "osx/osx-sciter.h"
#elif defined(NATIVE_GTK_BACKEND)
  #include "gtk/gtk-sciter.h"
#endif

extern bool get_html_resource(const char *res_id, char *&pbstart, char *&pbend);

namespace tis {

  // typedef mswin::dialog xdialog;
  // typedef mswin::frame  xframe;

  value CSF_dialog(xvm *c) {
    value obj;
    value src;
    value prm = UNDEFINED_VALUE;
    int_t alignment = 5;

    CsParseArguments(c, "V=*V|V|i", &obj, c->viewDispatch, &src, &prm,
      &alignment);

    /*if( alignment >= 1 && alignment <= 9)
      alignment = -alignment;
    else
      alignment = 0; */

    xview *pv = xview_ptr(c, obj);
    if (!pv) return UNDEFINED_VALUE;

    if (pv->dismissing)
      CsThrowKnownError(c, CsErrGenericError, "view is closed");

    handle<html::view> xd;

    window_params params(html::DIALOG_WINDOW);
    params.parent = pv;

    params.debug_mode = pv->debug_mode();

    if (CsObjectP(src) /* view.dialog {params} */) {
      ustring html;
      ustring url;

      CsGetProperty(c, src, "url", url); params.url = url;

      handle<html::pump::request> prq = new html::pump::request(params.url, html::DATA_HTML);

      if (CsGetProperty(c, src, "html", html)) {
        u8::from_utf16(html, prq->data, true);
      }
      else if (params.url.length()) {
        prq->url =
          html::combine_url(pv->doc()->uri().src, url::escape(params.url));
        if (!pv->load_data(prq, true))
          CsThrowKnownError(c, CsErrFileNotFound, params.url.c_str());
      }

      params.data = prq->data();
      params.alignment = 5;
      CsGetProperty(c, src, "caption", params.caption);
      CsGetProperty(c, src, "alignment", params.alignment);
      CsGetProperty(c, src, "screen", params.screen_no._v);
      CsGetProperty(c, src, "width", params.dim.x._v);
      CsGetProperty(c, src, "height", params.dim.y._v);
      CsGetProperty(c, src, "x", params.pos.x._v);
      CsGetProperty(c, src, "y", params.pos.y._v);
      CsGetProperty(c, src, "client", params.client_coordinates);

      params.direct_window = false;
      bool dw;
      if (CsGetProperty(c, src, "direct", dw))
        params.direct_window = dw;

      if (!CsGetProperty(c, src, CsSymbolOf("parameters"), &prm))
        prm = UNDEFINED_VALUE;
      params.window_parameters = value_to_value(c, prm);
      xd = app()->create_dialog(params);
      if (!xd) return UNDEFINED_VALUE;
      xd->notify_data_arrived(nullptr, prq);
      bool  r = xd->show_modal();
      value retval = xd.ptr_of<xview>()->dialog_retval;
      return r ? retval : NOTHING_VALUE;
    }
    else if (CsStringP(src) && CsStringSize(src)) {
      c->val = prm;
      tool::string  path = html::combine_url(pv->doc()->uri().src, url::escape(CsStringChars(src)));
      handle<html::pump::request> prq = new html::pump::request(path, html::DATA_HTML);
      // to prevent tracker to be used on this view, we report it later
      // auto_state<decltype(pv->url_data_tracker)>
      // tracker(pv->url_data_tracker,nullptr);
      if (pv->load_data(prq)) {
        params.data = prq->data();
        params.alignment = alignment;
        params.url = prq->url;
        xd = app()->create_dialog(params);
        xd->notify_data_arrived(nullptr, prq);
        bool r = xd->show_modal();
        // CsDumpScopes(c);
        value retval = xd.ptr_of<xview>()->dialog_retval;
        return r ? retval : NOTHING_VALUE;
      }
      else
        CsThrowKnownError(c, CsErrFileNotFound, CsStringAddress(src));

      // return UNDEFINED_VALUE;
    }
    else if (CsFileP(c, src) && CsFileStream(src) &&
      CsFileStream(src)->is_string_stream()) {
      string_stream *ss = (string_stream *)CsFileStream(src);
      // tool::string path = c->combine_url(pv->doc()->url().src,
      // ss->stream_name());
      c->val = prm;
      params.data = ss->buf();
      params.alignment = alignment;
      params.url = string(ss->stream_name());
      xd = app()->create_dialog(params);
      if (!xd) return UNDEFINED_VALUE;
      bool  r = xd->show_modal();
      value retval = xd.ptr_of<xview>()->dialog_retval;
      return r ? retval : NOTHING_VALUE;
    }
    /*else if(CsVNodeP(src))
    {
      params.url = "sciter:vmsgbox.htm";
      handle<html::pump::request> prq = new html::pump::request(params.url, html::DATA_HTML);
      if (!pv->load_data(prq, true))
          CsThrowKnownError(c, CsErrFileNotFound, params.url.c_str());

      c->val = src;
      params.data = prq->data();
      params.alignment = -5;

      value atts = CsVNodeAtts(src);
      if (CsObjectP(atts)) {
        CsGetProperty(c, atts, "caption", params.caption);
        CsGetProperty(c, atts, "alignment", params.alignment);
        CsGetProperty(c, atts, "screen", params.screen_no._v);
        CsGetProperty(c, atts, "width", params.dim.x._v);
        CsGetProperty(c, atts, "height", params.dim.y._v);
        CsGetProperty(c, atts, "x", params.pos.x._v);
        CsGetProperty(c, atts, "y", params.pos.y._v);
        CsGetProperty(c, atts, "client", params.client_coordinates);

        params.direct_window = false;
        bool dw;
        if (CsGetProperty(c, atts, "direct", dw))
          params.direct_window = dw;

        if (!CsGetProperty(c, atts, CsSymbolOf("parameters"), &prm))
          prm = UNDEFINED_VALUE;
      }
      params.window_parameters = value_to_value(c, src);
      xd = app()->create_dialog(params);
      if (!xd) return UNDEFINED_VALUE;
      xd->notify_data_arrived(nullptr, prq);
      bool  r = xd->show_modal();
      value retval = xd.ptr_of<xview>()->dialog_retval;
      return r ? retval : NOTHING_VALUE;
    } */
    else {
      CsThrowKnownError(c, CsErrUnexpectedTypeError, src,
        "source is neither url:string nor in-memory stream");
    }
    return UNDEFINED_VALUE;
  }

  value CSF_window(xvm *c) {
    value obj = UNDEFINED_VALUE;
    value prm = UNDEFINED_VALUE;

    CsParseArguments(c, "V*V=", &obj, &prm, &CsObjectDispatch);

    window_params params(html::TOOL_WINDOW);

    xview *pv = xview_ptr(c, obj);
    if (!pv) {
      pv = c->current_view();
      if (!pv) return UNDEFINED_VALUE;
      params.is_detached = true;
    }

    params.debug_mode = pv->debug_mode();
    params.parent     = pv;

    ustring html;
    ustring url;

    CsGetProperty(c, prm, "url", url); params.url = url;

    handle<html::pump::request> prq =
        new html::pump::request(params.url, html::DATA_HTML);

    if (CsGetProperty(c, prm, "html", html)) {
      u8::from_utf16(html, prq->data, true);
    } else if (params.url.length()) {
      //tool::string path =
      //    html::combine_url(pv->doc()->uri().src, url::escape(params.url));
      params.url = html::combine_url(pv->doc()->uri().src, url::escape(params.url));
      // to prevent tracker to be used on this view, we report it later
      // auto_state<decltype(pv->url_data_tracker)>
      // tracker(pv->url_data_tracker,nullptr);
      //if (!pv->load_data(prq, true))
      //  CsThrowKnownError(c, CsErrFileNotFound, params.url.c_str());
      //params.url = 
    } else 
      CsThrowKnownError(c, CsErrGenericError, "url or html required");

    params.data = prq->data();
    CsGetProperty(c, prm, "caption", params.caption);
    CsGetProperty(c, prm, "alignment", params.alignment);
    CsGetProperty(c, prm, "screen", params.screen_no._v);
    CsGetProperty(c, prm, "width", params.dim.x._v);
    CsGetProperty(c, prm, "height", params.dim.y._v);
    CsGetProperty(c, prm, "x", params.pos.x._v);
    CsGetProperty(c, prm, "y", params.pos.y._v);
    CsGetProperty(c, prm, "client", params.client_coordinates);

    bool dw;
    if (CsGetProperty(c, prm, "direct", dw))
      params.direct_window = dw;

    int_t wtype = 0;
    if (CsGetProperty(c, prm, "type", wtype))
      params.set((html::WINDOW_TYPE)wtype);

    int_t state = -1;
    CsGetProperty(c, prm, "state", state);
    switch (state) {
    case html::WINDOW_SHOWN: params.window_state = html::WINDOW_SHOWN; break;
    case html::WINDOW_HIDDEN: params.window_state = html::WINDOW_HIDDEN; break;
    case html::WINDOW_MINIMIZED:
      params.window_state = html::WINDOW_MINIMIZED;
      break;
    case html::WINDOW_MAXIMIZED:
      params.window_state = html::WINDOW_MAXIMIZED;
      break;
    case html::WINDOW_FULL_SCREEN:
      params.window_state = html::WINDOW_FULL_SCREEN;
      break;
    default: params.window_state = html::WINDOW_SHOWN; break;
    }

    value prms = UNDEFINED_VALUE;

    CsGetProperty(c, prm, CsSymbolOf("parameters"), &prms);

    params.window_parameters = value_to_value(c, prms);

    //c->val              = prms;
    handle<html::view> frm = app()->create_frame(params);
    if (frm) {
      if(prq->data.length())
        frm->notify_data_arrived(nullptr, prq);
      if (params.window_state &&
          (frm->get_window_state() != params.window_state))
        frm->set_window_state(params.window_state);
      return frm.ptr_of<tis::xview>()->view_obj;
    }

    return NULL_VALUE;
  }

  value CSF_msgbox(xvm *c) {
    value obj = 0;
    value vns = CsMakeObject(c, UNDEFINED_VALUE);
    PROTECT(vns, obj);
    CsSetObjectProperty(c, vns, CsSymbolOf("type"), UNDEFINED_VALUE);
    CsSetObjectProperty(c, vns, CsSymbolOf("title"), UNDEFINED_VALUE);
    CsSetObjectProperty(c, vns, CsSymbolOf("caption"), UNDEFINED_VALUE);
    CsSetObjectProperty(c, vns, CsSymbolOf("content"), UNDEFINED_VALUE);
    CsSetObjectProperty(c, vns, CsSymbolOf("buttons"), UNDEFINED_VALUE);
    CsSetObjectProperty(c, vns, CsSymbolOf("onLoad"), UNDEFINED_VALUE);
    CsSetObjectProperty(c, vns, CsSymbolOf("onClose"), UNDEFINED_VALUE);

    /*
       var parameters =
       {
          type:    #alert,
          title:   "Test",
          content: "Test content",
          buttons: [#yes, #no]
       };
       var output_stream = Stream.openString();
       emit("samples/std-dialog.htm",output_stream, parameters);
       var v = view.dialog( output_stream, parameters );
     */

    value text    = UNDEFINED_VALUE;
    value caption = UNDEFINED_VALUE;
    value type    = UNDEFINED_VALUE;
    value buttons = UNDEFINED_VALUE;
    value onLoad  = UNDEFINED_VALUE;
    value onClose = UNDEFINED_VALUE;

    CsParseArguments(c, "V=*V|V|V|V|V|V", &obj, c->viewDispatch, &type, &text,
                     &caption, &buttons, &onLoad, &onClose);

    xview *pv = xview_ptr(c, obj);
    if (!pv) return UNDEFINED_VALUE;

    if (pv->dismissing)
      CsThrowKnownError(c, CsErrGenericError, "view is closed");

    bytes facade;

    handle<html::pump::request> prq =
        new html::pump::request("sciter:msgbox.htm", html::DATA_HTML);

    {
      // to prevent tracker to be used on this view, we report it later
      // auto_state<decltype(pv->url_data_tracker)>
      // tracker(pv->url_data_tracker,nullptr);
      if (!pv->load_data(prq, true)) return UNDEFINED_VALUE;
    }

    facade = prq->data();

    // facade = app()->get_resource(W("msgbox"),W("html"));
    // if(!facade)
    //  return UNDEFINED_VALUE;

    string_stream sin;
    sin.buf.push(facade);
    string_stream sout(256);

    if (CsObjectP(type))
      vns = type;
    else {
      if (text == UNDEFINED_VALUE && CsStringP(type)) {
        text = type;
        type = CsSymbolOf("information");
      }
      CsSetObjectProperty(c, vns, CsSymbolOf("type"), type);
      CsSetObjectProperty(c, vns, CsSymbolOf("caption"), caption);
      CsSetObjectProperty(c, vns, CsSymbolOf("content"), text);
      CsSetObjectProperty(c, vns, CsSymbolOf("buttons"), buttons);
      CsSetObjectProperty(c, vns, CsSymbolOf("onLoad"), onLoad);
      CsSetObjectProperty(c, vns, CsSymbolOf("onClose"), onClose);
    }

    {
      auto_scope as(c, vns, true);
      CsLoadStream(c->currentScope(), &sin, &sout);
    }
    //c->val = vns;

    // ustring us = ustring::utf8(sout.buf.head(),sout.buf.size());
    //::MessageBoxW(NULL,us,L"Test",MB_OK);

    window_params params(html::DIALOG_WINDOW);

    params.window_parameters = value_to_value(c, vns);

    params.alignment = -5;
    //params.screen_no = html::screen_of(pv);
    params.data      = sout.buf();
    params.parent    = pv;
    params.url       = CHARS("sciter:msgbox.htm");
    params.direct_window = false;

    handle<html::view> xd = app()->create_dialog(params);
    xd->notify_data_arrived(nullptr, prq);
    // handle<xdialog> xd = xdialog::construct(params);
    // xd->set_focus_on(html::view::FOCUS_FIRST);
    bool r = xd->show_modal();

    value retval = xd.ptr_of<xview>()->dialog_retval;
    return r ? retval : UNDEFINED_VALUE;
    //#else
    //    return UNDEFINED_VALUE;
    //#endif
  }

} // namespace tis
