#include "xsciter.h"

namespace tis {
  // using namespace tis;
  // using namespace html;

  static html::element *attributes_element_ptr(xvm *c, value obj) {
    assert(CsGetDispatch(obj) == c->elementInterfaces[ATTRIBUTE_IFACE]);
    if (CsGetDispatch(obj) != c->elementInterfaces[ATTRIBUTE_IFACE]) return 0;

    html::node *n = static_cast<html::node *>(CsCObjectValue(obj));
    assert(n && n->is_element());
    return n->cast<html::element>();

    // html::element* b = static_cast<html::element*>(CsCObjectValue(obj));
    // assert(b);
    // return b;

    // return static_cast<html::element*>(ptr<html::element>(obj));
  }

  static value CSF_name(xvm *c) {
    value obj;
    int_t idx;
    CsParseArguments(c, "V=*i", &obj, c->elementInterfaces[ATTRIBUTE_IFACE],
                     &idx);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (idx < 0 || idx >= self->atts.size()) return UNDEFINED_VALUE;
    string s = self->atts.name(idx);
    return string_to_value(c, ustring(s));
  }

  static bool RemoveAttr(xvm *c, value obj, value key) {
    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return false;

    if (CsStringP(key)) {
      string s = value_to_string(key);
      self->remove_attr(s);
      return true;
    }
    else if (CsIntegerP(key)) {
      int i = CsIntegerValue(key);
      if (i < 0 || i >= self->atts.size()) return false;
      self->remove_attr(self->atts.symbol(i));
      return true;
    }
    else if (CsSymbolP(key)) {
      string s = CsSymbolName(key);
      self->remove_attr(s);
      return true;
    }
    return false;
  }

  static value CSF_remove(xvm *c) {
    value obj;
    value tag;
    CsParseArguments(c, "V=*V", &obj, c->elementInterfaces[ATTRIBUTE_IFACE], &tag);

    RemoveAttr(c, obj, tag);
    return UNDEFINED_VALUE;
  }

  static value CSF_exists(xvm *c) {
    value obj;
    value tag;
    CsParseArguments(c, "V=*V", &obj, c->elementInterfaces[ATTRIBUTE_IFACE],
                     &tag);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (CsStringP(tag) || CsSymbolP(tag)) {
      string s = value_to_string(tag);
      return self->atts.exist(s) ? TRUE_VALUE : FALSE_VALUE;
    } else if (CsIntegerP(tag)) {
      int i = CsIntegerValue(tag);
      if (i < 0 || i >= self->atts.size()) return FALSE_VALUE;
      return TRUE_VALUE;
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_set(xvm *c) {
    value obj;
    value atts;
    CsParseArguments(c, "V=*V=", &obj, c->elementInterfaces[ATTRIBUTE_IFACE],
                     &atts, &CsObjectDispatch);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    each_property gen(c, atts);
    value         tag = 0, val = 0;
    PROTECT(tag, val);
    while (gen(tag, val)) {
      if (!CsStringP(tag) && !CsSymbolP(tag))
        CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                          "string or symbol as an attribute name");
      string name = value_to_string(tag);
      if (val != UNDEFINED_VALUE && val != NULL_VALUE)
        self->set_attr(name, value_to_string(CsToString(c, val)));
      else
        self->remove_attr(name);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_clear(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->elementInterfaces[ATTRIBUTE_IFACE]);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    self->atts.clear();
    html::view *pv = self->pview();
    if (pv) {
      pv->add_to_update(self, true);
      self->clear_style();
    }

    return UNDEFINED_VALUE;
  }

  static value CSF_addClass(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*|", &obj, c->elementInterfaces[ATTRIBUTE_IFACE]);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    tool::ustring cls = trim(self->attr_class()());
    for (int n = 3; n <= CsArgCnt(c); ++n) {
      tool::ustring to_add = value_to_string(CsToString(c, CsGetArg(c, n)));
      if (match_list(to_add(), cls(), WCHARS(" "))) continue; // already there.
      if (cls.length()) cls += WCHARS(" ");
      cls += to_add;
    }
    self->set_attr(html::attr::a_class, cls);

    return iface_base(
        obj); // return the Element instance, this will allow to chain calls
  }

  static value CSF_removeClass(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*|", &obj, c->elementInterfaces[ATTRIBUTE_IFACE]);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    tool::ustring             cls = self->attr_class();
    tool::array<tool::wchars> items;
    tool::wtokens             ts(cls, WCHARS(" "));
    for (tool::wchars item; ts.next(item);)
      items.push(item);

    int n, n_changes = 0;
    for (n = 3; n <= CsArgCnt(c); ++n) {
      tool::ustring to_remove = value_to_string(CsToString(c, CsGetArg(c, n)));
      int           idx       = items.get_index(to_remove);
      if (idx >= 0) {
        ++n_changes;
        items.remove(idx);
      }
    }
    if (n_changes == 0)
      return iface_base(
          obj); // return the Element instance, this will allow to chain calls

    tool::array<wchar> cls_out;
    for (n = 0; n < items.size(); ++n) {
      if (n) cls_out.push(' ');
      cls_out.push(items[n]);
    }
    if (cls_out.size())
      self->set_attr(html::attr::a_class, cls_out());
    else
      self->remove_attr(html::attr::a_class);

    return iface_base(
        obj); // return the Element instance, this will allow to chain calls
  }

  static value CSF_toggleClass(xvm *c) {
    value  obj;
    wchars cls;
    value  onoff = 0;
    CsParseArguments(c, "V=*S#|V", &obj, c->elementInterfaces[ATTRIBUTE_IFACE],
                     &cls.start, &cls.length, &onoff);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (!onoff || onoff == UNDEFINED_VALUE)
      onoff = self->atts.has_class(cls) ? FALSE_VALUE : TRUE_VALUE;
    else
      onoff = CsToBoolean(c, onoff);

    ustring nc;

    if (onoff == TRUE_VALUE)
      goto ADD_CLASS;
    else
      goto REMOVE_CLASS;

  REMOVE_CLASS:

    if (self->atts.remove_class(cls, nc)) {
      if (nc.length())
        self->set_attr(html::attr::a_class, nc);
      else
        self->remove_attr(html::attr::a_class);
    }

    return iface_base(
        obj); // return the Element instance, this will allow to chain calls

  ADD_CLASS:

    if (self->atts.add_class(cls, nc)) self->set_attr(html::attr::a_class, nc);

    return iface_base(
        obj); // return the Element instance, this will allow to chain calls
  }

  static value CSF_hasClass(xvm *c) {
    value  obj;
    wchars cls;
    CsParseArguments(c, "V=*S#", &obj, c->elementInterfaces[ATTRIBUTE_IFACE],
                     &cls.start, &cls.length);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return self->atts.has_class(cls) ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_toObject(xvm *c) {
    value  obj;
    CsParseArguments(c, "V=*", &obj, c->elementInterfaces[ATTRIBUTE_IFACE]);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    if (self->atts.items.length() == 0)
      return NULL_VALUE;

    value map = CsMakeObject(c, c->objectObject);
    PROTECT(map);
    for (auto& item : self->atts.items) {
      value val = string_to_value(c, item.att_value);
      CsSetProperty(c, map, CsSymbolOf(html::attr::symbol_name(item.att_sym)()),val);
    }
    return map;    
  }

  void object_to_attribute_bag(VM *c, value o, html::attribute_bag &atts);

  static value CSF_fromObject(xvm *c) {
    value  obj;
    value  map;
    CsParseArguments(c, "V=*V=", &obj, c->elementInterfaces[ATTRIBUTE_IFACE], &map, &CsObjectDispatch);

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    html::attribute_bag atts;
    object_to_attribute_bag(c, map, atts);

    bool changes = self->set_attributes(atts);

    return changes ? TRUE_VALUE : FALSE_VALUE;
  }


  static value CSF_length(xvm *c, value obj) {
    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return CsMakeInteger(self->atts.size());
  }

  static value CSF_hasBound(xvm *c, value obj) {
    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return self->atts.has_bound ? TRUE_VALUE : FALSE_VALUE;
  }

  //has - bound - attributes

  /* element methods */
  static c_method methods[] = {C_METHOD_ENTRY_X("name", CSF_name),
                               C_METHOD_ENTRY_X("remove", CSF_remove),
                               C_METHOD_ENTRY_X("clear", CSF_clear),
                               C_METHOD_ENTRY_X("exists", CSF_exists),
                               C_METHOD_ENTRY_X("exist", CSF_exists),
                               C_METHOD_ENTRY_X("set", CSF_set),

                               C_METHOD_ENTRY_X("addClass", CSF_addClass),
                               C_METHOD_ENTRY_X("removeClass", CSF_removeClass),
                               C_METHOD_ENTRY_X("toggleClass", CSF_toggleClass),
                               C_METHOD_ENTRY_X("hasClass", CSF_hasClass),

                               C_METHOD_ENTRY_X("toObject", CSF_toObject),
                               C_METHOD_ENTRY_X("fromObject", CSF_fromObject),

                               C_METHOD_ENTRY_X(0, 0)};

  /* String properties */
  static vp_method properties[] = {VP_METHOD_ENTRY_X("length", CSF_length, 0),
                                   VP_METHOD_ENTRY_X("hasBound", CSF_hasBound, 0),
                                   VP_METHOD_ENTRY_X(0, 0, 0)};

  void destroy_attributes(xvm *c, value obj) { ; }

  extern long ElementSize(value obj);
  extern void ElementScan(VM *c, value obj);
  // extern value ElementCopy(VM *c,value obj);
  extern int_t ElementHash(value obj);

  static value GetNextElement(xvm *c, value *index, value obj, int nr) {
    int_t          idx = 0;
    html::element *b   = attributes_element_ptr(c, obj);
    assert(b);
    if (!b)
      //CS_RETURN2(c, NOTHING_VALUE, NOTHING_VALUE);
      return NOTHING_VALUE;

    if (*index != NOTHING_VALUE) {
      idx = CsIntegerValue(*index) + 1; // not first
    }
    *index = CsMakeInteger(idx);
    if (idx >= b->atts.size()) 
      //CS_RETURN2(c,NOTHING_VALUE, NOTHING_VALUE);
      return NOTHING_VALUE;
    //CsSetRVal(c, 1, string_to_value(c, ustring(b->atts.value(idx))));
    //return string_to_value(c, ustring(b->atts.name(idx)));
    value n = 0, v = 0;
    PROTECT(n, v);
    if(nr > 1)
    {
      v = string_to_value(c, ustring(b->atts.value(idx)));
      n = string_to_value(c, ustring(b->atts.name(idx)));
      CS_RETURN2(c, n, v);
    } else 
      return string_to_value(c, ustring(b->atts.name(idx)));
  }

  /* GetElementProperty - mimics GetObjectProperty */
  static bool GetProperty(xvm *c, value &obj, value tag, value *pValue) {
    value     p;
    dispatch *d = c->elementInterfaces[ATTRIBUTE_IFACE];
    if ((p = CsFindProperty(c, d->obj, tag, nullptr, nullptr)) != NIL_VALUE) {
      value propValue = CsPropertyValue(p);
      if (CsVPMethodP(propValue)) {
        vp_method *method = ptr<vp_method>(propValue);
        if (method->get(c, obj, *pValue))
          return true;
        else
          CsThrowKnownError(c, CsErrReadOnlyProperty, tag);
      } else {
        *pValue = propValue;
        return true;
      }
    }
    return false;
  }

  /* SetElementProperty - mimics SetObjectProperty  */
  static bool SetProperty(xvm *c, value obj, value tag, value val) {
    return false;
    // return CsSetCObjectProperty(c,obj,tag,val);
  }

  static value GetItem(xvm *c, value obj, value tag) {
    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    if (CsStringP(tag)) {
      string s = value_to_string(tag);
      // string_value(s,tag);
      if (!self->atts.exist(s))
        return UNDEFINED_VALUE;
      else
        return string_to_value(c, self->atts(s));
    } else if (CsSymbolP(tag)) {
      string s = CsSymbolName(tag);
      // string_value(s,tag);
      if (!self->atts.exist(s))
        return UNDEFINED_VALUE;
      else
        return string_to_value(c, self->atts(s));
    } else if (CsIntegerP(tag)) {
      int i = CsIntegerValue(tag);
      if (i < 0 || i >= self->atts.size())
        return UNDEFINED_VALUE;
      else
        return string_to_value(c, self->atts.value(i));
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                        "string or integer as index");
    return UNDEFINED_VALUE;
  }
  static void SetItem(xvm *c, value obj, value tag, value value) {

    html::element *self = attributes_element_ptr(c, obj);
    if (!self) return;

    PROTECT(obj, tag);

    if (!CsStringP(value) && !CsSymbolP(value)) value = CsToString(c, value);

    ustring s;
    if (value != UNDEFINED_VALUE && value != NULL_VALUE) {
      value = CsToString(c, value);
      s     = value_to_string(value);
    }

    if (CsIntegerP(tag)) {
      int_t i = CsIntegerValue(tag);
      if (i < 0 || i >= self->atts.size())
        CsThrowKnownError(c, CsErrIndexOutOfBounds, tag);
      if (value != UNDEFINED_VALUE && value != NULL_VALUE)
        self->set_attr(self->atts.symbol(i), s);
      else
        self->remove_attr(self->atts.symbol(i));
    } else if (CsStringP(tag)) {
      string n = value_to_string(tag);
      if (value != UNDEFINED_VALUE && value != NULL_VALUE) {
        self->set_attr(n, s);
      } else
        self->remove_attr(n);
    } else if (CsSymbolP(tag)) {
      string n = CsSymbolName(tag);
      if (value != UNDEFINED_VALUE && value != NULL_VALUE)
        self->set_attr(n, s);
      else
        self->remove_attr(n);
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, tag,
                        "symbol, string or integer as index");
  }


  void xvm::init_element_attributes_class() {
    dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Attributes", methods, properties);

    /* create the 'Attributes' type */
    if (!pd) CsInsufficientMemory(this);

    /* setup alternate handlers */

    pd->getProperty = (get_property_t)GetProperty;
    pd->setProperty = (set_property_t)SetProperty;

    pd->scan = ElementScan;
    // pd->size = ElementSize;
    // pd->copy = ElementCopy;
    pd->hash = ElementHash;

    pd->getItem = (get_item_t)GetItem;
    pd->setItem = (set_item_t)SetItem;
    pd->delItem = (del_item_t)RemoveAttr;

    pd->baseType       = &CsCObjectDispatch;
    pd->getNextElement = (get_next_element_t)GetNextElement;

    pd->destroy = (destructor_t)destroy_attributes;

    elementInterfaces[ATTRIBUTE_IFACE] = pd;
  }

} // namespace tis
