﻿
#include "win.h"

#include "win-ux-themes.h"
#include "win-delayload.h"
#include "win-accessible.h"
#include "win-callback.h"
#include "win-frame.h"

//#include "gdi+/gdi+graphics.h"
//#include "gdi+/gdi+application.h"

#include <commdlg.h>
#include <windowsx.h>
#include <shlobj.h>
#include <tpcshrd.h>

HWND drawing_hwnd = 0;


// tool::bytes get_resource( const wchar* res_id, const wchar* res_type_id);
extern uint module_version(bool major);

//DLOADV(_DwmGetCompositionTimingInfo, DwmGetCompositionTimingInfo, dwmapi.dll,
//  HRESULT(WINAPI *)(HWND hwnd, DWM_TIMING_INFO *pTimingInfo));

DLOADV(_IsCompositionActive, IsCompositionActive, uxtheme.dll,
  BOOL(WINAPI *)());


DLOADV(_GetSystemMetricsForDpi, GetSystemMetricsForDpi, user32.dll,
  int(WINAPI *)(int,uint));

DLOADV(_WTSRegisterSessionNotification, WTSRegisterSessionNotification, wtsapi32.dll,
  BOOL(WINAPI *)(HWND,DWORD));

DLOADV(_DwmSetIconicLivePreviewBitmap, DwmSetIconicLivePreviewBitmap, dwmapi.dll,
  HRESULT(WINAPI*)(HWND, HBITMAP, POINT *, DWORD));

#ifndef DPI_ENUMS_DECLARED
typedef enum MONITOR_DPI_TYPE {
  MDT_EFFECTIVE_DPI = 0,
  MDT_ANGULAR_DPI   = 1,
  MDT_RAW_DPI       = 2,
  MDT_DEFAULT       = MDT_EFFECTIVE_DPI
} MONITOR_DPI_TYPE;
#endif

DLOADV(_GetDpiForMonitor, GetDpiForMonitor, shcore.dll,
       HRESULT(WINAPI *)(HMONITOR hmonitor, MONITOR_DPI_TYPE dpiType,
                         UINT *dpiX, UINT *dpiY));

EXTERN_DLOADV(_SHCreateItemFromParsingName, SHCreateItemFromParsingName, shell32.dll,
              HRESULT(WINAPI *)(__in PCWSTR pszPath, __in_opt IBindCtx *pbc,
                                __in REFIID riid, __deref_out void **ppv));

DLOADV(_DwmDefWindowProc, DwmDefWindowProc, dwmapi.dll,
       BOOL(WINAPI *)(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam,
                      LRESULT *plResult));

DLOADV(_AdjustWindowRectExForDpi, AdjustWindowRectExForDpi, user32.dll,
       BOOL(WINAPI *)(LPRECT lpRect,DWORD dwStyle, BOOL bMenu, DWORD dwExStyle, UINT dpi));

DLOADV(_Shell_NotifyIconGetRect, Shell_NotifyIconGetRect, shell32.dll,
       HRESULT(WINAPI *)(const NOTIFYICONIDENTIFIER *identifier,RECT* iconLocation));

DLOADV(_GetCurrentInputMessageSource, GetCurrentInputMessageSource, user32.dll,
  BOOL(WINAPI *)(INPUT_MESSAGE_SOURCE *inputMessageSource));

#ifndef WM_DPICHANGED
#define WM_DPICHANGED 0x02E0
#endif

void map_client_point(HWND hwnd, gool::point &pt) {
  if (GetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_LAYOUTRTL) {
    RECT rc;
    ::GetClientRect(hwnd, &rc);
    pt.x = (rc.right - rc.left) - pt.x + 1;
  }
}

void screen2client(HWND hwnd, gool::point &pt, bool standard_frame) {
  if (::IsIconic(hwnd) || !::IsWindowVisible(hwnd)) {
    WINDOWPLACEMENT wp; wp.length = sizeof(wp);
    GetWindowPlacement(hwnd, &wp);
    pt -= point(wp.rcNormalPosition.left, wp.rcNormalPosition.top);
  }
  else if (standard_frame) {
    ::ScreenToClient(hwnd, PPOINT(pt));
  }
  else {
    rect r;
    ::GetWindowRect(hwnd, PRECT(r));
    pt -= r.s;
  }
  map_client_point(hwnd, pt);
}

void client2screen(HWND hwnd, gool::point &pt, bool standard_frame) {
  map_client_point(hwnd, pt);
  if (::IsIconic(hwnd) || !::IsWindowVisible(hwnd)) {
    WINDOWPLACEMENT wp; wp.length = sizeof(wp);
    GetWindowPlacement(hwnd, &wp);
    pt += point(wp.rcNormalPosition.left, wp.rcNormalPosition.top);
  }
  else if (standard_frame) {
    ::ClientToScreen(hwnd, PPOINT(pt));
  }
  else {
    rect r;
    ::GetWindowRect(hwnd, PRECT(r));
    pt += r.s;
  }
}


namespace mswin {

  argb accent_color = argb::no_color();

  argb _get_current_system_color(SYSTEM_COLORS sc) {
    if (sc == SC_ACCENT)
    {
      if (accent_color == argb::no_color())
      {
        static mswin::registry::key dwm_params = mswin::registry::key::open(HKEY_CURRENT_USER, W("Software\\Microsoft\\Windows\\DWM"));
        argb c;

        if (dwm_params.is_valid() && environment::get_os_version() >= environment::WIN_8_1) { //new thing with fixed name
          uint32 dw_accent = dwm_params.get(W("AccentColor"), uint32(0));
          if (dw_accent) {
            c = dw_accent;
            c.alfa = 0xFF;
          }
          else 
          { // old "oily oil" name 
            dw_accent = dwm_params.get(W("ColorizationColor"), uint32(GetSysColor(COLOR_HIGHLIGHT)));
            c = dw_accent;
            swap(c.red, c.blue); // for some reason it uses ABGR format...
            c.alfa = 0xFF;
          }
          argb sel = xcolor(SC_SELECTION);
          auto sel_hsv = hsv(sel);
          hsv acc_hsv  = hsv(c);
          sel_hsv.h = acc_hsv.h;
          /*c = sel_hsv;*/
        }
        else 
        {
          BOOL  blend = FALSE;
          DWORD dw_accent = 0;
          /*HRESULT r = */_DwmGetColorizationColor()(&dw_accent, &blend);
          c = dw_accent;
          swap(c.red, c.blue);
          c.alfa = 0xFF;
        }
        accent_color = c;
      }
      return accent_color;
    }
    return argb(xcolor(sc));
  }


  inline BOOL ScreenToClientRaw(HWND hWnd, LPPOINT lpPoint) {
    MapWindowPoints(HWND_DESKTOP, hWnd, lpPoint, 1);
    return TRUE;
  }
  inline BOOL ClientToScreenRaw(HWND hWnd, LPPOINT lpPoint) {
    MapWindowPoints(hWnd, HWND_DESKTOP, lpPoint, 1);
    return TRUE;
  }

  //hash_table<uint_ptr, handle<window>> window::_all;
  //mutex                                window::_all_guard;

  uint WM_GETWINDOWBLOCK  = 0;
  //uint WM_UPDATELAYERED   = 0;
  uint WM_POST_IDLE       = 0;
  uint WM_TRAY_CALLBACK   = 0;
  //uint WM_POSTED_CALLBACK = 0;

  bool window::init(bool startup) {
    static ATOM atom = 0;
    if (atom) return true;

    WM_GETWINDOWBLOCK  = RegisterWindowMessage(TEXT("SciterWhois"));
    //WM_UPDATELAYERED   = RegisterWindowMessage(TEXT("SciterUpdateLayered"));
    WM_POST_IDLE       = RegisterWindowMessage(TEXT("SciterIdle"));
    WM_TRAY_CALLBACK   = RegisterWindowMessage(TEXT("SciterTrayCallback"));
    //WM_POSTED_CALLBACK = RegisterWindowMessage(TEXT("HSmilePostedCallback"));

    WNDCLASSEX wcex;

    // Register window class.
    wcex.cbSize        = sizeof(WNDCLASSEX);
    wcex.style = CS_HREDRAW | CS_VREDRAW;// | CS_OWNDC | CS_DBLCLKS;
    wcex.lpfnWndProc   = window::window_proc;
    wcex.cbClsExtra    = 0;
    wcex.cbWndExtra    = sizeof(LONG_PTR);
    wcex.hInstance     = HINST_THISCOMPONENT;
    wcex.hbrBackground = //HBRUSH(COLOR_WINDOW + 1);
                         CreateSolidBrush(0xFFFFFF);
    wcex.lpszMenuName  = NULL;
    wcex.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    wcex.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wcex.lpszClassName = CHILD_CLASS_NAME;
    wcex.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);

    atom = RegisterClassEx(&wcex);

    if (_DwmGetColorizationColor)
      gool::get_current_system_color = &_get_current_system_color;


    if (!atom) return false;
    return true;
  }

#if defined(USE_UIAUTOMATION)
  bool window::use_uiautomation = false;
#endif

  point window::screen_pos() {
    HWND hwnd = get_hwnd();
    if (::IsIconic(hwnd) || !::IsWindowVisible(hwnd)) {
      WINDOWPLACEMENT wp; wp.length = sizeof(wp);
      GetWindowPlacement(hwnd, &wp);
      return point(wp.rcNormalPosition.left, wp.rcNormalPosition.top);
    }
    else {
      rect r;
      ::GetWindowRect(get_hwnd(), PRECT(r));
      return r.s;
    }
  }

  size window::window_dim() {
    HWND hwnd = get_hwnd();
    if (::IsIconic(hwnd) || !::IsWindowVisible(hwnd)) {
      WINDOWPLACEMENT wp; wp.length = sizeof(wp);
      GetWindowPlacement(hwnd, &wp);
      return size(wp.rcNormalPosition.right - wp.rcNormalPosition.left, wp.rcNormalPosition.bottom - wp.rcNormalPosition.top);
    }
    else {
      rect r;
      ::GetWindowRect(get_hwnd(), PRECT(r));
      return r.size();
    }
  }

  size window::client_dim() {
    if (dim.empty()) {
      rect r;
      ::GetClientRect(get_hwnd(), PRECT(r));
      dim = r.size();
    }
    return dim;
  }

  // virtual size  client_dim() { return _dim; };

  point window::client_screen_pos() {
    point pt(0, 0);
    client2screen(get_hwnd(), pt, get_frame_type() == STANDARD);
    return pt;
  }

  point window::cursor_pos() {
    point pt;
    ::GetCursorPos(PPOINT(pt));
    screen2client(get_hwnd(), pt,get_frame_type() == STANDARD);
    return pt;
  }

  rect window::window_decoration() const {
    rect rc(0, 0, 100, 100);
    rect r0 = rc;

    uint styles = GetWindowLong(get_hwnd(), GWL_STYLE);

    auto ws = get_window_state();
    if (ws == WINDOW_MAXIMIZED)
      styles &= ~WS_THICKFRAME;
    
    if (_AdjustWindowRectExForDpi) {
      uint dpi = const_cast<window*>(this)->pixels_per_inch().x;
      //dbg_printf("window styles %x %x\n", GetWindowLong(get_hwnd(), GWL_STYLE), GetWindowLong(get_hwnd(), GWL_EXSTYLE));
      _AdjustWindowRectExForDpi()(PRECT(rc), styles, FALSE, GetWindowLong(get_hwnd(), GWL_EXSTYLE), dpi);
    }
    else
      ::AdjustWindowRectEx(PRECT(rc), styles, FALSE, GetWindowLong(get_hwnd(), GWL_EXSTYLE));
    
    return rect(r0.s.x - rc.s.x, r0.s.y - rc.s.y,
                rc.e.x - r0.e.x, rc.e.y - r0.e.y);
  }

  void window::move_window(const rect &spos, bool client_rc) {
    super::move_window(spos, client_rc);
    rect place = spos;
    if (client_rc && (get_frame_type() == STANDARD))
      place >>= window_decoration();
    ::MoveWindow(get_hwnd(), place.left(), place.top(), place.width(), place.height(),FALSE);
    //SetWindowPos(get_hwnd(),0, place.left(), place.top(), 0,0, SWP_NOZORDER | SWP_NOSIZE | SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOSENDCHANGING | SWP_DEFERERASE /*| WM_WINDOWPOSCHANGING*/);
    //SetWindowPos(get_hwnd(), 0, 0, 0, place.width(), place.height(), SWP_NOZORDER | SWP_NOMOVE | SWP_NOACTIVATE | SWP_DEFERERASE);
  }

  void window::attached(HWINDOW hw) {
    ::SetClassLong(hw, GCL_STYLE,::GetClassLong(hw, GCL_STYLE) | CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS);
    _is_child = (::GetWindowLong(hw, GWL_STYLE) & WS_CHILD) == WS_CHILD;
#ifdef THEMES_SUPPORT
    if (window::view_count() == 1) mswin::themes::init();
#endif
    super::attached(hw);
  }
  void window::detached(HWINDOW hw) {
    callback = nullptr;
    super::detached(hw);
  }

  int window::get_window_metrics(tool::value::length_special_values what) {

    /*auto round_to_odd = [this](int n) {
      // it should be odd
      int ppd = pixels_per_dip(1);
      n /= ppd;
      if ((n & 1) == 0) --n;
      n *= ppd;
      return n;
    };*/

    auto inflated = [this](int n) {
      int num = window_decoration().s.y;
      int denum = get_system_metrics(SM_CYCAPTION);
      int r = muldiv(n, num, denum);
      // it should be odd
      int ppd = (int)pixels_per_dip(1);
      r /= ppd;
      if ((r & 1) == 0) --r;
      r *= ppd;
      return r;
    };
    
    switch (what) 
    {
      case tool::value::$scrollbar_height:   return get_system_metrics(SM_CYHSCROLL);
      case tool::value::$scrollbar_width:    return get_system_metrics(SM_CXVSCROLL);
      case tool::value::$small_icon_height:  return get_system_metrics(SM_CYSMICON) + get_system_metrics(SM_CYEDGE) * 2;
      case tool::value::$small_icon_width:   return get_system_metrics(SM_CXSMICON) + get_system_metrics(SM_CXEDGE) * 2;
      case tool::value::$border_width:       return 1;
      case tool::value::$border_3d_width:    return get_system_metrics(SM_CXEDGE);

     /*case tool::value::$window_caption_height:
        //return get_system_metrics(SM_CYCAPTION);
      case tool::value::$window_button_height:  return round_to_odd(get_system_metrics(SM_CYSIZE));
      case tool::value::$window_button_width:   return round_to_odd(get_system_metrics(SM_CXSIZE));
      case tool::value::$window_frame_width: {
        //auto ws = get_window_state();  
        //return (ws == WINDOW_MAXIMIZED || ws == WINDOW_FULL_SCREEN) ? 0 : get_system_metrics(SM_CXEDGE);
        auto ws = get_window_state();
        return (ws == WINDOW_MAXIMIZED || ws == WINDOW_FULL_SCREEN) 
          ? get_system_metrics(SM_CXSIZEFRAME) + get_system_metrics(SM_CXPADDEDBORDER)
          : get_system_metrics(SM_CXEDGE);
      }*/

      case tool::value::$window_caption_height: {
        //auto t = window_decoration().s.y;
        ///return window_decoration().s.y;//
        if (tool::environment::get_os_version() >= tool::environment::WIN_8) {
          auto ws = get_window_state();
          return (ws == WINDOW_MAXIMIZED || ws == WINDOW_FULL_SCREEN) 
            ? get_system_metrics(SM_CYCAPTION)
            : window_decoration().s.y;
        }
        else
          return get_system_metrics(SM_CYCAPTION);
      }
      case tool::value::$window_button_height:  return inflated(get_system_metrics(SM_CYSIZE));
      case tool::value::$window_button_width:   return inflated(get_system_metrics(SM_CXSIZE));

      case tool::value::$window_frame_width: {
        if (tool::environment::get_os_version() >= tool::environment::WIN_8) {
          auto ws = get_window_state();
          return (ws == WINDOW_MAXIMIZED || ws == WINDOW_FULL_SCREEN) ? 
            get_system_metrics(SM_CXSIZEFRAME) + get_system_metrics(SM_CXPADDEDBORDER) :
            get_system_metrics(SM_CXEDGE);
          //return get_system_metrics(SM_CXEDGE);
        }
        else
          return get_system_metrics(SM_CXSIZEFRAME) + get_system_metrics(SM_CXPADDEDBORDER);
      }
      default:
        assert(false);
        return 10;
    }
  }

  void window::on_size(size sz) {
    super::on_size(sz);
    // --- refresh();
    //update(); // flush update to avoid visible frame changing artefacts.
  }

  void window::refresh() {
    if (dismissing || !check_visibility()) 
      return;
    invalid = rect(client_dim());

    //if (is_layered())
    //  request_render_layered();
    //else
    ::InvalidateRect(get_hwnd(), 0, FALSE);
  }
  void window::refresh(const rect &rc) {
    if (dismissing) return;
    invalid |= rc;
    rect rc_to_refresh = rc;
    ::InvalidateRect(get_hwnd(), PRECT(rc_to_refresh), FALSE);
  }

  element *window::element_under_cursor(point &pt) {
      ::GetCursorPos(PPOINT(pt));
      HWND     hw = ::WindowFromPoint(*PPOINT(pt));
      element *pb = 0;
#if 0
      if (hw == get_hwnd())
        pb = doc();
      else {
        /*HWND h = GetDesktopWindow();
          LONG st = GetWindowStyle(hw);
          LONG stex = GetWindowExStyle(hw);
          if( stex == WS_EX_TRANSPARENT )
            stex = stex;*/
        pb = window_element(hw);
      }
      if (!pb || (pb->pview() != this) /*!pb->belongs_to(*this, doc(), true)*/) {
        // if(pb)
        //  pb->dbg_report("under cursor");
        // assert(0);
        return 0;
      }
      screen2client(get_hwnd(), pt, get_frame_type() == STANDARD);
      return find_element(pt);
#else
      handle<html::view> w;
      if (!all.find(uint_ptr(hw), w)) {
        pb = window_element(hw);
        if (pb) {
          w = pb->pview();
          hw = w->get_hwnd();
        }
        else
          return nullptr;
      }
      screen2client(hw, pt, w->get_frame_type() == STANDARD);
      return w->find_element(pt);
#endif
  }

  element *window::window_element(HWND hwnd) {
    if (::GetWindowThreadProcessId(get_hwnd(), 0) !=
        ::GetWindowThreadProcessId(hwnd, 0))
      return 0;
    element *pelement = 0;
    if (0xAF == ::SendMessage(hwnd, WM_GETWINDOWBLOCK, 0, LPARAM(&pelement)))
      return pelement;
    return 0;
  }

  bool window::ask_close_window(bool by_chrome) {
    if (!doc()) return false;

    if (!get_hwnd()) return false;

    if (0 == (WS_CHILD & ::GetWindowLong(get_hwnd(), GWL_STYLE)))
      ::PostMessage(get_hwnd(), WM_CLOSE, by_chrome ? 0 : WPARAM(get_hwnd()), 0);

    return true; //!::IsWindow(wnd) || !::IsWindowVisible(wnd);
  }
  bool window::close_window() {
    if (!get_hwnd()) return false;
    ::DestroyWindow(get_hwnd());
    return true;
  }

  void window::do_request_idle() {
    critical_section _(posted_guard);
    if (idle_pileup_detected()) {
      // posted message has higher priority than WM_TIMER so it should help idle
      // request to go through WM_PAINTs, etc.
      ::PostMessage(get_hwnd(), WM_POST_IDLE, 0, 0);
    } else {
      idle_timer_id = ::SetTimer(get_hwnd(), IDLE_TIMER_ID, USER_TIMER_MINIMUM, &timer_proc);
    }
  }

  void window::stop_request_idle() {
    critical_section _(posted_guard);
    if (get_hwnd()) {
      if (items_in_idle_queue() && !dismissing) return;
      KillTimer(get_hwnd(), IDLE_TIMER_ID);
    }
    idle_timer_id = 0;
  }

  VOID CALLBACK window::timer_proc(HWND     hwnd,    // handle to window
                                   UINT     uMsg,    // WM_TIMER message
                                   UINT_PTR idEvent, // timer identifier
                                   DWORD    dwTime   // current system time
  ) {
    handle<window> self = ptr<window>(hwnd);
    // dbg_printf("timer_proc id %x\n",idEvent);
    if (self) {
      html::current_view_state _(self);
      if (idEvent == IDLE_TIMER_ID) {
#if 0
        self->on_idle();
        if (!self->awaiting_on_idle) KillTimer(hwnd, IDLE_TIMER_ID);
#else 
        if (self->on_idle()) 
          self->stop_request_idle();
#endif
      } else
        self->on_timer(idEvent);
    } else
      KillTimer(hwnd, idEvent);
  }

  void window::set_timer(uint_ptr id, dword ms, uint_ptr &sys_id) {
    if (ms) {
      UINT_PTR tid = ::SetTimer(get_hwnd(), id, ms, &timer_proc);
      assert(tid);
      tid = tid;
    } else
      ::KillTimer(get_hwnd(), id);
  }

  uint get_buttons(WPARAM wp) {
    uint btns = 0;
    if (wp & MK_LBUTTON) btns |= html::MAIN_BUTTON;
    if (wp & MK_RBUTTON) btns |= html::PROP_BUTTON;
    return btns;
  }

#ifdef USE_TOUCH
  bool IsTouchEvent() {
    const LONG_PTR c_SIGNATURE_MASK = 0xFFFFFF00;
    const LONG_PTR c_MOUSEEVENTF_FROMTOUCH = 0xFF515700;
    LONG_PTR extraInfo = GetMessageExtraInfo();
    return ((extraInfo & c_SIGNATURE_MASK) == c_MOUSEEVENTF_FROMTOUCH);
  }
#endif

  uint get_alts(LPARAM lParam = 0) {
    uint alts = 0;
    if (GetAsyncKeyState(VK_SHIFT) < 0) alts |= html::ALT_SHIFT;
    if (GetAsyncKeyState(VK_RSHIFT) < 0) alts |= html::ALT_RIGHT_SHIFT;
    if (GetAsyncKeyState(VK_CONTROL) < 0) alts |= html::ALT_CONTROL;
    if (GetAsyncKeyState(VK_MENU) < 0) alts |= html::ALT_ALT;
    if (GetAsyncKeyState(VK_LWIN) < 0 || GetAsyncKeyState(VK_RWIN) < 0)
      alts |= html::ALT_COMMAND;
    // if (GetAsyncKeyState(VK_RMENU) < 0) alts |= html::ALT_ALTGR;
    const long EXTENDED_KEY_BIT = 0x1000000; // 24 bit
    if ((lParam & EXTENDED_KEY_BIT) == EXTENDED_KEY_BIT)
      alts |= html::ALT_EXTENDED;
#ifdef USE_TOUCH
    if(IsTouchEvent())
      alts |= html::ALT_TOUCH;
#endif

    return alts;
  }
  uint get_sync_alts(LPARAM lParam = 0) {
    uint alts = 0;
    if (GetKeyState(VK_SHIFT) < 0) alts |= html::ALT_SHIFT;
    if (GetKeyState(VK_RSHIFT) < 0) alts |= html::ALT_RIGHT_SHIFT;
    if (GetKeyState(VK_CONTROL) < 0) alts |= html::ALT_CONTROL;
    if (GetKeyState(VK_MENU) < 0) alts |= html::ALT_ALT;
    if (GetKeyState(VK_LWIN) < 0 || GetKeyState(VK_RWIN) < 0)
      alts |= html::ALT_COMMAND;
    // if (GetAsyncKeyState(VK_RMENU) < 0) alts |= html::ALT_ALTGR;
    const long EXTENDED_KEY_BIT = 0x1000000; // 24 bit
    if ((lParam & EXTENDED_KEY_BIT) == EXTENDED_KEY_BIT)
      alts |= html::ALT_EXTENDED;
    return alts;
  }
  uint get_buttons_async() {
    uint btns = 0;
    if (GetAsyncKeyState(VK_LBUTTON) < 0) btns |= MAIN_BUTTON;
    if (GetAsyncKeyState(VK_RBUTTON) < 0) btns |= PROP_BUTTON;
    return btns;
  }

  inline UINT LangToCodePage(IN LANGID wLangID) {
    TCHAR szLocaleData[6];
    // In this case there is no advantage to using the W or U
    // interfaces. We know the string in szLocaleData will consist of
    // digits 0-9, so there is no multilingual functionality lost by
    // using the A interface.
    GetLocaleInfo(MAKELCID(wLangID, SORT_DEFAULT), LOCALE_IDEFAULTANSICODEPAGE,
                  szLocaleData, 6);
    return tool::stoi(szLocaleData);
  }

  inline ustring LangToIsoString(IN LANGID wLangID) {

    const int MAX_LANG_LEN = 50;
    // Prepare LCID
    const LCID lcidLang = MAKELCID(wLangID, SORT_DEFAULT);

    // Will hold language
    wchar szLangBuffer[MAX_LANG_LEN] = {0};
    /*
       // Get language
       DWORD dwCount = GetLocaleInfo( lcidLang, LOCALE_SENGLANGUAGE,
     szLangBuffer, MAX_LANG_LEN ); if( !dwCount ) return ustring();
     

       // Will hold country
       wchar szCountryBuffer[MAX_LANG_LEN] = { 0 };
     

       // Get country
       dwCount = GetLocaleInfo( lcidLang, LOCALE_SENGCOUNTRY, szCountryBuffer,
     MAX_LANG_LEN ); if( !dwCount ) return ustring();
     

       // Prepare language string
        ustring us = ustring::format(L"%s-%s", szLangBuffer, szCountryBuffer );
        return us.to_lower();
            */

    DWORD dwCount =
        GetLocaleInfo(lcidLang, LOCALE_SNAME, szLangBuffer, MAX_LANG_LEN);
    if (!dwCount) return ustring();

    ustring us = szLangBuffer;
    return us.to_lower();
  }

  void window_controls::setup(window *pw, FRAME_TYPE type) {
    if (pw->is_child()) return;
    if (type == STANDARD_EXTENDED) return;
    HWND hwnd                 = pw->get_hwnd();
    this->original_style      = ::GetWindowLong(hwnd, GWL_STYLE);
    this->original_style_ex   = ::GetWindowLong(hwnd, GWL_EXSTYLE);
    this->original_is_layered = !!pw->_is_layered;
    LONG new_style            = WS_POPUP | (this->original_style & ~WS_OVERLAPPEDWINDOW);
    if (find_first(*pw, pw->doc(), WCHARS("[role='window-max'],[role='window-maximize']"),true)) new_style |= WS_MAXIMIZEBOX;
    if (find_first(*pw, pw->doc(), WCHARS("[role='window-min'],[role='window-minimize']"),true)) new_style |= WS_MINIMIZEBOX;
    LONG non_visual_ex_flags = ::GetWindowLong(hwnd, GWL_EXSTYLE) & (WS_EX_TOPMOST | WS_EX_NOPARENTNOTIFY | WS_EX_ACCEPTFILES | WS_EX_TRANSPARENT | WS_EX_APPWINDOW | WS_EX_NOREDIRECTIONBITMAP | WS_EX_NOINHERITLAYOUT);
    pw->_is_layered = type == LAYERED;

    LONG visual_ex_flags = 0;
    if (pw->_is_layered /*&& !pw->is_direct()*/) 
      visual_ex_flags |= WS_EX_LAYERED;

    if (pw->type != FRAME_WINDOW && pw->type != DIALOG_WINDOW)
      visual_ex_flags |= WS_EX_TOOLWINDOW;
   
    UINT new_style_ex = (non_visual_ex_flags & original_style_ex) | visual_ex_flags;

    if( new_style != this->original_style)
      ::SetWindowLong(hwnd, GWL_STYLE, new_style);
    if(new_style_ex != this->original_style_ex)
      ::SetWindowLong(hwnd, GWL_EXSTYLE, new_style_ex);
  }
  void window_controls::reset(window *pw) {
    if (pw->is_child()) return;
    if (pw->get_frame_type() == STANDARD_EXTENDED) return;
    HWND hwnd = pw->get_hwnd();
    this->original_style |= ::GetWindowLong(hwnd, GWL_STYLE) & WS_VISIBLE;
    LONG non_visual_ex_flags =
        ::GetWindowLong(hwnd, GWL_EXSTYLE) &
        (WS_EX_TOPMOST | WS_EX_NOPARENTNOTIFY | WS_EX_ACCEPTFILES |
         WS_EX_TRANSPARENT | WS_EX_APPWINDOW);
    this->original_style_ex |= non_visual_ex_flags;
    ::SetWindowLong(hwnd, GWL_STYLE, this->original_style);
    ::SetWindowLong(hwnd, GWL_EXSTYLE, this->original_style_ex);
    ::SetWindowPos(hwnd, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER);
    pw->_is_layered = this->original_is_layered;
  }

  bool window::set_frame_type(FRAME_TYPE on) {

    // note: do not call super::set_frame_type() here, we do that logic here:

    window_frame_updater _(this);

    if (_window_controls) {
      detach_behavior(_window_controls);
      _window_controls->reset(this);
      _window_controls = nullptr;
    }

    handle<document> d = doc();
    if (!d) return false;

    if (on == LAYERED || on == SOLID || on == SOLID_WITH_SHADOW || on == STANDARD_EXTENDED) {
      handle<window_controls> wctls = new window_controls;
      wctls->ftype                  = on;
      _window_controls              = wctls;
      attach_behavior(wctls);
      _window_controls->setup(this, on);
    }
    else if (_window_controls) {
      detach_behavior(_window_controls);
      _window_controls = nullptr;
    }
    
    extend_window_frame(on, get_frame_type());
    
    on_size(client_dim());

    return true;
  }

  FRAME_TYPE window::get_frame_type() const {
    if (!this->_window_controls) return STANDARD;
    return this->_window_controls->ftype;
  }

  static void set_frame_style(iwindow* pw, bool on, UINT style) {
    window_frame_updater _(pw);
    LONG styles = ::GetWindowLong(pw->get_hwnd(), GWL_STYLE);
    LONG new_styles = 0;
    if (on) {
      if(pw->is_direct() || pw->is_layered())
        new_styles = styles | style /*| WS_CLIPCHILDREN*/;
      else 
        new_styles = styles | style | WS_CLIPCHILDREN;
    }
    else 
      new_styles = styles & ~style;
    if (styles != new_styles)
      ::SetWindowLong(pw->get_hwnd(), GWL_STYLE, new_styles);
  }

  gool::image *window::get_icon() const { return _icon; }

  bool window::set_icon(gool::image *pimg) {
    _icon = pimg;
    if (!_icon) {
      ::SendMessage(get_hwnd(), WM_SETICON, ICON_BIG, NULL);
      ::SendMessage(get_hwnd(), WM_SETICON, ICON_SMALL, NULL);
      return true;
    }
    if (_icon->is_bitmap()) {
      HICON hicon = _icon.ptr_of<gool::bitmap>()->create_win_icon();
      ::SendMessage(get_hwnd(), WM_SETICON, ICON_BIG, LPARAM(hicon));
      ::SendMessage(get_hwnd(), WM_SETICON, ICON_SMALL, LPARAM(hicon));
      return true;
    } else {
      handle<bitmap> hbmp = _icon->get_bitmap(nullptr, gool::size(48));
      int            n    = 0;
      if (hbmp) {
        HICON hicon = hbmp->create_win_icon();
        ::SendMessage(get_hwnd(), WM_SETICON, ICON_SMALL, LPARAM(hicon));
        ++n;
      }
      hbmp = _icon->get_bitmap(nullptr, gool::size(256));
      if (hbmp) {
        HICON hicon = hbmp->create_win_icon();
        ::SendMessage(get_hwnd(), WM_SETICON, ICON_BIG, LPARAM(hicon));
        ++n;
      }
      return n > 0;
    }
    return false;
  }

  /*void window::set_enabled(bool on_off) {
    ::EnableWindow(get_hwnd(), BOOL(on_off));
    super::set_enabled(on_off);
  }
  bool window::is_enabled() const { return ::IsWindowEnabled(get_hwnd()) != FALSE; }*/

  bool window::set_resizeable(bool on) {
    super::set_resizeable(on);
    auto ft = get_frame_type();
    if (ft == STANDARD || ft == STANDARD_EXTENDED)
      set_frame_style(this, on, WS_THICKFRAME);
    return true;
  }

  bool window::get_resizeable() const {
    // auto ft = get_frame_type();
    if (_resizeable.is_defined())
      return _resizeable.val(0) != 0;

    bool rs = type == FRAME_WINDOW;
    if (doc())
      rs = doc()->atts.get_bool("resizeable", rs) ||
           doc()->atts.get_bool("window-resizable", rs);
    const_cast<window*>(this)->_resizeable = rs;
    return rs;
  }

  bool window::set_minimizable(bool on) {
    // if(get_frame_type() == STANDARD)
    set_frame_style(this, on, WS_MINIMIZEBOX);
    return true;
  }

  bool window::get_minimizable() {
    // if(get_frame_type() == STANDARD)
    return (GetWindowLong(get_hwnd(), GWL_STYLE) & WS_MINIMIZEBOX) != 0;
    // return true;
  }

  bool window::set_maximizable(bool on) {
    // if(get_frame_type() == STANDARD)
    set_frame_style(this, on, WS_MAXIMIZEBOX);
    return true;
  }

  bool window::get_maximizable() {
    // if(get_frame_type() == STANDARD)
    return (GetWindowLong(get_hwnd(), GWL_STYLE) & WS_MAXIMIZEBOX) != 0;
    // return true;
  }

  LRESULT CALLBACK window::window_proc(HWND hwnd, UINT msg, WPARAM wParam,
                                       LPARAM lParam) {
    BOOL           handled = 0;
    LRESULT        lr      = proc(hwnd, msg, wParam, lParam, handled);
    handle<window> pview   = ptr<window>(hwnd);
    if (pview) {
      critical_section cs(pview->guard);
      if (pview->finished()) pview->close_window();
    }
    if (handled) return lr;
    return DefWindowProc(hwnd, msg, wParam, lParam);
  }

#ifdef USE_TOUCH

  DLOADV(_GetGestureInfo, GetGestureInfo, user32.dll,
         BOOL(WINAPI *)(HGESTUREINFO hGestureInfo, PGESTUREINFO pGestureInfo));
  DLOADV(_CloseGestureInfoHandle, CloseGestureInfoHandle, user32.dll,
         BOOL(WINAPI *)(HGESTUREINFO hGestureInfo));
  DLOADV(_SetGestureConfig, SetGestureConfig, user32.dll,
         BOOL(WINAPI *)(HWND hwnd, DWORD dwReserved, UINT cIDs,
                        PGESTURECONFIG pGestureConfig, UINT cbSize));

  // WM_GESTURENOTIFY handler
  LRESULT config_GESTURE(window *pw, WPARAM wParam, LPARAM lParam, HWND targetHwnd, BOOL &handled) {
    handled = FALSE;
    if (!_SetGestureConfig) { return 0; }
    PGESTURENOTIFYSTRUCT pgns = (PGESTURENOTIFYSTRUCT)lParam;

    point pt(pgns->ptsLocation.x, pgns->ptsLocation.y);
    ::MapWindowPoints(HWND_DESKTOP, pw->get_hwnd(), PPOINT(pt), 1);

    pw->is_touched = TRUE;
    pw->on_mouse(html::MOUSE_ENTER, 0, get_alts() | ALT_TOUCH, pt);

    uint flags = 0;
    if (pw->will_handle_gesture_at(pt, flags)) {
      // GESTURECONFIG gc = {0,GC_ALLGESTURES,0};
      // BOOL bResult = _SetGestureConfig()(hwnd,0,1,&gc,sizeof(GESTURECONFIG));

      GESTURECONFIG gc[5];
      memzero(gc); // = {0,GC_ALLGESTURES,0};
      int nc = 0;
      if (flags & html::GESTURE_FLAG_ZOOM) {
        gc[nc].dwID    = GID_ZOOM;
        gc[nc].dwWant  = GC_ZOOM;
        gc[nc].dwBlock = 0;
        ++nc;
      }
      if (flags & html::GESTURE_FLAG_ROTATE) {
        gc[nc].dwID    = GID_ROTATE;
        gc[nc].dwWant  = GC_ROTATE;
        gc[nc].dwBlock = 0;
        ++nc;
      }
      if (flags & (html::GESTURE_FLAG_PAN_VERTICAL |
                   html::GESTURE_FLAG_PAN_HORIZONTAL)) {
        gc[nc].dwID    = GID_PAN;
        gc[nc].dwBlock = 0;
        if (flags & html::GESTURE_FLAG_PAN_VERTICAL)
          gc[nc].dwWant |= GC_PAN_WITH_SINGLE_FINGER_VERTICALLY;
        else
          gc[nc].dwBlock |= GC_PAN_WITH_SINGLE_FINGER_VERTICALLY;
        if (flags & html::GESTURE_FLAG_PAN_HORIZONTAL)
          gc[nc].dwWant |= GC_PAN_WITH_SINGLE_FINGER_HORIZONTALLY;
        else
          gc[nc].dwBlock |= GC_PAN_WITH_SINGLE_FINGER_HORIZONTALLY;
        if (flags & html::GESTURE_FLAG_PAN_WITH_GUTTER)
          gc[nc].dwWant |= GC_PAN_WITH_GUTTER;
        else
          gc[nc].dwBlock |= GC_PAN_WITH_GUTTER;
        if (flags & html::GESTURE_FLAG_PAN_WITH_INERTIA)
          gc[nc].dwWant |= GC_PAN_WITH_INERTIA;
        else
          gc[nc].dwBlock |= GC_PAN_WITH_INERTIA;
        ++nc;
      }
      if (flags & html::GESTURE_FLAG_TAP1) {
        gc[nc].dwID    = GID_PRESSANDTAP;
        gc[nc].dwWant  = GC_PRESSANDTAP;
        gc[nc].dwBlock = 0;
        ++nc;
      }
      if (flags & html::GESTURE_FLAG_TAP2) {
        gc[nc].dwID    = GID_TWOFINGERTAP;
        gc[nc].dwWant  = GC_TWOFINGERTAP;
        gc[nc].dwBlock = 0;
        ++nc;
      }
      BOOL bResult = nc > 0 ? _SetGestureConfig()(targetHwnd, 0, nc, gc, sizeof(GESTURECONFIG)) : FALSE;

      if (bResult) {
        handled = TRUE;
        return DefWindowProc(targetHwnd, WM_GESTURENOTIFY, wParam, lParam);
        //_CloseGestureInfoHandle()()
        // return 0;
      }
      // else an error
    }
    return 0;
  }

  LRESULT handle_GESTURE(window *pw, WPARAM wParam, LPARAM lParam, HWND targetHwnd, BOOL &handled) {
    handled = FALSE;
    if (!_GetGestureInfo) { return 0; }
    // Create a structure to populate and retrieve the extra message info.
    GESTUREINFO gi;
    struct_zero(gi);

    BOOL        bResult = _GetGestureInfo()((HGESTUREINFO)lParam, &gi);
    gool::point pt;
    pt.x = gi.ptsLocation.x;
    pt.y = gi.ptsLocation.y;
    ScreenToClientRaw(pw->get_hwnd(), PPOINT(pt));
    html::gesture_cmd cmd = html::GESTURE_REQUEST /*0*/;
    double            val = 0;

    // dbg_printf("gi.dwID %d\n",gi.dwID);

    if (bResult) {
      // now interpret the gesture
      switch (gi.dwID) {
      case GID_BEGIN: cmd = html::GESTURE_START; break;
      case GID_ZOOM:
        cmd = html::GESTURE_ZOOM;
        val = (double)(gi.ullArguments & 0xFFFFFFFF);
        break;
      case GID_PAN:
        cmd = html::GESTURE_PAN;
        val = (double)(gi.ullArguments);
        break;
      case GID_ROTATE:
        cmd = html::GESTURE_ROTATE;
        val = GID_ROTATE_ANGLE_FROM_ARGUMENT(gi.ullArguments & 0xFFFFFFFF);
        break;
      case GID_TWOFINGERTAP: cmd = html::GESTURE_TAP2; break;
      case GID_PRESSANDTAP: cmd = html::GESTURE_TAP1; break;
      default:
        // A gesture was not recognized
        handled = TRUE;
        return DefWindowProc(targetHwnd, WM_GESTURE, wParam, lParam);
        break;
      }
    } else {
      DWORD dwErr = GetLastError();
      if (dwErr > 0) {
        // MessageBoxW(hWnd, L"Error!", L"Could not retrieve a GESTUREINFO
        // structure.", MB_OK);
      }
    }
    LRESULT lr = 0;
    if (cmd && pw->handle_gesture(cmd, gi.dwFlags, pt, val)) {
      handled = TRUE;
      lr = DefWindowProc(targetHwnd, WM_GESTURE, wParam, lParam);
      if (gi.dwFlags & GF_END) {
        pw->handle_gesture(html::GESTURE_END, gi.dwFlags, pt, val);
        pw->on_mouse(html::MOUSE_LEAVE, 0, get_alts() | ALT_TOUCH, point(-1, -1));
      }
      return lr;
    }
    return 0;
  }
   
#endif


  /*  bool test_mouse_target_for(element* el,element* elhover) {
      if( !el ) return false;
      while(elhover) {
        if( elhover == el ) return true;
        if( elhover->handles<event_mouse>() ) return false;
        elhover = elhover->parent;
      }
      return false;
    }

    bool is_mouse_target_on_caption(element* elhover) {
      while(elhover) {
        ustring role = elhover->attr_role();
        if( role == WCHARS("window-caption") ) return true;
        if( elhover->handles<event_mouse>() ) return false;
        elhover = elhover->parent;
      }
      return false;
    } */

  LRESULT window::on_nchittest(WPARAM wParam, LPARAM lParam, BOOL &bHandled) {

    if (get_frame_type() == STANDARD) {
      bHandled = FALSE;
      return 0;
    }

    HWND        hWnd = get_hwnd();
    gool::point pt((signed short int)LOWORD(lParam),
                   (signed short int)HIWORD(lParam));
    ::MapWindowPoints(HWND_DESKTOP, hWnd, PPOINT(pt), 1);
    gool::rect rc;
    ::GetClientRect(hWnd, PRECT(rc));

    bHandled = TRUE;

    //if (!rc.contains(pt)) 
    //  return HTCLIENT;

    event_mouse evt;
    evt.cmd          = html::MOUSE_HIT_TEST;
    evt.button_state = 0;
    evt.pos_view = evt.pos = pt;
    evt.target             = doc();
    if (traverse_mouse(doc(), evt)) {
      LRESULT lr = (LRESULT)evt.data.to_int();
      //if (lr != HTCAPTION)
      //  lr = HTCLIENT;
      bHandled = TRUE;
      return lr;
    }

    LRESULT ncht = DefWindowProc(hWnd, WM_NCHITTEST, wParam, lParam);
    if (!get_resizeable() && ncht >= HTSIZEFIRST && ncht <= HTSIZELAST)
      return HTBORDER;
    return ncht;
  }

  void window::on_dpi_changed(size dpi, rect proposed_window_rect) {
    super::on_dpi_changed(dpi, proposed_window_rect);
    //move_window(proposed_window_rect);
  }

  size window::pixels_per_inch() {
    if (dpi.x.is_defined()) return dpi;
    if (_GetDpiForMonitor) {
      UINT     x, y;
      HMONITOR hmonitor = MonitorFromWindow(get_hwnd(), MONITOR_DEFAULTTONEAREST);
      HRESULT hr = _GetDpiForMonitor()(hmonitor, MDT_EFFECTIVE_DPI, &x, &y);
      if (SUCCEEDED(hr)) {
        dpi.x = x;
        dpi.y = y;
        return dpi;
      }
    }
    return resolution_provider::desktop().pixels_per_inch();
  }

  int window::get_system_metrics(int idx) {
    //uint dpi
    //GetSystemMetricsForDpi
    if (_GetSystemMetricsForDpi)
      return _GetSystemMetricsForDpi()(idx, uint(pixels_per_inch().x));
    else
      return GetSystemMetrics(idx);
  }
 

  void window::handle_state_changed() {
    WINDOWPLACEMENT wp;
    wp.length = sizeof(WINDOWPLACEMENT);

    if (!::IsWindowVisible(get_hwnd()))
      wp.showCmd = SW_HIDE;
    else
      GetWindowPlacement(get_hwnd(), &wp);
    if ((wp.showCmd != _window_state)) {
      _window_state = wp.showCmd;
      if (wp.showCmd == SW_RESTORE || wp.showCmd == SW_MAXIMIZE ||
          wp.showCmd == SW_SHOWNORMAL) {
        _collapsing = false;
        on_animation_tick(); // to restart pending animations
      }

      //bool rsz = get_resizeable();
      //window_frame_updater _(this);
      //DWORD exs = GetWindowLong(get_hwnd(), GWL_EXSTYLE);
      on_state_changed();
    }
  }


  BOOL CALLBACK window::proc_x(HWND hwnd, SCITER_X_MSG *pMsg) {
    // NOTE: proc_x is purely Sciter.Lite function
#if 0
    if (pMsg->msg == SXM_CREATE) {
      SCITER_X_MSG_CREATE *pMsgCreate = (SCITER_X_MSG_CREATE *)pMsg;

      (void)pMsgCreate;

      handle<window> pw = ptr<window>(hwnd);
      if (pw) // the engine has been initialized already on that window.
              // that happens when WM_CREATE and WM_INITDIALOG are *both* sent
              // to the winproc by
              // CreateDialogIndirect/CreateDialogIndirectParam, quote:
              //     The CreateDialogIndirect macro uses the CreateWindowEx
              //     function to create the dialog box. CreateDialogIndirect
              //     then sends a WM_INITDIALOG message to the dialog box
              //     procedure.
        return FALSE;

      bool rtl_env  = false;
      LONG exstyles = GetWindowLong(hwnd, GWL_EXSTYLE);
#if defined(WS_EX_LAYOUTRTL)
      if (exstyles & WS_EX_LAYOUTRTL) {
        // SetWindowLong(hwnd,GWL_EXSTYLE, exstyles & ~WS_EX_LAYOUTRTL);
        rtl_env = true;
      }
#endif
      window_params params;
      params.window_type = FRAME_WINDOW;
      params.parent      = NULL;
      params.rtl         = rtl_env;
      params.owns_vm     = FALSE;

      try {
        pw = mswin::app()->create_window_processor(params);
        //attach(pw, hwnd);
        //pw->attached(nullptr);
        pw->set_hwnd(hwnd);
        pw->start(window_params());
        pw->reset_resolution();
        pw->on_size(pw->client_dim());
      } catch (std::bad_alloc &) { return FALSE; }
      return TRUE;
    }

    handle<window> pw = ptr<window>(hwnd);
    if (!pw) return FALSE;

    html::current_view_state thread_state(pw);

    switch (pMsg->msg) {
    case SXM_DESTROY: {
      pw->stop();
      if (pw->_need_OleUninitialize) OleUninitialize();
      //detach(pw, hwnd);
      pw->set_hwnd(nullptr);
      window::release_hook();
      thread_state.drop_current();
      return TRUE;
    }
    case SXM_SIZE: {
      SCITER_X_MSG_SIZE *pMsgSize = (SCITER_X_MSG_SIZE *)pMsg;
      size               sz;
      sz.x = int(pMsgSize->width);
      sz.y = int(pMsgSize->height);
      pw->on_size(sz);
      return TRUE;
    }
    case SXM_PAINT: {
      SCITER_X_MSG_PAINT *pMsPaint = (SCITER_X_MSG_PAINT *)pMsg;

      if (pw->has_animations())
        pw->on_animation_tick();

      switch (pMsPaint->targetType) {
        case SPT_DEFAULT:
          return pw->render_element(pMsPaint->element, !!pMsPaint->isFore)
                     ? TRUE
                     : FALSE;
        case SPT_RECEIVER: {
          auto cb = [pMsPaint](gool::bitmap *dst, point view_pos) {
            size dim = dst->dim();
            pMsPaint->target.receiver.callback(
                (LPCBYTE)dst->get_bits().start, view_pos.x, view_pos.y,
                uint(dim.x), uint(dim.y), pMsPaint->target.receiver.param);
          };
          pw->paint(cb, pMsPaint->element, !!pMsPaint->isFore);
          return TRUE;
        }
      }
    }
    }
#endif
    return FALSE;
  }

  bool HandleTouchInput(WPARAM wParam, LPARAM lParam, window* pv);

  LRESULT CALLBACK window::proc(HWND hwnd, UINT message, WPARAM wParam,
                                LPARAM lParam, BOOL &handled) {
    static int input_code_page = CP_ACP;

    //dbg_printf("msg=%x\n", message);

    handled = FALSE;
    if (message == WM_CREATE || message == WM_INITDIALOG) {
      handle<window> pw = ptr<window>(hwnd);
      if (pw) // the engine has been initialized already on that window.
              // that happens when WM_CREATE and WM_INITDIALOG are *both* sent
              // to the winproc by
              // CreateDialogIndirect/CreateDialogIndirectParam, quote:
              //     The CreateDialogIndirect macro uses the CreateWindowEx
              //     function to create the dialog box. CreateDialogIndirect
              //     then sends a WM_INITDIALOG message to the dialog box
              //     procedure.
        return 0;

      bool rtl_env  = false;
      LONG exstyles = GetWindowLong(hwnd, GWL_EXSTYLE);
#if defined(WS_EX_LAYOUTRTL)
      if (exstyles & WS_EX_LAYOUTRTL) {
        // SetWindowLong(hwnd,GWL_EXSTYLE, exstyles & ~WS_EX_LAYOUTRTL);
        rtl_env = true;
      }
#endif

      LONG styles = GetWindowLong(hwnd, GWL_STYLE);
      //if (!(styles & WS_CLIPCHILDREN))
      //  SetWindowLong(hwnd, GWL_STYLE, styles | WS_CLIPCHILDREN);

      if (_WTSRegisterSessionNotification)
        _WTSRegisterSessionNotification()(hwnd, 0);


      handle<window> parentw = 0;
      LPCREATESTRUCT cst     = (LPCREATESTRUCT)lParam;
      if (cst) {
        DWORD parentThreadId = GetWindowThreadProcessId(cst->hwndParent, NULL);
        if (parentThreadId == GetCurrentThreadId())
          parentw = ptr<window>(cst->hwndParent);
      }

      window_params params;
      params.window_type = (styles & WS_CHILD) ? CHILD_WINDOW : FRAME_WINDOW;
      if(exstyles & WS_EX_NOREDIRECTIONBITMAP)
        params.direct_window = true;
      params.parent      = parentw;
      params.rtl         = rtl_env;
      params.owns_vm     = wParam == 0xC0DADEFA;

      try {
        pw = mswin::app()->create_window_processor(params);
        pw->set_hwnd(hwnd);
        //if (styles & WS_THICKFRAME)
        //  pw->set_resizeable(true);
        pw->start(params);
        //attach(pw, hwnd);
        //pw->attached(nullptr);
        pw->reset_resolution();
      } catch (std::bad_alloc &) { return LRESULT(-1); }
      return 0;
    }

    handle<window> pw = ptr<window>(hwnd);
    if (!pw) return 0;

/*        LRESULT dwmWindowProcLResult = 0;
        if(pw->get_frame_type() == STANDARD_EXTENDED && _DwmDefWindowProc)
        {
          if (message == WM_NCHITTEST) {
            uint ht = pw->on_nchittest(wParam, lParam, handled);
            if (ht != HTCLIENT)
              return ht;
          }
          handled = _DwmDefWindowProc()( hwnd, message, wParam, lParam,  &dwmWindowProcLResult); if(handled) 
          if(handled)
          {
            if( message == WM_PAINT)
              pw->do_paint();
            return dwmWindowProcLResult;
            //handled = FALSE;
          }
        } */

    html::current_view_state thread_state(pw);

    pw->message_time = GetMessageTime();

    switch (message) 
    {
#ifdef USE_TOUCH
    case WM_INPUT: {
      //auto tt = get_current_event_source();
      //return handle_WM_INPUT(hwnd, wParam, lParam, handled);
      HandleTouchInput(wParam, lParam,pw);
      //handled = TRUE;
      return 0;
    }
#endif
    case WM_SIZE:
      if (wParam == SIZE_MINIMIZED) {
        size sz(0, 0);
        pw->on_size(sz);
      }
      else if (wParam == SIZE_MAXIMIZED || wParam == SIZE_RESTORED) 
      {
        size sz;
        sz.x = LOWORD(lParam);
        sz.y = HIWORD(lParam);
        //assert(!sz.empty());
        if (sz.empty())
          sz = pw->client_dim();
        if (!sz.empty()) {
          pw->on_size(sz);
        }

      } 
      return 0;

    case WM_SIZING: {
      int point_id = 0;
      switch (wParam) {
      case WMSZ_BOTTOM: point_id = 2; break;
      case WMSZ_BOTTOMLEFT: point_id = 1; break;
      case WMSZ_BOTTOMRIGHT: point_id = 3; break;
      case WMSZ_LEFT: point_id = 4; break;
      case WMSZ_RIGHT: point_id = 6; break;
      case WMSZ_TOP: point_id = 8; break;
      case WMSZ_TOPLEFT: point_id = 7; break;
      case WMSZ_TOPRIGHT: point_id = 9; break;
      }
      LPRECT pr  = (LPRECT)lParam;
      rect   prc = fromRECT(*pr);
      if (pw->on_size_request(point_id, prc)) {
        handled = true;
        *pr     = toRECT(prc);
        return TRUE;
      }
    }
      return 0;

    case WM_GETMINMAXINFO: {
      MINMAXINFO *info = reinterpret_cast<MINMAXINFO *>(lParam);
      size        sz;
      rect        fr;
      bool        was_set = false;
      if (pw->get_min_size(sz)) {
        sz = pw->dip_to_ppx(sizef(sz)); // TODO: get_min_size shall return sizef - dips
        if (pw->get_frame_type() == STANDARD)
        fr = pw->window_decoration();
        sz.x += fr.left() + fr.right();
        sz.y += fr.top() + fr.bottom();
        was_set = true;
        info->ptMinTrackSize.x = sz.x;
        info->ptMinTrackSize.y = sz.y;
      }
      if (pw->get_max_size(sz)) {
        sz = pw->dip_to_ppx(sizef(sz)); // TODO
        if (!was_set) fr = pw->window_decoration();
        sz.x += fr.left() + fr.right();
        sz.y += fr.top() + fr.bottom();
        info->ptMaxTrackSize.x = sz.x;
        info->ptMaxTrackSize.y = sz.y;
      }
      if (was_set) {
        handled = TRUE;
        return 0;
      }
    } break;

    case WM_MOVE: 
      pw->on_move();
      return 0;

    case WM_MOVING: {
      RECT *     pr = (RECT *)(lParam);
      gool::rect rc = fromRECT(*pr);
      if (pw->on_move_request(rc)) *pr = toRECT(rc);
    }
    return 0;

    case WM_ENTERSIZEMOVE: pw->on_start_ui_replacement(); break;

    case WM_EXITSIZEMOVE:
      pw->on_end_ui_replacement();
      break;

      // case WM_QUERYOPEN:
      //  break;

    case WM_CLOSE:
      if (!pw->ask_unload(pw->doc(), wParam == WPARAM(hwnd)
                                         ? view::UNLOAD_BY_CODE
                                         : view::UNLOAD_BY_CHROME))
        handled = true;
      return 0;

    case WM_NCHITTEST: 
      return pw->on_nchittest(wParam, lParam, handled);

    case WM_NCCALCSIZE: 
      //if(!pw->is_child())
        return pw->on_nccalcsize(wParam, lParam, handled);
      break;

    //case WM_SYSCOMMAND:
    //  dbg_printf("WM_SYSCOMMAND command=%x\n", wParam & 0xFFF0);
    //  break;

#if defined(USE_DIRECT_COMP)
    case WM_WINDOWPOSCHANGING: 
      if (pw->is_child()) 
        break;
      if (pw->_full_screen)
        break;
      break;
#endif

    case WM_WINDOWPOSCHANGED:
      pw->handle_state_changed();
      pw->handle_position_change();
      break;

     //case WM_NCACTIVATE:
     // if (pw->is_direct()) pw->refresh();
     // return 0; 

     //case WM_NCPAINT:
     // return 0;

    case WM_ERASEBKGND:
    {
#if 0 // experiments
      static int cnt = 0;
      if (++cnt == 1) 
      {
        size sz = pw->client_dim();
        dib32 dib(sz);
        BitBlt(
          dib.DC(),                            // Target device HDC
          0,                      // X sink position
          0,                       // Y sink position
          sz.x, // Destination width
          sz.y, // Destination height
          (HDC)wParam,               // Source device context
          0,                         // X source position
          0,                         // Y source position
          SRCCOPY);                  // Simple copy

        //auto px = dib.pixels();
        handle<gool::bitmap> bmp = new bitmap(dib.BITMAP());
        array<byte> bytes;
        bmp->save(bytes, image::PNG,0);
        FILE *f = fopen("d:\\erase.png", "w+b");
        if (!f) return FALSE_VALUE;
        size_t r = fwrite(bytes.cbegin(), 1, bytes.length(), f);
        fclose(f);
      }
#endif
        handled = TRUE;
      }
      return TRUE;


    case WM_PAINT: {
      pw->do_paint();
      handled = TRUE;
      return 0;
    }

    /*case WM_DWMSENDICONICLIVEPREVIEWBITMAP:
      if(_DwmSetIconicLivePreviewBitmap) {
        dib32 dib(pw->client_dim());
        if (!pw->is_painting)
          pw->print(dib.DC(), rect(pw->client_dim()));
        if (dib.BITMAP())
        {
          _DwmSetIconicLivePreviewBitmap()(hwnd, dib.BITMAP(), NULL, DWM_SIT_DISPLAYFRAME);
        }
      }
      break;*/

    case WM_SHOWWINDOW:
      handled = FALSE;
      return 0;

    case WM_PRINTCLIENT: {
      HDC  hdc = (HDC)wParam;
      RECT rc;
      GetClientRect(hwnd, &rc);
      if(!pw->is_painting)
        pw->print(hdc, fromRECT(rc));
      return 0;
    }

    case WM_ACTIVATE: {
      ACTIVATE_MODE am = ACTIVATE_MODE();
      switch (wParam) {
      case WA_ACTIVE: am = ACTIVATED; break;
      case WA_CLICKACTIVE: am = MOUSE_ACTIVATED; break;
      case WA_INACTIVE: am = INACTIVE; break;
      }
#ifdef USE_TOUCH
      if (am) EnableTouchpadInput(hwnd);
#endif
      pw->on_activate(am);
      pw->refresh();
    } break;

#ifdef THEMES_SUPPORT
    case WM_THEMECHANGED:
      if (!theme::processing) // handling WM_THEMECHANGED only if it was
                              // generated out of WM_PAINT handling
      {
        theme *pt = theme::current(theme::PEEK);
        if (!pt)
          pw->on_media_changed();
        else if (pt != theme::current(theme::RESET))
          pw->on_media_changed();
      }
      break;
#endif

	case WM_WTSSESSION_CHANGE: {
	  if (wParam == WTS_SESSION_LOGON || wParam == WTS_SESSION_UNLOCK)
		  goto RESET_UI;
	} break;
    case WM_DISPLAYCHANGE:
      //???? breaks custom frame windows: pw->set_frame_type(pw->get_frame_type());
      // fall through
    case WM_DWMCOMPOSITIONCHANGED:
    case WM_DWMCOLORIZATIONCOLORCHANGED:
    case WM_SETTINGCHANGE:
    {
    RESET_UI:
      pw->remove_tooltips();
      //pw->reset_surface();
      pw->dpi.x.clear(); // reset window DPI
      pw->dpi.y.clear();
      accent_color = argb::no_color();
      pw->refresh();
      pw->on_size(pw->dim);
      // post it to prevent frequent updates //pw->on_media_changed();
      pw->notify_media_change();
    } break;

    case WM_STYLECHANGED:
      if (wParam == GWL_EXSTYLE) {
        STYLESTRUCT *pss = reinterpret_cast<STYLESTRUCT *>(lParam);
        if ((pss->styleOld & WS_EX_LAYERED) != (pss->styleNew & WS_EX_LAYERED))
          pw->reset_surface();
      }
      break;

    case WM_ENABLE: 
      pw->html::view::set_enabled(wParam != FALSE); 
      break;

    case WM_DPICHANGED: {
      gool::size dpi(LOWORD(wParam), HIWORD(wParam));
      RECT       wrc = *(reinterpret_cast<RECT *>(lParam));
      pw->on_dpi_changed(dpi, fromRECT(wrc));
      RECT* rect = reinterpret_cast<RECT*>(lParam);
      ::MoveWindow(hwnd, rect->left, rect->top, rect->right - rect->left, rect->bottom - rect->top, false);
      //SetWindowPos(hwnd, nullptr, rect->left, rect->top, rect->right - rect->left, rect->bottom - rect->top, SWP_NOZORDER | SWP_NOACTIVATE | SWP_FRAMECHANGED);
      return TRUE;
    } break;

#if 1 // does not work on W10 ?
    case 0x02E4 /*WM_GETDPISCALEDSIZE*/:
    {
      /*UINT dpi = static_cast<UINT>(wParam);
      float scaling_factor = static_cast<float>(dpi) / USER_DEFAULT_SCREEN_DPI;

      RECT client_area;
      client_area.right *= scaling_factor;
      client_area.bottom *= scaling_factor;

      RECT window_rectangle;
      window_rectangle.left = 0;
      window_rectangle.top = 0;
      window_rectangle.right = static_cast<LONG>(window_width * scaling_factor);
      window_rectangle.bottom = static_cast<LONG>(window_height * scaling_factor);

      if (!AdjustWindowRectExForDpi(&window_rectangle, window_style, false, 0, dpi))
      {
        // Error handling
        return 0;
      }

      SIZE* new_size = reinterpret_cast<SIZE*>(l_param);
      new_size->cx = window_rectangle.right - window_rectangle.left;
      new_size->cy = window_rectangle.bottom - window_rectangle.top;*/

      return 1;
    }
#endif 

#if 0
    case WM_NCPOINTERUPDATE              :
    case WM_NCPOINTERDOWN                :
    case WM_NCPOINTERUP                  :
    case WM_POINTERUPDATE                :
    case WM_POINTERDOWN                  :
    case WM_POINTERUP                    :
    case WM_POINTERENTER                 :
    case WM_POINTERLEAVE                 :
    case WM_POINTERACTIVATE              :
    case WM_POINTERCAPTURECHANGED        :
    case WM_TOUCHHITTESTING              :
    case WM_POINTERWHEEL                 :
    case WM_POINTERHWHEEL                :
    case DM_POINTERHITTEST               :
    case WM_POINTERROUTEDTO              :
    case WM_POINTERROUTEDAWAY            :
    case WM_POINTERROUTEDRELEASED        :
    {
      UINT32 pointerId = GET_POINTERID_WPARAM(wParam);

      POINTER_INFO pi = { 0 };

      if (GetPointerInfo(pointerId, &pi))
      {
        dbg_printf("WM_POINTER %x, pid=%d type=%d flags=%x\n", message, pointerId, pi.pointerType, pi.pointerFlags);
      }

    } break;
#endif

    case WM_MOUSEWHEEL:
      //dbg_printf("WM_MOUSEWHEEL\n");
      handled = pw->mouse_wheel(wParam, lParam, true);
      break;
    case WM_MOUSEHWHEEL:
      // dbg_printf("WM_MOUSEHWHEEL\n");
      handled = pw->mouse_wheel(wParam, lParam, false);
      break;

    case WM_MOUSEMOVE: handled = pw->mouse_move(wParam, lParam); break;
    case WM_LBUTTONDOWN:
      handled = pw->mouse_down(MAIN_BUTTON, wParam, lParam);
      break;
    case WM_RBUTTONDOWN:
      handled = pw->mouse_down(PROP_BUTTON, wParam, lParam);
      break;
    case WM_MBUTTONDOWN:
      handled = pw->mouse_down(MIDDLE_BUTTON, wParam, lParam);
      break;
    case WM_XBUTTONDOWN:
      handled = pw->mouse_down(HIWORD(wParam) << 3, wParam, lParam);
      break;

    case WM_LBUTTONUP:
      handled = pw->mouse_up(MAIN_BUTTON, wParam, lParam);
      break;
    case WM_RBUTTONUP:
      handled = pw->mouse_up(PROP_BUTTON, wParam, lParam);
      break;
    case WM_MBUTTONUP:
      handled = pw->mouse_up(MIDDLE_BUTTON, wParam, lParam);
      break;
    case WM_XBUTTONUP:
      handled = pw->mouse_up(HIWORD(wParam) << 3, wParam, lParam);
      break;

    case WM_LBUTTONDBLCLK:
      handled = pw->mouse_dblclick(MAIN_BUTTON, wParam, lParam);
      break;
    case WM_RBUTTONDBLCLK:
      handled = pw->mouse_dblclick(PROP_BUTTON, wParam, lParam);
      break;
    case WM_MBUTTONDBLCLK:
      handled = pw->mouse_dblclick(MIDDLE_BUTTON, wParam, lParam);
      break;
    case WM_XBUTTONDBLCLK:
      handled = pw->mouse_dblclick(HIWORD(wParam) << 3, wParam, lParam);
      break;

    case WM_NCMOUSEMOVE:
      if (pw->_window_controls) {
        point pt;
        pt.x = GET_X_LPARAM(lParam);
        pt.y = GET_Y_LPARAM(lParam);
        screen2client(hwnd, pt, pw->get_frame_type() == STANDARD);
        auto_state<bool> _(pw->_non_client_mouse, true);
        handled = pw->mouse_move(wParam, POINTTOPOINTS(pt));
      }
      break;

    case WM_NCLBUTTONDBLCLK:
      if (pw->_window_controls)
      {
        POINT pt; pt.x = GET_X_LPARAM(lParam);
        pt.y = GET_Y_LPARAM(lParam);
        ::ScreenToClient(hwnd, &pt);
        auto_state<bool> _(pw->_non_client_mouse, true);
        handled = pw->mouse_dblclick(MAIN_BUTTON, wParam, MAKELPARAM(WORD(short(pt.x)), WORD(short(pt.y))));
      }
      break;

      /* We are not responsible for handling this:
        case WM_NCLBUTTONDOWN:
        if(pw->_window_controls)
        {
          POINT pt; pt.x = GET_X_LPARAM(lParam);
                    pt.y = GET_Y_LPARAM(lParam);
          ::ScreenToClient(hwnd, &pt);
          auto_state<bool> _(pw->_non_client_mouse,true);
          handled = pw->mouse_down(MAIN_BUTTON,wParam, MAKELPARAM(
      WORD(short(pt.x)), WORD(short(pt.y)) ));
        }
        break;
      case WM_NCLBUTTONUP:
        if(pw->_window_controls)
        {
          POINT pt; pt.x = GET_X_LPARAM(lParam);
                    pt.y = GET_Y_LPARAM(lParam);
          ::ScreenToClient(hwnd, &pt);
          auto_state<bool> _(pw->_non_client_mouse,true);
          handled = pw->mouse_up(MAIN_BUTTON,wParam, MAKELPARAM(
      WORD(short(pt.x)), WORD(short(pt.y)) ));
        }
        break; */

    case WM_TIMER:
      handled = pw->timer_tick(wParam, lParam);
      break;

    // case WM_SHOWWINDOW:
    //case WM_WINDOWPOSCHANGING: pw->handle_state_changed(); break;
    case WM_SETCURSOR:
      if (LOWORD(lParam) == HTCLIENT && (HWND)wParam == hwnd) {
        if (pw->_cursor) {
          pw->set_cursor(pw->_cursor);
          handled = TRUE;
        }
        //::SetCursor(pw->_cursor->object());
        return TRUE;
      }
      break;
    case WM_DESTROY: {
      handle<gool::application> app_holder = pw->app;
      pw->stop();
      if (pw->_need_OleUninitialize) OleUninitialize();
      //detach(pw, hwnd);
      pw->set_hwnd(nullptr);
      window::release_hook();
      thread_state.drop_current();
      pw = nullptr;
    }
      return 0;

    case WM_CHAR: {
      unsigned char c = (byte)wParam;
      if (!::IsWindowUnicode(hwnd))
        MultiByteToWideChar(input_code_page, 0, (LPCSTR)&c, 1, (LPWSTR)&wParam,
                            1);
      handled = pw->on_key(html::KEY_CHAR, (int)wParam, get_alts(lParam));
    } break;
    case WM_UNICHAR:
      handled = pw->on_key(html::KEY_CHAR, (int)wParam, get_alts(lParam));
      break;
    case WM_KEYDOWN:
      handled = pw->on_key(html::KEY_DOWN, (int)wParam, get_alts(lParam));
      break;
    case WM_KEYUP:
      handled = pw->on_key(html::KEY_UP, (int)wParam, get_alts(lParam));
      break;
    case WM_SYSKEYDOWN:
      if (wParam == VK_F10)
        handled = pw->on_key(html::KEY_DOWN, (int)wParam, get_alts(lParam));
      else
        handled = pw->on_key(html::KEY_DOWN, (int)wParam, get_alts(lParam) | ALT_ALT);
      break;
    case WM_SYSKEYUP:
      if (wParam == VK_F10)
        handled = pw->on_key(html::KEY_UP, (int)wParam, get_alts(lParam));
      else
        handled = pw->on_key(html::KEY_UP, (int)wParam, get_alts(lParam) | ALT_ALT);
      break;
    case WM_SYSCHAR:
      handled = pw->on_key(html::KEY_CHAR, (int)wParam, get_alts(lParam) | ALT_ALT);
      break;
#ifdef WM_INPUTLANGCHANGE
    case WM_INPUTLANGCHANGE: // WM_INPUTLANGCHANGEREQUEST:
    {
      HKL NewInputLocale = (HKL)lParam;
      // LANGID wPrimaryLang =
      // PRIMARYLANGID(LANGIDFROMLCID(LOWORD(NewInputLocale))) ;
      input_code_page = LangToCodePage(LOWORD(NewInputLocale));
      critical_section cs(pw->guard);
      bool             ime_status = pw->ime_ctx.SetInputLanguage();
      if (ime_status != pw->ime_notification) pw->ime_notification = ime_status;
      pw->on_input_lang_change(LangToIsoString(LOWORD(NewInputLocale)));
    } break;
#endif
    case WM_IME_SETCONTEXT:
      pw->ime_notification = (wParam == TRUE);
      if (pw->ime_notification) pw->ime_ctx.CreateImeWindow(hwnd);
      pw->ime_ctx.CleanupComposition(hwnd);
      pw->ime_ctx.SetImeWindowStyle(hwnd, message, wParam, lParam, &handled);
      return 0;

    case WM_IME_STARTCOMPOSITION:
      // Reset the composition status and create IME windows.
      pw->ime_ctx.CreateImeWindow(hwnd);
      pw->ime_ctx.ResetComposition(hwnd);
      // We have to prevent caller from calling ::DefWindowProc() because the
      // function calls ::ImmSetCompositionWindow() and
      // ::ImmSetCandidateWindow() to over-write the position of IME windows.
      handled = TRUE;
      return 0;

    case WM_IME_COMPOSITION: {
      // At first, update the position of the IME window.
      pw->ime_ctx.UpdateImeWindow(hwnd);
      // Retrieve the result string and its attributes of the ongoing
      // composition and send it to a renderer process.
      ImeComposition composition;
      if (pw->ime_ctx.GetResult(hwnd, lParam, &composition)) {
        pw->on_ime_chars(true, composition.ime_string);
        pw->ime_ctx.ResetComposition(hwnd);
        // Fall though and try reading the composition string.
        // Japanese IMEs send a message containing both GCS_RESULTSTR and
        // GCS_COMPSTR, which means an ongoing composition has been finished
        // by the start of another composition.
      }
      // Retrieve the composition string and its attributes of the ongoing
      // composition and send it to a renderer process.
      if (pw->ime_ctx.GetComposition(hwnd, lParam, &composition)) {
        range ime_target;
        if (composition.target_start >= 0 &&
            composition.target_start < composition.target_end)
          ime_target =
              range(composition.target_start, composition.target_end - 1);
        int_v ime_caret;
        if (composition.cursor_position >= 0 &&
            composition.cursor_position <= composition.ime_string.size())
          ime_caret = composition.cursor_position;
        pw->on_ime_chars(false, composition.ime_string, ime_target, ime_caret);
        gool::rect rc;
        if (pw->focus_element && pw->focus_element->get_caret_location(*pw, rc))
          pw->ime_ctx.SetCaretRect(hwnd, rc + pw->focus_element->view_pos(*pw));
      }
      // We have to prevent caller from calling ::DefWindowProc() because we do
      // not want for the IMM (Input Method Manager) to send WM_IME_CHAR
      // messages.
      handled = TRUE;
      return 0;
    }

    case WM_IME_ENDCOMPOSITION:
      if (pw->ime_ctx.is_composing()) {
        // A composition has been ended while there is an ongoing composition,
        // i.e. the ongoing composition has been canceled.
        // We need to reset the composition status both of the ImeInput object
        // and of the renderer process.
        pw->on_ime_chars(false, wchars());
        pw->ime_ctx.ResetComposition(hwnd);
      }
      pw->ime_ctx.DestroyImeWindow(hwnd);
      // Let caller call ::DefWindowProc() and release its resources.
      handled = FALSE;
      return 0;

    case WM_GETDLGCODE: handled = true; return DLGC_WANTALLKEYS | DLGC_WANTTAB;

    case WM_CAPTURECHANGED:
      if (lParam != (LPARAM)hwnd) pw->view::set_capture(0);
      handled = true;
      break;

    case WM_HSCROLL: handled = pw->handle_scroll(false, wParam, lParam); break;
    case WM_VSCROLL: handled = pw->handle_scroll(true, wParam, lParam); break;

    case WM_CONTEXTMENU: {
      point pt;
      pt.x = GET_X_LPARAM(lParam);
      pt.y = GET_Y_LPARAM(lParam);
      ::MapWindowPoints(HWND_DESKTOP, hwnd, PPOINT(pt), 1);
      if (pw->on_context_menu(pt)) {
        handled = TRUE;
        return 0;
      }
    } break;

    //case WM_TOUCH:
    //  handled = handled;
    //  break;

#ifdef USE_TOUCH
    case WM_GESTURE: 
      return handle_GESTURE(pw, wParam, lParam, pw->get_hwnd(), handled);
    case WM_GESTURENOTIFY: 
      return config_GESTURE(pw, wParam, lParam, pw->get_hwnd(), handled);
    case WM_TABLET_QUERYSYSTEMGESTURESTATUS:
      handled = TRUE;
      return TABLET_DISABLE_FLICKS;
#endif

    case WM_SETFOCUS:
      pw->handle_got_focus((HWND)wParam);
      handled = TRUE;
      return 0;

    case WM_KILLFOCUS:
      pw->handle_lost_focus((HWND)wParam);
      handled = TRUE;
      return 0;

#ifdef ACCESSIBLE
    case WM_GETOBJECT: 
      return pw->handle_get_object(wParam, lParam, handled);
#endif

    default:
      if (message == WM_GETWINDOWBLOCK) {
        critical_section cs(pw->guard);
        element **       ppelement = (element **)lParam;
        if (ppelement) *ppelement = pw->doc();
        return 0xAF;
      }
      //else if (message == WM_UPDATELAYERED) {
      //  //if (!pw->dismissing && ::IsWindowVisible(hwnd)) {
      //  //  pw->render_layered();
      //  //}
      //  handled = TRUE;
      //  return 0;
      //}
      else if (message == WM_POST_IDLE) {
        // MSG msg; // WRONG: PeekMessage dispatches the message that may lead
        // to WM_POST_IDLE to be posted to the queue again.
        // while(::PeekMessage(&msg,hwnd,WM_POST_IDLE,WM_POST_IDLE, PM_REMOVE |
        // PM_NOYIELD));
        pw->on_idle();
        handled = TRUE;
        return 0;
      }
      else if (message == WM_TRAY_CALLBACK)
        return pw->trayicon_message(wParam, lParam, handled);
    }
    return 0;
  }

  bool window::mouse_move(WPARAM wParam, LPARAM lParam) {
    POINTSTOPOINT(_last_known_point, lParam);
    uint buttons = get_buttons(wParam);

    uint alts = get_sync_alts();
#ifdef USE_TOUCH
    if (is_touched)
      alts |= html::ALT_TOUCH;
#endif

    return on_mouse(html::MOUSE_MOVE, buttons, alts, _last_known_point);
  }

  bool window::mouse_wheel(WPARAM wParam, LPARAM lParam, bool vertical) {

    //uint keys = GET_KEYSTATE_WPARAM(wParam);
    short deltas = GET_WHEEL_DELTA_WPARAM(wParam);
    short steps = deltas;
    point pos;
    pos.x = GET_X_LPARAM(lParam);
    pos.y = GET_Y_LPARAM(lParam);

    //dbg_printf("mouse_wheel deltas:%d keys:%x, vertical:%d\n", deltas, keys, vertical);
    uint alts = get_sync_alts();
#ifdef USE_TOUCH
    if(is_touched)
      alts |= html::ALT_TOUCH;
#endif

    screen2client(get_hwnd(), pos, get_frame_type() == STANDARD);
    // dbg_printf("MOUSE_WHEEL %d\n",steps);
    uint z = vertical ? make_dword(0, steps) : make_dword(short(-steps), 0);
    return on_mouse(html::MOUSE_WHEEL, z, alts, pos);
  }

  bool window::mouse_down(uint buttons, WPARAM wParam, LPARAM lParam) {
    ime_ctx.CleanupComposition(get_hwnd());
        
    POINTSTOPOINT(_last_known_point, lParam);

    map_client_point(get_hwnd(), _last_known_point);

    uint alts = get_sync_alts();
#ifdef USE_TOUCH
    if (is_touched)
      alts |= html::ALT_TOUCH;
#endif

    if ((GetFocus() != get_hwnd()) && is_on_screen()) // get_mode() != 0 &&
    {
      auto_state<tristate_v> _(focus_by_mouse, TRUE);
      SetFocus(get_hwnd());
    }
    return on_mouse(html::MOUSE_DOWN, buttons, alts, _last_known_point);
  }

  bool window::mouse_up(uint buttons, WPARAM wParam, LPARAM lParam) {
    POINTSTOPOINT(_last_known_point, lParam);
    map_client_point(get_hwnd(), _last_known_point);
    uint alts = get_sync_alts();
#ifdef USE_TOUCH
    if (is_touched)
      alts |= html::ALT_TOUCH;
#endif
    return on_mouse(html::MOUSE_UP, buttons, alts, _last_known_point);
  }

  bool window::mouse_dblclick(uint buttons, WPARAM wParam, LPARAM lParam) {
    POINTSTOPOINT(_last_known_point, lParam);
    map_client_point(get_hwnd(), _last_known_point);
    uint alts = get_sync_alts();
#ifdef USE_TOUCH
    if (is_touched)
      alts |= html::ALT_TOUCH;
#endif
    bool r = on_mouse(html::MOUSE_DCLICK, buttons, alts, _last_known_point);
    return r;
  }

  bool window::is_at_position(point screen_pos) 
  {
    HWND hw = ::WindowFromPoint(*PPOINT(screen_pos));
    if (hw == get_hwnd())
      return true;
    else {
      element* pb = window_element(hw);
      if (pb && pb->belongs_to(doc(), true))
        return true;
    }
    return false;
  }

  bool window::timer_tick(WPARAM wParam, LPARAM lParam) {
    return on_timer(wParam);
  }

  void window::set_cursor(cursor *pcur) {
    if (_non_client_mouse) return;
    _cursor = pcur;
    if (_cursor) 
      ::SetCursor(_cursor->object());
    else 
      ::SetCursor(cursor::system(0)->object());
  }

  cursor *window::get_cursor() { return _cursor; }

  /*
    void  window::set_cursor(uint cid)
    {
       if( _non_client_mouse )
         return;
       //if(_cursor_type == 13 && cid == 0)
       //  dbg_printf("cursor type=%d\n",_cursor_type);
       _cursor_type = cid;
       if( cid >= 32 )
       {
          cid -= 32;
          if( (cid < cursors.length()) && cursors[cid].hcursor )
          {
            SetCursor(cursors[cid].hcursor);
            return;
          }
          cid = 0;
       }
       else if(cid > 13)
       {
          static HCURSOR additional[32-13] = {0};
          if(!additional[cid-14])
            additional[cid-14] = LoadCursor(HINST_THISCOMPONENT,(const
    TCHAR*)(cursor_ids[cid-14])); SetCursor(additional[cid-14]);
       }
       else
          SetCursor(LoadCursor(NULL,MAKEINTRESOURCE(cursor_ids[cid])));
    } */

  /*
  void window::cursor_data_arrived(handle<pump::request> rq)
  {
    char tmppath[MAX_PATH];
    char tmpname[MAX_PATH];
    GetTempPathA(MAX_PATH,tmppath);
    GetTempFileNameA(tmppath,"cur",0,tmpname);

    FILE* f = 0; fopen_s(&f,tmpname,"wb+");
    if(!f) return;
    fwrite(rq->data.head(), rq->data.size(),1,f);
    fclose(f);

    HCURSOR h = LoadCursorFromFileA( tmpname );

    ::remove(tmpname);

    assert(h);
    if( !h ) return;
    for( int i = 0; i < cursors.size(); ++i )
    {
      if( cursors[i].uri == rq->url )
      {
        if(cursors[i].hcursor)
          DestroyIcon((HICON)cursors[i].hcursor);
        cursors[i].hcursor = h;
        return;
      }
    }
    cursor_def cd; cd.uri = rq->url; cd.hcursor = h;
    cursors.push(cd);
  }

  uint window::get_cursor_id( string uri )
  {
    for( uint i = 0; i < cursors.length(); ++i )
    {
      if( cursors[i].uri == uri )
      {
        return i + 32;
      }
    }
    cursor_def cd; cd.uri = uri; cd.hcursor = 0;
    cursors.push(cd);

    handle<pump::request> rq = new pump::request(uri, DATA_CURSOR);
    if(load_data(rq))
    {
        cursor_data_arrived(rq);
    }
    return (uint) cursors.last_index() + 32;
  } */

  void window::update() {
    if (dismissing) return;
    if (!_is_painting) {
      ::UpdateWindow(get_hwnd());
    }
  }

  void window::handle_got_focus(HWND hwnd_from) {
    while (hwnd_from) {
      if (hwnd_from == get_hwnd()) return;
      hwnd_from = GetParent(hwnd_from);
    }
    if (!focus_by_mouse) on_focus(true);
  }

  void window::handle_lost_focus(HWND hwnd_to) {

    HWND t = hwnd_to;
    while (t) {
      if (t == get_hwnd()) {
        element *b = window_element(hwnd_to);
        if (b) {
          view::set_focus(b, BY_CODE, true);
          return;
        }
      }
      t = GetParent(t);
    }
    on_focus(false);
  }

  bool window::set_h_scrollbar(range content_h, bool noremove, size &sz) {
    auto_state<bool> _(_scrollbar_handling, true);

    SCROLLINFO si;
    si.cbSize = sizeof(si);

    rect rc;
    ::GetClientRect(get_hwnd(), PRECT(rc));
    size view_size = rc.size(); //--view_size;

    si.fMask = SIF_PAGE | SIF_RANGE;

    if (view_size.x <= 1 || view_size.y <= 1) {
      if (noremove) si.fMask |= SIF_DISABLENOSCROLL;

      si.nMax      = 0;
      si.nMin      = 0;
      si.nPage     = 0;
      si.nPos      = 0;
      si.nTrackPos = 0;
      SetScrollInfo(get_hwnd(), SB_HORZ, &si, FALSE);
    } else {
      if (noremove) si.fMask |= SIF_DISABLENOSCROLL;

      si.nMax      = content_h.e;
      si.nMin      = content_h.s;
      si.nPage     = view_size.x;
      si.nTrackPos = 0;
      SetScrollInfo(get_hwnd(), SB_HORZ, &si, TRUE);
    }

    rect rc1;
    ::GetClientRect(get_hwnd(), PRECT(rc1));

    sz.x = rc1.width();
    sz.y = rc1.height();

    return rc.height() != rc1.height();
  }

  bool window::set_v_scrollbar(range content_v, bool noremove, size &sz) {
    auto_state<bool> _(_scrollbar_handling, true);

    SCROLLINFO si;
    memset(&si, 0, sizeof(si));
    si.cbSize = sizeof(si);

    rect rc;
    ::GetClientRect(get_hwnd(), PRECT(rc));

    size view_size = rc.size();

    si.fMask = SIF_PAGE | SIF_RANGE;

    if (view_size.x <= 1 || view_size.y <= 1) {
      if (noremove) si.fMask |= SIF_DISABLENOSCROLL;

      si.nMax      = 0;
      si.nMin      = 0;
      si.nPage     = 0;
      si.nPos      = 0;
      si.nTrackPos = 0;
      SetScrollInfo(get_hwnd(), SB_VERT, &si, FALSE);

    } else {
      if (noremove) si.fMask |= SIF_DISABLENOSCROLL;

      si.nMax  = content_v.e;
      si.nMin  = content_v.s;
      si.nPage = view_size.y; // limit(view_size.y,0, si.nMax - si.nMin + 1);

      // string s = string::format("%d %d %d\n")
      // dbg_printf("%d %d %d\n", content_v.l, content_v.h, view_size.y);

      si.nTrackPos = 0;
      SetScrollInfo(get_hwnd(), SB_VERT, &si, TRUE);
    }

    rect rc1;
    ::GetClientRect(get_hwnd(), PRECT(rc1));

    sz.x = rc1.width();
    sz.y = rc1.height();
    return rc.width() != rc1.width();
  }

  bool window::handle_scroll(bool vertical, WPARAM wParam, LPARAM lParam) {
    int cmd = 0;

    int pos = HIWORD(wParam);

    switch (LOWORD(wParam)) {
    case SB_BOTTOM: cmd = html::SCROLL_END; break;
    case SB_LINEDOWN: cmd = html::SCROLL_STEP_PLUS; break;
    case SB_LINEUP: cmd = html::SCROLL_STEP_MINUS; break;
    case SB_PAGEDOWN: cmd = html::SCROLL_PAGE_PLUS; break;
    case SB_PAGEUP:
      cmd = html::SCROLL_PAGE_MINUS;
      break;
      // SB_THUMBPOSITION The user has dragged the scroll box (thumb) and
      // released the mouse button. The high-order word indicates the position of
      // the scroll box at the end of the drag operation.
    case SB_THUMBTRACK:
      cmd = html::SCROLL_POS;
      {
        SCROLLINFO si;
        si.cbSize = sizeof(SCROLLINFO);
        si.fMask  = SIF_TRACKPOS;
        GetScrollInfo(get_hwnd(), vertical ? SB_VERT : SB_HORZ, &si);
        pos = si.nTrackPos;
      }
      break;
    case SB_TOP: cmd = html::SCROLL_HOME; break;
    default: return 0;
    }

    if (doc()) {
      event_scroll evt(doc(), cmd, vertical, pos,html::SCROLL_SOURCE_UNKNOWN,0);
      return doc()->on(*this, evt);
    }
    // LOCK_INSTANCE(this);
    // on_scroll(uMsg == WM_VSCROLL, cmd, param, doc());
    return false;
  }

  void window::set_scroll_pos(point pos) {
    SCROLLINFO si;
    si.cbSize = sizeof(si);

    bool scrolled = false;

    si.fMask = SIF_POS;
    {
      si.nMax      = 0;
      si.nMin      = 0;
      si.nPage     = 0;
      si.nPos      = pos.y;
      si.nTrackPos = 0;
      if (SetScrollInfo(get_hwnd(), SB_VERT, &si, TRUE)) scrolled = true;
    }

    si.fMask = SIF_POS;
    {
      si.nMax      = 0;
      si.nMin      = 0;
      si.nPage     = 0;
      si.nPos      = pos.x;
      si.nTrackPos = 0;
      if (SetScrollInfo(get_hwnd(), SB_HORZ, &si, TRUE)) scrolled = true;
    }
    if (scrolled) {
      auto_state<tristate_v> _(is_measuring, true);
      if (doc()) {
        doc()->measure(*this, client_dim());
        refresh();
        replace_windowed();
      }
    }
  }

  point window::get_scroll_pos() {
    point pt;

    SCROLLINFO si;
    si.cbSize = sizeof(SCROLLINFO);
    si.fMask  = SIF_POS;
    if (GetScrollInfo(get_hwnd(), SB_HORZ, &si)) pt.x = si.nPos;
    if (GetScrollInfo(get_hwnd(), SB_VERT, &si)) pt.y = si.nPos;
    return pt;
  }

  bool window::has_h_scrollbar(bool &yes) {
    SCROLLINFO si;
    si.cbSize = sizeof(SCROLLINFO);
    si.fMask  = SIF_PAGE | SIF_RANGE;
    if (GetScrollInfo(get_hwnd(), SB_HORZ, &si)) {
      yes = (si.nMax - si.nMin) > int(si.nPage);
      return true;
    }
    return false;
  }
  bool window::has_v_scrollbar(bool &yes) {
    SCROLLINFO si;
    si.cbSize = sizeof(SCROLLINFO);
    si.fMask  = SIF_PAGE | SIF_RANGE;
    if (GetScrollInfo(get_hwnd(), SB_VERT, &si)) {
      yes = (si.nMax - si.nMin) > int(si.nPage);
      return true;
    }
    return false;
  }

  array<ustring> window::ask_file_name(AFN_MODE mode, const ustring &caption,
                                       const ustring &filename_in,
                                       const wchar *  def_ext,
                                       const wchar *  filter) {

    ustring filename = filename_in;
    filename.replace_all(wchar('/'), wchar('\\'));

    HWND  owner                               = get_hwnd();
    wchar filepath_buffer[10 * _MAX_PATH + 1] = {0};
    wchar filename_buffer[_MAX_FNAME + 1]     = {0};
    wchar folder_buffer[_MAX_FNAME + 1] = { 0 };

    ustring sfilter = filter;

    sfilter.replace_all('|', '\0');
    sfilter += wchar('\0');

    int last_slash = last_slash = filename().last_index_of('\\');
    if (last_slash >= 0) {
      // wcsncpy(filepath_buffer,filename.c_str(),_MAX_PATH);
      wcsncpy_s(filepath_buffer, filename.c_str() + last_slash + 1, _MAX_PATH);
      wcsncpy_s(folder_buffer, filename.c_str(), last_slash + 1);
    }
    else if (filename.length()) {
      wcsncpy_s(filepath_buffer, filename.c_str(), _MAX_PATH);
      wcsncpy_s(folder_buffer, filename.c_str(), _MAX_PATH);
    }

    OPENFILENAMEW ofn = {0};

    ofn.lStructSize    = sizeof(ofn);
    ofn.lpstrFile      = filepath_buffer;
    ofn.nMaxFile       = items_in(filepath_buffer);
    ofn.lpstrDefExt    = def_ext;
    ofn.lpstrFileTitle = filename_buffer;
    ofn.nMaxFileTitle  = _MAX_FNAME;
    ofn.Flags          = OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR;
    switch (mode) {
    case AFN_OPEN: break;
    case AFN_OPEN_MULTIPLE: ofn.Flags |= OFN_ALLOWMULTISELECT; break;
    case AFN_SAVE: ofn.Flags |= (OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT); break;
    }
    ofn.lpstrFilter = sfilter;
    ofn.hInstance   = HINST_THISCOMPONENT;
    ofn.hwndOwner   = owner;

    // setup initial file name
    //ustring initial_dir = filename;
    //initial_dir.replace_all('/', '\\');
    //if (initial_dir.length() && !initial_dir().ends_with('\\'))
    //  initial_dir += "\\";
    ofn.lpstrInitialDir = folder_buffer;

    if (caption.length()) ofn.lpstrTitle = caption;

    // filepath_buffer[0] = 0;
    // filepath_buffer[_MAX_PATH] = 0;

    BOOL bRet;
    if (mode == AFN_SAVE)
      bRet = ::GetSaveFileNameW(&ofn);
    else
      bRet = ::GetOpenFileNameW(&ofn);

    array<ustring> filenames;

    if (bRet) {
      if (mode == AFN_SAVE || mode == AFN_OPEN)
        filenames.push(ustring(filepath_buffer));
      else {
        const wchar_t *str = filepath_buffer;
        while (*str) {
          ustring fn = str;
          str += (fn.length() + 1);
          filenames.push(fn);
        }
        if (filenames.size() > 1) {
          ustring dir = filenames[0] + "\\";
          for (int n = 1; n < filenames.size(); ++n)
            filenames[n] = dir + filenames[n];
          filenames.remove(0);
        }
      }
    }
    return filenames;
  }

  bool window::ask_folder_name(const ustring &caption, ustring &foldername) {
    wchar   buf[MAX_PATH] = {0};
    HRESULT hr            = 0;
    bool    selected      = false;
    // Create a new common open file dialog.
    IFileOpenDialog *pfd = NULL;

    foldername.replace_all('/', '\\');

    if (!_SHCreateItemFromParsingName) goto OLDWAY;

    hr = CoCreateInstance(CLSID_FileOpenDialog, NULL, CLSCTX_INPROC_SERVER,
                          IID_PPV_ARGS(&pfd));
    if (FAILED(hr))
      goto OLDWAY;
    else {
      DWORD dwOptions;
      hr = pfd->GetOptions(&dwOptions);
      if (SUCCEEDED(hr)) 
        hr = pfd->SetOptions(dwOptions | FOS_PICKFOLDERS);
      // Set the title of the dialog.
      if (SUCCEEDED(hr)) {
        hr = pfd->SetTitle(caption);
        if (foldername.length()) {
          HRESULT hrs = pfd->ClearClientData();
          IShellItem *psiFolder = nullptr;
          hrs = _SHCreateItemFromParsingName()(foldername, NULL, IID_PPV_ARGS(&psiFolder));
          if (SUCCEEDED(hr)) {
            hrs = pfd->SetDefaultFolder(psiFolder);
            if(psiFolder)
              psiFolder->Release();
          }
        }
      
        // Show the open file dialog.
        hr = pfd->Show(get_hwnd());
        if (SUCCEEDED(hr)) { // Get the selection from the user.
          IShellItem *psiResult = nullptr;
          hr = pfd->GetResult(&psiResult);
          if (SUCCEEDED(hr) && psiResult) {
            PWSTR pszPath = nullptr;
            hr = psiResult->GetDisplayName(SIGDN_FILESYSPATH, &pszPath);
            if (SUCCEEDED(hr)) {
              selected   = true;
              foldername = pszPath;
              foldername.replace_all('\\', '/');
              CoTaskMemFree(pszPath);
            }
            psiResult->Release();
          }
        } 
        else if (hr == HRESULT_FROM_WIN32(ERROR_CANCELLED))
          selected = false; // User cancelled the dialog...
        pfd->Release();
      }
    }
    return selected;

  OLDWAY :

  {
    BROWSEINFOW bi;
    memset(&bi, 0, sizeof(bi));
    bi.hwndOwner      = get_hwnd();
    bi.pszDisplayName = buf;
    bi.ulFlags        = BIF_USENEWUI | BIF_BROWSEINCLUDEURLS;
    bi.lpszTitle      = caption;

    LPITEMIDLIST lpi = SHBrowseForFolderW(&bi);

    if (lpi && buf[0]) {
      wchar bufp[MAX_PATH] = {0};
      SHGetPathFromIDListW(lpi, bufp); // Make sure it is a path
      foldername = bufp;
      foldername.replace_all('\\', '/');
      return true;
    }
    return false;
  }
  }



  WINDOW_STATE window::get_window_state() const {
    if (!get_hwnd()) return WINDOW_STATE_NA;

    if (!::IsWindowVisible(get_hwnd())) return WINDOW_HIDDEN;

    // LONG exStyle = GetWindowLong(get_hwnd(),GWL_EXSTYLE);
    // LONG style = GetWindowLong(get_hwnd(),GWL_STYLE);

    switch (_window_state) {
    case SW_SHOWMAXIMIZED: return _full_screen ? WINDOW_FULL_SCREEN : WINDOW_MAXIMIZED;
    case SW_SHOWMINIMIZED: return WINDOW_MINIMIZED;
    case SW_SHOWNORMAL: return WINDOW_SHOWN;
    case SW_HIDE: return WINDOW_HIDDEN;
    }
    return WINDOW_HIDDEN;
  }
  bool window::set_window_state(WINDOW_STATE ws) {
    if (!get_hwnd()) return false;

    LONG exStyle = ::GetWindowLong(get_hwnd(), GWL_EXSTYLE);
    LONG style   = ::GetWindowLong(get_hwnd(), GWL_STYLE);

    FRAME_TYPE ft = get_frame_type();

    WINDOW_STATE old_st = get_window_state();
    if (old_st != ws) {

      /*switch (ws) {
        case WINDOW_MAXIMIZED:
          if (old_st == WINDOW_FULL_SCREEN) return false;
          break;
        case WINDOW_FULL_SCREEN:
          if (old_st == WINDOW_MAXIMIZED) return false;
          break;
      }*/

      if (old_st == WINDOW_FULL_SCREEN) {
        if (ft == STANDARD || ft == STANDARD_EXTENDED)
          ::SetWindowLong(get_hwnd(), GWL_STYLE, (style & ~WS_POPUP) | WS_OVERLAPPEDWINDOW);
        ::SetWindowLong(get_hwnd(), GWL_EXSTYLE, exStyle & ~WS_EX_TOPMOST);
      }
      else if (old_st == WINDOW_MAXIMIZED) {
        if(_resizeable)
          ::SetWindowLong(get_hwnd(), GWL_STYLE, style | WS_THICKFRAME);
      }
    }

    _full_screen = false;

    switch (ws) {
    case WINDOW_MAXIMIZED:
      //::SetWindowLong(get_hwnd(), GWL_STYLE, style & ~WS_THICKFRAME); -- 
      ::ShowWindow(get_hwnd(), SW_SHOWMAXIMIZED);
      check_mouse();
      break;
    case WINDOW_MINIMIZED:
      _collapsing = true;
      on_mouse(html::MOUSE_MOVE, 0, 0, point(-1, -1));
      if (is_layered()) commit_update(true);
      ::ShowWindow(get_hwnd(), SW_SHOWMINIMIZED);
      break;
    case WINDOW_FULL_SCREEN:
      _full_screen = true;
      if (ft == STANDARD || ft == STANDARD_EXTENDED)
        ::SetWindowLong(get_hwnd(), GWL_STYLE, (style & ~WS_OVERLAPPEDWINDOW) | WS_POPUP);
      ::SetWindowLong(get_hwnd(), GWL_EXSTYLE, exStyle | WS_EX_TOPMOST);
      ::ShowWindow(get_hwnd(), SW_SHOWMAXIMIZED);
      break;
    case WINDOW_SHOWN:
      if (_window_controls && old_st == WINDOW_HIDDEN)
        _window_controls->setup(this, this->get_frame_type());
      if (old_st == WINDOW_MAXIMIZED || old_st == WINDOW_FULL_SCREEN)
        ::ShowWindow(get_hwnd(), SW_RESTORE);
      else
        ::ShowWindow(get_hwnd(), SW_SHOWNORMAL);
      break;
    case WINDOW_HIDDEN: 
      ::ShowWindow(get_hwnd(), SW_HIDE); 
      break;
    }
    return true;
  }

  ustring window::get_window_title() const {
    if (get_hwnd()) {
      wchar buf[1024] = {0};
      ::GetWindowTextW(get_hwnd(), buf, 1024);
      return buf;
    }
    return ustring();
  }

  bool window::set_window_title(const wchar *title) {
    if (get_hwnd()) {
      ::SetWindowTextW(get_hwnd(), title);
      return true;
    }
    return false;
  }

  bool window::show() {
    if (::IsWindow(get_hwnd())) {
      ShowWindow(get_hwnd(), SW_SHOWNORMAL);
      UpdateWindow(get_hwnd());
      return true;
    }
    return false;
  }

  bool window::do_event(html::DO_EVENT_MANNER m, bool &result) {
    if (!::IsWindow(get_hwnd()) /*|| !::IsWindowVisible(get_hwnd()) - this condition has to be ruled out on script 
                                level by testing `view.state != View.WINDOW_HIDDEN` */)
      return false;

    if (!doc()) return false;

    if (dismissing) return false;

    if (super::do_event(m, result))
      return true;

    MSG msg;

    result = true;

    switch (m) {
    case html::DO_EVENT_WAIT:
      if (::GetMessage(&msg, NULL, 0, 0)) {
        if (!::CallMsgFilter(&msg, 0)) {
          if (!translate_message(msg)) ::TranslateMessage(&msg);
          ::DispatchMessage(&msg);
        }
        return true;
      }
      ::PostQuitMessage((int)msg.wParam);
      return false;
    case html::DO_EVENT_NOWAIT:
      if (::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
        if (msg.message == WM_QUIT) {
          ::PostQuitMessage((int)msg.wParam);
          return false;
        }
        if (!::CallMsgFilter(&msg, 0)) {
          if (!translate_message(msg)) ::TranslateMessage(&msg);
          ::DispatchMessage(&msg);
        }
        return true;
      }
      ::Sleep(1);
      return true;

    case html::DO_EVENT_ALL:
      while (::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
        if (msg.message == WM_QUIT) {
          ::PostQuitMessage((int)msg.wParam);
          return false;
        }
        if (::CallMsgFilter(&msg, 0)) continue;

        if (!translate_message(msg)) TranslateMessage(&msg);
        ::DispatchMessage(&msg);
      }
      ::Sleep(1);
      return true;

    case html::DO_EVENT_UNTIL_MOUSE_UP: {
      // if( !mouse_capture_element )
      //  this->set_capture(doc());

      helement capture = mouse_capture_element;

      ::SetCapture(this->get_hwnd());

      for (;;) {
        if (::GetMessage(&msg, NULL, 0, 0)) {
          /*          WRONG:  if( msg.message == WM_MOUSEMOVE )
                      {
                        point pt = msg.pt;
                        map_client_point(get_hwnd(), pt);
                        on_mouse(html::MOUSE_MOVE,html::MAIN_BUTTON,get_alts(),pt);
                        this->_last_known_point = pt;
                      }*/

          if (::CallMsgFilter(&msg, 0)) continue;

          if (!translate_message(msg)) ::TranslateMessage(&msg);

          ::DispatchMessage(&msg);

          if (msg.message == WM_LBUTTONUP) {
            ::SetCapture(NULL);
            return true;
          }

          if (msg.message == WM_KEYDOWN && msg.wParam == VK_ESCAPE) {
            ::SetCapture(NULL);
            result = false;
            return true;
          }

          if (GetAsyncKeyState(VK_LBUTTON) >= 0) {
            ::SetCapture(NULL);
            return true;
          }

          if (capture && ((capture != mouse_capture_element) ||
                          (capture->pview() != this))) {
            ::SetCapture(NULL);
            result = false;
            return true;
          }

        } else {
          ::SetCapture(NULL);
          ::PostQuitMessage((int)msg.wParam);
          return false;
        }
      }
    } break;

    case DO_EVENT_ONLY_IO: 
      return exec_idle();
  }

    return false;
  }

  bool window::translate_message(MSG &msg) { return false; }

  bool window::add_animation(element *b, animation *ba, const style *new_style,
                             const style *old_style) {
    if (!get_hwnd()) return false;
    if (_collapsing) return false;
    if (!super::add_animation(b, ba, new_style, old_style)) return false;
    return true;
  }

  static VOID CALLBACK animation_frame_timer_proc(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
  {
    KillTimer(hwnd, idEvent);
    window *pw = window::ptr<window>(hwnd);
    if (pw) {
      pw->_animation_timer = NULL;
      pw->on_animation_tick();
    }
  }
    
  bool window::request_animation_frame(uint delay) 
  {
    if (!GetUpdateRect(get_hwnd(), NULL, FALSE) && !_animation_timer && !is_painting)
      _animation_timer = ::SetTimer(get_hwnd(), ANIMATION_FRAME_TIMER_ID, USER_TIMER_MINIMUM, &animation_frame_timer_proc);
    return true;
  }

  void window::stop_animation_frames() {
  }


  void window::set_capture(element *b) {
    if (!_non_client_mouse) {
      if (b)
        ::SetCapture(get_hwnd());
      else if (GetCapture() == get_hwnd())
        ::ReleaseCapture();
      view::set_capture(b);
    }
  }

  static tool::thread_context<HHOOK> tlhook;

  LRESULT CALLBACK window::hook_proc(int code, WPARAM wParam, LPARAM lParam) {
    MSG *pMsg = (MSG *)lParam;
    if (wParam == PM_REMOVE) {
      if (tlhook.get()) {
        critical_section _(all_guard);
        for (index_t n = all.size() - 1; n >= 0; --n) {
          window *pw = all(n).ptr_of<window>();
          if (popup::translate_event(pw, *pMsg)) return TRUE;
        }
      }
    }
    return ::CallNextHookEx(NULL, code, wParam, lParam);
  }

  void window::setup_hook() {
    tlhook.get([]() {
      return ::SetWindowsHookExW(WH_GETMESSAGE, hook_proc, NULL, GetCurrentThreadId());
    });
  }

  void window::release_hook() {
    HHOOK hook = tlhook.get();
    if (hook && (all.size() == 0)) {
      ::UnhookWindowsHookEx(hook);
      tlhook.set(NULL);
    }
  }

  bool window::is_active() const {
    HWND hWndActive = GetActiveWindow();
    if (get_hwnd() == hWndActive) return true;
    return IsChild(hWndActive, get_hwnd()) != FALSE;
    // return false;
  }

  void window::enable_ime(bool on) {
    if (on && focus_element) {
      rect rc = focus_element->content_box(*this, element::TO_VIEW);
      ime_ctx.EnableIME(get_hwnd(), rc, true);
      // ImmAssociateContext(hWnd,himc_suppressed);
      // himc_suppressed = 0;
    } else {
      ime_ctx.DisableIME(get_hwnd());
      // himc_suppressed = ImmGetContext(hWnd);
      // if(!himc_suppressed)
      //  return;
      // ImmAssociateContext(hWnd,0);
      // ImmReleaseContext(hWnd,himc_suppressed);
    }
  }

  size window::screen_dim() {
    size device_size;
    RECT rc;
    if (SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0)) {
      device_size.x = rc.right - rc.left;
      device_size.y = rc.bottom - rc.top;
    }
    return device_size;
  }

  void window::replace_windowed() {
    if (windows.size() == 0) return;

    int i;

    UINT flags = SWP_NOACTIVATE | SWP_NOOWNERZORDER | SWP_NOZORDER /*| SWP_FRAMECHANGED*/;

    HDWP hdwp = BeginDeferWindowPos((int)windows.size());
    uint cnt = 0, popups = 0;

    HWND phwnd = get_hwnd();

    for (i = 0; i < windows.size(); ++i) {
      auto     biw = windows[i];
      helement b   = biw->root();
      if (!b || !b->pview())
        continue;

      if (!biw->is_child())
      {
        ++popups;
        continue;
      }

      rect     rc = b->content_box(*this, element::TO_VIEW);
      element *pw = b->get_windowed_container(*this);
      if (pw && pw != this->doc()) rc -= pw->view_pos(*this);

      bool visible = b->is_visible(*this);
      bool w_visible = (::GetWindowLong(biw->get_hwnd(), GWL_STYLE) & WS_VISIBLE) != 0;

      UINT f = flags;

      if (visible != w_visible) {
        if (visible)
          f |= SWP_SHOWWINDOW;
        else {
          f |= SWP_HIDEWINDOW;
        }
      } else {
        RECT wrc;
        ::GetWindowRect(HWND(biw->get_hwnd()), &wrc);
        ::MapWindowPoints(HWND_DESKTOP, get_hwnd(), (LPPOINT)&wrc, 2);
        if (rc.left() == wrc.left && rc.top() == wrc.top &&
            (wrc.right - wrc.left) == rc.width() &&
            (wrc.bottom - wrc.top) == rc.height())
          continue;
        // rc
      }
      DeferWindowPos(hdwp, biw->get_hwnd(), phwnd, rc.left(), rc.top(),
                     rc.width(), rc.height(), f);
      phwnd = biw->get_hwnd();
      ++cnt;
    }
    EndDeferWindowPos(hdwp);

    // need this pass to update popup windows (that are not children)

    if (popups) {
      HDWP hdwp = BeginDeferWindowPos((int)windows.size());
      for (i = 0; i < windows.size(); i++) {
        auto     biw = windows[i];
        helement b   = biw->root();
        if (!b) 
          continue;
        if (biw->is_child() || !b->is_visible(*this))
          continue;

        if (!b->is_layout_valid())
          measure_out_of_flow(*this, b);

        rect rc = b->outline_box(*this, element::TO_SCREEN);

        rect rcw;
        ::GetWindowRect(biw->get_hwnd(), PRECT(rcw));
        
        if ((rc != rcw) && !rc.empty()) {
          rect trc = rc;
#ifdef DEBUG
          dbg_printf("replace popup %d %d %d %d\n", trc.left(), trc.top(), trc.width(), trc.height());
#endif
          DeferWindowPos(hdwp, biw->get_hwnd(), 0, rc.left(), rc.top(),
                         rc.width(), rc.height(), flags);
          ++cnt;
        }
        //WRONG, will show popup when owner is hidden (FCC)
        //if(!::IsWindowVisible(biw->get_hwnd()))
        //  ::ShowWindow(biw->get_hwnd(), SW_SHOWNOACTIVATE); // must be SW_SHOWNOACTIVATE here, see: https://sciter.com/forums/topic/tow-windows-z-order-issue/
      }
      EndDeferWindowPos(hdwp);
    }

    // if (cnt && !is_painting) update(); - we do this in view::on_size()
  }

  static HWINDOW get_nearest_hwnd(view& v, element *el) {
    iwindow *pw = el->get_window(v, true);
    if (pw) return pw->get_hwnd();
    return v.get_hwnd();
  };

#ifdef USE_UIAUTOMATION
  void raise_automation_event(window *pw, EVENTID event_id) {
    HRESULT hr = S_FALSE;

    if (_UiaHostProviderFromHwnd && _UiaClientsAreListening && _UiaClientsAreListening()())
      do {
        if (!event_id) break;

        com::asset<IRawElementProviderSimple> provider_ptr;
        hr = _UiaHostProviderFromHwnd()(pw->get_hwnd(), provider_ptr.target());

        if (FAILED(hr)) {
          assert(FALSE && "Failure returned UiaHostProviderFromHwnd");
          break;
        }

        hr = _UiaRaiseAutomationEvent()(provider_ptr, event_id);

        if (FAILED(hr)) {
          assert(FALSE && "Failure returned UiaRaiseAutomationEvent");
          break;
        }
      } while (false);
  }

  void raise_automation_event(window* pw, element* pel, EVENTID event_id) {
    HRESULT hr = S_FALSE;

    if (_UiaHostProviderFromHwnd && _UiaClientsAreListening && _UiaClientsAreListening()())
      do {
        if (!event_id) break;

        HWND hwnd = get_nearest_hwnd(*pw, pel);

        com::asset<accessible_root_provider> root_provider_ptr = accessible_root_provider::make(hwnd, pel->parent);
        if (!root_provider_ptr) {
          assert(FALSE && "accessible_root_provider::make");
          break;
        }

        com::asset<accessible_sciter_provider> provider_ptr = accessible_sciter_provider::make(root_provider_ptr, pel);

        hr = _UiaRaiseAutomationEvent()(provider_ptr, event_id);
               
        if (FAILED(hr)) {
          assert(FALSE && "Failure returned UiaRaiseAutomationEvent");
          break;
        }
        //dbg_printf("UiaRaiseAutomationEvent %d\n", event_id);
      } while (false);
  }


#endif

  bool window::send_behavior_event(event_behavior &evt) {

    if (evt.target) switch (evt.cmd) {
      case html::POPUP_READY:
      case html::POPUP_READY | html::EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_MenuOpenedEventId);
#endif
        if (_is_iaccessible_active) {
          if (evt.target->tag == tag::T_MENU)
            //NotifyWinEvent(EVENT_SYSTEM_MENUPOPUPSTART, get_nearest_hwnd(*this,evt.target), OBJID_CLIENT, evt.target->uid);
            notify_win_event(EVENT_SYSTEM_MENUPOPUPSTART, evt.target);
          else
            //NotifyWinEvent(EVENT_OBJECT_SHOW, get_hwnd(), OBJID_CLIENT, evt.target->uid);
            notify_win_event(EVENT_OBJECT_SHOW, evt.target);
        }
        break;

      case html::POPUP_DISMISSED:
      case html::POPUP_DISMISSED | EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_MenuClosedEventId);
#endif
        if (_is_iaccessible_active) {
          if (evt.target->tag == tag::T_MENU)
            //NotifyWinEvent(EVENT_SYSTEM_MENUPOPUPEND,   get_nearest_hwnd(*this, evt.target), OBJID_CLIENT, evt.target->uid);
            notify_win_event(EVENT_SYSTEM_MENUPOPUPEND, evt.target);
          else
            //NotifyWinEvent(EVENT_OBJECT_HIDE, get_hwnd(), OBJID_CLIENT, evt.target->uid);
            notify_win_event(EVENT_OBJECT_HIDE, evt.target);
        }
        break;

      case html::MENU_ITEM_ACTIVE:
      case html::MENU_ITEM_ACTIVE | EVENT_HANDLED:
        if (_is_iaccessible_active) {
          //NotifyWinEvent(EVENT_OBJECT_FOCUS, get_hwnd(), OBJID_CLIENT, evt.target->uid); 
          notify_win_event(EVENT_OBJECT_FOCUS, evt.target);
        }
        break;

      case html::CHANGE:
      case html::EDIT_VALUE_CHANGED:
      case html::EDIT_VALUE_CHANGED | EVENT_HANDLED:
        if (_is_iaccessible_active) {
#ifdef DEBUG
          evt.target->dbg_report("EVENT_OBJECT_VALUECHANGE a");
#endif
          //NotifyWinEvent(EVENT_OBJECT_VALUECHANGE, get_nearest_hwnd(*this, evt.target), OBJID_CLIENT, evt.target->uid);
          notify_win_event(EVENT_OBJECT_VALUECHANGE, evt.target);
        }
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_Text_TextChangedEventId);
#endif
        break;

      case html::BUTTON_STATE_CHANGED:
      case html::BUTTON_STATE_CHANGED | EVENT_HANDLED:
      case html::SELECT_SELECTION_CHANGED:
      case html::SELECT_SELECTION_CHANGED | EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active) raise_automation_event(this, UIA_Selection_InvalidatedEventId);
#endif

        if (_is_iaccessible_active) {
#ifdef DEBUG
          evt.target->dbg_report("EVENT_OBJECT_STATECHANGE b");
#endif
          //NotifyWinEvent(EVENT_OBJECT_STATECHANGE, get_nearest_hwnd(*this, evt.target), OBJID_CLIENT, evt.target->uid);
          notify_win_event(EVENT_OBJECT_STATECHANGE, evt.target);
        }
        break;

      case html::SELECT_VALUE_CHANGED:
      case html::SELECT_VALUE_CHANGED | EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_SelectionItem_ElementSelectedEventId);
#endif
        break;
      case html::CONTENT_CHANGED:
      case html::CONTENT_CHANGED | EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_StructureChangedEventId);
#endif
        break;

      case html::ARIA_LIVE_AREA_CHANGED:
      case html::ARIA_LIVE_AREA_CHANGED | EVENT_HANDLED:

        if (_is_iaccessible_active) {
          if (auto al = evt.target->get_a11y_live(*this))
            //NotifyWinEvent(EVENT_OBJECT_LIVEREGIONCHANGED, get_nearest_hwnd(*this, evt.target), OBJID_CLIENT, evt.target->uid);
            notify_win_event(EVENT_OBJECT_LIVEREGIONCHANGED, evt.target);
        }
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, evt.target, UIA_LiveRegionChangedEventId);
          //raise_automation_event(this, UIA_LiveRegionChangedEventId);
#endif
        break;

      case html::DOCUMENT_COMPLETE:
      case html::DOCUMENT_COMPLETE | EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_AsyncContentLoadedEventId);
#endif
        break;

        /*      case html::CONTENT_CHANGED:
              case html::CONTENT_CHANGED | EVENT_HANDLED:
        #ifdef USE_UIAUTOMATION
                if( _is_uiautomation_active && _UiaClientsAreListening &&
        _UiaClientsAreListening()())
                   raise_automation_event(this,UIA_Text_TextChangedEventId);
        #endif
                break; */

      case html::ELEMENT_COLLAPSED:
      case html::ELEMENT_COLLAPSED | EVENT_HANDLED:
      case html::ELEMENT_EXPANDED:
      case html::ELEMENT_EXPANDED | EVENT_HANDLED:
#ifdef USE_UIAUTOMATION
        if (_is_uiautomation_active)
          raise_automation_event(this, UIA_LayoutInvalidatedEventId);
#endif
        break;
      }
    return super::send_behavior_event(evt);
  }

  void window::on_focus_changed(element *b, bool got) {
#if defined(USE_UIAUTOMATION)
    if (UIA_AutomationFocusChangedEventId)
      raise_automation_event(this, UIA_AutomationFocusChangedEventId);
#endif

    if (_is_iaccessible_active && got && b) {
      notify_win_event(EVENT_OBJECT_FOCUS, b);
      //NotifyWinEvent(EVENT_OBJECT_FOCUS, get_hwnd(), OBJID_CLIENT, b->uid);
    }
  }

  void window::on_current_changed(element *b) {
#if defined(USE_UIAUTOMATION)
    if (UIA_AutomationFocusChangedEventId)
      raise_automation_event(this, UIA_AutomationFocusChangedEventId);
#endif
    if (_is_iaccessible_active && b) {
      notify_win_event(EVENT_OBJECT_FOCUS, b);
    }
  }

  //CURRENT_ELEMENT_CHANGED

  void window::init_media_vars() {
    super::init_media_vars();
    // media_variables _media_vars;

    gool::size min_w_size(0, 0);
    gool::size max_w_size(GetSystemMetrics(SM_CXFULLSCREEN),
                          GetSystemMetrics(SM_CYFULLSCREEN));
    gool::size w_size      = max_w_size;
    gool::size device_size = max_w_size;

    uint bits_per_pixel = 0;
    uint num_colors     = 0;

    gool::size dpi = pixels_per_inch();
    gool::size dpcm;

    bool high_contrast   = false;
    bool has_pen         = false;
    bool has_mouse       = false;
    bool has_mouse_wheel = false;
    bool has_horizontal_mouse_wheel =
        false; // GetSystemMetrics(SM_MOUSEHORIZONTALWHEELPRESENT) != 0;
    bool screen_reader = false;
    bool slow_machine  = false;

    has_pen         = GetSystemMetrics(SM_PENWINDOWS) != 0;
    has_mouse       = GetSystemMetrics(SM_MOUSEPRESENT) != 0;
    has_mouse_wheel = GetSystemMetrics(SM_MOUSEWHEELPRESENT) != 0;
    slow_machine    = GetSystemMetrics(SM_SLOWMACHINE) != 0;

    bool has_touch_screen   = false;
    bool has_touch_external = false;
    bool has_pen_screen     = false;
    bool has_pen_external   = false;
    bool has_multi_touch    = false;

    {
      int value          = GetSystemMetrics(SM_DIGITIZER);
      has_touch_screen   = (value & NID_INTEGRATED_TOUCH) != 0;
      has_touch_external = (value & NID_EXTERNAL_TOUCH) != 0;
      has_pen_screen     = (value & NID_INTEGRATED_PEN) != 0;
      has_pen_external   = (value & NID_EXTERNAL_PEN) != 0;
      has_multi_touch    = (value & NID_MULTI_INPUT) != 0;
    }

    {
      RECT rc;
      if (SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0)) {
        device_size.x = rc.right - rc.left;
        device_size.y = rc.bottom - rc.top;
      }
#if DEVICE == DESKTOP
      HIGHCONTRAST hci;
      memset(&hci, 0, sizeof(hci));
      hci.cbSize = sizeof(hci);
      if (SystemParametersInfo(SPI_GETHIGHCONTRAST, 0, &hci, 0))
        high_contrast = (hci.dwFlags & HCF_HIGHCONTRASTON) != 0;

      BOOL bv = FALSE;
      if (SystemParametersInfo(SPI_GETSCREENREADER, 0, &bv, 0))
        screen_reader = bv != 0;
#endif
    }

    {
      HDC hDC        = GetDC(0);
      bits_per_pixel = GetDeviceCaps(hDC, BITSPIXEL);
      if (GetDeviceCaps(hDC, RASTERCAPS) & RC_PALETTE)
        num_colors = GetDeviceCaps(hDC, COLORRES);
      else {
        uint64 nc  = uint64(1) << bits_per_pixel;
        num_colors = nc > 0xFFFFFFFF ? 0xFFFFFFFF : int(nc);
      }
      // dpi.x = GetDeviceCaps(hDC, LOGPIXELSX);
      // dpi.y = GetDeviceCaps(hDC, LOGPIXELSY);

      size physical_screen_mm(GetDeviceCaps(hDC, HORZSIZE),
                              GetDeviceCaps(hDC, VERTSIZE));

      if (physical_screen_mm.x && physical_screen_mm.y) {
        dpcm.x = (GetDeviceCaps(hDC, HORZRES) * 10) / physical_screen_mm.x;
        dpcm.y = (GetDeviceCaps(hDC, VERTRES) * 10) / physical_screen_mm.y;
      } else {
        dpcm.x = (dpi.x * 254) / 100;
        dpcm.y = (dpi.y * 254) / 100;
      }
      ReleaseDC(0, hDC);
    }

    if (get_hwnd()) {
      gool::rect wrc;
      GetClientRect(get_hwnd(), PRECT(wrc));
      if(!wrc.empty())
        w_size = wrc.size();
      /*rect mwrc;
        AdjustWindowRectEx(
        PRECT(mwrc),
        GetWindowLong(get_hwnd(),GWL_STYLE),
        FALSE,
        GetWindowLong(get_hwnd(),GWL_EXSTYLE));*/
      //
    }
    _media_vars["width"]  = tool::value::make_length(w_size.x, tool::value::px);
    _media_vars["height"] = tool::value::make_length(w_size.y, tool::value::px);
    _media_vars["min-width"] =
        tool::value::make_length(min_w_size.x, tool::value::px);
    _media_vars["min-height"] =
        tool::value::make_length(min_w_size.y, tool::value::px);
    _media_vars["max-width"] =
        tool::value::make_length(max_w_size.x, tool::value::px);
    _media_vars["max-height"] =
        tool::value::make_length(max_w_size.y, tool::value::px);
    _media_vars["aspect-ratio"] =
        w_size.empty() ? tool::value(1.0) : tool::value(double(w_size.x) / double(w_size.y));

    _media_vars["monitors"] = tool::value(GetSystemMetrics(SM_CMONITORS));
    _media_vars["device-width"] =
        tool::value::make_length(device_size.x, tool::value::px);
    _media_vars["device-height"] =
        tool::value::make_length(device_size.y, tool::value::px);
    _media_vars["device-aspect-ratio"] =
        tool::value(double(device_size.x) / double(device_size.y));

    _media_vars["orientation-portrait"]  = device_size.y > device_size.x;
    _media_vars["orientation-landscape"] = device_size.y < device_size.x;
    _media_vars["color"]                 = int(bits_per_pixel);
    _media_vars["color-index"]           = int(num_colors);

    _media_vars["supports-filters"]  = app->supports_filters();
    _media_vars["supports-printing"] = app->supports_printing();

    // monochrome ???

    if (dpi.x == dpi.y) // dots per inch
    {
      _media_vars["resolution"]     = dpi.x;
      _media_vars["physical-resolution"] = physical_dpi.x.val(1);
      _media_vars["min-resolution"] = dpi.x;
      _media_vars["max-resolution"] = dpi.x;
    } else {
      // A ‘resolution’ (without a "min-" or "max-" prefix) query never matches
      // a device with non-square pixels.
      _media_vars["min-resolution"] = min(dpi.x, dpi.y);
      _media_vars["max-resolution"] = max(dpi.x, dpi.y);
    }

    if (dpcm.x == dpcm.y) // dots per sentimeter
    {
      _media_vars["resolution-dpcm"]     = dpcm.x;
      _media_vars["min-resolution-dpcm"] = dpcm.x;
      _media_vars["max-resolution-dpcm"] = dpcm.x;
    } else {
      // A ‘resolution’ (without a "min-" or "max-" prefix) query never matches
      // a device with non-square pixels.
      _media_vars["min-resolution-dpcm"] = min(dpcm.x, dpcm.y);
      _media_vars["max-resolution-dpcm"] = max(dpcm.x, dpcm.y);
    }

    _media_vars["high-contrast"]   = high_contrast;
    _media_vars["contrast-screen"] = high_contrast; // Symantec's var.

    _media_vars["has-pen"]                    = has_pen;
    _media_vars["has-mouse"]                  = has_mouse;
    _media_vars["has-mouse-wheel"]            = has_mouse_wheel;
    _media_vars["has-horizontal-mouse-wheel"] = has_horizontal_mouse_wheel;

    _media_vars["has-touch-screen"]   = has_touch_screen;
    _media_vars["has-touch-external"] = has_touch_external;
    _media_vars["has-pen-screen"]     = has_pen_screen;
    _media_vars["has-pen-external"]   = has_pen_external;
    _media_vars["has-multi-touch"]    = has_multi_touch;

    _media_vars["screen-reader"] = screen_reader;
    _media_vars["slow-machine"]  = slow_machine;

    _media_vars["engine"]               = ustring(L"sciter");
    _media_vars["engine-version-minor"] = (int)module_version(false);
    _media_vars["engine-version-major"] = (int)module_version(true);

    static uint ver[4] = {SCITER_VERSION};

    _media_vars["sciter"] = value(ver[0]);

    _media_vars["os"]       = ustring(tool::environment::get_os_version_name());
    _media_vars["platform"] = ustring("Windows");

    BOOL isDWM = _IsCompositionActive ? _IsCompositionActive()() : FALSE;
    _media_vars["composition-supported"] = tool::value(isDWM != FALSE);

#if defined(WINDOWS) && defined(THEMES_SUPPORT)
    if (theme::current()) {
      if (theme::current()->is_ux_theme()) {
        _media_vars["ux-themes"] = value(true);
        _media_vars["old-themes"] =
            environment::get_os_version() < environment::WIN_VISTA;
        _media_vars["new-themes"] =
            environment::get_os_version() >= environment::WIN_VISTA;
      } else {
        _media_vars["ux-themes"]  = value(false);
        _media_vars["old-themes"] = value(false);
        _media_vars["new-themes"] = value(false);
      }
    }
#endif
    _media_vars["graphics-layer"] = tool::value(graphics_caps());
    if (tool::environment::get_os_version() < tool::environment::WIN_10) {
      _media_vars["ui-blurbehind"] = false;
      _media_vars["ui-ambience"] = ustring("light");
    }
    else {
      _media_vars["ui-blurbehind"] = !!isDWM;
      gool::argb wc = GetSysColor(COLOR_WINDOW);
      _media_vars["ui-ambience"] = wc.luminance() < 128 ? ustring("dark") : ustring("light");

      static mswin::registry::key bb_params = mswin::registry::key::open(HKEY_CURRENT_USER, W("Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize"));
      if (bb_params.is_valid())
      {
        uint32 dw_enable_transparency = bb_params.get(W("EnableTransparency"), uint32(-1));
        if (dw_enable_transparency != uint32(-1))
          _media_vars["ui-blurbehind"] = !!dw_enable_transparency;

        uint32 dw_use_light_theme = bb_params.get(W("AppsUseLightTheme"), uint32(-1));
        if (dw_use_light_theme != uint32(-1))
          _media_vars["ui-ambience"] = dw_use_light_theme ? ustring("light") : ustring("dark");
      }
    }

#ifdef _DEBUG
    auto mv = _media_vars["os-vendor"];
    assert(mv.is_defined());
#endif

  }

  struct window_list {
    // struct wd { HWND hwnd; bool enabled; };
    array<HWND> list;
    HWND        except;

    window_list(HWND exceptThat) : except(exceptThat) {
      EnumThreadWindows(::GetCurrentThreadId(), eproc, LPARAM(this));
    }
    
    static bool is_owned_by(HWND wnd, HWND other) {

      html::view* pr = html::view::ptr<html::view>(wnd);
      html::view* ph = html::view::ptr<html::view>(other);
      if (!ph)
        return false; // this is not a sciter window

      while (pr) {
        if (pr->is_detached())
          return false;
        if (pr == ph) 
          return true;
        pr = pr->parent();
      }
      return false;
    }
    
    static BOOL CALLBACK eproc(HWND hwnd, LPARAM lParam) {
      UINT ws = GetWindowStyle(hwnd);
      if ((ws & WS_CHILD) != 0) return TRUE;
      if ((ws & WS_VISIBLE) == 0) return TRUE;
      if ((ws & WS_DISABLED) != 0) return TRUE;
      if (ws & WS_POPUP) {
        RECT rc = {0};
        GetClientRect(hwnd, &rc);
        if (IsRectEmpty(&rc)) return TRUE;
      }

      window_list *self = reinterpret_cast<window_list *>(lParam);
      if (hwnd != self->except) {
        if(is_owned_by(self->except, hwnd))
          self->list.push(hwnd);
      }
      return TRUE;
    }
  };

  bool window::show_modal() {
    if (!::IsWindow(get_hwnd())) return false;

    RECT rc;
    GetWindowRect(get_hwnd(),&rc);
    if ((rc.right - rc.left) <= 0 || (rc.bottom - rc.top) <= 0)
    {
      debug_printf(html::OT_DOM, html::OS_ERROR, "dialog window of zero size");
      return false;
    }

    ::ShowWindow(get_hwnd(), SW_SHOWNORMAL); 

    HWND frm = ::GetWindow(get_hwnd(), GW_OWNER);
    ::UpdateWindow(frm);

    update();                        // \\  
    SetForegroundWindow(get_hwnd()); // // this has to be here to fix layered windows z-index.

    window_list wl(get_hwnd());

    for (int n = 0; n < wl.list.size(); ++n) {
      // if(wl.list[n].enabled)
      ::EnableWindow(wl.list[n], FALSE);
    }
        
    MSG msg;
    while (::IsWindow(get_hwnd()) && ::IsWindowVisible(get_hwnd())) {
      if (0 == ::GetMessage(&msg, NULL, 0, 0)) {
        ::EnableWindow(frm, TRUE);
        ::PostQuitMessage(int(msg.wParam));
        break;
      }
      if (::CallMsgFilter(&msg, 0)) continue;
      ::TranslateMessage(&msg);
      ::DispatchMessage(&msg);
    }

    for (int n = 0; n < wl.list.size(); ++n) {
      // if(wl.list[n].enabled)
      ::EnableWindow(wl.list[n], TRUE);
    }

#if defined(SCITER)
    return dialog_retval != NOTHING_VALUE;
#elif defined(SCITERJS)
    return dialog_retval.is_defined();
#endif
  }

  handle<gool::image> load_image(view *pv, string url) {

    handle<gool::image>   out;
    handle<pump::request> prq = new pump::request(url, DATA_IMAGE);
    prq->add([url, pv, &out](request *rq) -> bool {
      out = image::create(rq->data, url, pv->doc());
      return true;
    });
    load_data(prq, pv, true);
    return out;
  }

  void make_hole(gool::bitmap *drag_image, point hotspot, int radii) {
    size  sz = drag_image->dim();
    point pt;
    for (pt.y = 0; pt.y < sz.y; ++pt.y) {
      auto row = drag_image->target_row(pt.y);
      for (pt.x = 0; pt.x < sz.x; ++pt.x) {
        int dist = distance(pt, hotspot);
        if (dist > radii) continue;
        argb c          = row.start[pt.x].demultiply();
        int  t          = (dist * 255) / radii;
        c.alfa          = byte((c.alfa * t) >> 8);
        row.start[pt.x] = c.premultiply();
      }
    }
  }

  void window::create_drag_cursors(gool::bitmap *drag_image, point &offset,
                                   handle<gool::bitmap> &move,
                                   handle<gool::bitmap> &copy,
                                   handle<gool::bitmap> &none) {
    static HICON hcursor = ::LoadCursor(NULL, IDC_ARROW);

    handle<image> overlay;

    // switch( formode ) {
    //  case dd_move: break;
    //  case dd_copy: overlay = load_image(this,"sciter:icon-copy-sign.png");
    //  break; case dd_none: overlay =
    //  load_image(this,"sciter:icon-none-sign.png"); break;
    //}
    if (!hcursor)
      return super::create_drag_cursors(drag_image, offset, move, copy, none);

    point cur_offset;

    handle<bitmap> cur = icon::make_bitmap_from_ico_handle(hcursor, cur_offset);
    if (!cur)
      return super::create_drag_cursors(drag_image, offset, move, copy, none);

    rect drag_rc(-offset, drag_image->dim());
    rect cur_rc(-cur_offset, cur->dim());

    rect over_rc;
    if (overlay) {
      over_rc        = cur_rc;
      over_rc.s = cur_rc.pointOf(5);
    }

    rect dst_rc = drag_rc | cur_rc | over_rc;

    // point hotspot_on_image = cur_rc.s - drag_rc.s + cur_offset;
    // make_hole(drag_image,hotspot_on_image, this->pixels_per_dip(size(48)).x
    // );

    // drag_image

    for (int n = 0; n < 3; ++n) {

      switch (n) {
      case 0: break;
      case 1: overlay = load_image(this, "sciter:icon-copy-sign.png"); break;
      case 2: overlay = load_image(this, "sciter:icon-none-sign.png"); break;
      }

      handle<bitmap> pout = new bitmap(dst_rc.size(), true, false);
      {
        handle<graphics> sfi =
            app->create_bitmap_bits_graphics(pout, argb(0, 0, 0, 0));
        if (sfi) {
          sfi->draw(drag_image, drag_rc.s - dst_rc.s, 96);
          sfi->draw(cur, cur_rc.s - dst_rc.s);
          if (overlay) sfi->draw(overlay, cur_rc.pointOf(5) - dst_rc.s);
        }
      }
      pout->demultiply();

      switch (n) {
      case 0: move = pout; break;
      case 1: copy = pout; break;
      case 2: none = pout; break;
      }
    }
    offset = cur_rc.s - dst_rc.s + cur_offset;
  }

  bool window::request_attention(WRA_MODE wm) {
    FLASHWINFO fwi = { 0 };
    fwi.cbSize = sizeof(fwi);
    fwi.hwnd = get_hwnd();
    switch (wm) {
      case WRA_MODE::WRA_STOP: fwi.dwFlags = FLASHW_STOP; break;
      case WRA_MODE::WRA_ATTENTION: fwi.dwFlags = FLASHW_TRAY | FLASHW_TIMER; fwi.uCount = 1000; break;
      case WRA_MODE::WRA_ATTENTION_CRITICAL: fwi.dwFlags = FLASHW_ALL | FLASHW_TIMER; fwi.uCount = 1000; break;
    }
    return ::FlashWindowEx(&fwi);
  }

  bool window::trayicon_setup(const tray_icon_params& params) {
    NOTIFYICONDATA nid;
    memzero(nid);
    nid.cbSize = sizeof(nid);
    nid.hWnd = get_hwnd();
    nid.uID = 0;
    nid.uCallbackMessage = WM_TRAY_CALLBACK;
    nid.uFlags = NIF_MESSAGE;

    if (params.img.is_defined()) {
      hbitmap hbm = params.img->get_bitmap(nullptr, size(64, 64));
      nid.hIcon = hbm->create_win_icon();
      nid.uFlags |= NIF_ICON;
      if(trayicon_icon)
        DeleteObject(trayicon_icon);
      trayicon_icon = nid.hIcon;
    }
    if (params.tooltip.is_defined()) {
      target(nid.szTip).copy(params.tooltip());
      nid.uFlags |= NIF_TIP;
    }
    if(trayicon_is_set)
      Shell_NotifyIcon(NIM_MODIFY, &nid);
    else 
      Shell_NotifyIcon(NIM_ADD, &nid);
    trayicon_is_set = TRUE;
    return true;
  }

  bool window::trayicon_remove() {
    if (!trayicon_is_set)
      return true;
    NOTIFYICONDATA nid;
    memzero(nid);
    nid.cbSize = sizeof(nid);
    nid.hWnd = get_hwnd();
    nid.uID = 0;
    Shell_NotifyIcon(NIM_DELETE, &nid);
    trayicon_is_set = FALSE;
    if (trayicon_icon)
      DeleteObject(trayicon_icon);
    return true;
  }

  bool window::trayicon_place(rect& orc)
  {
    if (!_Shell_NotifyIconGetRect)
      return false;
    NOTIFYICONIDENTIFIER nid;
    memzero(nid);
    nid.cbSize = sizeof(nid);
    nid.hWnd = get_hwnd();
    nid.uID = 0;
    nid.guidItem = GUID_NULL;
    RECT rc;
    _Shell_NotifyIconGetRect()(&nid, &rc);
    orc = fromRECT(rc);
    return true;
  }

  LRESULT window::trayicon_message(WPARAM wp, LPARAM lp, BOOL& handled)
  {
    POINT p;
    GetCursorPos(&p);

    switch (lp) {
      //case WM_LBUTTONDOWN: handled = trayicon_notify(point(p), 1, html::MOUSE_DOWN); return 0;
      //case WM_RBUTTONDOWN: handled = trayicon_notify(point(p), 2, html::MOUSE_DOWN); return 0;
      case WM_LBUTTONUP: handled = trayicon_notify(point(p),1, html::MOUSE_CLICK); return 0;
      case WM_RBUTTONUP: handled = trayicon_notify(point(p),2, html::MOUSE_CLICK); return 0;
      //case WM_MOUSEMOVE: handled = trayicon_notify(point(p), 0, html::MOUSE_MOVE); return 0;
    }
    handled = FALSE;
    return 0;
  }
  
  

} // namespace mswin

namespace html {

  void iwindow::set_layered(bool onoff) {
#ifdef NATIVE_WINDOWS_BACKEND 
    auto exstyle = ::GetWindowLong(get_hwnd(), GWL_EXSTYLE);
    if (onoff)
      ::SetWindowLong(get_hwnd(), GWL_EXSTYLE, exstyle | WS_EX_LAYERED);
    else
      ::SetWindowLong(get_hwnd(), GWL_EXSTYLE, exstyle & ~WS_EX_LAYERED);
#endif
    _is_layered = onoff;
  }

  bool iwindow::set_topmost(bool on) {
    LONG exstyles = GetWindowLong(get_hwnd(), GWL_EXSTYLE);
    if (on) {
      ::SetWindowLong(get_hwnd(), GWL_EXSTYLE, exstyles | WS_EX_TOPMOST);
      ::SetWindowPos(get_hwnd(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
    } else {
      ::SetWindowLong(get_hwnd(), GWL_EXSTYLE, exstyles & ~WS_EX_TOPMOST);
      ::SetWindowPos(get_hwnd(), HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
    }
    return true;
  }
  bool iwindow::get_topmost() {
    LONG exstyles = GetWindowLong(get_hwnd(), GWL_EXSTYLE);
    return (exstyles & WS_EX_TOPMOST) != 0;
  }
    

  rect iwindow::screen_workarea(rect rc) const {
    gool::rect mr;
    SystemParametersInfo(SPI_GETWORKAREA, 0, PRECT(mr), 0);
    mr.e--;

    HMONITOR    hmon;
    MONITORINFO minf;

    if (rc.empty())
      hmon = MonitorFromWindow(get_hwnd(), MONITOR_DEFAULTTONEAREST);
    else {
      // RECT r = toRECT(rc);
      // hmon = MonitorFromRect(&r, MONITOR_DEFAULTTONEAREST);
      POINT pt = toPOINT(rc.pointOf(5));
      hmon     = MonitorFromPoint(pt, MONITOR_DEFAULTTONEAREST);
    }
    if (hmon) {
      minf.cbSize = sizeof(minf);
      GetMonitorInfo(hmon, &minf);
      mr = fromRECT(minf.rcMonitor);
    }
    return mr;
  }

  EVENT_SOURCE get_current_event_source() 
  {
    if (_GetCurrentInputMessageSource) {
      INPUT_MESSAGE_SOURCE ims = {};
      if (_GetCurrentInputMessageSource()(&ims))
        return (EVENT_SOURCE)ims.deviceType;
    }
    return ES_UNAVAILABLE;
  }

} // namespace html

HWND engine_controlled_hwnd() {
  auto win = html::view::last<mswin::window>();
  return win ? win->get_hwnd() : NULL;
}

#if defined(SCITERJS)
  #include "master-css-resources-js.cpp"
#else
  #include "master-css-resources.cpp"
#endif

tool::bytes get_resource(const wchar *path) {
  critical_section _(html::lock);
  static tool::sar ctx(tool::items_of(master_css_resources));
  tool::bytes      r = ctx.get(path);
  // assert(r.length);
  return r;
}

/*tool::bytes get_app_resource( const wchar* res_id, const wchar* res_type_id)
{
        HRSRC hrsrc = 0;
  if( (wcscmp(L"htm",res_type_id) == 0)
      || (wcscmp(L"html",res_type_id) == 0))
    hrsrc = ::FindResource(HINST_THISCOMPONENT, res_id, RT_HTML);
  else
          hrsrc = ::FindResource(HINST_THISCOMPONENT, res_id, res_type_id);

  if (!hrsrc) { assert(false); return tool::bytes(); }

        // Load specified resource and check if ok

        HGLOBAL hgres = ::LoadResource(HINST_THISCOMPONENT, hrsrc);
  if (!hgres) { assert(false); return tool::bytes(); }

        // Retrieve resource data and check if ok

  tool::bytes r;

        r.start = (byte*)::LockResource(hgres); if (!r.start) return r;
  r.length = ::SizeofResource(HINST_THISCOMPONENT, hrsrc);
  return r;
}
*/
std::pair<tool::bytes, tool::ustring> get_stock_style_resource() {
  tool::ustring u;
#if !defined(WINDOWLESS) && !defined(SCITERJS)
  if (html::use_platform_theming)
    u = WTEXT("win-master.css");
  else
#endif
    u = WTEXT("ux-master.css");
  tool::bytes r = get_resource(u);
  assert(r.length);
  return std::pair<tool::bytes, tool::ustring>(r, u);
}
