#ifndef __win_version_h__
#define __win_version_h__

#include <windows.h>

#if _WIN32_WINNT >= 0x0603
#include <VersionHelpers.h>
#ifndef _WIN32_WINNT_WIN10
#define _WIN32_WINNT_WIN10 0x0A00
VERSIONHELPERAPI
IsWindows10OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WIN10),
                                   LOBYTE(_WIN32_WINNT_WIN10), 0);
}
#endif
#else

#define _WIN32_WINNT_WIN8 0x0602
#define _WIN32_WINNT_WINBLUE 0x0603
#define _WIN32_WINNT_WIN10 0x0A00

#define VERSIONHELPERAPI inline bool

// typedef NTSTATUS( NTAPI* fnRtlGetVersion )(PRTL_OSVERSIONINFOW
// lpVersionInformation);

VERSIONHELPERAPI
IsWindowsVersionOrGreater(WORD wMajorVersion, WORD wMinorVersion,
                          WORD wServicePackMajor) {
  OSVERSIONINFOEXW osvi             = {sizeof(osvi), 0, 0, 0, 0, {0}, 0, 0};
  DWORDLONG const  dwlConditionMask = VerSetConditionMask(
      VerSetConditionMask(
          VerSetConditionMask(0, VER_MAJORVERSION, VER_GREATER_EQUAL),
          VER_MINORVERSION, VER_GREATER_EQUAL),
      VER_SERVICEPACKMAJOR, VER_GREATER_EQUAL);

  osvi.dwMajorVersion    = wMajorVersion;
  osvi.dwMinorVersion    = wMinorVersion;
  osvi.wServicePackMajor = wServicePackMajor;

  return VerifyVersionInfoW(
             &osvi, VER_MAJORVERSION | VER_MINORVERSION | VER_SERVICEPACKMAJOR,
             dwlConditionMask) != FALSE;

  /*    RTL_OSVERSIONINFOEXW verInfo = { 0 };
      verInfo.dwOSVersionInfoSize = sizeof( verInfo );
   

      static auto RtlGetVersion = (fnRtlGetVersion)GetProcAddress(
   GetModuleHandleW( L"ntdll.dll" ), "RtlGetVersion" );
   

      if (RtlGetVersion != 0 && RtlGetVersion( (PRTL_OSVERSIONINFOW)&verInfo )
   == 0)
      {
          if (verInfo.dwMajorVersion > wMajorVersion)
              return true;
          else if (verInfo.dwMajorVersion < wMajorVersion)
              return false;
   

          if (verInfo.dwMinorVersion > wMinorVersion)
              return true;
          else if (verInfo.dwMinorVersion < wMinorVersion)
              return false;
   

          if (verInfo.wServicePackMajor >= wServicePackMajor)
              return true;
      }
   

      return false; */
}

VERSIONHELPERAPI
IsWindowsXPOrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WINXP),
                                   LOBYTE(_WIN32_WINNT_WINXP), 0);
}

VERSIONHELPERAPI
IsWindowsXPSP1OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WINXP),
                                   LOBYTE(_WIN32_WINNT_WINXP), 1);
}

VERSIONHELPERAPI
IsWindowsXPSP2OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WINXP),
                                   LOBYTE(_WIN32_WINNT_WINXP), 2);
}

VERSIONHELPERAPI
IsWindowsXPSP3OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WINXP),
                                   LOBYTE(_WIN32_WINNT_WINXP), 3);
}

VERSIONHELPERAPI
IsWindowsVistaOrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_VISTA),
                                   LOBYTE(_WIN32_WINNT_VISTA), 0);
}

VERSIONHELPERAPI
IsWindowsVistaSP1OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_VISTA),
                                   LOBYTE(_WIN32_WINNT_VISTA), 1);
}

VERSIONHELPERAPI
IsWindowsVistaSP2OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_VISTA),
                                   LOBYTE(_WIN32_WINNT_VISTA), 2);
}

VERSIONHELPERAPI
IsWindows7OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WIN7),
                                   LOBYTE(_WIN32_WINNT_WIN7), 0);
}

VERSIONHELPERAPI
IsWindows7SP1OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WIN7),
                                   LOBYTE(_WIN32_WINNT_WIN7), 1);
}

VERSIONHELPERAPI
IsWindows8OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WIN8),
                                   LOBYTE(_WIN32_WINNT_WIN8), 0);
}

VERSIONHELPERAPI
IsWindows8Point1OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WINBLUE),
                                   LOBYTE(_WIN32_WINNT_WINBLUE), 0);
}

VERSIONHELPERAPI
IsWindows10OrGreater() {
  return IsWindowsVersionOrGreater(HIBYTE(_WIN32_WINNT_WIN10),
                                   LOBYTE(_WIN32_WINNT_WIN10), 0);
}

VERSIONHELPERAPI
IsWindowsServer() {
  OSVERSIONINFOEXW osvi = {sizeof(osvi), 0, 0, 0, 0,
                           {0},          0, 0, 0, VER_NT_WORKSTATION};
  DWORDLONG const  dwlConditionMask =
      VerSetConditionMask(0, VER_PRODUCT_TYPE, VER_EQUAL);

  return !VerifyVersionInfoW(&osvi, VER_PRODUCT_TYPE, dwlConditionMask);
}
#endif

#endif