#include "win.h"

#include "gool/gool-theme.h"
#include "win-ux-themes.h"

#ifdef THEMES_SUPPORT

namespace mswin {

  namespace themes {

    // XP Themes
    static BOOL themed           = FALSE;
    static BOOL theme_lib_loaded = FALSE;

    static HMODULE hModThemes = NULL;

    HTHEME hThemes[gool::THEME_GROUPS_SIZE] = {0};

    bool init(bool update) {
      tool::critical_section _(gool::theme::lock());
      if (update && theme_lib_loaded) {
        return theme_lib_loaded = update_current();
      }
      if (tool::environment::get_os_version() < tool::environment::WIN_XP)
        return false;
      theme_lib_loaded = update_current();
      return theme_lib_loaded != FALSE;
    }

    void shutdown() {
      tool::critical_section _(gool::theme::lock());
      for (int n = 0; n < items_in(hThemes); ++n)
        if (hThemes[n]) {
          CloseThemeData(hThemes[n]);
          hThemes[n] = NULL;
        }
    }

    bool update_current() {
      tool::critical_section _(gool::theme::lock());
      for (int n = 0; n < items_in(hThemes); ++n)
        if (hThemes[n]) {
          CloseThemeData(hThemes[n]);
          hThemes[n] = NULL;
        }

      LPCWSTR names[items_in(hThemes)] = {
          L"Button",  L"Edit",   L"Scrollbar", L"Treeview", L"Combobox",
          L"Tab",     L"Spin",   L"Progress",  L"Trackbar", L"Rebar",
          L"Toolbar", L"Header", L"Tooltip",   L"Listview"};

      int n;
      for (n = 0; n < items_in(names) - 1; ++n) {
        hThemes[n] = OpenThemeData(NULL, names[n]);
        //assert(hThemes[n]);
        if (!hThemes[n]) return false;
      }
      hThemes[n] = 0; // Listview will be initialized later
      return true;
    }

  } // namespace themes
} // namespace mswin

#endif