//|
//|
//| Copyright (c) 2001-2010
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| UXTHEME support
//|

#include "win.h"

#ifdef THEMES_SUPPORT

#include <uxtheme.h>
#include "win-ux-themes.h"

//#include "gool/gool-part-names-ph.h"

//#if !defined(PLATFORM_WINCE) && !defined(EMULATE_WINCE)
#include "win-theme-xp.h"
#include "win-theme-95.h"
//#else
//  #include "gool_theme_ce.h"
//#endif

namespace gool {
  // static himage  images[ TOTAL_KEYWORDS ];

  theme *theme::current(CURRENT_OP op) {

    critical_section cs(gool::lock);

    static handle<theme> _current;

    switch (op) {
    case PEEK: return _current;
    case CURRENT:
      if (_current) return _current;
      break;
    case RESET:
      if (_current == 0)
        break;
      else {
        if (mswin::themes::init(true)) {
          if (!_current->is_ux_theme()) _current = new theme_XP();
        } else {
          if (!_current->is_classic_theme()) _current = new theme_95();
        }
        return _current;
      }
    case DESTROY: _current = 0; return 0;
    }

    if (mswin::themes::init(true))
      _current = new theme_XP();
    else
      _current = new theme_95();
    return _current;
  }

  // metrics
  int theme::scrollbar_width() { return GetSystemMetrics(SM_CXVSCROLL); }
  int theme::scrollbar_height() { return GetSystemMetrics(SM_CYHSCROLL); }
  int theme::small_icon_width() { return GetSystemMetrics(SM_CXSMICON) + GetSystemMetrics(SM_CXEDGE) * 2; }
  int theme::small_icon_height() { return GetSystemMetrics(SM_CYSMICON) + GetSystemMetrics(SM_CYEDGE) * 2; }
  int theme::border_width() { return 1; }
  int theme::border_3d_width() { return 2; }

  /*  image* theme::get_image(chars name)
      {
        image* pi = get_image(get_image_id(name));
        if(pi && (pi->get_url().length() == 0))
          pi->set_url(string("theme:") + name);
        return pi;
      }


    uint theme::get_image_id(chars name)
      {
  #ifdef _DEBUG
        if(name == CHARS("tooltip-standard"))
          name = name;
  #endif
        part_def *pd = part_names::find_def(name.start,name.size());
        if( !pd )
        {
          assert(0);
          return 0;
        }
        return uint(pd - theme_part_defs) + 1;
      }
  */
} // namespace gool

#endif