//|
//|
//| Copyright (c) 2001-2010
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| UXTHEME support
//|

#include "win.h"

#ifdef THEMES_SUPPORT

#include <uxtheme.h>
#include "win-ux-themes.h"

#include "win-theme-xp.h"
#include "win-delayload.h"
#include "gool/gool-part-names-ph.h"

// extern tool::bytes get_resource( LPCTSTR res_id, LPCTSTR res_type_id);

#if defined(BufferedPaintMakeOpaque)

DLOADV(_BufferedPaintInit, BufferedPaintInit, uxtheme.dll, HRESULT(WINAPI *)());
DLOADV(_BufferedPaintUnInit, BufferedPaintUnInit, uxtheme.dll,
       HRESULT(WINAPI *)());
DLOADV(_BeginBufferedPaint, BeginBufferedPaint, uxtheme.dll,
       HPAINTBUFFER(WINAPI *)(HDC hdcTarget, const RECT *prcTarget,
                              BP_BUFFERFORMAT dwFormat,
                              __in_opt BP_PAINTPARAMS *pPaintParams,
                              __out HDC *phdc));
DLOADV(_GetBufferedPaintBits, GetBufferedPaintBits, uxtheme.dll,
       HRESULT(WINAPI *)(HPAINTBUFFER hBufferedPaint, __out RGBQUAD **ppbBuffer,
                         __out int *pcxRow));
DLOADV(_EndBufferedPaint, EndBufferedPaint, uxtheme.dll,
       HRESULT(WINAPI *)(HPAINTBUFFER hBufferedPaint, BOOL fUpdateTarget));
#endif

namespace gool {

  theme_XP::theme_XP() {
    themes::update_current();
    images.size(TOTAL_KEYWORDS);
#if defined(BufferedPaintMakeOpaque)
    if (_BufferedPaintInit) _BufferedPaintInit()();
#endif
  }

  theme_XP::~theme_XP() {
#if defined(BufferedPaintMakeOpaque)
    if (_BufferedPaintUnInit) _BufferedPaintUnInit()();
#endif
  }

  image *theme_XP::get_image_impl(uint id) {
    if (!id || id > TOTAL_KEYWORDS) return 0;
    --id;
    if (images[id].is_null()) images[id] = new theme_image_XP(id + 1);
    return images[id];
  }

  void render(theme_image_XP *pimg, graphics *sf, rect dst, rect src) {
    /*
        part_def& pd = theme_part_defs[pimg->image_id - 1];
        //if(sf.push_clip(dst))

        if( pd.nClass == THEME_GROUP_TRACKBAR )
        {
          if( pd.nPart == TKP_TRACK )
          {
            size sz = dimension(pd);
            --sz;
            dst.s.y += (dst.height() - sz.y) / 2;
            dst.e.y = dst.s.y + sz.y - 1;

            part_def tpd;
            tpd.nClass = THEME_GROUP_TRACKBAR;
            tpd.nPart = TKP_THUMB;
            tpd.nState = 0;
            size tsz = dimension(tpd);

            dst.s.x += tsz.x / 2;
            dst.e.x -= tsz.x / 2;
          }
          else if( pd.nPart == TKP_TRACKVERT )
          {
            size sz = dimension(pd);
            --sz;
            dst.s.x += (dst.width() - sz.x) / 2;
            dst.e.x = dst.s.x + sz.x - 1;

            part_def tpd;
            tpd.nClass = THEME_GROUP_TRACKBAR;
            tpd.nPart = TKP_THUMBVERT;
            tpd.nState = 0;
            size tsz = dimension(tpd);

            dst.s.y += tsz.y / 2;
            dst.e.y -= tsz.y / 2;
          }
        }
        do_draw_theme_background(sf, pd.nClass, pd.nPart, pd.nState, dst,
       false);
        //sf.pop_clip();
    */
  }

  bool is_expandable(const theme_image_XP *pimg, SECTION_DEFS &sd) {
    part_def pd = theme_part_defs[pimg->image_id - 1];
    if (pd.margin == 0 || pd.stretch_mode == SHAPE_NOT_EXPANDABLE) return false;
    sd.margins.s = sd.margins.e = gool::point(pd.margin, pd.margin);
    sd.center                             = SRM_STRETCH;
    switch (pd.stretch_mode) {
    case SHAPE_HORIZONTAL: // stretch vertically but tile horizontally
      sd.top    = SRM_TILE;
      sd.bottom = SRM_TILE;
      sd.left   = SRM_STRETCH;
      sd.right  = SRM_STRETCH;
      break;
    case SHAPE_VERTICAL: // stretch horizontally but tile vertically
      sd.top    = SRM_STRETCH;
      sd.bottom = SRM_STRETCH;
      sd.left   = SRM_TILE;
      sd.right  = SRM_TILE;
      break;
    case SHAPE_EXPAND: // tile horizontally and vertically
      sd.top    = SRM_TILE;
      sd.bottom = SRM_TILE;
      sd.left   = SRM_TILE;
      sd.right  = SRM_TILE;
      sd.center = SRM_TILE;
      break;
    case SHAPE_STRETCH_BOTH: // stretch horizontally and vertically
      sd.top    = SRM_STRETCH;
      sd.bottom = SRM_STRETCH;
      sd.left   = SRM_STRETCH;
      sd.right  = SRM_STRETCH;
      break;
    }
    return true;
  }

  bitmap *load_res_expandable_bitmap(const wchar *       name,
                                     const SECTION_DEFS &sd) {
    tool::bytes   data = app()->get_resource(name);
    handle<image> aimg = gool::image::create(data, name);
    if (!aimg || !aimg->is_bitmap()) return 0;
    expandable_bitmap *peb =
        new expandable_bitmap(aimg->dim(), true, false, sd);
    if (!peb) return 0;
    peb->_pixels.transfer_from(aimg.ptr_of<gool::bitmap>()->_pixels);
    return peb;
  }

  bitmap *make_bitmap(graphics *sf, theme_image_XP *pimg, size dim) {
    tool::critical_section _1(gool::theme::lock());
    auto_state<bool>       _2(theme::processing, true);

    const part_def &pd = theme_part_defs[pimg->image_id - 1];

#ifdef _DEBUG
    if (pd.nClass == THEME_GROUP_EDIT && pd.nPart == EP_BACKGROUNDWITHBORDER)
      dim = dim;
#endif // _DEBUG

    if (pd.nClass == THEME_GROUP_TOOLBAR && pd.nPart == TP_BUTTON) {
      if (pd.nState == 1)
        return 0; // toolbar button has no bitmap in normal state.
      else if (environment::get_os_version() < environment::WIN_VISTA) {

        SECTION_DEFS sd;
        // bool is_image_expandable = is_expandable(pimg,sd);

        switch (pd.nState) {
        case 2:
          return load_res_expandable_bitmap(L"toolbar-button-hover.png", sd);
        case 3:
          return load_res_expandable_bitmap(L"toolbar-button-pressed.png", sd);
        case 4:
          return load_res_expandable_bitmap(L"toolbar-button-disabled.png", sd);
        case 5:
          return load_res_expandable_bitmap(L"toolbar-button-checked.png", sd);
        case 6:
          return load_res_expandable_bitmap(L"toolbar-button-checked-hover.png",
                                            sd);
        }
      }
    } else if (pd.nClass == THEME_GROUP_LISTVIEW && pd.nPart == LVP_LISTITEM &&
               environment::get_os_version() < environment::WIN_VISTA) {

      SECTION_DEFS sd;
      // bool is_image_expandable = is_expandable(pimg,sd);

      switch (pd.nState) {
      case 0:
      case 1: return nullptr;
      case 2:
        return load_res_expandable_bitmap(L"list-view-item-hover.png", sd);
      case 3:
        return load_res_expandable_bitmap(L"list-view-item-selected.png", sd);
      case 4:
        return nullptr; // return
                        // load_res_expandable_bitmap(L"list-view-item-disabled.png",sd);
      case 5:
        return load_res_expandable_bitmap(
            L"list-view-item-selected-not-focus.png", sd);
      case 6:
        return load_res_expandable_bitmap(L"list-view-item-selected-hover.png",
                                          sd);
      }
    }

    rect rc = rect(dim);

#ifdef _DEBUG
    if (pd.nClass == THEME_GROUP_HEADER) rc = rc;
#endif

#if defined(BufferedPaintMakeOpaque)
    RECT r = toRECT(rc);
#endif

    HTHEME hTheme = hThemes[pd.nClass];
    HWND   ehwnd  = engine_controlled_hwnd();

    if (!hTheme && pd.nClass == THEME_GROUP_LISTVIEW &&
        pd.nPart == LVP_LISTITEM) {
      SetWindowTheme(ehwnd, L"Explorer", NULL);
      hTheme = OpenThemeData(ehwnd, L"Listview");
      assert(hTheme);
      hThemes[THEME_GROUP_LISTVIEW] = hTheme;
    }

    SECTION_DEFS sd;
    bool         is_image_expandable = is_expandable(pimg, sd);
    bool         has_alpha           = !!IsThemeBackgroundPartiallyTransparent(
        hThemes[pd.nClass], pd.nPart, pd.nState);

    if (pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNK) {
      // PROGRESS bug workaround
      is_image_expandable = false;
    } else if (pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNKVERT) {
      is_image_expandable = false;
    }
#if defined(BufferedPaintMakeOpaque)
    else if (pd.nClass == THEME_GROUP_HEADER && !_BeginBufferedPaint)
      has_alpha = false;
#else
    else if (pd.nClass == THEME_GROUP_HEADER)
      has_alpha = false;
#endif

      // rc = rc;
#if defined(BufferedPaintMakeOpaque)
    if (_BeginBufferedPaint) // WV,W7,...
    {

      HDC hdcBuffer = 0;

      BP_PAINTPARAMS paintParams = {0};
      paintParams.cbSize         = sizeof(paintParams);
      paintParams.dwFlags = BPPF_ERASE | BPPF_NOCLIP; //  | BPPF_NONCLIENT

      HDC          hdc = GetDC(0);
      HPAINTBUFFER hpb = _BeginBufferedPaint()(hdc, &r, BPBF_COMPOSITED,
                                               &paintParams, &hdcBuffer);
      ReleaseDC(0, hdc);
      if (!hpb) return 0;
      // BufferedPaintSetAlpha(hpb,NULL,0);

      HRESULT hr =
          DrawThemeBackground(hTheme, hdcBuffer, pd.nPart, pd.nState, &r, &r);
      assert(SUCCEEDED(hr));

      if (FAILED(hr)) return 0;

      RGBQUAD *bits  = 0;
      int      width = 0;
      hr             = _GetBufferedPaintBits()(hpb, &bits, &width);
      assert(SUCCEEDED(hr));
      if (FAILED(hr)) return 0;

      bitmap *bmp = is_image_expandable
                        ? new expandable_bitmap(dim, has_alpha, true, sd)
                        : new bitmap(dim, has_alpha, true);

      RGBQUAD *src = bits;
      for (int rn = 0; rn < dim.y; ++rn) {
        bmp->target_row(rn).copy((const argb *)src);
        src += width;
      }
      if (!has_alpha) bmp->foreach_pixel([](argb &p) { p.alfa = 255; });

      //????? bmp->premultiply();

      _EndBufferedPaint()(hpb, FALSE);

#if 0 && defined(_DEBUG)
      if (pd.nClass == THEME_GROUP_LISTVIEW && pd.nPart == LVP_LISTITEM) {

        SECTION_DEFS sd;
        //bool is_image_expandable = is_expandable(pimg,sd);

        switch (pd.nState) {
        //case 0:
        //case 1: return nullptr;
        //case 2: return load_res_expandable_bitmap(L"list-view-item-hover.png", sd);
        case 3: //return load_res_expandable_bitmap(L"list-view-item-selected.png", sd);
        {
          /*tool::array<byte> data;
          bmp->save(data, image::PNG, 0);
          FILE* f = 0; fopen_s(&f, "D:/temp.png", "wb+");
          if (f) {
            fwrite(data.head(), data.size(), 1, f);
            fclose(f);
          }*/
        }
        //case 4: return nullptr; //return load_res_expandable_bitmap(L"list-view-item-disabled.png",sd);
        //case 5: return load_res_expandable_bitmap(L"list-view-item-selected-not-focus.png", sd);
        //case 6: return load_res_expandable_bitmap(L"list-view-item-selected-hover.png", sd);
        }
      }
#endif

      return bmp;

    } else
#endif
    { // XP
      dib32   buf(dim);
      RECT    r = {0, 0, dim.x, dim.y};
      HRESULT hr =
          DrawThemeBackground(hTheme, buf.DC(), pd.nPart, pd.nState, &r, NULL);
      assert(SUCCEEDED(hr));
      hr          = hr;
      bitmap *bmp = is_image_expandable
                        ? new expandable_bitmap(&buf, has_alpha, sd)
                        : new bitmap(&buf, has_alpha);
      return bmp;
    }
  }

  size dimension(part_def pd) {
    tool::critical_section _1(gool::theme::lock());
    auto_state<bool>       _2(theme::processing, true);

    if (pd.dim.x && pd.dim.y) return pd.dim;

    HTHEME hTheme = hThemes[pd.nClass];
    HWND   ehwnd  = engine_controlled_hwnd();

    if (!hTheme && pd.nClass == THEME_GROUP_LISTVIEW &&
        pd.nPart == LVP_LISTITEM) {
      SetWindowTheme(ehwnd, L"Explorer", NULL);
      hTheme = OpenThemeData(ehwnd, L"Listview");
      assert(hTheme);
      hThemes[THEME_GROUP_LISTVIEW] = hTheme;
    }
    HDC dc = ::GetDC(ehwnd);
    if (pd.nClass == THEME_GROUP_PROGRESS &&
        (pd.nPart == PP_BAR || pd.nPart == PP_BARVERT)) {
      // PROGRESS bug workaround
      pd.dim.x = 14;
      pd.dim.y = 14;
    }

    /*else if(pd.nClass == THEME_GROUP_LISTVIEW && pd.nPart == LVP_LISTITEM )
    {
      pd.dim.x = 14;
      pd.dim.y = 14;
    }*/
    else
      GetThemePartSize(hThemes[pd.nClass], dc, pd.nPart, pd.nState, 0, TS_TRUE,
                       PSIZE(pd.dim));
    ReleaseDC(ehwnd, dc);

    switch (pd.stretch_mode) {
    case SHAPE_NOT_EXPANDABLE: break;
    case SHAPE_HORIZONTAL: pd.dim.x = max(pd.dim.x, 64); break;
    case SHAPE_VERTICAL: pd.dim.y = max(pd.dim.y, 64); break;
    case SHAPE_EXPAND:
      pd.dim.x = max(pd.dim.x, 64);
      pd.dim.y = max(pd.dim.y, 64);
      break;
    case SHAPE_STRETCH_BOTH:
      pd.dim.x = min(pd.dim.x, 64);
      pd.dim.y = min(pd.dim.y, 64);
      break;
    }

    if (pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNK) {
      // PROGRESS bug workaround
      pd.dim.x = 8;
      pd.dim.y = 16;
    } else if (pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNKVERT) {
      // PROGRESS bug workaround
      pd.dim.x = 16;
      pd.dim.y = 8;
    } else if (pd.stretch_mode != SHAPE_NOT_EXPANDABLE) {
      pd.dim.x = max(pd.dim.x, 16);
      pd.dim.y = max(pd.dim.y, 16);
    }

    return pd.dim;
  }

  size dimension(const theme_image_XP *pimg) {
    const part_def &pd = theme_part_defs[pimg->image_id - 1];
    return dimension(pd);
  }

  bool is_transparent(const part_def &pd) {
    if (pd.nClass == THEME_GROUP_TRACKBAR) return true;
    if (pd.nClass == THEME_GROUP_BUTTON) return true;
    if (pd.nClass == THEME_GROUP_SPIN) return true;
    if (pd.nClass == THEME_GROUP_TOOLBAR) return true;
    if (pd.nClass == THEME_GROUP_REBAR) return true;
    if (pd.nClass == THEME_GROUP_TOOLTIP) return true;
    return 0 != IsThemeBackgroundPartiallyTransparent(hThemes[pd.nClass],
                                                      pd.nPart, pd.nState);
  }

  bool is_transparent(const theme_image_XP *pimg) {
    const part_def &pd = theme_part_defs[pimg->image_id - 1];
    return is_transparent(pd);
  }

  void render(theme_image_XP *pimg, graphics *sf, rect dst, rect src,
              byte opacity) {
    SECTION_DEFS sd;
    bitmap *     bmp = pimg->get_bitmap(sf, dst.size());
    if (bmp) {
      if (is_expandable(pimg, sd))
        sf->do_expand(bmp, dst, sd, rect());
      else
        sf->do_draw(bmp, dst, src, opacity);
    }
  }

  void theme_XP::draw_h_scrollbar(gool::graphics *sf, uint pt, uint st,
                                  rect rc) {
    if (rc.empty()) return;
    // uint part = 0;
    // uint uistate = st;

    if (!h_scrollbar[0]) {
      tool::critical_section _(gool::theme::lock());
      // int n = 0;
      h_scrollbar[0] = (theme_image_XP *)get_image(CHARS("h-scrollbar-base"));
      h_scrollbar[1] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-minus-normal"));
      h_scrollbar[2] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-minus-hover"));
      h_scrollbar[3] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-minus-pressed"));
      h_scrollbar[4] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-minus-disabled"));
      h_scrollbar[5] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-plus-normal"));
      h_scrollbar[6] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-plus-hover"));
      h_scrollbar[7] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-plus-pressed"));
      h_scrollbar[8] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-plus-disabled"));
      h_scrollbar[9] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-minus-normal"));
      h_scrollbar[10] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-minus-hover"));
      h_scrollbar[11] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-minus-pressed"));
      h_scrollbar[12] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-minus-disabled"));
      h_scrollbar[13] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-plus-normal"));
      h_scrollbar[14] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-plus-hover"));
      h_scrollbar[15] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-plus-pressed"));
      h_scrollbar[16] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-page-plus-disabled"));
      h_scrollbar[17] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-thumb-normal"));
      h_scrollbar[18] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-thumb-hover"));
      h_scrollbar[19] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-thumb-pressed"));
      h_scrollbar[20] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-thumb-disabled"));
      h_scrollbar[21] = (theme_image_XP *)get_image(
          CHARS("h-scrollbar-thumb-gripper-normal"));
      h_scrollbar[22] =
          (theme_image_XP *)get_image(CHARS("h-scrollbar-thumb-gripper-hover"));
      h_scrollbar[23] = (theme_image_XP *)get_image(
          CHARS("h-scrollbar-thumb-gripper-pressed"));
    }

    himage pimg;
    himage pgripper;
    // RECT r = toRECT(rc);
    switch (pt) {
    case SCROLLBAR_BASE: pimg = h_scrollbar[0]; break;
    case SCROLLBAR_SLIDER:
      pimg     = h_scrollbar[17 + limit(int(st) - 1, 0, 3)];
      pgripper = h_scrollbar[21 + limit(int(st) - 1, 0, 2)];
      break;
    case SCROLLBAR_PAGE_MINUS:
      pimg = h_scrollbar[9 + limit(int(st) - 1, 0, 3)];
      break;
    case SCROLLBAR_PAGE_PLUS:
      pimg = h_scrollbar[13 + limit(int(st) - 1, 0, 3)];
      break;
    case SCROLLBAR_PLUS:
      pimg = h_scrollbar[5 + limit(int(st) - 1, 0, 3)];
      break;
    case SCROLLBAR_MINUS:
      pimg = h_scrollbar[1 + limit(int(st) - 1, 0, 3)];
      break;
    }
    assert(pimg);
    if (pimg) {
      sf->draw(pimg, rc);
      if (pgripper) {
        rect gripper_rc = rect(pgripper->dimension());
        if (gripper_rc.width() * 2 < rc.width()) {
          gripper_rc.pointOf(5, rc.pointOf(5));
          sf->draw(pgripper, gripper_rc);
        }
      }
    }
  }

  void theme_XP::draw_v_scrollbar(gool::graphics *sf, uint pt, uint st,
                                  rect rc) {
    if (rc.empty()) return;
    // uint part = 0;
    // uint uistate = st;

    if (!v_scrollbar[0]) {
      tool::critical_section _(gool::theme::lock());
      v_scrollbar[0] = (theme_image_XP *)get_image(CHARS("v-scrollbar-base"));
      v_scrollbar[1] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-minus-normal"));
      v_scrollbar[2] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-minus-hover"));
      v_scrollbar[3] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-minus-pressed"));
      v_scrollbar[4] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-minus-disabled"));
      v_scrollbar[5] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-plus-normal"));
      v_scrollbar[6] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-plus-hover"));
      v_scrollbar[7] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-plus-pressed"));
      v_scrollbar[8] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-plus-disabled"));
      v_scrollbar[9] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-minus-normal"));
      v_scrollbar[10] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-minus-hover"));
      v_scrollbar[11] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-minus-pressed"));
      v_scrollbar[12] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-minus-disabled"));
      v_scrollbar[13] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-plus-normal"));
      v_scrollbar[14] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-plus-hover"));
      v_scrollbar[15] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-plus-pressed"));
      v_scrollbar[16] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-page-plus-disabled"));
      v_scrollbar[17] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-thumb-normal"));
      v_scrollbar[18] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-thumb-hover"));
      v_scrollbar[19] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-thumb-pressed"));
      v_scrollbar[20] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-thumb-disabled"));
      v_scrollbar[21] = (theme_image_XP *)get_image(
          CHARS("v-scrollbar-thumb-gripper-normal"));
      v_scrollbar[22] =
          (theme_image_XP *)get_image(CHARS("v-scrollbar-thumb-gripper-hover"));
      v_scrollbar[23] = (theme_image_XP *)get_image(
          CHARS("v-scrollbar-thumb-gripper-pressed"));
    }

    himage pimg;
    himage pgripper;
    switch (pt) {
    case SCROLLBAR_BASE: pimg = v_scrollbar[0]; break;
    case SCROLLBAR_SLIDER:
      pimg     = v_scrollbar[17 + limit(int(st) - 1, 0, 3)];
      pgripper = v_scrollbar[21 + limit(int(st) - 1, 0, 2)];
      break;
    case SCROLLBAR_PAGE_MINUS:
      pimg = v_scrollbar[9 + limit(int(st) - 1, 0, 3)];
      break;
    case SCROLLBAR_PAGE_PLUS:
      pimg = v_scrollbar[13 + limit(int(st) - 1, 0, 3)];
      break;
    case SCROLLBAR_PLUS:
      pimg = v_scrollbar[5 + limit(int(st) - 1, 0, 3)];
      break;
    case SCROLLBAR_MINUS:
      pimg = v_scrollbar[1 + limit(int(st) - 1, 0, 3)];
      // dbg_printf("SCROLLBAR_MINUS %d,%d\n", rc.width(), rc.height());
      break;
    case SCROLLBAR_CORNER: {
      argb c = get_current_system_color(SC_DIALOG_SURFACE);
      sf->fill(c, rc);
      return;
    }
    }
    assert(pimg);

    if (pimg) {
      sf->draw(pimg, rc);
      if (pgripper) {
        rect gripper_rc = rect(pgripper->dimension());
        if (gripper_rc.height() * 2 < rc.height()) {
          gripper_rc.pointOf(5, rc.pointOf(5));
          sf->draw(pgripper, gripper_rc);
        }
      }
    }

    // do_draw_theme_background(sf,THEME_GROUP_SCROLLBAR, part, uistate, rc,
    // true);
  }

  handle<bitmap> theme_image_XP::get_bitmap(graphics *sf, size sz) {
    critical_section _(theme::lock());

    if (!theme::current()->is_ux_theme()) {
      theme::current(
          theme::RESET); // the window did not receive WM_THEMECHANGED message.
      return 0;
    }

    // size native_dim = dim();
    SECTION_DEFS sd;
    if (is_expandable(this, sd)) sz = dim();

    int nm = cache.size();
    // dbg_printf("get_bitmap %d:\n",image_id);
    for (int n = 0; n < nm; ++n) {
      bitmap *pbmp = cache[n];
      if (!pbmp) {
        cache.clear();
        return 0;
      }
      if (pbmp->dim() == sz) return pbmp;
      // dbg_printf("get_bitmap %d: %d,%d\n", image_id, pbmp->dim().x,
      // pbmp->dim().y);
    }
    handle<bitmap> pbmp = make_bitmap(sf, this, sz);
    // dbg_printf("get_bitmap %d: miss %d,%d\n", image_id, sz.x, sz.y);
    cache.push_front(pbmp);

    return pbmp;
  }

  void theme_image_XP::draw(graphics *gfx, rect dst, rect src, byte opacity) {
    render(this, gfx, dst, src, opacity);
  }
  void theme_image_XP::draw(graphics *gfx, rectf dst, rect src, byte opacity) {
    render(this, gfx, rect(dst), src, opacity);
  }


  size theme_image_XP::dim() const { return gool::dimension(this); }
  bool theme_image_XP::is_transparent() const {
    return gool::is_transparent(this);
  }

} // namespace gool

#endif