//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| UXTHEME support for non-themed os'es
//|

#pragma once

#include "tool/tool.h"
#include "gool/gool-image.h"
#include "gool/gool-theme.h"
#include "win-ux-themes.h"

namespace gool {

  class theme_image_95;

  class theme_95 : public theme {
    typedef theme super;

  public:
    theme_95() {}

    virtual ~theme_95() {}

    virtual void draw_h_scrollbar(gool::graphics *sf, uint pt, uint st,
                                  rect rc) override;
    virtual void draw_v_scrollbar(gool::graphics *sf, uint pt, uint st,
                                  rect rc) override;

    virtual int border_width() { return 2; }
    virtual int border_3d_width() { return border_width(); }

    virtual bool is_classic_theme() const { return true; } // theme emulation

    virtual image *get_image_impl(uint id);
  };

  class theme_image_95 : public image {
  public:
    uint image_id;

    theme_image_95(uint ni) : image_id(ni) {}
    virtual ~theme_image_95() {}

    virtual handle<bitmap> get_bitmap(graphics *pg, size sz) override { return 0; }

    virtual bool is_valid() const override { return true; }

    virtual void draw(graphics *gfx, rect dst, rect src, byte opacity) override;
    virtual void draw(graphics *gfx, rectf dst, rect src, byte opacity) override;

    virtual size dim(const rect &for_dst) const override { return for_dst.size(); }
    virtual size dim() const override;

    virtual bool is_spacer() { return false; }

    virtual bool is_transparent() const;

    virtual void drop_cache() {}
  };

} // namespace gool
