#include "win.h"

#include <shlobj.h>
#include <shobjidl.h> //For IShellItemImageFactory

DLOADV(_SHCreateItemFromParsingName, SHCreateItemFromParsingName, shell32.dll,
       HRESULT(WINAPI *)(__in PCWSTR pszPath, __in_opt IBindCtx *pbc,
                         __in REFIID riid, __deref_out void **ppv));

namespace mswin {

#if 0 // experiments with this IExcrementImage, a.k.a. IExtractImage     
    HRESULT get_thumbnail(ustring pathname, SIZE size, HBITMAP& thumbnail)
    {
        pathname.replace('/','\\');

        LPITEMIDLIST pid_list = 0;
        DWORD dw_priority = 0;
        DWORD dw_flags = /*IEIFLAG_ASPECT |*/ IEIFLAG_ASYNC | IEIFLAG_QUALITY;
        HRESULT hr = E_NOINTERFACE;
        WCHAR buffer[MAX_PATH];
                
        ustring folder = wchars(pathname).r_head('\\');
        ustring file   = wchars(pathname).r_tail('\\');
                        
        com::asset<IShellFolder>  p_desktop;
        com::asset<IShellFolder>  p_dir;
        com::asset<IExtractImage> p_ei;
        com::asset<IRunnableTask> p_runnable;

        //CoInitialize(NULL);
        do {

          HWND hwnd = GetDesktopWindow();

          hr = SHGetDesktopFolder(p_desktop.target());
          if(!SUCCEEDED(hr))
            break;

          hr = p_desktop->ParseDisplayName(hwnd, NULL, (LPWSTR)folder.c_str(), NULL, &pid_list, NULL);
          if(!SUCCEEDED(hr)) 
            break;
                
          hr = p_desktop->BindToObject(pid_list, NULL, IID_IShellFolder, (void **)p_dir.target());
          if(!SUCCEEDED(hr)) 
            break;
                
          hr = p_dir->ParseDisplayName(hwnd, NULL, (LPWSTR)file.c_str(), NULL, &pid_list, NULL);
          if(!SUCCEEDED(hr))
            break;
                
          LPCITEMIDLIST pcid_list = pid_list;
          hr = p_dir->GetUIObjectOf(hwnd, 1, &pcid_list, IID_IExtractImage, NULL, (void **)p_ei.target());
          if(!SUCCEEDED(hr)) 
            break;
                
          hr = p_ei->GetLocation(buffer, MAX_PATH, &dw_priority, &size, 32, &dw_flags);

          if( SUCCEEDED(hr) )
          {
EXTRACT:
            hr = p_ei->Extract(&thumbnail);
            return hr;
          }
          else if(hr == E_PENDING) 
          {
            do {
              Sleep(20);
              hr = p_ei->GetLocation(buffer, MAX_PATH, &dw_priority, &size, 32, &dw_flags);
              if(SUCCEEDED(hr))
                goto EXTRACT;

            } while(hr == E_PENDING);

/*
            hr = p_ei->QueryInterface<IRunnableTask>(p_runnable.target());
            if(FAILED(hr))
              break;
          
            for(uint n = 0; n < 100; ++n, Sleep(20))
            {
              LONG rs = p_runnable->IsRunning();
              switch(rs)
              {
                case IRTIR_TASK_NOT_RUNNING:
                  if( n == 0 )
                    p_runnable->Run();
                  continue;
                case IRTIR_TASK_RUNNING:
                  continue;
                case IRTIR_TASK_SUSPENDED:
                  if( n == 0 && FAILED(p_runnable->Resume()))
                      break;
                  continue;
                case IRTIR_TASK_PENDING:
                  break;
                case IRTIR_TASK_FINISHED:
                  goto EXTRACT;
              }
              break;
            }
            */

           //CoUninitialize();
          } else
           hr = hr;

        } while(false);

        if(pid_list)
          CoTaskMemFree(pid_list);

        return hr;
    }
#endif
  
  static bool load_file_thumbnail(const ustring &path, uint n_size,
                                  handle<html::bitmap> &bmp,
                                  bool                  from_cache_only) {
    ustring ospath = path;
    ospath.replace_all('/', '\\');

    UINT flags = 0; // SIIGBF_BIGGERSIZEOK/* | SIIGBF_THUMBNAILONLY*/;

    OleInitialize(NULL);

    if (n_size == 0) {
      n_size = GetSystemMetrics(SM_CXSMICON);
      flags  = SIIGBF_ICONONLY;
    }

    if (!_SHCreateItemFromParsingName) {
      bmp = 0;
      return true;
    }

    com::asset<IShellItemImageFactory> pImageFactory;
    HRESULT                            hr = _SHCreateItemFromParsingName()(
        ospath, NULL, IID_PPV_ARGS(pImageFactory.target()));
    if (SUCCEEDED(hr)) {
      SIZE    size = {int(n_size), int(n_size)};
      HBITMAP hbmp = 0;
      //-------------- if(from_cache_only) flags |= SIIGBF_INCACHEONLY; //---
      //THIS DOES NOT WORK RELIABLY ON W7
      hr = pImageFactory->GetImage(size, flags, &hbmp);
      if (SUCCEEDED(hr) && hbmp) {
        bmp = new gool::bitmap(hbmp);
        // bmp = 0;
        DeleteObject(hbmp);
        return true;
      }
    } else {
      bmp = 0;
      return true; // error
    }
    return false; // need pumping
#if 0 
    // IExtractImage
    SIZE size = { n_size, n_size };

    HBITMAP hbmp = 0;
    HRESULT hr = get_thumbnail(path, size, hbmp);
    if( SUCCEEDED(hr) && hbmp )
    {
      bmp = new gool::bitmap(hbmp);
      DeleteObject(hbmp);
    }
    else 
      bmp = 0;
    return true;
#endif
  }

#if 0
    struct shell_image_task: public tool::task
    {
       handle<html::pump::request> hrq;
       html::view* pv;
       
       shell_image_task(html::pump::request* prq,html::view* pview):hrq(prq),pv(pview) {}

       virtual void exec() 
       {
         if(!load_file_thumbnail(hrq,false))
           hrq->data.clear();
         locked::inc(hrq->ready);
         pv->data_arrived(hrq);
       }
       virtual void stop() {}

    };
#endif

  struct shell_image_task : public tool::async::task {

    typedef tool::async::task super;

    handle<load_file_thumbnail_callback> _cb;
    ustring                              _path;
    uint                                 _size;

        shell_image_task(const ustring &path, uint size,
                     load_file_thumbnail_callback *pcb)
        : _cb(pcb), _path(path), _size(size) {}

    virtual void exec() {
      handle<gool::bitmap> bmp;
      load_file_thumbnail(_path, _size, bmp, false);
      _cb->on_thumbnail_created(bmp);
    }
    virtual void stop() { super::stop(); }
  };
}

/*bool load_file_thumbnail(html::pump::request* prq,html::view* pv)
{
  if(mswin::load_file_thumbnail(prq, true))
    return true; // delivered
  static mswin::shell_image_pump pump;
  pump.add_task(new mswin::shell_image_task(prq,pv));
  return false; // will be delivered later
}*/

bool load_file_thumbnail(const ustring &path, uint size,
                         load_file_thumbnail_callback *pcb) {
  auto pt = new mswin::shell_image_task(path, size, pcb);
  pt->start();
  return false; // will be delivered later
}
