#include "win.h"

#include "win/win-callback.h"
#include "api/api-defs.h"

#ifdef WINDOWLESS

  #include "api/window-api.cpp"
  #include "api/dom-api.cpp"
  #include "api/api-iface.cpp"

#else 

#include "d2d/d2d.h"

using namespace tool;

LPCWSTR SCAPI SciterClassName_api(void)
{
  if(html::app()->is_valid())
    return CHILD_CLASS_NAME;
  return 0;
}

LRESULT SCAPI SciterProc_api(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  return mswin::window::window_proc(hwnd, msg, wParam, lParam);
}

LRESULT SCAPI SciterProcND_api(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam, SBOOL* pbHandled)
{
  if (pbHandled)
    return mswin::window::proc(hwnd, msg, wParam, lParam, *pbHandled);
  return 0;
}

extern uint module_version(bool major);
UINT  SCAPI SciterVersion_api(SBOOL major)
{
  return module_version(major != FALSE);
}

SBOOL SCAPI SciterProcX_api(HWINDOW hwnd, SCITER_X_MSG* pMsg)
{
  return mswin::window::proc_x(hwnd, pMsg);
}


VOID SCAPI SciterSetupDebugOutput_api(HWND hwndOrNull,
          LPVOID                param,    // param to be passed "as is" to the pfOutput
          DEBUG_OUTPUT_PROC     pfOutput  // output function, output stream alike thing.
          )
{
  if(hwndOrNull)
  {
    handle<mswin::window> pview = html::view::ptr<mswin::window>(hwndOrNull);
    if(pview)
    {
      if( pfOutput )
        pview->set_native_debug_output(new window_debug_output(pfOutput,param));
      else
        pview->set_native_debug_output(nullptr);
      return;
    }
  }
  setup_debug_output(param, pfOutput);
}

SBOOL SCAPI SciterTranslateMessage_api(MSG* lpMsg)
{
  // does nothing now, functionality moved to the hook for desktop
  // windows mobile has not got hooks, so use it
#ifdef PLATFORM_WINCE
  for( int n = all().size() - 1; n >= 0; --n )
  {
    html::h_layout_view pv = all()(n);
    if(popup::translate_event(pv, *lpMsg) || wtool::translate_event(pv, *lpMsg))
      return TRUE;
  }
#endif
  return FALSE;
}

SBOOL SCAPI     SciterRenderD2D_api(HWND hWndSciter, IUnknown* /*ID2D1RenderTarget**/ prt )
{
  handle<mswin::window> pview = html::view::ptr<mswin::window>(hWndSciter);
  if(!pview || !prt)
    return FALSE;

  com::asset<IUnknown> unk = prt;
  com::asset<ID2D1RenderTarget> rt;
  if (FAILED(unk.QueryInterface(rt)))
    return FALSE;

  handle<d2d::ext_graphics> pgx = new d2d::ext_graphics(rt);
  if( !pgx )
    return FALSE;
  
  return pview->render_on(pgx)? TRUE:FALSE;
}

SBOOL SCAPI     SciterD2DFactory_api(IUnknown** /*ID2D1Factory ** */ ppf)
{
  if(!ppf || *ppf != 0)
    return FALSE;
  ID2D1Factory *t = d2d::d2_factory();
  if (t) {
    t->AddRef();
    *ppf = t;
  }
  return TRUE;
}

SBOOL SCAPI     SciterDWFactory_api(IUnknown** /*IDWriteFactory ** */ ppf)
{
  if(!ppf || *ppf != 0)
    return FALSE;
  IDWriteFactory* t = d2d::dw_factory();
  if (t) {
    t->AddRef();
    *ppf = t;
  }
  return TRUE;
}

#define get_pview( hwnd ) handle<mswin::window> pview = html::view::ptr<mswin::window>(hwnd)

VOID SCAPI     SciterSetCallback_api(HWINDOW hwnd, LPSciterHostCallback cb, LPVOID cbParam)
{
  get_pview(hwnd);
  if(!pview)
    return ;
  critical_section cs(pview->guard);

  window_callback* pcb = new window_callback();

  pcb->_p_callback = cb;
  pcb->_p_callback_param = cbParam;
  pcb->_hwnd = pview->get_hwnd();
  pview->set_callback(pcb);
}

LPVOID SCAPI SciterGetCallbackParam_api(HWINDOW hwnd)
{
  get_pview(hwnd);
  if(!pview)
    return nullptr;
  critical_section cs(pview->guard);

  window_callback* pcb = (window_callback*)pview->get_callback();
  if(pcb)
    return pcb->_p_callback_param;
  return nullptr;
}

SBOOL SCAPI SciterCreateOnDirectXWindow_api (HWINDOW hwnd, IUnknown* pIDXGISwapChain) // IDXGISwapChain* pSwapChain
{
  window_params params;
  params.window_type = FRAME_WINDOW;
  params.parent = NULL;
  params.rtl = (GetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_LAYOUTRTL) != FALSE;
  params.owns_vm = FALSE;

  com::asset<IDXGISwapChain> pSwapChain;

  pIDXGISwapChain->QueryInterface(pSwapChain.target());

  if(!pSwapChain) 
    return false;

  try {
    handle<mswin::window> pw = mswin::app()->create_dx_window_processor(params,pSwapChain);
    if(!pw) return FALSE;
    //mswin::window::attach(pw,hwnd);
    pw->set_hwnd(hwnd);
    //pw->attached(nullptr);
    pw->reset_resolution();
    return TRUE;
  } catch (std::bad_alloc&) {
    return FALSE;
  }
}

extern html::element*   element_ptr( HELEMENT he );

SBOOL SCAPI SciterRenderOnDirectXWindow_api (HWINDOW hwnd, HELEMENT elementToRenderOrNull, SBOOL frontLayer)
{
  handle<mswin::window> pw = html::view::ptr<mswin::window>(hwnd);
  if( !pw )
    return FALSE;
  if( elementToRenderOrNull ) {
    html::element *b = element_ptr(elementToRenderOrNull);
    if(b->pview() != pw)
      return FALSE;
    return pw->render_element(b, frontLayer != FALSE) ? TRUE : FALSE;
  }
  else {
    if (pw->has_animations())
      pw->on_animation_tick();
    pw->check_timers_overdue_in_all_views();
    pw->on_idle();
    return pw->render(nullptr, gool::rect(pw->client_dim())) ? TRUE : FALSE;
  }
}

SBOOL SCAPI SciterRenderOnDirectXTexture_api(HWINDOW hwnd, HELEMENT elementToRenderOrNull, IUnknown* pIDXGISurface) // IDXGISurface* surface
{
#ifdef USE_D2D_PLUS
  handle<mswin::window> pw = html::view::ptr<mswin::window>(hwnd);
  if( !pw )
    return FALSE;

  html::element *el = element_ptr(elementToRenderOrNull);
  if( !el )
    el = pw->doc();

  if( !el )
    return FALSE;

  com::asset<IDXGISurface> surface;
  pIDXGISurface->QueryInterface(surface.target());
  if( !surface )
    return FALSE;

  if (pw->has_animations())
    pw->on_animation_tick();

  handle<d2d::dx_surface_graphics> pg = d2d::dx_surface_graphics::create(surface);

  return pw->render_element_on(el, pg) ? TRUE : FALSE;
#else 
  return FALSE;
#endif

}

#include "api/window-api.cpp"
#include "api/dom-api.cpp"
#include "api/value-api.cpp"
#include "api/ext-ctl-api.cpp"
#include "api/api-iface.cpp"

#endif