#include "win.h"
#include "api/ext-ctl-api.h"
#include "win-callback.h"
#include "win-delayload.h"
#include <dwmapi.h>

DLOADV(_DwmExtendFrameIntoClientArea, DwmExtendFrameIntoClientArea, dwmapi.dll,
       HRESULT(WINAPI *)(HWND hWnd, const MARGINS *pMarInset));

DLOADV(_DwmSetWindowAttribute, DwmSetWindowAttribute, dwmapi.dll,
       HRESULT(WINAPI *)(HWND hwnd, DWORD dwAttribute, _In_ LPCVOID pvAttribute,
                         DWORD cbAttribute));

DLOADV(_DwmGetWindowAttribute, DwmGetWindowAttribute, dwmapi.dll,
  HRESULT(WINAPI *)(HWND hwnd, DWORD dwAttribute, _Out_ LPVOID pvAttribute, DWORD cbAttribute));

DLOADV(_DwmEnableBlurBehindWindow, DwmEnableBlurBehindWindow, dwmapi.dll,
       HRESULT(WINAPI *)(HWND hWnd, const DWM_BLURBEHIND *pBlurBehind));

DLOADV(_DwmGetColorizationColor, DwmGetColorizationColor, dwmapi.dll,
  HRESULT(WINAPI *)(DWORD *pcrColorization, BOOL *pfOpaqueBlend));

//DLOADV(_DwmGetColorizationParameters, DwmGetColorizationParameters, dwmapi.dll,
//  VOID(WINAPI *)(DWMCOLORIZATIONPARAMS* pp));

DLOADV(_SetWindowCompositionAttribute, SetWindowCompositionAttribute,
       user32.dll,
       BOOL(WINAPI *)(HWND hWnd, WINDOWCOMPOSITIONATTRIBDATA *compositionData));

DLOADV(_GetWindowCompositionAttribute, SetWindowCompositionAttribute,
       user32.dll,
       BOOL(WINAPI *)(HWND hWnd, WINDOWCOMPOSITIONATTRIBDATA *compositionData));

namespace mswin {

  bool window::extend_window_frame(FRAME_TYPE ftype, FRAME_TYPE pftype) {

    //if (ftype == STANDARD_EXTENDED)
    //  return true;

#if 0
    if (_SetWindowCompositionAttribute) {
      BOOL r = FALSE;
      if (ftype == SOLID) {
        // hr = _DwmExtendFrameIntoClientArea()(hwnd,&zero_margins); // Extend
        // frame across entire window.
      } else if (ftype == SOLID_WITH_SHADOW) {

        window_frame_updater _(this);

        DWORD                       flag = DWMNCRP_ENABLED;
        WINDOWCOMPOSITIONATTRIBDATA data;
        data.dwAttrib = WCA_NCRENDERING_POLICY;
        data.pvData   = &flag;
        data.cbData   = sizeof(flag);
        r             = _SetWindowCompositionAttribute()(get_hwnd(), &data);
        static MARGINS margins1 = {1, 1, 1, 1};
        _DwmExtendFrameIntoClientArea()(get_hwnd(),
                                        &margins1); // Extend frame a bit.
      }
      if (r) return TRUE;
    }
#endif

    if (!_DwmExtendFrameIntoClientArea) return false;

    HRESULT hr = S_OK;

    static MARGINS unlimited_margins = {-1, -1, -1, -1};
    static MARGINS zero_margins = {0, 0, 0, 0};

    if (ftype == STANDARD_EXTENDED) {
      static MARGINS margins1 = { 1,1,1,1 };
      _DwmExtendFrameIntoClientArea()( get_hwnd(), &margins1); // Extend frame across entire window.
    }
    else if (ftype == SOLID) {
      if (pftype != STANDARD)
        hr = _DwmExtendFrameIntoClientArea()(get_hwnd(),&zero_margins); // Extend frame across entire window.
    } else if (ftype == SOLID_WITH_SHADOW) {
      int val = DWMNCRP_ENABLED;
      _DwmSetWindowAttribute()(get_hwnd(), DWMWA_NCRENDERING_POLICY, &val, sizeof(val));
      static MARGINS margins1 = {1};
      hr = _DwmExtendFrameIntoClientArea()(get_hwnd(),&margins1); // Extend frame a bit.
    }
    return SUCCEEDED(hr);
  }

  /*BLUR_BEHIND window::get_blurbehind() const
  {
    if(_GetWindowCompositionAttribute && tool::environment::get_os_version() >=
  tool::environment::WIN_10 )
    {
      BOOL r = FALSE;
      ACCENT_POLICY accent = { ACCENT_DISABLED, 0, 0, 0 };
                  WINDOWCOMPOSITIONATTRIBDATA data;
                  data.dwAttrib = WCA_ACCENT_POLICY;
                  data.pvData = &accent;
                  data.cbData = sizeof(accent);
                  r = _GetWindowCompositionAttribute()(get_hwnd(), &data);
      if(r && accent.AccentState == ACCENT_ENABLE_BLURBEHIND)
        return true;
    }
    return false;
  }*/

} // namespace mswin

HWINDOW SCAPI SciterCreateWindow_api(UINT creationFlags, LPRECT frame,
                                     SciterWindowDelegate *delegate,
                                     LPVOID delegateParam, HWINDOW parent) {
  window_params params( creationFlags & SW_TOOL ? html::TOOL_WINDOW : html::FRAME_WINDOW);
  gool::rect          rc = frame;

  if (parent) {
    params.parent = html::view::ptr<mswin::window>(parent);
    params.owner  = params.parent
                       ? params.parent->get_hwnd()
                       : parent; // just `parent` or view->get_hwnd() here?
  }

  if (!rc.empty()) {
    params.pos = rc.s;
    params.dim = rc.size();
  }
  params.delegate      = delegate;
  params.delegateParam = delegateParam;

  // params.window_style = 0;
  // params.window_style_ex = 0;

  if (creationFlags & SW_CHILD) {
    params.window_type = gool::CHILD_WINDOW;
    params.init_window_styles();
    if (creationFlags & SW_ENABLE_DEBUG) params.debug_mode = true;
  } else {
    if (creationFlags & SW_ALPHA) {
      params.window_style = WS_POPUP;
      params.window_style_ex |= WS_EX_LAYERED;
      params.is_transparent = true;
    }
    if (creationFlags & SW_POPUP)
      params.window_style = WS_POPUP;

    if (creationFlags & SW_TITLEBAR) params.window_style |= WS_CAPTION;

    if (creationFlags & SW_RESIZEABLE)
      params.window_style |= (WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);
    else
      params.window_style &= ~(WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);

    if (creationFlags & SW_CONTROLS)
      params.window_style |= WS_SYSMENU /*| WS_MINIMIZEBOX | WS_MAXIMIZEBOX*/;
    else
      params.window_style &= ~(WS_SYSMENU /*| WS_MINIMIZEBOX | WS_MAXIMIZEBOX*/);

    if (creationFlags & SW_TOOL) params.window_style_ex |= WS_EX_TOOLWINDOW;
    if (creationFlags & SW_OWNS_VM) params.owns_vm = true;
    if (creationFlags & SW_ENABLE_DEBUG) params.debug_mode = true;
    if (creationFlags & SW_MAIN) params.is_main = true;
    if (creationFlags & SW_GLASSY) params.is_glassy = true;
  }
  try {
    auto pw = app()->create_frame(params);
    return pw ? pw->get_hwnd() : nullptr;
  } catch (std::bad_alloc &) { return nullptr; }
}
