#ifndef __win32_dd_target_h__
#define __win32_dd_target_h__

#include "tool/tool.h"
#include "gool/gool.h"

#include "html/html-view.h"
#include "html/html-clipboard.h"

#include <oleidl.h>
#include <shlobj.h>
#include <hlink.h>
#include <shellapi.h>

namespace mswin {
  HGLOBAL packed_dib(gool::application *app, const gool::image *pd);
}

namespace html {
  using namespace tool;
  using namespace gool;

  inline HRESULT CreateHGlobalFromBlob(const void *pvData, SIZE_T cbData,
                                       UINT uFlags, HGLOBAL *phglob) {
    HGLOBAL hglob = GlobalAlloc(uFlags, cbData);
    if (hglob) {
      void *pvAlloc = GlobalLock(hglob);
      if (pvAlloc) {
        CopyMemory(pvAlloc, pvData, cbData);
        GlobalUnlock(hglob);
      } else {
        GlobalFree(hglob);
        hglob = NULL;
      }
    }
    *phglob = hglob;
    return hglob ? S_OK : E_OUTOFMEMORY;
  }

  /* note: apartment-threaded object */
  class drag_data_object : public IDataObject {
  public:
    // IUnknown
    STDMETHODIMP QueryInterface(REFIID riid, void **ppv) {
      IUnknown *punk = NULL;
      if (riid == IID_IUnknown) {
        punk = static_cast<IUnknown *>(this);
      } else if (riid == IID_IDataObject) {
        punk = static_cast<IDataObject *>(this);
      }

      *ppv = punk;
      if (punk) {
        punk->AddRef();
        return S_OK;
      } else {
        return E_NOINTERFACE;
      }
    }
    STDMETHODIMP_(ULONG) AddRef() { return ++_ref_count; }
    STDMETHODIMP_(ULONG) Release() {
      ULONG cRef = --_ref_count;
      if (cRef == 0) delete this;
      return cRef;
    }

    // IDataObject
    STDMETHODIMP GetData(FORMATETC *pfe, STGMEDIUM *pmed) {
      memzero(*pmed);
      int n = GetDataIndex(pfe);
      if (n < 0) return DV_E_FORMATETC;
      uint cfFormat = formats[n].cfFormat;

      // pmed->pUnkForRelease  = 0;

      if (cfFormat == clipboard::CF_HTML()) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::html_item *pi =
            _data->get<html::clipboard::html_item>();
        if (pi) {
          dbg_printf("CF_HTML %s\n", pi->val.c_str());
          return CreateHGlobalFromBlob(pi->val.c_str(), pi->val.length() + 1,
                                       GMEM_MOVEABLE, &pmed->hGlobal);
        }
      } else if (cfFormat == CF_TEXT) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::text_item *pi =
            _data->get<html::clipboard::text_item>();
        if (pi) {
          string astr = pi->val;
          return CreateHGlobalFromBlob(astr.c_str(), astr.length() + 1,
                                       GMEM_MOVEABLE, &pmed->hGlobal);
        }
      } else if (cfFormat == CF_UNICODETEXT) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::text_item *pi =
            _data->get<html::clipboard::text_item>();
        if (pi)
          return CreateHGlobalFromBlob(pi->val.c_str(),
                                       (pi->val.length() + 1) * sizeof(wchar),
                                       GMEM_MOVEABLE, &pmed->hGlobal);
      } else if (cfFormat == clipboard::CF_JSON()) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::json_item *pi =
            _data->get<html::clipboard::json_item>();
        if (pi) {
          //dbg_printf("JSON %s\n", pi->val.cbegin());
          return CreateHGlobalFromBlob(pi->val.cbegin(), pi->val.size(),
                                       GMEM_MOVEABLE, &pmed->hGlobal);
        }
      }

      /*else if(cfFormat == CF_DIB)
      {
        pmed->tymed = TYMED_HGLOBAL;
        //if( !hglobals[n] ) {
          html::clipboard::image_item *pi =
      _data->get<html::clipboard::image_item>(); if(pi) hglobals[n] =
      mswin::packed_dib(app(), pi->image);
        //}
      

        //pmed->hGlobal = hglobals[n];
        dbg_printf("cfFormat == CF_DIB %x, %d\n", pfe->tymed, hglobals[n]);
        return hglobals[n] ? S_OK : DV_E_FORMATETC;
      }
      else if(cfFormat == CF_BITMAP)
      {
        pmed->tymed = TYMED_GDI;
        //if( !hglobals[n] ) {
          html::clipboard::image_item *pi =
      _data->get<html::clipboard::image_item>(); if(pi) hglobals[n] =
      pi->image->create_win_bitmap();
        //}
        pmed->hBitmap = (HBITMAP)hglobals[n];
        dbg_printf("cfFormat == CF_BITMAP %x, %d\n", pfe->tymed, pmed->hBitmap);
        

        return pmed->hBitmap ? S_OK : DV_E_FORMATETC;
      }
      else if(cfFormat == clipboard::CF_FILEDESCRIPTOR())
      {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::image_item *pi =
      _data->get<html::clipboard::image_item>(); if(pi) { ustring us =
      pi->image->get_url(); if( us.length() == 0 ) us = WCHARS("image.png");
          FILEGROUPDESCRIPTOR fgd; memzero(fgd);
          fgd.cItems = 1;
          tool::target(fgd.fgd[0].cFileName).copy(us());
          //dbg_printf("FILEDESCRIPTOR %S\n",us.c_str());
          return CreateHGlobalFromBlob(&fgd, sizeof(fgd), GMEM_MOVEABLE,
      &pmed->hGlobal);
        }
      }
      else if(cfFormat == clipboard::CF_FILECONTENTS())
      {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::image_item *pi =
      _data->get<html::clipboard::image_item>(); if(pi) { if(
      pi->image->get_data().length ) {
            //dbg_printf("CF_FILECONTENTS A %d\n",pi->image->get_data().length);
            return CreateHGlobalFromBlob(pi->image->get_data().start,
      pi->image->get_data().length, GMEM_MOVEABLE, &pmed->hGlobal);
          }
          else {
            array<byte> data;
            pi->image->save(data,gool::image::PNG,0);
            //dbg_printf("CF_FILECONTENTS B %d\n",data.length());
            return CreateHGlobalFromBlob(data.cbegin(), data.length(),
      GMEM_MOVEABLE, &pmed->hGlobal);
          }
        }
      }*/

      else if (cfFormat == clipboard::CF_HYPERLINK()) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::link_item *pi =
            _data->get<html::clipboard::link_item>();
        if (pi) {
          dbg_printf("HYPERLINK %S\n", pi->url.c_str());
          return CreateHGlobalFromBlob(pi->url.cbegin(),
                                       (pi->url.size() + 1) * sizeof(wchar),
                                       GMEM_MOVEABLE, &pmed->hGlobal);
        }
      } else if (cfFormat == clipboard::CF_FILEDESCRIPTOR()) {
        pmed->tymed = TYMED_HGLOBAL;
        {
          html::clipboard::image_item *pi =
              _data->get<html::clipboard::image_item>();
          if (pi) {
            ustring us = pi->image->get_url();
            if (us.length() == 0) us = WCHARS("image.png");
            FILEGROUPDESCRIPTOR fgd;
            memzero(fgd);
            fgd.cItems         = 1;
            fgd.fgd[0].dwFlags = (DWORD)FD_UNICODE;
            tool::target(fgd.fgd[0].cFileName).copy(us());
            // dbg_printf("FILEDESCRIPTOR %S\n",us.c_str());
            return CreateHGlobalFromBlob(&fgd, sizeof(fgd), GMEM_MOVEABLE,
                                         &pmed->hGlobal);
          }
        }
        {
          html::clipboard::link_item *pi =
              _data->get<html::clipboard::link_item>();
          if (pi && pi->caption.length()) {
            ustring             us = pi->caption + W(".url");
            FILEGROUPDESCRIPTOR fgd;
            memzero(fgd);
            fgd.cItems         = 1;
            fgd.fgd[0].dwFlags = (DWORD)FD_UNICODE;
            tool::target(fgd.fgd[0].cFileName).copy(us());
            dbg_printf("FILEDESCRIPTOR %S\n", fgd.fgd[0].cFileName);
            return CreateHGlobalFromBlob(&fgd, sizeof(fgd), GMEM_MOVEABLE,
                                         &pmed->hGlobal);
          }
        }
      } else if (cfFormat == CF_HDROP) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::file_item *pi =
            _data->get<html::clipboard::file_item>();
        if (pi) {

          DROPFILES df;
          memzero(df);
          df.pFiles = sizeof(df);
          df.fWide  = TRUE;

          array<byte> data;
          data.push((const byte *)&df, sizeof(df));

          for (int i = 0; i < pi->filenames.size(); ++i) {
            ustring filename = pi->filenames[i];
            if (filename.like(W("file://*"))) filename = filename().sub(7);
            filename.replace_all('/', '\\');
            data.push((const byte *)filename.c_str(),
                      (filename.size() + 1) * sizeof(wchar));
          }
          data.push(0);
          data.push(0);
          if (pi)
            return CreateHGlobalFromBlob(data.cbegin(), data.size(),
                                         GMEM_MOVEABLE, &pmed->hGlobal);
        }
      }
      /*else if(cfFormat == clipboard::CF_HYPERLINK()) {
        pmed->tymed = TYMED_HGLOBAL;
        html::clipboard::link_item *pi =
      _data->get<html::clipboard::link_item>(); if(pi) { HGLOBAL hglobal = NULL;
           CreateHGlobalFromBlob(pi->url.c_str(), (pi->url.length() + 1) *
      sizeof(wchar), GMEM_MOVEABLE, &hglobal); pmed->hGlobal = hglobal; return
      pmed->hGlobal ? S_OK : DV_E_FORMATETC;
        }
      }*/
      return DV_E_FORMATETC;
    }

    STDMETHODIMP GetDataHere(FORMATETC *pfe, STGMEDIUM *pmed) {
      return E_NOTIMPL;
    }

    STDMETHODIMP QueryGetData(FORMATETC *pfe) {
      return GetDataIndex(pfe) == DATA_INVALID ? S_FALSE : S_OK;
    }

    STDMETHODIMP GetCanonicalFormatEtc(FORMATETC *pfeIn, FORMATETC *pfeOut) {
      *pfeOut     = *pfeIn;
      pfeOut->ptd = NULL;
      return DATA_S_SAMEFORMATETC;
    }

    STDMETHODIMP SetData(FORMATETC *pfe, STGMEDIUM *pmed, BOOL fRelease) {
      return E_NOTIMPL;
    }

    STDMETHODIMP EnumFormatEtc(DWORD dwDirection, LPENUMFORMATETC *ppefe) {
      if (dwDirection == DATADIR_GET)
        return SHCreateStdEnumFmtEtc((UINT)formats.length(), formats.head(),
                                     ppefe);
      *ppefe = NULL;
      return E_NOTIMPL;
    }

    STDMETHODIMP DAdvise(FORMATETC *pfe, DWORD grfAdv, IAdviseSink *pAdvSink,
                         DWORD *pdwConnection) {
      return OLE_E_ADVISENOTSUPPORTED;
    }
    STDMETHODIMP DUnadvise(DWORD dwConnection) {
      return OLE_E_ADVISENOTSUPPORTED;
    }
    STDMETHODIMP EnumDAdvise(LPENUMSTATDATA *ppefe) {
      return OLE_E_ADVISENOTSUPPORTED;
    }

    drag_data_object(clipboard::data *pd) : _data(pd), _ref_count(0) {
      for (int i = 0; i < pd->items.size(); ++i) {
        clipboard::item *pi = pd->items[i];
        FORMATETC        fc;
        switch (pi->data_type) {
        case clipboard::cf_text:
          SetFORMATETC(&fc, CF_TEXT);
          formats.push(fc);
          SetFORMATETC(&fc, CF_UNICODETEXT);
          formats.push(fc);
          break;
        case clipboard::cf_html:
          SetFORMATETC(&fc, clipboard::CF_HTML());
          formats.push(fc);
          break;
        case clipboard::cf_picture:
          // SetFORMATETC(&fc, CF_DIB ); formats.push(fc);
          SetFORMATETC(&fc, clipboard::CF_FILEDESCRIPTOR());
          formats.push(fc);
          SetFORMATETC(&fc, clipboard::CF_FILECONTENTS());
          formats.push(fc);
          break;
        case clipboard::cf_file:
          SetFORMATETC(&fc, CF_HDROP);
          formats.push(fc);
          break;
        case clipboard::cf_hyperlink:
          SetFORMATETC(&fc, clipboard::CF_HYPERLINK());
          formats.push(fc);
          if (static_cast<html::clipboard::link_item *>(pi)->caption.length()) {
            SetFORMATETC(&fc, clipboard::CF_FILEDESCRIPTOR());
            formats.push(fc);
          }
          break;
        case clipboard::cf_json:
          SetFORMATETC(&fc, clipboard::CF_JSON());
          formats.push(fc);
          break;
        }
      }
    }

    ~drag_data_object() {}

  private:
    enum {
      DATA_TEXT,
      DATA_TEXTW,
      DATA_HTML,
      DATA_JSON,
      DATA_HYPERLINK,
      DATA_PICTURE,
      // DATA_HDROP,
      DATA_COUNT,
      DATA_INVALID = -1,
    };

    int GetDataIndex(const FORMATETC *pfe) {
      for (int i = 0; i < formats.size(); i++) {
        if ((pfe->cfFormat == formats[i].cfFormat) &&
            (pfe->tymed & formats[i].tymed) &&
            (pfe->dwAspect == formats[i].dwAspect) &&
            (pfe->lindex == formats[i].lindex))
          return i;
      }
      return -1;
    }

    void SetFORMATETC(FORMATETC *pfe, UINT cf, TYMED tymed = TYMED_HGLOBAL,
                      LONG lindex = -1, DWORD dwAspect = DVASPECT_CONTENT,
                      DVTARGETDEVICE *ptd = NULL) {
      pfe->cfFormat = (CLIPFORMAT)cf;
      pfe->tymed    = tymed;
      pfe->lindex   = lindex;
      pfe->dwAspect = dwAspect;
      pfe->ptd      = ptd;
    }

  private:
    ULONG                   _ref_count;
    array<FORMATETC>        formats;
    handle<clipboard::data> _data;
  };

  // T should have
  // HWND get_hwnd()
  // bool on_drop(const array<byte>& html_fragment, bool is_copying, point
  // pt)=0;  bool on_drag_enter(bool is_copying, clipboard::data* pd, point pt)=0;
  // bool on_drag_over(bool is_copying, clipboard::data* pd, point pt)=0;
  // void on_drag_leave()=0;

  template <class T>
  class drop_target : public IDropTarget, public IDropSource {
    ULONG                   _ref_count;
    DWORD                   _drag_op;
    gool::point             _last_pos;
    handle<clipboard::data> _data;
    handle<html::element>   _source;
    icon::icon_handle       _cur_none;
    icon::icon_handle       _cur_move;
    icon::icon_handle       _cur_copy;

  public:
    drop_target() : _ref_count(0), _drag_op(0) {}

    void activate_drop_target(bool on) {
      HRESULT hr;
      HWND    hWnd = static_cast<T *>(this)->get_hwnd();
      if (on) {
        hr = ::RegisterDragDrop(hWnd, static_cast<T *>(this));
        assert(hr != E_OUTOFMEMORY);
        assert(hr != DRAGDROP_E_INVALIDHWND);
        assert(hr != DRAGDROP_E_ALREADYREGISTERED);
        assert(hr != CO_E_NOTINITIALIZED);
        assert(SUCCEEDED(hr));
      } else
        hr = ::RevokeDragDrop(hWnd);
    }

    // Interface IDropTarget
    HRESULT STDMETHODCALLTYPE DragOver(DWORD grfKeyState, POINTL pt,
                                       DWORD *pdwEffect) {
      if (_data) {
        _last_pos = point(pt.x, pt.y);
        MapWindowPoints(HWND_DESKTOP, static_cast<T *>(this)->get_hwnd(),
                        PPOINT(_last_pos), 1);
        // dbg_printf("dragging:%d %d eff=%d\n",pt.x,pt.y,*pdwEffect);

        if ((*pdwEffect & (DROPEFFECT_COPY | DROPEFFECT_MOVE)) == (DROPEFFECT_COPY | DROPEFFECT_MOVE)) {
          if (grfKeyState & MK_CONTROL)
            *pdwEffect = DROPEFFECT_COPY;
          else
            *pdwEffect = DROPEFFECT_MOVE;
        }

        _drag_op = *pdwEffect;

        // dbg_printf("dragging:%d %d eff=%d\n",pt.x,pt.y,*pdwEffect);

        if (!static_cast<T *>(this)->on_drag_over(*pdwEffect, _data, _last_pos, _source))
          _drag_op = *pdwEffect = DROPEFFECT_NONE;
        ::UpdateWindow(static_cast<T *>(this)->get_hwnd());
        // dbg_printf("DragOver %x\n", (T*)this );
        // dbg_printf("dragging:%d %d
        // eff=%d\n",_last_pos.x,_last_pos.y,*pdwEffect);
      } else
        _drag_op = *pdwEffect = DROPEFFECT_NONE;

      return S_OK;
    }

    HRESULT STDMETHODCALLTYPE DragEnter(IDataObject *pDataObject,
                                        DWORD grfKeyState, POINTL pt,
                                        DWORD *pdwEffect) {
      STGMEDIUM stgMedium;
      memzero(stgMedium);

      FORMATETC formats[] = {
          {clipboard::CF_HTML(), NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL},
          {CF_TEXT, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL},
          {CF_UNICODETEXT, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL},
          {clipboard::CF_HYPERLINK(), NULL, DVASPECT_CONTENT, -1,
           TYMED_HGLOBAL},
          {CF_HDROP, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL},
          {clipboard::CF_JSON(), NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL}};
      clipboard::clipboard_format xformats[] = {
          clipboard::cf_html,      clipboard::cf_text, clipboard::cf_text,
          clipboard::cf_hyperlink, clipboard::cf_file, clipboard::cf_json};

      //_is_clipboard_format = false;
      _drag_op = *pdwEffect; // DROPEFFECT_COPY;
      _data    = new clipboard::data();

      HRESULT hr;

      /*
            does not work with IE but works with GC, why?

            com::asset<IEnumFORMATETC> enu;

            pDataObject->EnumFormatEtc(DATADIR_GET, enu.target());
            FORMATETC fc; ULONG c = 0;
            while (enu && enu->Next(1,&fc,&c) == S_OK) {
              wchar name[128];
              GetClipboardFormatName(fc.cfFormat, name, items_in(name));
              dbg_printf("CF:%S\n",name);
              if (clipboard::CF_HTML() == fc.cfFormat)
              {
                //stgMedium.tymed = TYMED_HGLOBAL;
                //stgMedium.hGlobal = GlobalAlloc(GPTR, 32000);
                hr = pDataObject->GetData(&fc, &stgMedium);
                hr = hr;
              }
            }
      */
      // bool wide_text = false;

      for (int nf = 0; nf < items_in(xformats); ++nf) {
        memzero(stgMedium);

        hr = pDataObject->QueryGetData(&formats[nf]);

        if (FAILED(hr)) continue;

        hr = pDataObject->GetData(&formats[nf], &stgMedium);

        if (FAILED(hr)) continue;

        /*????? if (stgMedium.pUnkForRelease != NULL)
        {
           ::ReleaseStgMedium(&stgMedium);
          continue;
        }*/

        clipboard::clipboard_format data_type = xformats[nf];

        switch (stgMedium.tymed) {
        case TYMED_HGLOBAL: {
          const byte *ptext      = (const byte *)GlobalLock(stgMedium.hGlobal);
          SIZE_T      ptext_size = GlobalSize(stgMedium.hGlobal);
          /*#ifdef _DEBUG
                        FILE *f = fopen("c:/dragdrop.txt","w+");
                        fwrite(ptext,1,ptext_size,f);
                        fclose(f);
          #endif*/
          if (data_type == clipboard::cf_hyperlink) {
            ustring uri =
                ustring((const wchar *)ptext, ptext_size / sizeof(wchar));
            ustring   caption = uri;
            STGMEDIUM stgMediumFD;
            FORMATETC fmtFILEDESCRIPTOR = {clipboard::CF_FILEDESCRIPTOR(), NULL,
                                           DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
            HRESULT   retFD =
                pDataObject->GetData(&fmtFILEDESCRIPTOR, &stgMediumFD);
            if (SUCCEEDED(retFD)) {
              FILEGROUPDESCRIPTORW *fd =
                  (FILEGROUPDESCRIPTORW *)GlobalLock(stgMediumFD.hGlobal);
              if (fd) caption = fd->fgd[0].cFileName;
              ::GlobalUnlock(stgMediumFD.hGlobal);
              ::ReleaseStgMedium(&stgMediumFD);
            }
            if (caption.like(L"*.url"))
              caption = caption().sub(0, caption.size() - 4);
            if (caption.length() == 0) caption = uri;

            _data->add(
                new html::clipboard::link_item(xml_escape(caption), uri));

            // uri = ustring(uri).utf8();
            // caption = html_escape(ustring(caption));

            // string si = string::format("<a href=\"%s\">%s</a>",
            //  url::escape(uri.utf8()).c_str(),
            //  caption.utf8().c_str() );
            //_data.push((const byte *)(const char *)si,si.length());

          } else if (data_type == clipboard::cf_file) {
            array<ustring> names;
            wchar          path[MAX_PATH];
            uint n = DragQueryFileW((HDROP)stgMedium.hGlobal, 0xFFFFFFFF, 0, 0);
            for (uint i = 0; i < n; ++i) {
              DragQueryFileW((HDROP)stgMedium.hGlobal, i, path, MAX_PATH);
              path[MAX_PATH - 1] = 0;
              //names.push(ustring::format(L"file://%s", path));
              names.push(url::path_to_file_url(path));
            }
            _data->add(new html::clipboard::file_item(names));
          } else if (data_type == clipboard::cf_text) {
            if (formats[nf].cfFormat == CF_TEXT) {
              tool::chars txt((const char *)ptext, ptext_size / sizeof(char));
              txt.length = min(txt.length, str_len(txt.start));
              _data->add(new html::clipboard::text_item(ustring(txt)));
            } else {
              tool::wchars txt((const wchar *)ptext,
                               ptext_size / sizeof(wchar));
              txt.length = min(txt.length, str_len(txt.start));
              _data->add(new html::clipboard::text_item(txt));
            }
          } else if (data_type == clipboard::cf_html) {
            tool::bytes htm((const byte *)ptext, ptext_size / sizeof(byte));
            _data->add(html::clipboard::html_item::from_cf_html(htm));
          } else if (data_type == clipboard::cf_json) {
            tool::bytes json((const byte *)ptext, ptext_size / sizeof(byte));
            _data->add(new html::clipboard::json_item(json));
          }
          GlobalUnlock(stgMedium.hGlobal);
        } break;
        default:
          // type not supported
          break;
        }
        ::ReleaseStgMedium(&stgMedium);
      } // for()

      if (_data && _data->get_default()) {
        // bool copy_op = true;
        point p(pt.x, pt.y);
        MapWindowPoints(HWND_DESKTOP, static_cast<T *>(this)->get_hwnd(),
                        PPOINT(p), 1);
        if (!static_cast<T *>(this)->on_drag_enter(*pdwEffect, _data, p,
                                                   _source))
          *pdwEffect = DROPEFFECT_NONE;
      } else
        *pdwEffect = DROPEFFECT_NONE;

      return S_OK;
    }

    HRESULT STDMETHODCALLTYPE DragLeave(void) {
      static_cast<T *>(this)->on_drag_leave(_source);
      if (_data) {
        _data    = 0;
        _drag_op = DROPEFFECT_NONE;
      }
      // dbg_printf("DragLeave\n");
      return S_OK;
    }

    HRESULT STDMETHODCALLTYPE Drop(IDataObject *pDataObj, DWORD grfKeyState,
                                   POINTL pt, DWORD __RPC_FAR *pdwEffect) {
      // dbg_printf("Drop\n");
      if (!_data) return E_INVALIDARG;

      try {
        *pdwEffect = _drag_op;

        // SetFocus(static_cast<T*>(this)->get_hwnd());

        point p(pt.x, pt.y);
        MapWindowPoints(HWND_DESKTOP, static_cast<T *>(this)->get_hwnd(),
                        PPOINT(p), 1);

        if (!static_cast<T *>(this)->on_drop(*pdwEffect, _data, p, _source))
          *pdwEffect = DROPEFFECT_NONE;
        // else
        //  static_cast<T*>(this)->on_drag_leave();
      } catch (...) { *pdwEffect = DROPEFFECT_NONE; }

      return S_OK;
    }

    // *** IDropSource ***
    STDMETHODIMP QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState) {
      if (fEscapePressed) {
        static_cast<T *>(this)->on_drag_cancel(_source);
        if (_data) {
          _data    = 0;
          _drag_op = DROPEFFECT_NONE;
        }
        return DRAGDROP_S_CANCEL;
      }
      if (!(grfKeyState & (MK_LBUTTON | MK_RBUTTON))) return DRAGDROP_S_DROP;
      return S_OK;
    }
    STDMETHODIMP GiveFeedback(DWORD dwEffect) {
      // dbg_printf("GiveFeedback:eff=%d\n",dwEffect);
      if ((dwEffect == DROPEFFECT_COPY) && _cur_copy)
        ::SetCursor(_cur_copy);
      else if ((dwEffect == DROPEFFECT_MOVE) && _cur_move)
        ::SetCursor(_cur_move);
      else if ((dwEffect == DROPEFFECT_NONE) && _cur_none)
        ::SetCursor(_cur_none);
      else
        return DRAGDROP_S_USEDEFAULTCURSORS;
      return S_OK;
    }

    // Interface IUnknown
    HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void **ppvObject) {
      if (ppvObject == nullptr) return E_POINTER;
      // Supports IID_IUnknown and IID_IDropTarget
      if (iid == IID_IUnknown || iid == IID_IDropTarget) {
        *ppvObject = (void *)static_cast<IDropTarget *>(this);
        AddRef();
        return NOERROR;
      } else if (iid == IID_IDropSource) {
        *ppvObject = (void *)static_cast<IDropSource *>(this);
        AddRef();
        return NOERROR;
      }
      return E_NOINTERFACE;
    }

    ULONG STDMETHODCALLTYPE AddRef(void) { return ++_ref_count; }

    ULONG STDMETHODCALLTYPE Release(void) {
      --_ref_count;
      if (_ref_count == 0) { _data = 0; }
      return _ref_count;
    }

    html::element drag_source() const { return _source; }

    bool perform_drag(clipboard::data *pd, uint &ddm /*in out DD_MODE*/,
                      element *src, gool::bitmap *drag_image, point offset) {
      com::asset<drag_data_object> dd = new drag_data_object(pd);

      DWORD   dwEffect = 0;
      HRESULT dwResult = 0;

      //_source
      _source = src;

#if 0
      // I gave up after two days of trying to convince IDropTargetHelper to work 
      // this f***g IDropTargetHelper::InitializeFromBitmap throws Run-Time Check Failure, possibly beacause of 32bit app on 64bit os
      if( drag_image ) 
      {
        dib32 dib(drag_image->dim());
        drag_image->demultiply();
        dib.target_pixels().copy(0, drag_image->get_bits()); 

        com::asset<IDragSourceHelper> ddh;
        CoCreateInstance(CLSID_DragDropHelper, NULL, CLSCTX_ALL, IID_IDropTargetHelper, (LPVOID*)ddh.target());
        
        if( !ddh ) 
          goto NODRAGIMAGE;

        IDataObject* pdo = dd;

        SHDRAGIMAGE sdi = {0}; 
        sdi.sizeDragImage.cx = dib.width();
        sdi.sizeDragImage.cy = dib.height();
        sdi.ptOffset.x = offset.x;
        sdi.ptOffset.y = offset.y;
        sdi.hbmpDragImage = dib.detach();
        sdi.crColorKey = CLR_NONE;
        dwResult = ddh->InitializeFromBitmap(&sdi,pdo);
        //ddh->InitializeFromWindow(&sdi,dd);

        dwResult = DoDragDrop(dd, static_cast<IDropSource*>(this), ddm, &dwEffect);

      }
      else {
NODRAGIMAGE:mple
        dwResult = DoDragDrop(dd, static_cast<IDropSource*>(this), ddm, &dwEffect);
      }
#else
      if (drag_image) {

        handle<gool::bitmap> move, copy, none;
        static_cast<T *>(this)->create_drag_cursors(drag_image, offset, move,
                                                    copy, none);
        if (none) _cur_none.h = none->create_win_icon(offset);
        if (move) _cur_move.h = move->create_win_icon(offset);
        if (copy) _cur_copy.h = copy->create_win_icon(offset);

        //_hcursor = drag_image->create_icon(offset);
        dwResult =
            DoDragDrop(dd, static_cast<IDropSource *>(this), ddm, &dwEffect);

        _cur_none.clear();
        _cur_move.clear();
        _cur_copy.clear();

      } else
        dwResult =
            DoDragDrop(dd, static_cast<IDropSource *>(this), ddm, &dwEffect);
#endif

      _source = nullptr;

      // success!
      if (dwResult == DRAGDROP_S_DROP) {
        ddm = (DD_MODE)dwEffect;
        return true;
      }
      // cancelled
      else if (dwResult == DRAGDROP_S_CANCEL) {
        ddm = dd_none;
        return true;
      }
      return false;
    }
  };

} // namespace html

#endif
