#include "sdk-headers.h"
#include "html/html.h"

#pragma once

struct window_callback : public html::view_callback {
  typedef html::view_callback super;
  HWND                        _hwnd;
  SciterHostCallback *        _p_callback;
  void *                      _p_callback_param;
  window_callback() : _hwnd(0), _p_callback(0), _p_callback_param(0) {}
  virtual bool load_data(html::view *pv, html::pump::request *rq) override;
  virtual bool data_loaded(html::view *pv, html::pump::request *rq) override;
  virtual html::ctl *create_behavior(html::view *pv, html::element *b,
                                     const tool::string &name) override;
  virtual void       graphics_critical_failure(html::view *pv) override;
  virtual void       post_notify(html::view *pv, uint_ptr wparam, uint_ptr lparam) override;

  // virtual bool  host_callback( int channel, const tool::value& p1, const
  // tool::value& p2, tool::value& r );
  virtual void final_release() override;
};

struct window_debug_output : public html::view_debug_output {
  DEBUG_OUTPUT_PROC _out;
  void *            _out_prm;
  window_debug_output(DEBUG_OUTPUT_PROC out, void *out_prm)
      : _out(out), _out_prm(out_prm) {}
  virtual void print(uint subs, uint sev, wchars msg) override {
    _out(_out_prm, subs, sev, msg.start, msg.size());
  }
};
