#include "win.h"
#include "win-callback.h"
#include "win-application.h"
#include "api/ext-ctl-api.h"

using namespace tool;
using namespace html;
// virtual bool  load_data(html::view* pv, html::pump::request* rq);
// virtual bool  data_loaded(html::view* pv, html::pump::request* rq);
// virtual ctl*  create_behavior(html::view *pv, html::element* b, const
// tool::string& name );

bool window_callback::load_data(view *pv, pump::request *rq) {
  tool::auto_state<handle<pump::request>> _(pv->current_rq, rq);

  SCN_LOAD_DATA nm;
  nm.hwnd = _hwnd;
  nm.code = SC_LOAD_DATA;

  ustring uri    = url::unescape(rq->url);
  nm.uri         = uri;
  nm.outData     = rq->data.size() ? rq->data.head() : 0;
  nm.outDataSize = rq->data.size();
  nm.dataType    = rq->data_type;
  nm.principal   = rq->dst;
  nm.initiator   = rq->initiator;
  nm.requestId   = rq;

  UINT lr = 0;

  if (_p_callback) {
    array<byte> data;
    swap(data, rq->data);
    lr = _p_callback((LPSCITER_CALLBACK_NOTIFICATION)&nm, _p_callback_param);
    //printf("SC_LOAD_DATA: %S %p %d %d\n", uri.c_str(), nm.outData, nm.outDataSize, lr);
    if (lr == LOAD_MYSELF) {
      rq->external_load = TRUE;
      return false;
    }
    if (rq->data.size()) return true;
    swap(data, rq->data);
  }

  if (nm.outData && nm.outDataSize && nm.outData != rq->data.head()) {
    rq->data.push(nm.outData, nm.outDataSize);
    return true;
  }

  if (lr == LOAD_DISCARD) return true;

  if (lr == LOAD_MYSELF) return false;

  if (lr == LOAD_DELAYED) {
    rq->add_ref();
    rq->external_load = TRUE;
    return // nm.outDataSize > 0;
        false;
  }

  if (lr != 0) return nm.outDataSize > 0;

  return false;
}

bool window_callback::data_loaded(view *pv, pump::request *rq) {
  if (!_p_callback) return false;
  SCN_DATA_LOADED nm;
  memzero(nm);

  nm.code     = SC_DATA_LOADED;
  nm.hwnd     = _hwnd;
  ustring uri = url::unescape(rq->url);
  nm.uri      = uri;
  nm.data     = rq->data.elements();
  nm.dataSize = rq->data.size();
  nm.dataType = rq->data_type;
  nm.status   = rq->status;

  (*_p_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm, _p_callback_param);

  if (nm.data == 0 && nm.dataSize == 0) return true;
  return false;
}

void window_callback::graphics_critical_failure(html::view *pv) {
  if (!_p_callback) return;
  SCN_GRAPHICS_CRITICAL_FAILURE nm;
  memzero(nm);

  nm.code = SC_GRAPHICS_CRITICAL_FAILURE;
  nm.hwnd = _hwnd;

  (*_p_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm, _p_callback_param);
}

void window_callback::post_notify(html::view *pv, uint_ptr wparam, uint_ptr lparam)
{
  if (!_p_callback) return;
  SCN_POSTED_NOTIFICATION pns;
  pns.code = SC_POSTED_NOTIFICATION;
  pns.hwnd = pv->get_hwnd();
  pns.wparam = wparam;
  pns.lparam = lparam;
  _p_callback((LPSCITER_CALLBACK_NOTIFICATION)&pns, _p_callback_param);
}

void window_callback::final_release() {
  if (!_p_callback) return;
  SCN_ENGINE_DESTROYED nm;
  memzero(nm);

  nm.code = SC_ENGINE_DESTROYED;
  nm.hwnd = _hwnd;

  (*_p_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm, _p_callback_param);

  return super::final_release();
}

struct SciterExtModule {
  SciterExtModule() {
    hlib     = 0;
    pfactory = 0;
  }
  HMODULE                hlib;
  SciterBehaviorFactory *pfactory;
};

inline SciterBehaviorFactory *getExtFactory(const tool::string &libname) {
  static tool::hash_table<tool::string, SciterExtModule> all;

  SciterExtModule scem;

  if (all.find(libname, scem)) return scem.pfactory;

  all[libname] = scem;

  scem.hlib = LoadLibraryExA(libname, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);

  if (!scem.hlib) return 0;

  scem.pfactory = (SciterBehaviorFactory *)::GetProcAddress(
      scem.hlib, "SciterBehaviorFactory");
  if (!scem.pfactory) return 0;

  all[libname] = scem;

  return scem.pfactory;
}

// behaviors
ctl *window_callback::create_behavior(view *pv, element *b,
                                      const string &behavior_name) {
  helement ap = b;

  SCN_ATTACH_BEHAVIOR nmab;
  nmab.code         = SC_ATTACH_BEHAVIOR;
  nmab.hwnd         = _hwnd;
  nmab.behaviorName = behavior_name;
  nmab.element      = ap.ptr();
  nmab.elementProc  = 0;
  nmab.elementTag   = 0;

  if (_p_callback) {
    (*_p_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nmab, _p_callback_param);
    if (nmab.elementProc)
      return new ext_ctl(behavior_name, nmab.elementProc, nmab.elementTag);
  }

  if (strchr(nmab.behaviorName, ':')) // attempt to load behavior from external
                                      // .sbx (sciter binary extension - dll)
                                      // file
  {
    tool::string bn = behavior_name;
    chars        lib_name, bhv_name;
    if (!chars(bn).split(':', lib_name, bhv_name)) return 0;

    char buffer[2048];
    buffer[0] = 0;
    GetModuleFileNameA(HINST_THISCOMPONENT, buffer, sizeof(buffer));
    string drive, dir, name, ext;
    split_path(buffer, drive, dir, name, ext);

    string dll_name = string(lib_name) + ".dll";
    string s        = drive + dir + dll_name;

    SciterBehaviorFactory *sbf = getExtFactory(s);
    if (!sbf) return 0;
    // second attempt, just dll name
    sbf = getExtFactory(dll_name);
    if (!sbf) return 0;

    // if( !( sbf = (SciterBehaviorFactory*) ::GetProcAddress( hlib,
    // "SciterBehaviorFactory" ) ) )
    //  return 0;

    if (sbf(string(bhv_name), nmab.element, &nmab.elementProc,
            &nmab.elementTag)) {
      if (nmab.elementProc)
        return new ext_ctl(name, nmab.elementProc, nmab.elementTag);
    }
    nmab.elementTag  = 0;
    nmab.elementProc = 0;
  }
  return 0;
}

/*bool window_callback::host_callback( int channel, const tool::value& p1, const
  tool::value& p2, tool::value& r )
  {
      if(!_p_callback)
        return false;
      

      SCN_CALLBACK_HOST nm;
      nm.code = SC_CALLBACK_HOST;
      nm.hwnd = _hwnd;
      nm.channel = channel;
      ValueInit(&nm.p1);
      ValueInit(&nm.p2);
      ValueInit(&nm.r);
      ValueCopy(&nm.p1,(const VALUE*)&p1);
      ValueCopy(&nm.p2,(const VALUE*)&p2);
      _p_callback(&nm,_p_callback_param);
      ValueCopy((VALUE*)&r,&nm.r);
      ValueClear(&nm.p1);
      ValueClear(&nm.p2);
      ValueClear(&nm.r);
      return true;
  }*/